/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEBrowser;
import weblogic.jms.backend.BEBrowserCreateRequest;
import weblogic.jms.backend.BEBrowserImpl;
import weblogic.jms.backend.BEConnection;
import weblogic.jms.backend.BEConsumerCommon;
import weblogic.jms.backend.BEConsumerCreateRequest;
import weblogic.jms.backend.BEConsumerCreateResponse;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BEDeliveryList;
import weblogic.jms.backend.BEDestinationCommon;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BESession;
import weblogic.jms.backend.BESessionAcknowledgeRequest;
import weblogic.jms.backend.BESessionCloseRequest;
import weblogic.jms.backend.BESessionRecoverRequest;
import weblogic.jms.backend.BESessionSetRedeliveryDelayRequest;
import weblogic.jms.backend.BETopicImpl;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.DispatcherCompletionListener;
import weblogic.jms.common.DurableSubscription;
import weblogic.jms.common.InvalidSubscriptionSharingException;
import weblogic.jms.common.JMSBrowserCreateResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.JMSSessionRecoverResponse;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.NonDurableSubscription;
import weblogic.jms.common.Subscription;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.jms.extensions.WLMessage;
import weblogic.jms.utils.Simple;
import weblogic.jms.utils.tracing.AggregationCounter;
import weblogic.jms.utils.tracing.MessageTimeStamp;
import weblogic.messaging.ID;
import weblogic.messaging.common.MessageIDImpl;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.kernel.GroupOwner;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelListener;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.Listener;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.RedeliveryParameters;
import weblogic.messaging.kernel.Sequence;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.security.WLSPrincipals;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.collections.CircularQueue;
import weblogic.utils.concurrent.atomic.AtomicFactory;
import weblogic.utils.concurrent.atomic.AtomicInteger;
import weblogic.work.WorkManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BESessionImpl
extends BEDeliveryList
implements BESession,
Listener,
NakedTimerListener {
    private final JMSID sessionId;
    private final JMSID sequencerId;
    private BEConnection connection;
    private final InvocableMonitor invocableMonitor;
    private String pushWorkManager;
    private final Set<BEConsumerImpl> consumers = new HashSet<BEConsumerImpl>();
    private final Map<JMSID, BEBrowser> browsers = new HashMap<JMSID, BEBrowser>();
    private final CircularQueue pendingMessages = new CircularQueue();
    private boolean stopped;
    private boolean closed;
    private boolean isPeerGone;
    private CloseWait closeInProgressLock;
    private final boolean transacted;
    private Object recoveryUnit;
    private final int acknowledgeMode;
    private int totalWindowSize;
    private AtomicInteger pipelineGeneration = AtomicFactory.createAtomicInteger();
    private final byte clientVersion;
    private static final boolean PUSH_STATS = false;
    private final AtomicInteger messagesPushed;
    private final AtomicInteger pushRequests;
    private static final int PUSH_DELAY;
    private static final int MAX_TOTAL_DELAY;
    private static final int DEFAULT_PUSH_DELAY = 3;
    private AggregationCounter aggregationCounter;
    private boolean noAggregation = false;
    private String aDestination = null;
    private int throughputEmphasis = -1;
    private WorkManager workManager;
    private long lastSeqAcked = 0L;

    BESessionImpl(BEConnection bEConnection, JMSID jMSID, JMSID jMSID2, boolean bl, boolean bl2, int n, byte by, String string) {
        super(null);
        this.sessionId = jMSID;
        this.sequencerId = jMSID2;
        this.transacted = bl;
        this.acknowledgeMode = n;
        this.connection = bEConnection;
        this.pushWorkManager = string;
        this.stopped = bEConnection.isStopped();
        this.clientVersion = by;
        if (by >= 5) {
            this.pipelineGeneration.set(0xF00000);
        }
        this.invocableMonitor = JMSService.getJMSService().getInvocableMonitor();
        this.pushRequests = null;
        this.messagesPushed = null;
        this.recoveryUnit = bl2 ? new XASessionOwner() : this;
    }

    @Override
    public JMSID getJMSID() {
        return this.sessionId;
    }

    @Override
    public ID getId() {
        return this.getJMSID();
    }

    public JMSID getSequencerId() {
        return this.sequencerId;
    }

    @Override
    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    @Override
    public void setConnection(BEConnection bEConnection) {
        this.connection = bEConnection;
    }

    @Override
    public BEConnection getConnection() {
        return this.connection;
    }

    int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    String getPushWorkManager() {
        return this.pushWorkManager;
    }

    public int getPipelineGeneration() {
        return this.pipelineGeneration.get();
    }

    synchronized void adjustWindowSize(int n) {
        this.totalWindowSize += n;
        this.initDeliveryList(this.totalWindowSize, this.throughputEmphasis, PUSH_DELAY, MAX_TOTAL_DELAY);
    }

    Object getRecoveryUnit() {
        return this.recoveryUnit;
    }

    @Override
    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 13328: {
                this.close((BESessionCloseRequest)request);
                break;
            }
            case 8464: {
                return this.createBrowser((BEBrowserCreateRequest)request);
            }
            case 14352: {
                this.start();
                break;
            }
            case 14096: {
                this.setRedeliveryDelay(((BESessionSetRedeliveryDelayRequest)request).getRedeliveryDelay());
                break;
            }
            case 13072: {
                return this.acknowledge((BESessionAcknowledgeRequest)request);
            }
            case 13840: {
                return this.recover((BESessionRecoverRequest)request);
            }
            case 10256: {
                return this.createConsumer((BEConsumerCreateRequest)request);
            }
            default: {
                throw new AssertionError((Object)("No such method " + request.getMethodId()));
            }
        }
        request.setResult(VoidResponse.THE_ONE);
        request.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BEConsumerImpl createBEConsumer(BEConsumerCreateRequest bEConsumerCreateRequest) throws JMSException {
        boolean bl;
        Invocable invocable = this;
        synchronized (invocable) {
            if (this.closedOrPeerGone()) {
                throw new JMSException("Session is closed");
            }
        }
        invocable = (BEDestinationImpl)InvocableManagerDelegate.delegate.invocableFind(20, bEConsumerCreateRequest.getDestinationId());
        if (invocable == null) {
            throw new weblogic.jms.common.JMSException("Destination not found");
        }
        this.aDestination = ((BEDestinationCommon)invocable).getName();
        this.throughputEmphasis = Math.max(this.throughputEmphasis, ((BEDestinationImpl)invocable).getMessagingPerformancePreference());
        BackEnd backEnd = ((BEDestinationCommon)invocable).getBackEnd();
        if (backEnd != null) {
            backEnd.checkShutdownOrSuspendedNeedLock("create consumer");
            if (this.workManager == null) {
                this.workManager = backEnd.getWorkManager();
            }
        }
        Object object = this;
        synchronized (object) {
            bl = this.stopped;
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Creating consumer to Destination " + ((BEDestinationCommon)invocable).getName() + ": clientId = " + bEConsumerCreateRequest.getClientId() + " subscriptionName=" + bEConsumerCreateRequest.getName());
        }
        if (invocable instanceof BETopicImpl && bEConsumerCreateRequest.getClientId() != null) {
            if (bEConsumerCreateRequest.getName() != null) {
                object = ((BETopicImpl)invocable).findDurableSubscriber(bEConsumerCreateRequest.getClientId(), bEConsumerCreateRequest.getName(), bEConsumerCreateRequest.getSelector(), bEConsumerCreateRequest.getNoLocal(), bEConsumerCreateRequest.getFlag(), bEConsumerCreateRequest.getClientIdPolicy(), bEConsumerCreateRequest.getSubscriptionSharingPolicy());
                if (object != null) {
                    if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                        JMSDebug.JMSBackEnd.debug("Found a durable subscriber sub.subscriptionPolicy = " + ((DurableSubscription)object).getSubscriptionSharingPolicy() + " request.subscriptionpolicy= " + bEConsumerCreateRequest.getSubscriptionSharingPolicy());
                    }
                    if (bEConsumerCreateRequest.getSubscriptionSharingPolicy() != ((DurableSubscription)object).getSubscriptionSharingPolicy() && ((DurableSubscription)object).getSubscribersCount() > 0) {
                        throw new InvalidSubscriptionSharingException("Cannot change the sharing policy on an active durable subscription");
                    }
                    BEConsumerImpl bEConsumerImpl = ((DurableSubscription)object).getConsumer();
                    if (!WLSPrincipals.isKernelUsername((String)JMSSecurityHelper.getSimpleAuthenticatedName())) {
                        ((BEDestinationCommon)invocable).getJMSDestinationSecurity().checkReceivePermission(JMSSecurityHelper.getCurrentSubject());
                        JMSService.getJMSService().registerSecurityParticipant(((BEDestinationCommon)invocable).getJMSDestinationSecurity().getJMSResourceForReceive(), bEConsumerImpl);
                    }
                    if (bEConsumerImpl.isClosed()) {
                        bEConsumerImpl.restore(bEConsumerCreateRequest, this, !bl);
                        return bEConsumerImpl;
                    }
                    if (bEConsumerCreateRequest.getSubscriptionSharingPolicy() == 0) {
                        throw new InvalidSubscriptionSharingException("Durable Subscription " + bEConsumerCreateRequest.getName() + " is in use and cannot be shared");
                    }
                    return ((BETopicImpl)invocable).createConsumer(this, !bl, bEConsumerCreateRequest, (Subscription)object);
                }
                if (bEConsumerCreateRequest.getFlag() == 0) {
                    throw new weblogic.jms.common.JMSException("Subscription not found");
                }
            } else if (bEConsumerCreateRequest.getClientId() != null) {
                object = ((BETopicImpl)invocable).findNonDurableSubscriber(bEConsumerCreateRequest.getClientId(), bEConsumerCreateRequest.getSelector(), bEConsumerCreateRequest.getNoLocal(), bEConsumerCreateRequest.getClientIdPolicy(), bEConsumerCreateRequest.getSubscriptionSharingPolicy());
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("createBEConsumer: found non durable " + object + " for " + bEConsumerCreateRequest.getClientId() + " " + bEConsumerCreateRequest.getSelector() + " " + bEConsumerCreateRequest.getNoLocal() + " " + bEConsumerCreateRequest.getClientIdPolicy() + " " + bEConsumerCreateRequest.getSubscriptionSharingPolicy());
                }
                if (object != null) {
                    if (((NonDurableSubscription)object).getSubscriptionSharingPolicy() != bEConsumerCreateRequest.getSubscriptionSharingPolicy() && ((NonDurableSubscription)object).getSubscribersCount() > 0) {
                        throw new InvalidSubscriptionSharingException("There is an active subscriber that uses a different subscription sharing policy");
                    }
                    if (((NonDurableSubscription)object).getSubscriptionSharingPolicy() != 0) {
                        return ((BETopicImpl)invocable).createConsumer(this, !bl, bEConsumerCreateRequest, (Subscription)object);
                    }
                }
            }
        }
        try {
            return ((BEDestinationImpl)invocable).createConsumer(this, !bl, bEConsumerCreateRequest);
        }
        catch (ClassCastException classCastException) {
            throw new weblogic.jms.common.JMSException("Invalid destination type", (Throwable)classCastException);
        }
    }

    private int createConsumer(BEConsumerCreateRequest bEConsumerCreateRequest) throws JMSException {
        BEConsumerImpl bEConsumerImpl = this.createBEConsumer(bEConsumerCreateRequest);
        this.registerConsumer(bEConsumerImpl);
        bEConsumerCreateRequest.setResult(new BEConsumerCreateResponse(bEConsumerImpl.registerConsumerReconnectInfo(bEConsumerCreateRequest.getConsumerReconnectInfo())));
        bEConsumerCreateRequest.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerConsumer(BEConsumerImpl bEConsumerImpl) throws JMSException {
        BESessionImpl bESessionImpl = this;
        synchronized (bESessionImpl) {
            this.consumers.add(bEConsumerImpl);
        }
        InvocableManagerDelegate.delegate.invocableAdd(17, bEConsumerImpl);
    }

    @Override
    public void peerGone() throws JMSException {
        this.performDelayedClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDelayedClose() throws JMSException {
        ArrayList<Invocable> arrayList;
        ArrayList<Invocable> arrayList2;
        BEConsumerImpl bEConsumerImpl = null;
        Object object = this;
        synchronized (object) {
            if (this.isPeerGone) {
                return;
            }
            this.isPeerGone = true;
            for (BEConsumerImpl bEConsumerImpl2 : this.consumers) {
                long l = bEConsumerImpl2.getDelayServerClose();
                if (l < 1L) {
                    bEConsumerImpl = null;
                    break;
                }
                if (bEConsumerImpl != null && l >= bEConsumerImpl.getDelayServerClose()) continue;
                bEConsumerImpl = bEConsumerImpl2;
            }
            if (bEConsumerImpl != null) {
                arrayList2 = new ArrayList<Invocable>(this.consumers);
                arrayList = new ArrayList<BEBrowser>(this.browsers.values());
                this.browsers.clear();
            } else {
                arrayList = null;
                arrayList2 = null;
            }
        }
        if (bEConsumerImpl == null) {
            this.close();
            return;
        }
        this.consumersStop(arrayList2);
        object = null;
        for (BEConsumerImpl bEConsumerImpl2 : arrayList2) {
            if (bEConsumerImpl2.getDelayServerClose() >= 1L) continue;
            try {
                bEConsumerImpl2.close(0L);
            }
            catch (JMSException jMSException) {
                if (object != null) continue;
                object = jMSException;
            }
        }
        this.browsersClose(arrayList);
        bEConsumerImpl.getDestination().getBackEnd().getTimerManager().schedule((TimerListener)this, bEConsumerImpl.getDelayServerClose());
        if (object != null) {
            throw object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        BESessionImpl bESessionImpl = this;
        synchronized (bESessionImpl) {
            if (this.closed) {
                return;
            }
        }
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            JMSLogger.logJMSServerShutdownError((String)this.getConnection().getDispatcher().getId().getName(), (String)jMSException.getMessage(), (Throwable)jMSException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long sequenceFromMsgId(MessageIDImpl messageIDImpl) {
        long l = Long.MAX_VALUE;
        BESessionImpl bESessionImpl = this;
        synchronized (bESessionImpl) {
            for (MessageElement messageElement : this.pendingMessages) {
                if (messageIDImpl.differentiatedEquals(messageElement.getMessage().getMessageID())) {
                    l = messageElement.getUserSequenceNum();
                    if (!JMSDebug.JMSBackEnd.isDebugEnabled()) break;
                    JMSDebug.JMSBackEnd.debug("reconnect closing lastSequenceNumber " + l);
                    break;
                }
                if (!JMSDebug.JMSBackEnd.isDebugEnabled() || messageElement.getMessage().getMessageID().getClass().equals(messageIDImpl.getClass())) continue;
                JMSDebug.JMSBackEnd.debug("comparing wrong classes me.id " + messageElement.getMessage().getMessageID().getClass() + " against last " + messageIDImpl.getClass());
            }
        }
        return l;
    }

    private void close(BESessionCloseRequest bESessionCloseRequest) throws JMSException {
        try {
            JMSService.getJMSService().checkShutdown();
        }
        catch (JMSException jMSException) {
            return;
        }
        if (bESessionCloseRequest.allowDelayClose()) {
            this.performDelayedClose();
            return;
        }
        this.close(bESessionCloseRequest.getLastSequenceNumber(), false);
    }

    @Override
    public void close() throws JMSException {
        this.close(Long.MAX_VALUE, false);
    }

    void close(JMSMessageId jMSMessageId) throws JMSException {
        this.close(this.sequenceFromMsgId(jMSMessageId), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void close(long l, boolean bl) throws JMSException {
        boolean bl2;
        CloseWait closeWait;
        block11: {
            block9: {
                block10: {
                    closeWait = null;
                    bl2 = false;
                    try {
                        ArrayList<Invocable> arrayList;
                        ArrayList<Invocable> arrayList2;
                        BESessionImpl bESessionImpl = this;
                        synchronized (bESessionImpl) {
                            if (this.closed) {
                                if (bl) {
                                    closeWait = this.closeInProgressLock;
                                }
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 8] lbl9 : MonitorExitStatement: MONITOREXIT : var8_5
                                Object var11_6 = null;
                                if (!bl2) break block9;
                                break block10;
                            }
                            closeWait = this.closeInProgressLock = new CloseWait();
                            this.closed = true;
                            bl2 = true;
                            arrayList2 = new ArrayList<Invocable>(this.consumers);
                            this.consumers.clear();
                            arrayList = new ArrayList<Invocable>(this.browsers.values());
                            this.browsers.clear();
                        }
                        this.closeInternal(arrayList2, l, arrayList);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var11_8 = null;
                        if (bl2) {
                            closeWait.complete();
                            this.connection.sessionRemove(this.getJMSID());
                            throw throwable;
                        }
                        if (closeWait == null) throw throwable;
                        closeWait.waitUntilClosed();
                        throw throwable;
                    }
                }
                closeWait.complete();
                this.connection.sessionRemove(this.getJMSID());
                return;
            }
            if (closeWait == null) return;
            closeWait.waitUntilClosed();
            return;
        }
        Object var11_7 = null;
        if (bl2) {
            closeWait.complete();
            this.connection.sessionRemove(this.getJMSID());
            return;
        }
        if (closeWait == null) return;
        closeWait.waitUntilClosed();
    }

    private void closeInternal(ArrayList<Invocable> arrayList, long l, ArrayList<Invocable> arrayList2) throws JMSException {
        this.consumersStop(arrayList);
        this.waitUntilIdle();
        this.recover(l, this.pipelineGeneration.get());
        JMSException jMSException = null;
        Iterator<Invocable> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                ((BEConsumerImpl)iterator.next()).close(0L);
            }
            catch (JMSException jMSException2) {
                jMSException = jMSException2;
            }
        }
        this.browsersClose(arrayList2);
        if (jMSException != null) {
            throw jMSException;
        }
    }

    private void consumersStop(ArrayList<Invocable> arrayList) {
        Iterator<Invocable> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((BEConsumerImpl)iterator.next()).stop();
        }
    }

    private void browsersClose(ArrayList<Invocable> arrayList) {
        Iterator<Invocable> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((BEBrowserImpl)iterator.next()).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createBrowser(BEBrowserCreateRequest bEBrowserCreateRequest) throws JMSException {
        Invocable invocable = this;
        synchronized (invocable) {
            if (this.closedOrPeerGone()) {
                throw new JMSException("Session is closed");
            }
        }
        invocable = (BEDestinationImpl)InvocableManagerDelegate.delegate.invocableFind(20, bEBrowserCreateRequest.getDestinationId());
        ((BEDestinationImpl)invocable).checkShutdownOrSuspended("create browser");
        BEBrowser bEBrowser = ((BEDestinationImpl)invocable).createBrowser(this, bEBrowserCreateRequest.getSelector());
        JMSService.getJMSService().registerSecurityParticipant(((BEDestinationCommon)invocable).getJMSDestinationSecurity().getJMSResourceForBrowse(), (BEBrowserImpl)bEBrowser);
        this.browserAdd(bEBrowser);
        bEBrowserCreateRequest.setResult(new JMSBrowserCreateResponse(bEBrowser.getJMSID()));
        bEBrowserCreateRequest.setState(Integer.MAX_VALUE);
        return bEBrowserCreateRequest.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void browserAdd(BEBrowser bEBrowser) throws JMSException {
        InvocableManagerDelegate.delegate.invocableAdd(18, bEBrowser);
        BESessionImpl bESessionImpl = this;
        synchronized (bESessionImpl) {
            this.browsers.put(bEBrowser.getJMSID(), bEBrowser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void browserRemove(JMSID jMSID) {
        BESessionImpl bESessionImpl = this;
        synchronized (bESessionImpl) {
            this.browsers.remove(jMSID);
        }
        InvocableManagerDelegate.delegate.invocableRemove(18, jMSID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws JMSException {
        ArrayList<BEConsumerImpl> arrayList;
        this.connection.checkShutdownOrSuspendedNeedLock("start session");
        BESessionImpl bESessionImpl = this;
        synchronized (bESessionImpl) {
            if (this.closedOrPeerGone() || !this.stopped) {
                return;
            }
            arrayList = new ArrayList<BEConsumerImpl>(this.consumers);
        }
        for (BEConsumerImpl bEDeliveryList2 : arrayList) {
            bEDeliveryList2.start();
        }
        BESessionImpl bESessionImpl2 = this;
        synchronized (bESessionImpl2) {
            this.stopped = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ArrayList<BEConsumerImpl> arrayList;
        BESessionImpl bESessionImpl = this;
        synchronized (bESessionImpl) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            arrayList = new ArrayList<BEConsumerImpl>(this.consumers);
        }
        for (BEConsumerImpl bEConsumerImpl : arrayList) {
            bEConsumerImpl.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRedeliveryDelay(long l) throws JMSException {
        ArrayList<BEConsumerImpl> arrayList;
        BESessionImpl bESessionImpl = this;
        synchronized (bESessionImpl) {
            if (this.closedOrPeerGone()) {
                throw new weblogic.jms.common.JMSException("Session is closed");
            }
            arrayList = new ArrayList<BEConsumerImpl>(this.consumers);
        }
        for (BEConsumerImpl bEConsumerImpl : arrayList) {
            bEConsumerImpl.setRedeliveryDelay(l);
        }
    }

    private synchronized List<MessageElement> removeBefore(long l) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Removing pending messages through " + (l == Long.MAX_VALUE ? "MAX" : "" + l) + " sessionId " + this.sessionId + " sequenceId " + this.sequencerId + " connection " + this.connection);
        }
        int n = this.pendingMessages.size();
        ArrayList<MessageElement> arrayList = new ArrayList<MessageElement>(n);
        for (int i = 0; i < n; ++i) {
            MessageElement messageElement = (MessageElement)this.pendingMessages.remove();
            if (messageElement.getUserSequenceNum() <= l) {
                arrayList.add(messageElement);
                continue;
            }
            this.pendingMessages.add((Object)messageElement);
        }
        return arrayList;
    }

    private synchronized List<MessageElement> removeAfter(long l, BEConsumerImpl bEConsumerImpl) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Removing pending and outgoing messages after " + l);
        }
        int n = this.pendingMessages.size();
        ArrayList<MessageElement> arrayList = new ArrayList<MessageElement>(n);
        for (int i = 0; i < n; ++i) {
            MessageElement messageElement = (MessageElement)this.pendingMessages.remove();
            if (messageElement.getUserSequenceNum() > l && (BEConsumerImpl)messageElement.getUserData() == bEConsumerImpl) {
                arrayList.add(messageElement);
                continue;
            }
            this.pendingMessages.add((Object)messageElement);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledgeStart(BESessionAcknowledgeRequest bESessionAcknowledgeRequest) throws JMSException {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Starting an acknowledge request for sequence number " + bESessionAcknowledgeRequest.getLastSequenceNumber());
        }
        bESessionAcknowledgeRequest.setWorkManager(this.workManager);
        bESessionAcknowledgeRequest.setTransaction(TransactionHelper.getTransactionHelper().getTransaction());
        List<MessageElement> list = this.removeBefore(bESessionAcknowledgeRequest.getLastSequenceNumber());
        if (list.isEmpty()) {
            BESessionImpl bESessionImpl = this;
            synchronized (bESessionImpl) {
                if (this.lastSeqAcked < bESessionAcknowledgeRequest.getLastSequenceNumber()) {
                    throw new JMSException("Cannot acknowledge messages: likely server is shutting down or consumer is closed");
                }
                bESessionAcknowledgeRequest.setState(11001);
            }
        } else {
            bESessionAcknowledgeRequest.setIterator(list.listIterator());
            bESessionAcknowledgeRequest.setState(11000);
        }
    }

    private static KernelRequest acknowledgeContinue(BESessionAcknowledgeRequest bESessionAcknowledgeRequest) throws JMSException {
        MessageElement messageElement;
        int n = 0;
        Queue queue = null;
        BEConsumerImpl bEConsumerImpl = null;
        ArrayList<MessageElement> arrayList = new ArrayList<MessageElement>();
        ListIterator listIterator = bESessionAcknowledgeRequest.getIterator();
        while (listIterator.hasNext()) {
            messageElement = (MessageElement)listIterator.next();
            if (queue != null && queue != messageElement.getQueue()) {
                listIterator.previous();
                break;
            }
            arrayList.add(messageElement);
            if (bEConsumerImpl == messageElement.getUserData()) {
                ++n;
            } else {
                if (bEConsumerImpl != null) {
                    if (bESessionAcknowledgeRequest.isTransactional()) {
                        BESessionImpl bESessionImpl = bEConsumerImpl.getSession();
                        if (!(messageElement.getGroup() == null || bESessionImpl != null && bESessionImpl.recoveryUnit != bESessionImpl && bEConsumerImpl.hasListener())) {
                            throw new JMSException("Cannot change group recover owner.");
                        }
                        bEConsumerImpl.incrementPendingCountTransactionally(bESessionAcknowledgeRequest.getTransaction(), n, false);
                    } else {
                        bEConsumerImpl.incrementPendingCount(n, false);
                    }
                }
                bEConsumerImpl = (BEConsumerImpl)messageElement.getUserData();
                n = 1;
            }
            queue = messageElement.getQueue();
        }
        if (arrayList.isEmpty()) {
            bESessionAcknowledgeRequest.setState(11001);
            return null;
        }
        if (bEConsumerImpl != null) {
            if (bESessionAcknowledgeRequest.isTransactional()) {
                bEConsumerImpl.incrementPendingCountTransactionally(bESessionAcknowledgeRequest.getTransaction(), n, false);
            } else {
                bEConsumerImpl.incrementPendingCount(n, false);
            }
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Acknowledging " + arrayList.size() + " messages for " + queue.getName() + " session " + bEConsumerImpl.getSession());
        }
        messageElement = null;
        try {
            if (bESessionAcknowledgeRequest.isTransactional()) {
                queue.associate(arrayList, (RedeliveryParameters)bEConsumerImpl);
            } else {
                messageElement = queue.acknowledge(arrayList);
            }
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        if (!listIterator.hasNext()) {
            bESessionAcknowledgeRequest.setState(11001);
        }
        return messageElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acknowledge(BESessionAcknowledgeRequest bESessionAcknowledgeRequest) throws JMSException {
        block15: while (true) {
            switch (bESessionAcknowledgeRequest.getState()) {
                case 0: {
                    this.acknowledgeStart(bESessionAcknowledgeRequest);
                    break;
                }
                case 11000: {
                    KernelRequest kernelRequest;
                    if (bESessionAcknowledgeRequest.getKernelRequest() != null) {
                        try {
                            bESessionAcknowledgeRequest.getKernelRequest().getResult();
                            bESessionAcknowledgeRequest.setKernelRequest(null);
                        }
                        catch (KernelException kernelException) {
                            throw new weblogic.jms.common.JMSException(kernelException);
                        }
                    }
                    if ((kernelRequest = BESessionImpl.acknowledgeContinue(bESessionAcknowledgeRequest)) == null) continue block15;
                    BESessionImpl bESessionImpl = kernelRequest;
                    synchronized (bESessionImpl) {
                        if (!kernelRequest.hasResult()) {
                            bESessionAcknowledgeRequest.setKernelRequest(kernelRequest);
                            bESessionAcknowledgeRequest.needOutsideResult();
                            kernelRequest.addListener((KernelListener)new DispatcherCompletionListener(bESessionAcknowledgeRequest));
                            return bESessionAcknowledgeRequest.getState();
                        }
                        break;
                    }
                }
                case 11001: {
                    if (bESessionAcknowledgeRequest.getKernelRequest() != null) {
                        try {
                            bESessionAcknowledgeRequest.getKernelRequest().getResult();
                            bESessionAcknowledgeRequest.setKernelRequest(null);
                        }
                        catch (KernelException kernelException) {
                            throw new weblogic.jms.common.JMSException(kernelException);
                        }
                    }
                    if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                        JMSDebug.JMSBackEnd.debug("Acknowledgement complete");
                    }
                    BESessionImpl bESessionImpl = this;
                    synchronized (bESessionImpl) {
                        this.lastSeqAcked = bESessionAcknowledgeRequest.getLastSequenceNumber();
                    }
                    bESessionAcknowledgeRequest.setIterator(null);
                    bESessionAcknowledgeRequest.setResult(VoidResponse.THE_ONE);
                    bESessionAcknowledgeRequest.setState(Integer.MAX_VALUE);
                    return Integer.MAX_VALUE;
                }
                default: {
                    throw new AssertionError((Object)"Invalid request state");
                }
            }
        }
    }

    private int recover(BESessionRecoverRequest bESessionRecoverRequest) throws JMSException {
        if (this.closed) {
            throw new weblogic.jms.common.JMSException("Session is closed");
        }
        JMSService.getJMSService().checkShutdown();
        if (bESessionRecoverRequest.getPipelineGeneration() == 0) {
            this.recover81(bESessionRecoverRequest);
        } else {
            this.recover90(bESessionRecoverRequest);
        }
        bESessionRecoverRequest.setResult(new JMSSessionRecoverResponse(bESessionRecoverRequest.getLastSequenceNumber()));
        bESessionRecoverRequest.setState(Integer.MAX_VALUE);
        return bESessionRecoverRequest.getState();
    }

    private boolean closedOrPeerGone() {
        return this.closed || this.isPeerGone;
    }

    private void recover81(BESessionRecoverRequest bESessionRecoverRequest) throws JMSException {
        this.recover(bESessionRecoverRequest.getLastSequenceNumber(), this.pipelineGeneration.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover90(BESessionRecoverRequest bESessionRecoverRequest) throws JMSException {
        ArrayList<BEConsumerImpl> arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList<BEConsumerImpl>(this.consumers);
        }
        object = new HashMap(arrayList.size());
        for (BEConsumerImpl bEConsumerImpl : arrayList) {
            if (!bEConsumerImpl.stopListening()) continue;
            object.put(bEConsumerImpl.getId(), bEConsumerImpl);
        }
        this.waitUntilIdle();
        this.recover(bESessionRecoverRequest.getLastSequenceNumber(), bESessionRecoverRequest.getPipelineGeneration());
        for (BEConsumerImpl bEConsumerImpl : arrayList) {
            if (object.get(bEConsumerImpl.getId()) == null) continue;
            bEConsumerImpl.startListening();
        }
    }

    private void replaceMessages(List<MessageElement> list, boolean bl) throws JMSException {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Replacing " + list.size() + " messages on the kernel queue," + (bl ? " incrementing" : " without incrementing"));
        }
        KernelRequest kernelRequest = new KernelRequest();
        Iterator<MessageElement> iterator = list.iterator();
        try {
            while (iterator.hasNext()) {
                MessageElement messageElement = iterator.next();
                BEConsumerImpl bEConsumerImpl = (BEConsumerImpl)messageElement.getUserData();
                kernelRequest.reset();
                messageElement.getQueue().negativeAcknowledge(messageElement, bEConsumerImpl.getRedeliveryDelay(), bl, kernelRequest);
                kernelRequest.getResult();
                bEConsumerImpl.incrementPendingCount(1, true);
            }
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover(long l, int n) throws JMSException {
        List<MessageElement> list;
        List<MessageElement> list2;
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Got a recover request for sequence num " + l);
        }
        BESessionImpl bESessionImpl = this;
        synchronized (bESessionImpl) {
            this.pipelineGeneration.set(n);
            list2 = this.removeBefore(l);
            list = this.pendingMessages.isEmpty() ? null : this.removeBefore(Long.MAX_VALUE);
        }
        this.replaceMessages(list2, true);
        if (list != null) {
            this.replaceMessages(list, false);
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            if (list == null) {
                JMSDebug.JMSBackEnd.debug("recovered " + list2.size() + " messages before " + l);
            } else {
                JMSDebug.JMSBackEnd.debug("recovered " + list2.size() + " messages before " + l + ", and " + list.size() + " afterwards");
            }
        }
    }

    synchronized void addPendingMessage(MessageElement messageElement, BEConsumerImpl bEConsumerImpl) {
        assert (messageElement.getUserSequenceNum() > 0L);
        this.pendingMessages.add((Object)messageElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumer(BEConsumerImpl bEConsumerImpl, long l) throws JMSException {
        this.replaceMessages(this.removeAfter(l, bEConsumerImpl), l == 0L);
        InvocableManagerDelegate.delegate.invocableRemove(17, bEConsumerImpl.getJMSID());
        BESessionImpl bESessionImpl = this;
        synchronized (bESessionImpl) {
            this.consumers.remove(bEConsumerImpl);
        }
    }

    void removeConsumerWithError(BEConsumerImpl bEConsumerImpl, long l, weblogic.jms.common.JMSException jMSException) throws JMSException {
        this.removeConsumer(bEConsumerImpl, l);
        if (this.connection != null) {
            JMSServerUtilities.anonDispatchNoReply(new JMSPushExceptionRequest(10, bEConsumerImpl.getJMSID(), jMSException), this.connection.getDispatcher());
        }
    }

    boolean allowsImplicitAcknowledge() {
        if (this.transacted) {
            return false;
        }
        return this.clientVersion >= 3;
    }

    private void decorateMessageWithSequence(WLMessage wLMessage, String string, long l) {
        wLMessage.setSAFSeqNumber(l);
        wLMessage.setSAFSequenceName(string);
    }

    @Override
    protected void pushMessages(List list) {
        JMSPushRequest jMSPushRequest = null;
        JMSPushRequest jMSPushRequest2 = null;
        for (MessageElement messageElement : list) {
            BEConsumerImpl bEConsumerImpl;
            boolean bl;
            boolean bl2;
            Sequence sequence = messageElement.getSequence();
            if (sequence != null) {
                this.decorateMessageWithSequence((WLMessage)messageElement.getMessage(), sequence.getName(), messageElement.getSequenceNum());
            }
            boolean bl3 = bl2 = (bl = (bEConsumerImpl = (BEConsumerImpl)messageElement.getUserData()).allowsImplicitAcknowledge()) || this.acknowledgeMode == 4;
            if (!bl2) {
                this.addPendingMessage(messageElement, bEConsumerImpl);
                bEConsumerImpl.adjustUnackedCount(1);
            }
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("BACKEND/BESession (id: " + this.sessionId + ") : " + "BACKEND/BEConsumer (id: " + bEConsumerImpl.getClientID() + ", sub: " + bEConsumerImpl.getSubscriptionName() + ") : " + "Pushing to the frontend, message " + ((MessageImpl)messageElement.getMessage()).getJMSMessageID());
            }
            JMSPushRequest jMSPushRequest3 = new JMSPushRequest(13, this.sequencerId, (MessageImpl)messageElement.getMessage(), bEConsumerImpl.createPushEntry(messageElement, bl, bl2));
            if (jMSPushRequest == null) {
                jMSPushRequest = jMSPushRequest2 = jMSPushRequest3;
            } else {
                jMSPushRequest2.setNext(jMSPushRequest3);
                jMSPushRequest2 = jMSPushRequest3;
            }
            MessageTimeStamp.record(4, jMSPushRequest3.getMessage());
            if (!bl2 || bEConsumerImpl.isKernelAutoAcknowledge()) continue;
            try {
                KernelRequest kernelRequest = bEConsumerImpl.getKernelQueue().acknowledge(messageElement);
                if (kernelRequest == null) continue;
                kernelRequest.getResult();
            }
            catch (KernelException kernelException) {
                if (!JMSDebug.JMSBackEnd.isDebugEnabled()) continue;
                JMSDebug.JMSBackEnd.debug("Unexpected exception while implicitly acknowledging: " + (Object)((Object)kernelException), (Throwable)kernelException);
            }
        }
        if (jMSPushRequest == null) {
            return;
        }
        if (this.aDestination != null && this.aggregationCounter == null && !this.noAggregation) {
            MessageTimeStamp.newAggregationCounter(this.aDestination + "-" + this.toString(), 51);
        }
        if (this.aggregationCounter != null) {
            this.aggregationCounter.increment(list.size());
        } else {
            this.noAggregation = true;
        }
        try {
            JMSServerUtilities.anonDispatchNoReply(jMSPushRequest, this.getConnection().getDispatcher());
        }
        catch (JMSException jMSException) {
            JMSLogger.logErrorPushingMessage((String)jMSException.toString(), (Throwable)jMSException);
        }
    }

    @Override
    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("Session");
        xMLStreamWriter.writeAttribute("id", this.sessionId != null ? this.sessionId.toString() : "");
        xMLStreamWriter.writeAttribute("pendingMessagesCurrentCount", String.valueOf(this.pendingMessages.size()));
        xMLStreamWriter.writeAttribute("browsersCurrentCount", String.valueOf(this.browsers.size()));
        xMLStreamWriter.writeStartElement("Consumers");
        assert (this.consumers instanceof HashSet);
        HashSet hashSet = (HashSet)((HashSet)this.consumers).clone();
        xMLStreamWriter.writeAttribute("currentCount", String.valueOf(hashSet.size()));
        for (BEConsumerCommon bEConsumerCommon : hashSet) {
            bEConsumerCommon.dump(jMSDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof BESessionImpl) {
            BESessionImpl bESessionImpl = (BESessionImpl)object;
            return bESessionImpl.sessionId != null ? bESessionImpl.sessionId.equals(this.sessionId) : bESessionImpl.sessionId == this.sessionId;
        }
        return false;
    }

    public int hashCode() {
        return this.sessionId != null ? this.sessionId.hashCode() : 0;
    }

    static {
        String string;
        String string2 = Simple.getenv("weblogic.jms.PushDelay");
        int n = 3;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        PUSH_DELAY = n;
        int n2 = 0;
        if (PUSH_DELAY != 0 && (string = Simple.getenv("weblogic.jms.MaxTotalDelay")) != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        MAX_TOTAL_DELAY = n2;
    }

    private static class CloseWait {
        boolean completed;
        boolean waiters;

        private CloseWait() {
        }

        private synchronized void complete() {
            this.completed = true;
            if (this.waiters) {
                this.notifyAll();
            }
        }

        private synchronized void waitUntilClosed() {
            if (this.completed) {
                return;
            }
            this.waiters = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new AssertionError((Object)interruptedException);
            }
        }
    }

    private class XASessionOwner
    implements GroupOwner {
        private XASessionOwner() {
        }

        public boolean exposeOnlyOneMessage() {
            return true;
        }
    }
}

