/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSSessionRecoverResponse;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.Sequencer;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class BESessionRecoverRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -7100249057361747189L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int ALGORITHM_90 = 1024;
    private long lastSequenceNumber;
    private int pipelineGeneration;
    private transient Sequencer sequencer;

    public BESessionRecoverRequest(JMSID jMSID, long l, Sequencer sequencer, int n) {
        super(jMSID, 13840);
        this.lastSequenceNumber = l;
        this.sequencer = sequencer;
        this.pipelineGeneration = n;
    }

    final long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public final Sequencer getSequencer() {
        return this.sequencer;
    }

    final int getPipelineGeneration() {
        return this.pipelineGeneration;
    }

    public int remoteSignature() {
        return 17;
    }

    public Response createResponse() {
        return new JMSSessionRecoverResponse();
    }

    public BESessionRecoverRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1 | this.pipelineGeneration;
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.lastSequenceNumber);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.lastSequenceNumber = objectInput.readLong();
        this.pipelineGeneration = n & 0xF00000;
    }
}

