/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import weblogic.jms.JMSLogger;
import weblogic.messaging.common.ThresholdHandler;
import weblogic.messaging.kernel.Destination;
import weblogic.messaging.kernel.Kernel;
import weblogic.messaging.kernel.Threshold;

final class BEThresholdHandler
extends ThresholdHandler {
    private final boolean isDestination;
    private String destName;

    BEThresholdHandler(String string, String string2) {
        super(string);
        this.isDestination = true;
        this.destName = string2;
    }

    BEThresholdHandler(Kernel kernel, String string) {
        super(kernel, string);
        this.isDestination = false;
    }

    void setTarget(Destination destination) {
        this.statistics = destination.getStatistics();
        this.replaceBytesThreshold();
        this.replaceMessagesThreshold();
    }

    public synchronized void onThreshold(Threshold threshold, boolean bl) {
        if (bl) {
            ++this.count;
            if (threshold == this.bytes) {
                if (this.isDestination) {
                    JMSLogger.logBytesThresholdHighDestination((String)this.targetName, (String)this.destName);
                } else {
                    JMSLogger.logBytesThresholdHighServer((String)this.targetName);
                }
            } else if (this.isDestination) {
                JMSLogger.logMessagesThresholdHighDestination((String)this.targetName, (String)this.destName);
            } else {
                JMSLogger.logMessagesThresholdHighServer((String)this.targetName);
            }
        } else {
            --this.count;
            if (threshold == this.bytes) {
                if (this.isDestination) {
                    JMSLogger.logBytesThresholdLowDestination((String)this.targetName, (String)this.destName);
                } else {
                    JMSLogger.logBytesThresholdLowServer((String)this.targetName);
                }
            } else if (this.isDestination) {
                JMSLogger.logMessagesThresholdLowDestination((String)this.targetName, (String)this.destName);
            } else {
                JMSLogger.logMessagesThresholdLowServer((String)this.targetName);
            }
        }
    }
}

