/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEConnectionConsumerImpl;
import weblogic.jms.backend.BEConsumerCommon;
import weblogic.jms.backend.BEConsumerCreateRequest;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEMulticastConsumer;
import weblogic.jms.backend.BESessionImpl;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.DSManager;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DurableSubscription;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDestinationSecurity;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSSQLExpression;
import weblogic.jms.common.JMSSQLFilter;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.NonDurableSubscription;
import weblogic.jms.common.Subscription;
import weblogic.jms.multicast.JMSTMSocket;
import weblogic.management.runtime.JMSDurableSubscriberRuntimeMBean;
import weblogic.messaging.kernel.Destination;
import weblogic.messaging.kernel.EventListener;
import weblogic.messaging.kernel.Filter;
import weblogic.messaging.kernel.InvalidExpressionException;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.Quota;
import weblogic.messaging.kernel.Topic;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.security.WLSPrincipals;
import weblogic.store.PersistentHandle;

public final class BETopicImpl
extends BEDestinationImpl {
    private static final String DURABLE_SUB_PREFIX = "_weblogic.jms.DS.";
    private static final String SHARABLE_NON_DURABLE_SUB_PREFIX = "_weblogic.jms.sharable.NDS.";
    private Topic topic;
    private final HashMap durableRuntimeMBeans = new HashMap();
    private int multicastConsumerCount;
    private boolean messageLogging;
    private String multicastAddress;
    private int multicastPort;
    private byte multicastTTL;
    private InetAddress multicastGroup;
    private BEMulticastConsumer multicastConsumer;
    private HashMap nonDurableSubscriptions = new HashMap();
    private TopicBean topicBean;

    public BETopicImpl(TopicBean topicBean, BackEnd backEnd, String string, boolean bl, JMSDestinationSecurity jMSDestinationSecurity) throws JMSException {
        super(backEnd, string, bl, jMSDestinationSecurity);
        this.topicBean = topicBean;
        Topic topic = backEnd.findKernelTopic(string);
        if (topic == null) {
            topic = backEnd.createKernelTopic(string, null);
        }
        this.setKernel(topic);
    }

    protected void setKernel(Topic topic) throws JMSException {
        super.setKernel((Destination)topic);
        this.topic = topic;
    }

    public void open() throws JMSException {
        DestinationImpl destinationImpl = this.getDestinationImpl();
        String string = this.getMulticastAddress();
        if (string != null && string.length() != 0) {
            try {
                this.setMulticastGroup(InetAddress.getByName(string));
            }
            catch (UnknownHostException unknownHostException) {
                throw new JMSException("MulticastAddress is not valid");
            }
            destinationImpl.setMulticastAddress(string);
            destinationImpl.setPort(this.getMulticastPort());
            JMSService.getJMSService().openMulticastSendSocket();
        }
        super.open();
        try {
            this.topic.setFilter((Filter)new JMSSQLFilter(this.topic.getKernel()));
            this.topic.setProperty("RedirectionListener", (Object)this);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        if (this.isMessageLoggingEnabled() && !this.backEnd.isMemoryLow()) {
            this.messageLogging = true;
        }
    }

    public int getDestinationTypeIndicator() {
        return this.isTemporary() ? 8 : 2;
    }

    public Queue createSubscriptionQueue(String string, boolean bl) throws JMSException {
        return this.createSubscriptionQueue(string, bl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Queue createSubscriptionQueue(String string, boolean bl, int n) throws JMSException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("MaximumMessageSize", new Integer(this.maximumMessageSize));
        hashMap.put("Quota", this.topic.getProperty("Quota"));
        hashMap.put("RedirectionListener", this);
        if (!bl) {
            hashMap.put("StatisticsMode", "Bypass");
        }
        try {
            Queue queue = null;
            BackEnd backEnd = this.backEnd;
            synchronized (backEnd) {
                if (bl || n == 1) {
                    queue = this.backEnd.findKernelQueue(string);
                }
                if (queue == null) {
                    queue = this.backEnd.createKernelQueue(string, hashMap);
                } else if (n != 1) {
                    queue.setProperties(hashMap);
                }
                queue.setComparator((Comparator)this.comparator);
                return queue;
            }
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    public void activateSubscriptionQueue(Queue queue, BEConsumerImpl bEConsumerImpl, JMSSQLExpression jMSSQLExpression, boolean bl, boolean bl2) throws JMSException {
        try {
            if (bl && bEConsumerImpl != null) {
                queue.addListener((EventListener)bEConsumerImpl);
                if (this.isMessageLoggingEnabled() && !this.backEnd.isMemoryLow()) {
                    queue.setProperty("Logging", (Object)new Integer(15));
                }
            }
            queue.setProperty("Durable", (Object)new Boolean(bl2 && this.backEnd.isStoreEnabled()));
            queue.suspend(this.destination.getMask());
            queue.resume(16384);
            KernelRequest kernelRequest = new KernelRequest();
            this.topic.subscribe(queue, (Object)jMSSQLExpression, kernelRequest);
            kernelRequest.getResult();
        }
        catch (InvalidExpressionException invalidExpressionException) {
            throw new InvalidSelectorException(invalidExpressionException.toString());
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestinationKeysList(List list) {
        ArrayList arrayList;
        Object object = this;
        synchronized (object) {
            super.setDestinationKeysList(list);
            arrayList = new ArrayList(this.consumers);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Queue queue = ((BEConsumerImpl)object.next()).getKernelQueue();
            if (queue == null) continue;
            queue.setComparator((Comparator)this.comparator);
        }
    }

    protected int getAdjustedExpirationPolicy(boolean bl) {
        if ((this.expirationPolicy == 2 || this.expirationPolicy == 4) && bl) {
            return 1;
        }
        return this.expirationPolicy;
    }

    public static String getSubscriptionQueueName(JMSID jMSID, String string, String string2) {
        return BETopicImpl.getSubscriptionQueueName(jMSID, string, 0, string2, 0, null, null);
    }

    private String getSubscriptionQueueName(BEConsumerCreateRequest bEConsumerCreateRequest, Subscription subscription, String string, String string2) {
        if (bEConsumerCreateRequest.getClientId() != null && bEConsumerCreateRequest.getName() == null && bEConsumerCreateRequest.getSubscriptionSharingPolicy() == 1) {
            if (subscription != null) {
                return ((NonDurableSubscription)subscription).getSubscriptionQueueName();
            }
            return this.getNextSharableNonDurableSubName(bEConsumerCreateRequest.getClientId());
        }
        return BETopicImpl.getSubscriptionQueueName(bEConsumerCreateRequest.getConsumerId(), bEConsumerCreateRequest.getClientId(), bEConsumerCreateRequest.getClientIdPolicy(), bEConsumerCreateRequest.getName(), bEConsumerCreateRequest.getSubscriptionSharingPolicy(), string, string2);
    }

    private static String getSubscriptionQueueName(JMSID jMSID, String string, int n, String string2, int n2, String string3, String string4) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("BETopicImpl: getSubscriptionQueueName: cleintId=" + string + " name =" + string2 + " client id policy = " + n + " subscriptionSharingPolicy = " + n2 + " topic name = " + string3 + " JMS Server name = " + string4);
        }
        if (string != null && string2 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(DURABLE_SUB_PREFIX);
            stringBuffer.append(string);
            stringBuffer.append('.');
            stringBuffer.append(string2);
            if (n == 1) {
                stringBuffer.append("@" + string3 + "@" + string4);
            }
            return stringBuffer.toString();
        }
        return jMSID.toString();
    }

    protected BEConsumerImpl createConsumer(BESessionImpl bESessionImpl, boolean bl, BEConsumerCreateRequest bEConsumerCreateRequest) throws JMSException {
        return this.createConsumer(bESessionImpl, bl, bEConsumerCreateRequest, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BEConsumerImpl createConsumer(BESessionImpl bESessionImpl, boolean bl, BEConsumerCreateRequest bEConsumerCreateRequest, Subscription subscription) throws JMSException {
        BEConsumerImpl bEConsumerImpl;
        block41: {
            String string;
            Subscription subscription2;
            boolean bl2;
            block39: {
                this.checkShutdownOrSuspendedNeedLock("create consumer");
                JMSID jMSID = bESessionImpl != null ? bESessionImpl.getConnection().getJMSID() : null;
                bl2 = bEConsumerCreateRequest.getClientId() != null && bEConsumerCreateRequest.getName() != null;
                boolean bl3 = false;
                int n = 0;
                if (!bl2) {
                    n |= 4;
                }
                if (bESessionImpl != null && bESessionImpl.getAcknowledgeMode() == 128) {
                    if (this.multicastGroup == null) {
                        throw new weblogic.jms.common.JMSException("Topic " + this.name + " does not support MULTICAST_NO_ACKNOWLEDGE delivery mode");
                    }
                    n |= 0x10;
                    bl3 = true;
                }
                JMSSQLExpression jMSSQLExpression = null;
                Queue queue = null;
                if (!bl3) {
                    jMSSQLExpression = new JMSSQLExpression(bEConsumerCreateRequest.getSelector(), bEConsumerCreateRequest.getNoLocal(), jMSID, bEConsumerCreateRequest.getClientId(), bEConsumerCreateRequest.getClientIdPolicy());
                    queue = this.createSubscriptionQueue(this.getSubscriptionQueueName(bEConsumerCreateRequest, subscription, this.getName(), this.getBackEnd().getName()), bl2, bEConsumerCreateRequest.getSubscriptionSharingPolicy());
                }
                if (bl2 && this.backEnd.isStoreEnabled()) {
                    DurableSubscription durableSubscription = (DurableSubscription)subscription;
                    if (!WLSPrincipals.isKernelUsername((String)JMSSecurityHelper.getSimpleAuthenticatedName())) {
                        this.getJMSDestinationSecurity().checkReceivePermission(JMSSecurityHelper.getCurrentSubject());
                    }
                }
                boolean bl4 = false;
                bEConsumerImpl = null;
                subscription2 = null;
                string = BEConsumerImpl.clientIdPlusName(bEConsumerCreateRequest.getClientId(), bEConsumerCreateRequest.getName(), bEConsumerCreateRequest.getClientIdPolicy(), this.getName(), this.getBackEnd().getName());
                try {
                    bEConsumerImpl = new BEConsumerImpl(bESessionImpl, this, queue, n, false, bEConsumerCreateRequest);
                    this.addConsumer(bEConsumerImpl);
                    if (!bl3) {
                        subscription2 = bEConsumerImpl.getSubscription();
                        boolean bl5 = true;
                        if (subscription2 != null) {
                            Subscription subscription3 = subscription2;
                            synchronized (subscription3) {
                                if (subscription2.getSubscribersCount() > 1 && bEConsumerCreateRequest.getSubscriptionSharingPolicy() == 1) {
                                    bl5 = false;
                                }
                            }
                        }
                        if (bl5) {
                            boolean bl6 = bl2 || JMSService.getJMSService().shouldMessageLogNonDurableSubscriber();
                            this.activateSubscriptionQueue(queue, bEConsumerImpl, jMSSQLExpression, bl6, bl2);
                        }
                        bl4 = true;
                    }
                    Object var19_20 = null;
                    if (bl4) break block39;
                }
                catch (Throwable throwable) {
                    Object var19_21 = null;
                    if (!bl4) {
                        BETopicImpl.deleteFailedConsumer(bEConsumerImpl, bl2);
                    } else if (bl2) {
                        Map map = this.backEnd.getDurableSubscriptionsMap();
                        synchronized (map) {
                            if (subscription2 == null) {
                                subscription2 = this.backEnd.getDurableSubscription(string);
                            }
                            if (subscription2 != null) {
                                Subscription subscription4 = subscription2;
                                synchronized (subscription4) {
                                    if (((DurableSubscription)subscription2).isPending()) {
                                        ((DurableSubscription)subscription2).setPending(false);
                                        if (((DurableSubscription)subscription2).hasWaits()) {
                                            subscription2.notifyAll();
                                        }
                                    }
                                }
                            }
                        }
                    }
                    throw throwable;
                }
                BETopicImpl.deleteFailedConsumer(bEConsumerImpl, bl2);
                break block41;
            }
            if (bl2) {
                Map map = this.backEnd.getDurableSubscriptionsMap();
                synchronized (map) {
                    if (subscription2 == null) {
                        subscription2 = this.backEnd.getDurableSubscription(string);
                    }
                    if (subscription2 != null) {
                        Subscription subscription5 = subscription2;
                        synchronized (subscription5) {
                            if (((DurableSubscription)subscription2).isPending()) {
                                ((DurableSubscription)subscription2).setPending(false);
                                if (((DurableSubscription)subscription2).hasWaits()) {
                                    subscription2.notifyAll();
                                }
                            }
                        }
                    }
                }
            }
        }
        if (bl) {
            bEConsumerImpl.start();
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Created a new consumer with ID " + bEConsumerCreateRequest.getConsumerId() + " on topic " + this.name);
        }
        return bEConsumerImpl;
    }

    static void deleteFailedConsumer(BEConsumerImpl bEConsumerImpl, boolean bl) {
        if (bEConsumerImpl == null) {
            return;
        }
        try {
            if (bl) {
                bEConsumerImpl.doDurableSubscriptionCleanup(bEConsumerImpl.getDestination().getBackEnd().getDurableSubscription(bEConsumerImpl.getName()), true, false, true, false);
            } else {
                bEConsumerImpl.close(0L);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverDurableSubscription(PersistentHandle persistentHandle, String string, int n, String string2, JMSSQLExpression jMSSQLExpression) throws JMSException {
        block14: {
            Subscription subscription;
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Recovered a durable subscription " + string2 + " on topic " + this.name);
            }
            Queue queue = this.createSubscriptionQueue(BETopicImpl.getSubscriptionQueueName(null, string, n, string2, 0, this.getName(), this.backEnd.getName()), true);
            BEConsumerCreateRequest bEConsumerCreateRequest = new BEConsumerCreateRequest(null, null, null, string, n, string2, null, jMSSQLExpression.getSelector(), jMSSQLExpression.isNoLocal(), 0, 0, this.getRedeliveryDelay(), null, null, 0);
            BEConsumerImpl bEConsumerImpl = null;
            try {
                bEConsumerImpl = new BEConsumerImpl(null, this, queue, 0, true, bEConsumerCreateRequest);
                bEConsumerImpl.close(0L);
                bEConsumerImpl.setPersistentHandle(persistentHandle);
                this.addConsumer(bEConsumerImpl);
                this.activateSubscriptionQueue(queue, bEConsumerImpl, jMSSQLExpression, true, true);
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("Recovered a durable subscription on topic " + this.name);
                }
                Object var10_9 = null;
                if (bEConsumerImpl == null || bEConsumerImpl.getSubscription() == null) break block14;
                subscription = bEConsumerImpl.getSubscription();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (bEConsumerImpl != null && bEConsumerImpl.getSubscription() != null) {
                    Subscription subscription2 = bEConsumerImpl.getSubscription();
                    synchronized (subscription2) {
                        ((DurableSubscription)bEConsumerImpl.getSubscription()).resetSubscribersCount();
                        if (((DurableSubscription)bEConsumerImpl.getSubscription()).isPending()) {
                            ((DurableSubscription)bEConsumerImpl.getSubscription()).setPending(false);
                            if (((DurableSubscription)bEConsumerImpl.getSubscription()).hasWaits()) {
                                bEConsumerImpl.getSubscription().notifyAll();
                            }
                        }
                    }
                }
                throw throwable;
            }
            synchronized (subscription) {
                ((DurableSubscription)bEConsumerImpl.getSubscription()).resetSubscribersCount();
                if (((DurableSubscription)bEConsumerImpl.getSubscription()).isPending()) {
                    ((DurableSubscription)bEConsumerImpl.getSubscription()).setPending(false);
                    if (((DurableSubscription)bEConsumerImpl.getSubscription()).hasWaits()) {
                        bEConsumerImpl.getSubscription().notifyAll();
                    }
                }
            }
        }
    }

    BEConnectionConsumerImpl createConnectionConsumer(JMSID jMSID, ServerSessionPool serverSessionPool, String string, String string2, String string3, boolean bl, int n, long l, boolean bl2, boolean bl3) throws JMSException {
        this.checkShutdownOrSuspendedNeedLock("create connection consumer");
        int n2 = 0;
        if (string == null || string2 == null) {
            n2 |= 4;
        }
        if (bl2) {
            n2 |= 8;
            string2 = null;
        }
        JMSSQLExpression jMSSQLExpression = new JMSSQLExpression(string3);
        Queue queue = this.createSubscriptionQueue(BETopicImpl.getSubscriptionQueueName(jMSID, string, string2), bl2);
        BEConnectionConsumerImpl bEConnectionConsumerImpl = null;
        try {
            bEConnectionConsumerImpl = new BEConnectionConsumerImpl(jMSID, this, serverSessionPool, queue, string3, bl, string, string2, n, l, n2);
            this.addConsumer(bEConnectionConsumerImpl);
            boolean bl4 = bl2 || JMSService.getJMSService().shouldMessageLogNonDurableSubscriber();
            this.activateSubscriptionQueue(queue, bEConnectionConsumerImpl, jMSSQLExpression, bl4, bl2);
        }
        catch (JMSException jMSException) {
            BETopicImpl.deleteFailedConsumer(bEConnectionConsumerImpl, bl2);
            throw jMSException;
        }
        if (bl3) {
            bEConnectionConsumerImpl.start();
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Created a new ConnectionConsumer with ID " + jMSID + " on topic " + this.name);
        }
        return bEConnectionConsumerImpl;
    }

    DurableSubscription findDurableSubscriber(String string, String string2, String string3, boolean bl, int n, int n2, int n3) throws JMSException {
        DurableSubscription durableSubscription;
        String string4 = BEConsumerImpl.clientIdPlusName(string, string2, n2, this.getName(), this.getBackEnd().getName());
        DurableSubscription durableSubscription2 = durableSubscription = this.backEnd.getDurableSubscription(string4);
        if (durableSubscription != null && n == 1) {
            if (n2 == 0) {
                durableSubscription2 = DSManager.manager().lookup(BEConsumerImpl.JNDINameForSubscription(string4));
                if (durableSubscription2 != null) {
                    DurableSubscription durableSubscription3 = new DurableSubscription(string4, this.destinationImpl, string3, bl, n2, n3);
                    Vector vector = durableSubscription2.getDSVector();
                    for (int i = 0; i < vector.size(); ++i) {
                        DurableSubscription durableSubscription4 = (DurableSubscription)vector.elementAt(i);
                        if (!durableSubscription4.equalsForSerialized(durableSubscription3)) continue;
                        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                            JMSDebug.JMSBackEnd.debug("Found existing durable subscription " + string4 + " on topic " + this.name);
                        }
                        return durableSubscription;
                    }
                }
                return null;
            }
            DurableSubscription durableSubscription5 = new DurableSubscription(string4, this.destinationImpl, string3, bl, n2, n3);
            if (durableSubscription.equals(durableSubscription5)) {
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("Found existing durable subscription " + string4 + " on topic " + this.name);
                }
                return durableSubscription;
            }
            if (durableSubscription.getSubscribersCount() > 0) {
                throw new JMSException("Cannot change the details of a durable subscription when it is in use");
            }
            try {
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("Deleting existing durable subscription " + string4 + " on topic " + this.name);
                }
                durableSubscription2.getConsumer().delete(false, true);
            }
            catch (JMSException jMSException) {
                throw new weblogic.jms.common.JMSException("Old subscription can not be removed", (Throwable)jMSException);
            }
            return null;
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled() && durableSubscription != null) {
            JMSDebug.JMSBackEnd.debug("Found existing durable subscription " + string4 + " on topic " + this.name);
        }
        return durableSubscription;
    }

    NonDurableSubscription findNonDurableSubscriber(String string, String string2, boolean bl, int n, int n2) throws JMSException {
        NonDurableSubscription nonDurableSubscription = new NonDurableSubscription(string, this.destinationImpl, string2, bl, n, n2);
        return this.getSharableNonDurableSubscription(nonDurableSubscription);
    }

    public synchronized void addConsumer(BEConsumerCommon bEConsumerCommon) throws JMSException {
        super.addConsumer(bEConsumerCommon);
        BEConsumerImpl bEConsumerImpl = (BEConsumerImpl)bEConsumerCommon;
        if (bEConsumerImpl.isDurable()) {
            this.durableRuntimeMBeans.put(bEConsumerImpl.getName(), bEConsumerImpl.getDurableSubscriberMbean());
        }
        if (bEConsumerImpl.isMulticastSubscriber()) {
            ++this.multicastConsumerCount;
            if (this.multicastConsumerCount > 0 && this.multicastConsumer == null) {
                this.startMulticastConsumer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Queue queue, boolean bl) throws JMSException {
        try {
            KernelRequest kernelRequest = new KernelRequest();
            Queue queue2 = queue;
            synchronized (queue2) {
                this.topic.unsubscribe(queue, kernelRequest);
                kernelRequest.getResult();
                kernelRequest = new KernelRequest();
                queue.delete(kernelRequest);
            }
            if (bl) {
                kernelRequest.getResult();
            }
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException("Error deleting a topic subscription", (Throwable)kernelException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(BEConsumerImpl bEConsumerImpl, boolean bl) throws JMSException {
        BETopicImpl bETopicImpl = this;
        synchronized (bETopicImpl) {
            if (bEConsumerImpl.isDurable() && bEConsumerImpl.getPersistentHandle() != null) {
                this.durableRuntimeMBeans.remove(bEConsumerImpl.getName());
                this.backEnd.getDurableSubscriptionStore().deleteSubscription(bEConsumerImpl.getPersistentHandle());
            }
            if (bEConsumerImpl.isMulticastSubscriber()) {
                --this.multicastConsumerCount;
                if (this.multicastConsumerCount == 0) {
                    this.stopMulticastConsumer();
                }
            }
        }
        if (!bEConsumerImpl.isDurable() && bEConsumerImpl.getClientID() != null) {
            this.removeSharableNonDurableSubscriber(bEConsumerImpl);
        }
        if (!(bEConsumerImpl.isMulticastSubscriber() || bEConsumerImpl.getSubscription() != null && bEConsumerImpl.getSubscription().getSubscribersCount() != 0)) {
            this.unsubscribe(bEConsumerImpl.getUnsubscribeQueue(), bl);
        }
        bETopicImpl = this;
        synchronized (bETopicImpl) {
            if (!this.consumers.contains(bEConsumerImpl)) {
                return;
            }
        }
        super.removeConsumer(bEConsumerImpl, bl);
    }

    public void removeConsumer(BEConsumerImpl bEConsumerImpl, boolean bl, boolean bl2) throws JMSException {
        if (bl2) {
            super.removeConsumer(bEConsumerImpl, bl);
        } else {
            this.removeConsumer(bEConsumerImpl, bl);
        }
    }

    private synchronized List getConsumerQueues() {
        ArrayList<Queue> arrayList = new ArrayList<Queue>(this.consumers.size() + 1);
        Iterator iterator = this.consumers.iterator();
        while (iterator.hasNext()) {
            Queue queue = ((BEConsumerImpl)iterator.next()).getKernelQueue();
            if (queue == null) continue;
            arrayList.add(queue);
        }
        if (this.multicastConsumer != null) {
            arrayList.add(this.multicastConsumer.getQueue());
        }
        return arrayList;
    }

    protected void suspendKernelDestination(int n) throws JMSException {
        super.suspendKernelDestination(n);
        Iterator iterator = this.getConsumerQueues().iterator();
        KernelException kernelException = null;
        while (iterator.hasNext()) {
            try {
                ((Queue)iterator.next()).suspend(n);
            }
            catch (KernelException kernelException2) {
                kernelException = kernelException2;
            }
        }
        if (kernelException != null) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    protected void resumeKernelDestination(int n) throws JMSException {
        super.resumeKernelDestination(n);
        KernelException kernelException = null;
        Iterator iterator = this.getConsumerQueues().iterator();
        while (iterator.hasNext()) {
            try {
                ((Queue)iterator.next()).resume(n);
            }
            catch (KernelException kernelException2) {
                kernelException = kernelException2;
            }
        }
        if (kernelException != null) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    protected void closeAllConsumers(String string) {
        super.closeAllConsumers(string);
        this.stopMulticastConsumer();
    }

    public String getMulticastAddress() {
        return this.multicastAddress;
    }

    public void setMulticastAddress(String string) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled() && string != null && string.length() != 0) {
            JMSDebug.JMSBackEnd.debug("Topic " + this.name + " setting multicastAddress to " + string);
        }
        this.multicastAddress = string;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setMulticastPort(int n) {
        this.multicastPort = n;
    }

    public void setMulticastTimeToLive(int n) {
        this.multicastTTL = (byte)n;
    }

    public int getMulticastTimeToLive() {
        return this.multicastTTL;
    }

    public void setMulticastGroup(InetAddress inetAddress) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled() && inetAddress != null) {
            JMSDebug.JMSBackEnd.debug("Topic " + this.name + " setting multicast group to " + inetAddress);
        }
        this.multicastGroup = inetAddress;
    }

    public synchronized JMSDurableSubscriberRuntimeMBean[] getDurableSubscribers() {
        if (this.durableRuntimeMBeans.isEmpty()) {
            return new JMSDurableSubscriberRuntimeMBean[0];
        }
        JMSDurableSubscriberRuntimeMBean[] jMSDurableSubscriberRuntimeMBeanArray = new JMSDurableSubscriberRuntimeMBean[this.durableRuntimeMBeans.size()];
        this.durableRuntimeMBeans.values().toArray(jMSDurableSubscriberRuntimeMBeanArray);
        return jMSDurableSubscriberRuntimeMBeanArray;
    }

    public void createDurableSubscriber(String string, String string2, String string3, boolean bl) throws JMSException {
        this.createDurableSubscriber(string, 0, string2, string3, bl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDurableSubscriber(String string, int n, String string2, String string3, boolean bl, int n2) throws JMSException {
        this.checkShutdownOrSuspendedNeedLock("create durable subscriber");
        JMSService.getJMSService().reserveClientID(string);
        try {
            DurableSubscription durableSubscription = this.findDurableSubscriber(string, string2, string3, bl, 1, n, n2);
            if (durableSubscription != null) {
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("createDurableSubscriber(): found a sub: sub's sharingpolicy = " + durableSubscription.getSubscriptionSharingPolicy() + "request's sharingpolicy = " + n2);
                }
                if (n2 != durableSubscription.getSubscriptionSharingPolicy() && durableSubscription.getSubscribersCount() != 0) {
                    throw new JMSException("Cannot change the sharing policy on an active subscriptions");
                }
            }
            if (durableSubscription == null || n2 == 1) {
                BEConsumerCreateRequest bEConsumerCreateRequest = new BEConsumerCreateRequest(null, null, null, string, n, string2, null, string3, bl, 0, 0, -1L, null, null, n2);
                BEConsumerImpl bEConsumerImpl = this.createConsumer(null, false, bEConsumerCreateRequest, durableSubscription);
                bEConsumerImpl.close(0L);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            JMSService.releaseClientID(string);
            throw throwable;
        }
        JMSService.releaseClientID(string);
    }

    private synchronized void startMulticastConsumer() throws JMSException {
        if (this.multicastConsumer != null) {
            return;
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Starting multicasting for the JMS topic " + this.getName());
        }
        JMSID jMSID = JMSService.getJMSService().getNextId();
        JMSTMSocket jMSTMSocket = JMSService.getJMSService().getMulticastSocket();
        if (jMSTMSocket == null) {
            throw new JMSException("Failed to start multicasting for JMS Topic " + this.getName());
        }
        Queue queue = this.createSubscriptionQueue(jMSID.toString(), false);
        this.multicastConsumer = new BEMulticastConsumer(this.backEnd, queue, this.destinationImpl, this.multicastGroup, this.multicastPort, this.multicastTTL, jMSTMSocket);
        this.activateSubscriptionQueue(queue, null, new JMSSQLExpression(), false, false);
        try {
            this.multicastConsumer.start();
        }
        catch (JMSException jMSException) {
            this.multicastConsumer = null;
            throw jMSException;
        }
    }

    private synchronized void stopMulticastConsumer() {
        block4: {
            if (this.multicastConsumer == null) {
                return;
            }
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Stopping multicasting for the JMS topic");
            }
            try {
                this.multicastConsumer.stop();
                this.unsubscribe(this.multicastConsumer.getQueue(), false);
                this.multicastConsumer = null;
            }
            catch (JMSException jMSException) {
                if (!JMSDebug.JMSBackEnd.isDebugEnabled()) break block4;
                JMSDebug.JMSBackEnd.debug("Error stopping multicast consumer: " + (Object)((Object)jMSException));
            }
        }
    }

    public final void setMessageLoggingEnabled(boolean bl) {
        if (super.isMessageLoggingEnabled() && bl || !super.isMessageLoggingEnabled() && !bl) {
            return;
        }
        super.setMessageLoggingEnabled(bl);
        try {
            if (bl && !this.backEnd.isMemoryLow()) {
                this.resumeMessageLogging();
            } else if (!bl) {
                this.suspendMessageLogging();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void resumeMessageLogging() throws JMSException {
        this.messageLogging = true;
        Map<Object, Object> map = this.getConsumersClone();
        for (BEConsumerImpl bEConsumerImpl : map.values()) {
            if (!JMSService.getJMSService().shouldMessageLogNonDurableSubscriber() && !bEConsumerImpl.isDurable()) continue;
            BETopicImpl.addPropertyFlags((Destination)bEConsumerImpl.getKernelQueue(), "Logging", 15);
        }
    }

    public void suspendMessageLogging() throws JMSException {
        this.messageLogging = false;
        Map<Object, Object> map = this.getConsumersClone();
        for (BEConsumerImpl bEConsumerImpl : map.values()) {
            if (!JMSService.getJMSService().shouldMessageLogNonDurableSubscriber() && !bEConsumerImpl.isDurable()) continue;
            BETopicImpl.removePropertyFlags((Destination)bEConsumerImpl.getKernelQueue(), "Logging", 15);
        }
    }

    public void setQuota(Quota quota) throws BeanUpdateFailedException {
        HashMap<String, Quota> hashMap = new HashMap<String, Quota>();
        try {
            hashMap.put("Quota", quota);
            this.getKernelDestination().setProperties(hashMap);
            Map<Object, Object> map = this.getConsumersClone();
            for (BEConsumerImpl bEConsumerImpl : map.keySet()) {
                if (bEConsumerImpl.isMulticastSubscriber()) continue;
                Queue queue = bEConsumerImpl.getKernelQueue();
                queue.setProperties(hashMap);
            }
        }
        catch (KernelException kernelException) {
            throw new BeanUpdateFailedException("Messaging Kernel failed to act on the quota" + quota);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NonDurableSubscription getSharableNonDurableSubscription(NonDurableSubscription nonDurableSubscription) {
        HashMap hashMap = this.nonDurableSubscriptions;
        synchronized (hashMap) {
            return (NonDurableSubscription)this.nonDurableSubscriptions.get(nonDurableSubscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NonDurableSubscription addSharableNonDurableSubscriber(NonDurableSubscription nonDurableSubscription) {
        HashMap hashMap = this.nonDurableSubscriptions;
        synchronized (hashMap) {
            NonDurableSubscription nonDurableSubscription2 = this.getSharableNonDurableSubscription(nonDurableSubscription);
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("BETopicImpl: addSharableNonDurableSubscriber subFound=" + nonDurableSubscription2);
            }
            if (nonDurableSubscription2 != null && nonDurableSubscription2.equals(nonDurableSubscription)) {
                nonDurableSubscription2.addSubscriber(null);
                return nonDurableSubscription2;
            }
            nonDurableSubscription.addSubscriber(null);
            this.nonDurableSubscriptions.put(nonDurableSubscription, nonDurableSubscription);
            return nonDurableSubscription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSharableNonDurableSubscriber(BEConsumerImpl bEConsumerImpl) {
        NonDurableSubscription nonDurableSubscription = new NonDurableSubscription(bEConsumerImpl.getClientID(), bEConsumerImpl.getDestination().getDestinationImpl(), bEConsumerImpl.getSelector(), bEConsumerImpl.getNoLocal(), bEConsumerImpl.getClientIdPolicy(), bEConsumerImpl.getSubscriptionSharingPolicy());
        HashMap hashMap = this.nonDurableSubscriptions;
        synchronized (hashMap) {
            NonDurableSubscription nonDurableSubscription2 = this.getSharableNonDurableSubscription(nonDurableSubscription);
            if (nonDurableSubscription2 == null) {
                return;
            }
            NonDurableSubscription nonDurableSubscription3 = nonDurableSubscription2;
            synchronized (nonDurableSubscription3) {
                nonDurableSubscription2.removeSubscriber(null);
                if (nonDurableSubscription2.getSubscribersCount() <= 0) {
                    this.nonDurableSubscriptions.remove(nonDurableSubscription2);
                }
            }
        }
    }

    private String getNextSharableNonDurableSubName(String string) {
        return SHARABLE_NON_DURABLE_SUB_PREFIX + string + "." + JMSService.getJMSService().getNextId().toString() + "@" + this.name + "@" + this.backEnd.getName();
    }

    public boolean isMessageLogging() {
        return this.messageLogging;
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("Topic");
        super.dump(jMSDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }
}

