/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.Map;
import javax.jms.JMSException;
import javax.naming.Context;
import weblogic.application.ModuleException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.jms.backend.BEDestinationRuntimeDelegate;
import weblogic.jms.backend.BEDestinationSecurityImpl;
import weblogic.jms.backend.BEDurableSubscriptionStore;
import weblogic.jms.backend.BETopicImpl;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.EntityName;
import weblogic.jms.common.ModuleName;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.management.ManagementException;
import weblogic.management.utils.GenericBeanListener;

public final class BETopicRuntimeDelegate
extends BEDestinationRuntimeDelegate {
    private BETopicImpl managedTopic;
    private GenericBeanListener multicastListener;

    public BETopicRuntimeDelegate(EntityName entityName, BackEnd backEnd, Context context, boolean bl, ModuleName moduleName, JMSBean jMSBean, TopicBean topicBean) {
        super(entityName, context, backEnd, jMSBean, (DestinationBean)topicBean, bl, moduleName);
    }

    protected void initialize(int n) throws ModuleException {
        try {
            this.managedTopic = new BETopicImpl((TopicBean)this.specificBean, this.backEnd, this.entityName.toString(), this.temporary, new BEDestinationSecurityImpl(this.entityName, "topic"));
            this.setManagedDestination(this.managedTopic);
            TopicBean topicBean = (TopicBean)this.specificBean;
            DescriptorBean descriptorBean = (DescriptorBean)topicBean.getMulticast();
            this.multicastListener = new GenericBeanListener(descriptorBean, (Object)this.managedTopic, (Map)JMSBeanHelper.multicastBeanSignatures, false);
            this.multicastListener.initialize();
            super.initialize(n);
        }
        catch (JMSException jMSException) {
            throw new ModuleException(jMSException);
        }
        catch (ManagementException managementException) {
            throw new ModuleException(managementException);
        }
    }

    public void activate(JMSBean jMSBean) throws ModuleException {
        BEDurableSubscriptionStore bEDurableSubscriptionStore = this.managedTopic.getBackEnd().getDurableSubscriptionStore();
        if (bEDurableSubscriptionStore != null) {
            try {
                bEDurableSubscriptionStore.restoreSubscriptions(this.managedTopic);
            }
            catch (JMSException jMSException) {
                throw new ModuleException(jMSException.getMessage(), jMSException);
            }
        }
        super.activate(jMSBean);
        if (jMSBean != null) {
            TopicBean topicBean = jMSBean.lookupTopic(this.getEntityName());
            DescriptorBean descriptorBean = (DescriptorBean)topicBean.getMulticast();
            this.multicastListener.close();
            this.multicastListener = new GenericBeanListener(descriptorBean, this.managedTopic, JMSBeanHelper.multicastBeanSignatures);
        }
    }

    public void deactivate() throws ModuleException {
        this.multicastListener.close();
        super.deactivate();
    }
}

