/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.common.CompletionRequest;
import weblogic.jms.backend.BEOrderUpdateParentRequest;
import weblogic.jms.backend.BEOrderUpdateRequest;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.path.Key;
import weblogic.messaging.path.LegalMember;
import weblogic.messaging.path.UpdatableMember;
import weblogic.messaging.path.helper.KeyString;
import weblogic.messaging.path.helper.MemberString;
import weblogic.messaging.saf.utils.SAFClientUtil;
import weblogic.store.PersistentStoreTransaction;

public class BEUOOMember
extends MemberString
implements LegalMember,
UpdatableMember {
    static final long serialVersionUID = -1978058611468713508L;
    private static int EXTVERSION = 1;
    private static int VERSION_MASK = 4095;
    private static int FLAG_DYNAMIC = 4096;
    protected boolean dynamic;

    public BEUOOMember(String string, String string2, boolean bl) {
        super(string, string2);
        this.dynamic = bl;
    }

    public BEUOOMember() {
    }

    public boolean getDynamic() {
        return this.dynamic;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public void setGeneration(int n) {
        this.generation = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Key key, UpdatableMember updatableMember, CompletionRequest completionRequest) {
        BEOrderUpdateParentRequest bEOrderUpdateParentRequest;
        BEOrderUpdateRequest bEOrderUpdateRequest;
        DistributedDestinationImpl distributedDestinationImpl;
        try {
            KeyString keyString = (KeyString)key;
            BEUOOMember bEUOOMember = (BEUOOMember)updatableMember;
            if (!DDManager.isMember(key.getAssemblyId(), this.getStringId())) {
                completionRequest.setResult((Object)new Exception("member " + this.getMemberId() + " unavailable within " + keyString.getAssemblyId()));
                return;
            }
            distributedDestinationImpl = DDManager.findDDImplByMemberName(this.getStringId());
            bEOrderUpdateRequest = new BEOrderUpdateRequest(distributedDestinationImpl.getId(), keyString, bEUOOMember, this);
            bEOrderUpdateParentRequest = new BEOrderUpdateParentRequest(distributedDestinationImpl.getId(), bEOrderUpdateRequest, completionRequest);
        }
        catch (Error error) {
            completionRequest.setResult((Object)error);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            completionRequest.setResult((Object)runtimeException);
            throw runtimeException;
        }
        try {
            bEOrderUpdateParentRequest.dispatchAsync(JMSDispatcherManager.dispatcherFindOrCreate(distributedDestinationImpl.getDispatcherId()), (Request)bEOrderUpdateRequest);
        }
        catch (Error error) {
            BEOrderUpdateParentRequest bEOrderUpdateParentRequest2 = bEOrderUpdateParentRequest;
            synchronized (bEOrderUpdateParentRequest2) {
                if (bEOrderUpdateParentRequest.getState() == Integer.MAX_VALUE) {
                    return;
                }
                bEOrderUpdateParentRequest.setState(Integer.MAX_VALUE);
            }
            completionRequest.setResult((Object)error);
            throw error;
        }
        catch (DispatcherException dispatcherException) {
            BEOrderUpdateParentRequest bEOrderUpdateParentRequest3 = bEOrderUpdateParentRequest;
            synchronized (bEOrderUpdateParentRequest3) {
                if (bEOrderUpdateParentRequest.getState() == Integer.MAX_VALUE) {
                    return;
                }
                bEOrderUpdateParentRequest.setState(Integer.MAX_VALUE);
            }
            completionRequest.setResult((Object)dispatcherException);
        }
        catch (RuntimeException runtimeException) {
            BEOrderUpdateParentRequest bEOrderUpdateParentRequest4 = bEOrderUpdateParentRequest;
            synchronized (bEOrderUpdateParentRequest4) {
                if (bEOrderUpdateParentRequest.getState() == Integer.MAX_VALUE) {
                    return;
                }
                bEOrderUpdateParentRequest.setState(Integer.MAX_VALUE);
            }
            completionRequest.setResult((Object)runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void isLegal(Key key, LegalMember legalMember, CompletionRequest completionRequest) {
        Error error;
        RuntimeException runtimeException;
        Serializable serializable;
        block17: {
            block16: {
                serializable = null;
                runtimeException = null;
                error = null;
                try {
                    try {
                        completionRequest.runListenersInSetResult(true);
                        if (!this.dynamic) {
                            serializable = Boolean.TRUE;
                            Object var9_7 = null;
                            break block16;
                        }
                        serializable = DDManager.isMember(key.getAssemblyId(), this.getStringId()) ? Boolean.TRUE : Boolean.FALSE;
                        break block17;
                    }
                    catch (RuntimeException runtimeException2) {
                        serializable = runtimeException = runtimeException2;
                        Object var9_9 = null;
                        completionRequest.setResult((Object)serializable);
                        if (runtimeException != null) {
                            throw runtimeException;
                        }
                        if (error == null) return;
                        throw error;
                    }
                    catch (Error error2) {
                        error = error2;
                        serializable = error;
                        Object var9_10 = null;
                        completionRequest.setResult((Object)serializable);
                        if (runtimeException != null) {
                            throw runtimeException;
                        }
                        if (error == null) return;
                        throw error;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    completionRequest.setResult((Object)serializable);
                    if (runtimeException != null) {
                        throw runtimeException;
                    }
                    if (error == null) throw throwable;
                    throw error;
                }
            }
            completionRequest.setResult((Object)serializable);
            if (runtimeException != null) {
                throw runtimeException;
            }
            if (error == null) return;
            throw error;
        }
        Object var9_8 = null;
        completionRequest.setResult((Object)serializable);
        if (runtimeException != null) {
            throw runtimeException;
        }
        if (error == null) return;
        throw error;
    }

    public boolean updateException(Throwable throwable, Key key, UpdatableMember updatableMember, PersistentStoreTransaction persistentStoreTransaction, CompletionRequest completionRequest) {
        completionRequest.setResult((Object)Boolean.FALSE);
        return false;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof BEUOOMember && this.dynamic == ((BEUOOMember)object).dynamic && super.equals(object);
    }

    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n != 0) {
            return n;
        }
        if (this.dynamic == ((BEUOOMember)object).dynamic) {
            return 0;
        }
        if (this.dynamic) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        if (this.dynamic) {
            return super.toString() + "^dynamic";
        }
        return super.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.dynamic ? FLAG_DYNAMIC | EXTVERSION : EXTVERSION;
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & VERSION_MASK;
        if (n2 != EXTVERSION) {
            throw SAFClientUtil.versionIOException(n2, EXTVERSION, EXTVERSION);
        }
        this.dynamic = (n & FLAG_DYNAMIC) != 0;
        super.readExternal(objectInput);
    }
}

