/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.naming.NamingException;
import weblogic.common.CompletionListener;
import weblogic.common.CompletionRequest;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEExtension;
import weblogic.jms.backend.BEProducerSendRequest;
import weblogic.jms.backend.BEUOOMember;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.extensions.JMSOrderException;
import weblogic.jms.server.SequenceData;
import weblogic.management.provider.ManagementService;
import weblogic.messaging.kernel.Destination;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.Sequence;
import weblogic.messaging.path.helper.KeyString;
import weblogic.messaging.path.helper.PathHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.utils.collections.CircularQueue;
import weblogic.work.ContextWrap;
import weblogic.work.InheritableThreadContext;

abstract class BEUOOState
implements BEExtension {
    private static long PATH_SERVICE_RESUME_RETRY_DELAY = 400L;
    private static boolean verbose = false;
    private static int QOS_STORE_OWNED_CACHE_ON_EQUAL = 49216;
    private static long PATH_SERVICE_DELETE_RETRY_DELAY = 120000L;
    public static HashMap TODOremoveDebug = new HashMap();
    private static boolean delayedRemoveRunning;
    private static final AuthenticatedSubject kernelId;
    private static final Object retryListLock;
    private static HashMap delayedRemoves;
    private static CircularQueue delayedRemove;
    private DDHandler ddHandler;
    private BEDestinationImpl destination;
    private HashMap uooStates = new HashMap();
    private HashMap uowStates = new HashMap();

    protected BEUOOState(BEDestinationImpl bEDestinationImpl, DDHandler dDHandler) {
        this.ddHandler = dDHandler;
        this.destination = bEDestinationImpl;
        if (verbose) assert (null == TODOremoveDebug.put(bEDestinationImpl.getName(), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendExtension(BEProducerSendRequest bEProducerSendRequest) throws JMSException {
        State state;
        int n = BEUOOState.getUOOSequenceOpcode(bEProducerSendRequest);
        Sequence sequence = bEProducerSendRequest.getSequence();
        String string = bEProducerSendRequest.getMessage().getUnitOfOrder();
        byte by = 1;
        if (string == null && this.destination.isUOWDestination()) {
            string = bEProducerSendRequest.getMessage().getStringProperty("JMS_BEA_UnitOfWork");
            by = 5;
        }
        if (n == 0) {
            if (string == null) {
                return;
            }
            if (bEProducerSendRequest.getCheckUOO() == 0) {
                return;
            }
        } else {
            if (sequence == null) {
                throw new weblogic.jms.common.JMSException("no Sequence for control message " + Integer.toHexString(n) + " for destination " + this.destination.getName());
            }
            if (!"Hash".equals(this.ddHandler.getUnitOfOrderRouting())) {
                bEProducerSendRequest.setState(Integer.MAX_VALUE);
                return;
            }
            if (n == 196608) {
                if (string == null) {
                    throw new weblogic.jms.common.JMSException("no Unit of Order for Reserve " + this.destination.getName());
                }
            } else {
                assert (131072 >= n);
                this.controlSequenceRelease(bEProducerSendRequest);
                return;
            }
        }
        bEProducerSendRequest.setCheckUOO(0);
        assert ("PathService".equals(this.ddHandler.getUnitOfOrderRouting()));
        bEProducerSendRequest.setUOOInfo(BEUOOState.getNewKeyString(this.ddHandler, string, by), new BEUOOMember(this.destination.getName(), ManagementService.getRuntimeAccess(kernelId).getServerName(), true), new PathServiceCompReqListener(bEProducerSendRequest));
        BEUOOState bEUOOState = this;
        synchronized (bEUOOState) {
            state = this.findOrCreateState(string, true, by);
        }
        state.setupPutIfAbsent(bEProducerSendRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void controlSequenceRelease(BEProducerSendRequest bEProducerSendRequest) throws JMSException {
        weblogic.jms.common.JMSException jMSException;
        block23: {
            CircularQueue circularQueue = new CircularQueue(4);
            jMSException = null;
            BEUOOState bEUOOState = this;
            synchronized (bEUOOState) {
                Iterator iterator = this.uooStates.values().iterator();
                while (iterator.hasNext()) {
                    State state;
                    State state2 = state = (State)iterator.next();
                    synchronized (state2) {
                        PathServiceRemoveRetry pathServiceRemoveRetry = this.removeLienInternal(bEProducerSendRequest.getSequence(), state.uoo);
                        if (pathServiceRemoveRetry == null) {
                            continue;
                        }
                        circularQueue.add((Object)pathServiceRemoveRetry);
                    }
                }
            }
            Object var12_11 = null;
            try {
                bEProducerSendRequest.getSequence().delete(false);
                Object var15_13 = null;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                while (!circularQueue.isEmpty()) {
                    ((PathServiceRemoveRetry)circularQueue.remove()).processRemove();
                }
                throw throwable;
            }
            while (!circularQueue.isEmpty()) {
                ((PathServiceRemoveRetry)circularQueue.remove()).processRemove();
            }
            {
                break block23;
                catch (KernelException kernelException) {
                    jMSException = new weblogic.jms.common.JMSException(kernelException);
                    Object var15_14 = null;
                    while (!circularQueue.isEmpty()) {
                        ((PathServiceRemoveRetry)circularQueue.remove()).processRemove();
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                block24: {
                    Object var12_12 = null;
                    try {
                        bEProducerSendRequest.getSequence().delete(false);
                        Object var15_16 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var15_18 = null;
                        while (!circularQueue.isEmpty()) {
                            ((PathServiceRemoveRetry)circularQueue.remove()).processRemove();
                        }
                        throw throwable2;
                    }
                    while (!circularQueue.isEmpty()) {
                        ((PathServiceRemoveRetry)circularQueue.remove()).processRemove();
                    }
                    {
                        break block24;
                        catch (KernelException kernelException) {
                            jMSException = new weblogic.jms.common.JMSException(kernelException);
                            Object var15_17 = null;
                            while (!circularQueue.isEmpty()) {
                                ((PathServiceRemoveRetry)circularQueue.remove()).processRemove();
                            }
                        }
                    }
                }
                throw throwable;
            }
        }
        if (jMSException != null) {
            throw jMSException;
        }
        bEProducerSendRequest.setState(Integer.MAX_VALUE);
    }

    private static int getUOOSequenceOpcode(BEProducerSendRequest bEProducerSendRequest) {
        int n = bEProducerSendRequest.getMessage().getControlOpcode();
        if (n != 0) {
            assert (n >= 65536);
            if (n > 196608) {
                n = 0;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void sequenceExtension(BEProducerSendRequest bEProducerSendRequest) throws JMSException {
        PathServiceRemoveRetry pathServiceRemoveRetry;
        block20: {
            block19: {
                boolean bl;
                SequenceData sequenceData;
                String string;
                SequenceData sequenceData2;
                Sequence sequence = bEProducerSendRequest.getSequence();
                if (sequence == null) {
                    return;
                }
                String string2 = bEProducerSendRequest.getMessage().getUnitOfOrder();
                if (verbose) {
                    System.out.println("BEUOOState " + string2 + " Sequence " + sequence.getName());
                }
                if ((sequenceData2 = (SequenceData)sequence.getUserData()) == null) {
                    if (string2 == null) {
                        return;
                    }
                    string = null;
                    sequenceData = new SequenceData();
                } else {
                    string = sequenceData2.getUnitOfOrder();
                    sequenceData = sequenceData2.copy();
                }
                if (string == string2) {
                    if (string2 != null) return;
                    return;
                }
                if (string2 != null && string2.equals(string)) {
                    return;
                }
                boolean bl2 = bl = false;
                if (bl) {
                    return;
                }
                pathServiceRemoveRetry = null;
                try {
                    BEUOOState bEUOOState = this;
                    synchronized (bEUOOState) {
                        if (string != null) {
                            pathServiceRemoveRetry = this.removeLienInternal(sequence, string);
                        }
                        sequenceData.setUnitOfOrder(string2);
                        try {
                            sequence.setUserData((Object)sequenceData);
                        }
                        catch (KernelException kernelException) {
                            throw new weblogic.jms.common.JMSException(kernelException);
                        }
                        if (string2 == null) {
                            // MONITOREXIT @DISABLED, blocks:[0, 18, 5] lbl36 : MonitorExitStatement: MONITOREXIT : var9_9
                            Object var13_12 = null;
                            if (pathServiceRemoveRetry == null) return;
                            pathServiceRemoveRetry.processRemove();
                            return;
                        }
                        State state = bEProducerSendRequest.getUooState();
                        if (state == null) {
                            // MONITOREXIT @DISABLED, blocks:[0, 17, 5] lbl44 : MonitorExitStatement: MONITOREXIT : var9_9
                            break block19;
                        }
                        state.addLienInternal(sequence);
                    }
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    if (pathServiceRemoveRetry == null) throw throwable;
                    pathServiceRemoveRetry.processRemove();
                    throw throwable;
                }
            }
            Object var13_13 = null;
            if (pathServiceRemoveRetry == null) return;
            pathServiceRemoveRetry.processRemove();
            return;
        }
        Object var13_14 = null;
        if (pathServiceRemoveRetry == null) return;
        pathServiceRemoveRetry.processRemove();
    }

    public final void unitOfWorkAddEvent(String string) {
        this.addEvent(string, (byte)5);
    }

    public final void groupAddEvent(String string) {
        this.addEvent(string, (byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addEvent(String string, byte by) {
        BEUOOState bEUOOState = this;
        synchronized (bEUOOState) {
            State state;
            State state2 = state = this.findOrCreateState(string, false, by);
            synchronized (state2) {
                state.sendSuccessBeforeGroupAdd = false;
                state.hadRemoveGroup = false;
                state.hadCreateGroup = true;
                if (state.hadRemoveGroup && (verbose || PathHelper.PathSvc.isDebugEnabled())) {
                    PathHelper.PathSvc.debug("DEBUG onGroupAdd " + state);
                }
                state.cancelPendingRemove();
                assert (!state.isRemovable());
            }
        }
    }

    public final void unitOfWorkRemoveEvent(String string) {
        this.removeEvent(string, (byte)5);
    }

    public final void groupRemoveEvent(String string) {
        this.removeEvent(string, (byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeEvent(String string, byte by) {
        PathServiceRemoveRetry pathServiceRemoveRetry;
        BEUOOState bEUOOState = this;
        synchronized (bEUOOState) {
            State state = this.findState(string, by);
            if (state == null) {
                if (verbose || PathHelper.PathSvc.isDebugEnabled()) {
                    PathHelper.PathSvc.debug("DEBUG BEUOOState missing for " + string);
                }
                return;
            }
            State state2 = state;
            synchronized (state2) {
                assert (!state.isInvalid);
                if (!state.hadCreateGroup && (verbose || PathHelper.PathSvc.isDebugEnabled())) {
                    PathHelper.PathSvc.debug("DEBUG new state " + string + " without CreateGroup " + state);
                }
                assert (state.hadCreateGroup);
                state.hadRemoveGroup = (state.hadCreateGroup = true);
                pathServiceRemoveRetry = state.setupRemoveRetry(null);
            }
        }
        if (pathServiceRemoveRetry == null) {
            return;
        }
        pathServiceRemoveRetry.processRemove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryPathServiceLater(PathServiceRemoveRetry pathServiceRemoveRetry) {
        Object object = retryListLock;
        synchronized (object) {
            PathServiceRemoveRetry pathServiceRemoveRetry2;
            if (delayedRemoves == null) {
                delayedRemoves = new HashMap();
            }
            if ((pathServiceRemoveRetry2 = delayedRemoves.put(pathServiceRemoveRetry.getKey(), pathServiceRemoveRetry)) != null) {
                delayedRemoves.put(pathServiceRemoveRetry.getKey(), pathServiceRemoveRetry2);
                if (pathServiceRemoveRetry2.member == null && pathServiceRemoveRetry.member != null) {
                    pathServiceRemoveRetry2.member = pathServiceRemoveRetry.member;
                }
                return;
            }
            if (delayedRemove.contains((Object)pathServiceRemoveRetry)) {
                return;
            }
            delayedRemove.add((Object)pathServiceRemoveRetry);
            if (delayedRemove.size() != 1) {
                return;
            }
        }
        this.destination.getBackEnd().getTimerManager().schedule((TimerListener)pathServiceRemoveRetry, PATH_SERVICE_DELETE_RETRY_DELAY);
    }

    private static KeyString getNewKeyString(DDHandler dDHandler, String string, byte by) {
        return new KeyString(by, dDHandler.getName(), string);
    }

    private static void doDebug(BEProducerSendRequest bEProducerSendRequest, BEUOOMember bEUOOMember, Throwable throwable) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("BESend Key:" + bEProducerSendRequest.getUOOKey() + ", got other member:" + bEUOOMember + ", guessed:" + bEProducerSendRequest.getUOOMember(), throwable);
        } else if (PathHelper.PathSvc.isDebugEnabled()) {
            PathHelper.PathSvc.debug("BESend Key:" + bEProducerSendRequest.getUOOKey() + ", got other member:" + bEUOOMember + ", guessed:" + bEProducerSendRequest.getUOOMember(), throwable);
        }
    }

    private static void pathBackDebug(String string) {
        if (PathHelper.PathSvc.isDebugEnabled()) {
            PathHelper.PathSvc.debug(string);
        } else {
            JMSDebug.JMSBackEnd.debug(string);
        }
    }

    private static void dispatcherPathBackDebug(String string, Throwable throwable) {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug(string, throwable);
        } else if (PathHelper.PathSvc.isDebugEnabled()) {
            PathHelper.PathSvc.debug(string, throwable);
        } else {
            JMSDebug.JMSBackEnd.debug(string, throwable);
        }
    }

    private HashMap getStates(byte by) {
        if (by == 1) {
            return this.uooStates;
        }
        return this.uowStates;
    }

    private State removeState(String string, byte by) {
        HashMap hashMap = this.getStates(by);
        return (State)hashMap.remove(string);
    }

    private State findState(String string, byte by) {
        HashMap hashMap = this.getStates(by);
        return (State)hashMap.get(string);
    }

    private void storeState(String string, byte by, State state) {
        HashMap hashMap = this.getStates(by);
        hashMap.put(string, state);
    }

    private State findOrCreateState(String string, boolean bl, byte by) {
        State state = this.findState(string, by);
        if (state == null) {
            state = new State(string, bl, by);
            this.storeState(string, by, state);
        } else if (bl) {
            state.incrementSendInProgress();
        }
        assert (!state.isInvalid);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathServiceRemoveRetry removeLienInternal(Sequence sequence, String string) {
        State state = this.findState(string, (byte)1);
        if (state == null) {
            return null;
        }
        State state2 = state;
        synchronized (state2) {
            if (state.isInvalid) {
                return null;
            }
            boolean bl = state.isRemovable();
            if (!state.removeLienInternal(sequence)) {
                return null;
            }
            if (PathHelper.PathSvc.isDebugEnabled()) {
                PathHelper.PathSvc.debug("DEBUG removed " + sequence.getName() + " from uoo " + state.uoo);
            }
            if (state.isRemovable() && !bl) {
                if (PathHelper.PathSvc.isDebugEnabled()) {
                    PathHelper.PathSvc.debug("releasing " + state.uoo);
                }
                return state.setupRemoveRetry(null);
            }
            return null;
        }
    }

    private void addLienInternal(Sequence sequence, String string) {
        this.findOrCreateState(string, false, (byte)1).addLienInternal(sequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restorePersistentState(Destination destination) {
        Iterator iterator = destination.getSequences().iterator();
        BEUOOState bEUOOState = this;
        synchronized (bEUOOState) {
            while (iterator.hasNext()) {
                String string;
                Sequence sequence = (Sequence)iterator.next();
                SequenceData sequenceData = (SequenceData)sequence.getUserData();
                if (sequenceData == null || (string = sequenceData.getUnitOfOrder()) == null) continue;
                this.addLienInternal(sequence, string);
            }
        }
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        retryListLock = BEUOOState.class;
        delayedRemove = new CircularQueue(4);
    }

    private class DelayedPutIfAbsent
    extends ContextWrap {
        BEProducerSendRequest request;
        State state;

        DelayedPutIfAbsent(final BEProducerSendRequest bEProducerSendRequest, final State state) {
            super(new Runnable(){

                public void run() {
                    if (PathHelper.PathSvc.isDebugEnabled() || JMSDebug.JMSBackEnd.isDebugEnabled()) {
                        BEUOOState.pathBackDebug("BEDest resumed putIfAbsent: " + bEProducerSendRequest.getUOOKey() + " request: " + bEProducerSendRequest);
                    }
                    try {
                        state.callPutIfAbsent(bEProducerSendRequest);
                    }
                    catch (Throwable throwable) {
                        bEProducerSendRequest.resumeRequest(throwable, false);
                    }
                }
            });
            this.request = bEProducerSendRequest;
            this.state = state;
        }
    }

    class State {
        private PathServiceRemoveRetry pendingRemove;
        private PathServiceRemoveRetry psRemoveInProgress;
        private BEProducerSendRequest putIfAbsentInProgress;
        private HashSet sequences;
        private boolean hadCreateGroup;
        private boolean hadRemoveGroup;
        private boolean sendSuccessBeforeGroupAdd;
        private boolean isInvalid;
        private int sendInProgress;
        private String uoo;
        private CircularQueue waitingSends;
        private byte indexKey;

        State(String string, boolean bl, byte by) {
            this.uoo = string;
            this.indexKey = by;
            if (bl) {
                ++this.sendInProgress;
            }
        }

        private synchronized void incrementSendInProgress() {
            ++this.sendInProgress;
        }

        BEUOOState getBEUOOState() {
            return BEUOOState.this;
        }

        boolean isRemovable() {
            return this.hadCreateGroup == this.hadRemoveGroup && this.sendInProgress == 0 && !this.sendSuccessBeforeGroupAdd && (this.sequences == null || this.sequences.isEmpty());
        }

        private boolean removableWithDefaultValues() {
            return this.pendingRemove == null && this.psRemoveInProgress == null && !this.hadCreateGroup;
        }

        synchronized void addLienInternal(Sequence sequence) {
            if (this.sequences == null) {
                this.sequences = new HashSet();
            }
            if (PathHelper.PathSvc.isDebugEnabled()) {
                PathHelper.PathSvc.debug("lien " + this.uoo + " add sequence " + sequence + ", " + this);
            }
            this.sequences.add(sequence);
        }

        boolean removeLienInternal(Sequence sequence) {
            if (this.sequences == null) {
                return false;
            }
            boolean bl = this.sequences.remove(sequence);
            if (PathHelper.PathSvc.isDebugEnabled()) {
                PathHelper.PathSvc.debug("remove lien " + sequence.getName() + " from uoo " + this.uoo);
            }
            if (this.sequences.isEmpty()) {
                this.sequences = null;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void removeReference(BEProducerSendRequest bEProducerSendRequest, boolean bl) {
            DelayedPutIfAbsent delayedPutIfAbsent;
            PathServiceRemoveRetry pathServiceRemoveRetry;
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block23: {
                                block24: {
                                    pathServiceRemoveRetry = null;
                                    delayedPutIfAbsent = null;
                                    try {
                                        BEUOOState bEUOOState = BEUOOState.this;
                                        synchronized (bEUOOState) {
                                            State state = this;
                                            synchronized (state) {
                                                delayedPutIfAbsent = this.computeSendToResume(bEProducerSendRequest);
                                                bEProducerSendRequest.setUooState(null);
                                                --this.sendInProgress;
                                                if (bl && !this.hadCreateGroup && !this.isInvalid) {
                                                    this.sendSuccessBeforeGroupAdd = true;
                                                }
                                                if (delayedPutIfAbsent == null) {
                                                    if (bl) {
                                                        // MONITOREXIT @DISABLED, blocks:[0, 21, 22, 8, 9] lbl15 : MonitorExitStatement: MONITOREXIT : var6_6
                                                        // MONITOREXIT @DISABLED, blocks:[0, 21, 22, 8] lbl16 : MonitorExitStatement: MONITOREXIT : var5_5
                                                        Object var11_7 = null;
                                                        if (delayedPutIfAbsent == null) break block23;
                                                        break block24;
                                                    }
                                                    if (!this.isRemovable()) {
                                                        // MONITOREXIT @DISABLED, blocks:[0, 20, 22, 8, 9] lbl22 : MonitorExitStatement: MONITOREXIT : var6_6
                                                        // MONITOREXIT @DISABLED, blocks:[0, 20, 22, 8] lbl23 : MonitorExitStatement: MONITOREXIT : var5_5
                                                        break block25;
                                                    }
                                                    if (this.removableWithDefaultValues()) {
                                                        State state2 = BEUOOState.this.removeState(this.uoo, this.indexKey);
                                                        assert (this == state2);
                                                        this.isInvalid = true;
                                                        // MONITOREXIT @DISABLED, blocks:[0, 19, 22, 8, 9] lbl31 : MonitorExitStatement: MONITOREXIT : var6_6
                                                        // MONITOREXIT @DISABLED, blocks:[0, 19, 22, 8] lbl32 : MonitorExitStatement: MONITOREXIT : var5_5
                                                        break block26;
                                                    }
                                                    if (!this.hadRemoveGroup) {
                                                        // MONITOREXIT @DISABLED, blocks:[0, 18, 22, 8, 9] lbl36 : MonitorExitStatement: MONITOREXIT : var6_6
                                                        // MONITOREXIT @DISABLED, blocks:[0, 18, 22, 8] lbl37 : MonitorExitStatement: MONITOREXIT : var5_5
                                                        break block27;
                                                    }
                                                    pathServiceRemoveRetry = this.setupRemoveRetry(null);
                                                }
                                            }
                                        }
                                        break block28;
                                    }
                                    catch (Throwable throwable) {
                                        Object var11_12 = null;
                                        if (delayedPutIfAbsent != null) {
                                            BEUOOState.this.destination.getBackEnd().getWorkManager().schedule((Runnable)((Object)delayedPutIfAbsent));
                                            throw throwable;
                                        }
                                        if (pathServiceRemoveRetry == null) throw throwable;
                                        pathServiceRemoveRetry.processRemove();
                                        throw throwable;
                                    }
                                }
                                BEUOOState.this.destination.getBackEnd().getWorkManager().schedule((Runnable)((Object)delayedPutIfAbsent));
                                return;
                            }
                            if (pathServiceRemoveRetry == null) return;
                            pathServiceRemoveRetry.processRemove();
                            return;
                        }
                        Object var11_8 = null;
                        if (delayedPutIfAbsent != null) {
                            BEUOOState.this.destination.getBackEnd().getWorkManager().schedule((Runnable)((Object)delayedPutIfAbsent));
                            return;
                        }
                        if (pathServiceRemoveRetry == null) return;
                        pathServiceRemoveRetry.processRemove();
                        return;
                    }
                    Object var11_9 = null;
                    if (delayedPutIfAbsent != null) {
                        BEUOOState.this.destination.getBackEnd().getWorkManager().schedule((Runnable)((Object)delayedPutIfAbsent));
                        return;
                    }
                    if (pathServiceRemoveRetry == null) return;
                    pathServiceRemoveRetry.processRemove();
                    return;
                }
                Object var11_10 = null;
                if (delayedPutIfAbsent != null) {
                    BEUOOState.this.destination.getBackEnd().getWorkManager().schedule((Runnable)((Object)delayedPutIfAbsent));
                    return;
                }
                if (pathServiceRemoveRetry == null) return;
                pathServiceRemoveRetry.processRemove();
                return;
            }
            Object var11_11 = null;
            if (delayedPutIfAbsent != null) {
                BEUOOState.this.destination.getBackEnd().getWorkManager().schedule((Runnable)((Object)delayedPutIfAbsent));
                return;
            }
            if (pathServiceRemoveRetry == null) return;
            pathServiceRemoveRetry.processRemove();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setupPutIfAbsent(BEProducerSendRequest bEProducerSendRequest) throws JMSException {
            Object object = bEProducerSendRequest;
            synchronized (object) {
                bEProducerSendRequest.setState(1101);
                bEProducerSendRequest.needOutsideResult();
                bEProducerSendRequest.rememberThreadContext();
                bEProducerSendRequest.getCompletionRequest().addListener((CompletionListener)bEProducerSendRequest);
            }
            object = this;
            synchronized (object) {
                bEProducerSendRequest.setUooState(this);
                if (this.psRemoveInProgress != null || this.putIfAbsentInProgress != null) {
                    if (this.waitingSends == null) {
                        this.waitingSends = new CircularQueue(4);
                    }
                    this.waitingSends.add((Object)new DelayedPutIfAbsent(bEProducerSendRequest, this));
                    if (PathHelper.PathSvc.isDebugEnabled() || JMSDebug.JMSBackEnd.isDebugEnabled()) {
                        BEUOOState.pathBackDebug("setupPutIfAbsent sees " + this.putIfAbsentInProgress + " send with UOO: " + bEProducerSendRequest.getUOOKey() + " request: " + bEProducerSendRequest);
                    }
                    return;
                }
                this.putIfAbsentInProgress = bEProducerSendRequest;
            }
            if (PathHelper.PathSvc.isDebugEnabled() || JMSDebug.JMSBackEnd.isDebugEnabled()) {
                BEUOOState.pathBackDebug("BEDest inline putIfAbsent key: " + bEProducerSendRequest.getUOOKey() + ", member: " + bEProducerSendRequest.getUOOMember());
            }
            this.callPutIfAbsent(bEProducerSendRequest);
        }

        private synchronized DelayedPutIfAbsent computeSendToResume(BEProducerSendRequest bEProducerSendRequest) {
            if (bEProducerSendRequest == null) {
                this.putIfAbsentInProgress = null;
                this.psRemoveInProgress = null;
            } else if (this.putIfAbsentInProgress == bEProducerSendRequest || this.putIfAbsentInProgress == null) {
                this.putIfAbsentInProgress = null;
            } else {
                boolean bl = false;
                if (this.waitingSends != null) {
                    Iterator iterator = this.waitingSends.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (e != bEProducerSendRequest) continue;
                        bl = true;
                        iterator.remove();
                        break;
                    }
                }
                if (bl && this.waitingSends.isEmpty()) {
                    this.waitingSends = null;
                }
                if (PathHelper.PathSvc.isDebugEnabled() || JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    BEUOOState.pathBackDebug("computeSendToResume found=" + bl + " waiting has " + (this.waitingSends == null ? "zero" : "" + this.waitingSends.size()) + ", sendCompletedPutIfAbsent:" + bEProducerSendRequest + " is not putIfAbsentInProgress:" + this.putIfAbsentInProgress);
                }
                return null;
            }
            if (this.waitingSends == null) {
                return null;
            }
            DelayedPutIfAbsent delayedPutIfAbsent = (DelayedPutIfAbsent)this.waitingSends.remove();
            if (this.waitingSends.isEmpty()) {
                this.waitingSends = null;
            }
            this.putIfAbsentInProgress = delayedPutIfAbsent.request;
            if (PathHelper.PathSvc.isDebugEnabled() || JMSDebug.JMSBackEnd.isDebugEnabled()) {
                BEUOOState.pathBackDebug("BEDest putIfAbsentInProgress: " + delayedPutIfAbsent.request.getUOOKey() + " state: " + delayedPutIfAbsent.request.getState() + " request: " + delayedPutIfAbsent.request);
            }
            return delayedPutIfAbsent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callPutIfAbsent(BEProducerSendRequest bEProducerSendRequest) {
            block6: {
                assert (this.putIfAbsentInProgress == bEProducerSendRequest);
                try {
                    PathHelper.manager().cachedPutIfAbsent(PathHelper.DEFAULT_PATH_SERVICE_JNDI, bEProducerSendRequest.getUOOKey(), bEProducerSendRequest.getUOOMember(), QOS_STORE_OWNED_CACHE_ON_EQUAL, bEProducerSendRequest.getCompletionRequest());
                }
                catch (NamingException namingException) {
                    boolean bl;
                    CompletionRequest completionRequest = bEProducerSendRequest.getCompletionRequest();
                    synchronized (completionRequest) {
                        bl = !bEProducerSendRequest.getCompletionRequest().hasResult();
                    }
                    if (!bl) break block6;
                    bEProducerSendRequest.getCompletionRequest().setResult((Object)new JMSOrderException("path service not available", (Throwable)namingException));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processPathServiceResult(BEProducerSendRequest bEProducerSendRequest) {
            BEUOOMember bEUOOMember;
            block11: {
                CompletionRequest completionRequest = bEProducerSendRequest.getCompletionRequest();
                bEUOOMember = null;
                try {
                    bEUOOMember = (BEUOOMember)completionRequest.getResult();
                    if (bEUOOMember == null) {
                        if (JMSDebug.JMSBackEnd.isDebugEnabled() || PathHelper.PathSvc.isDebugEnabled()) {
                            BEUOOState.pathBackDebug("BESend stored success State:" + bEProducerSendRequest.getState() + ", Key: " + bEProducerSendRequest.getUOOKey() + ", got: " + bEUOOMember + ", guessed: " + bEProducerSendRequest.getUOOMember());
                        }
                        BEProducerSendRequest bEProducerSendRequest2 = bEProducerSendRequest;
                        synchronized (bEProducerSendRequest2) {
                            bEProducerSendRequest.setState(1102);
                        }
                        bEProducerSendRequest.resumeExecution(false);
                        return;
                    }
                    if (!BEUOOState.this.destination.getName().equals(bEUOOMember.getMemberId())) break block11;
                    if (JMSDebug.JMSBackEnd.isDebugEnabled() || PathHelper.PathSvc.isDebugEnabled()) {
                        BEUOOState.pathBackDebug("BESend success State:" + bEProducerSendRequest.getState() + ", Key: " + bEProducerSendRequest.getUOOKey() + ", got: " + bEUOOMember + ", guessed: " + bEProducerSendRequest.getUOOMember());
                    }
                    bEProducerSendRequest.setUOOInfo(bEProducerSendRequest.getUOOKey(), bEUOOMember, completionRequest);
                    BEProducerSendRequest bEProducerSendRequest3 = bEProducerSendRequest;
                    synchronized (bEProducerSendRequest3) {
                        bEProducerSendRequest.setState(1102);
                    }
                    bEProducerSendRequest.resumeExecution(false);
                    return;
                }
                catch (Throwable throwable) {
                    BEUOOState.doDebug(bEProducerSendRequest, bEUOOMember, throwable);
                    bEProducerSendRequest.resumeRequest(throwable, true);
                    return;
                }
            }
            JMSOrderException jMSOrderException = new JMSOrderException("Unit of Order on Distributed Destination " + BEUOOState.this.destination.getName() + " rather than " + bEUOOMember.getMemberId());
            jMSOrderException.setMember(bEUOOMember);
            BEUOOState.doDebug(bEProducerSendRequest, bEUOOMember, (Throwable)((Object)jMSOrderException));
            bEProducerSendRequest.resumeRequest((Throwable)((Object)jMSOrderException), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelPendingRemove() {
            DelayedPutIfAbsent delayedPutIfAbsent;
            PathServiceRemoveRetry pathServiceRemoveRetry = this.pendingRemove;
            if (pathServiceRemoveRetry == null) {
                return;
            }
            PathServiceRemoveRetry pathServiceRemoveRetry2 = pathServiceRemoveRetry;
            synchronized (pathServiceRemoveRetry2) {
                pathServiceRemoveRetry.cancel();
                this.pendingRemove = null;
                delayedPutIfAbsent = this.computeSendToResume(null);
                assert (this.psRemoveInProgress == null);
                Object object = retryListLock;
                synchronized (object) {
                    if (delayedRemoves == null) {
                        return;
                    }
                    PathServiceRemoveRetry pathServiceRemoveRetry3 = (PathServiceRemoveRetry)delayedRemoves.remove(pathServiceRemoveRetry.getKey());
                    if (pathServiceRemoveRetry3 == null || pathServiceRemoveRetry3 == pathServiceRemoveRetry) {
                        return;
                    }
                    pathServiceRemoveRetry3.cancel();
                    delayedRemove.remove((Object)pathServiceRemoveRetry);
                }
            }
            if (delayedPutIfAbsent != null) {
                BEUOOState.this.destination.getBackEnd().getWorkManager().schedule((Runnable)((Object)delayedPutIfAbsent));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PathServiceRemoveRetry setupRemoveRetry(PathServiceRemoveRetry pathServiceRemoveRetry) {
            PathServiceRemoveRetry pathServiceRemoveRetry2 = new PathServiceRemoveRetry(BEUOOState.getNewKeyString(BEUOOState.this.ddHandler, this.uoo, this.indexKey), null);
            State state = this;
            synchronized (state) {
                if (pathServiceRemoveRetry != this.pendingRemove) {
                    if (PathHelper.PathSvc.isDebugEnabled()) {
                        PathHelper.PathSvc.debug("different remove pending" + this);
                    }
                    return null;
                }
                if (!this.isRemovable()) {
                    if (PathHelper.PathSvc.isDebugEnabled()) {
                        PathHelper.PathSvc.debug("DEBUG not removed on groupRemoveEvent " + this);
                    }
                    this.cancelPendingRemove();
                    return null;
                }
                if (PathHelper.PathSvc.isDebugEnabled()) {
                    PathHelper.PathSvc.debug("DEBUG removing " + this);
                }
                if (this.pendingRemove == null) {
                    pathServiceRemoveRetry2.setState(this);
                    this.pendingRemove = pathServiceRemoveRetry2;
                }
                return this.pendingRemove;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean completeRemove() {
            BEUOOState bEUOOState = BEUOOState.this;
            synchronized (bEUOOState) {
                State state = this;
                synchronized (state) {
                    if (this.isRemovable()) {
                        Object object;
                        if (verbose && (object = TODOremoveDebug.remove(BEUOOState.this.destination.getName())) != BEUOOState.this && null != object) {
                            TODOremoveDebug.put(BEUOOState.this.destination.getName(), object);
                        }
                        if ((object = BEUOOState.this.removeState(this.uoo, this.indexKey)) != this && null != object) {
                            BEUOOState.this.storeState(this.uoo, this.indexKey, object);
                        }
                        this.isInvalid = true;
                        return true;
                    }
                    return false;
                }
            }
        }

        public String toString() {
            return "beUOOState.state uoo=" + this.uoo + " create=" + this.hadCreateGroup + " |remove=" + this.hadRemoveGroup + " |pending=" + this.pendingRemove + " |sendInProgress=" + this.sendInProgress + " |successBeforeAdd=" + this.sendSuccessBeforeGroupAdd + " |isRemovable=" + this.isRemovable() + " |sequences=" + this.sequences;
        }
    }

    private final class PathServiceRemoveRetry
    implements TimerListener,
    Runnable {
        private State state;
        private KeyString key;
        private BEUOOMember member;
        private boolean cancelled;

        PathServiceRemoveRetry(KeyString keyString, BEUOOMember bEUOOMember) {
            this.key = keyString;
            this.member = bEUOOMember;
        }

        private void setState(State state) {
            this.state = state;
        }

        private void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean processRemove() {
            State state = this.state;
            synchronized (state) {
                if (this.state.setupRemoveRetry(this) != this) {
                    this.cancel();
                    return true;
                }
            }
            try {
                PathHelper.manager().cachedGet(PathHelper.DEFAULT_PATH_SERVICE_JNDI, this.key, 32832, this.getCompReqListener());
            }
            catch (NamingException namingException) {
                BEUOOState.this.retryPathServiceLater(this);
                return false;
            }
            return true;
        }

        private CompReqListener getCompReqListener() {
            return new CompReqListener(){

                public final void onException(CompletionRequest completionRequest, Throwable throwable) {
                    BEUOOState.this.retryPathServiceLater(PathServiceRemoveRetry.this);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void onCompletion(CompletionRequest completionRequest, Object object) {
                    boolean bl;
                    PathServiceRemoveRetry.this.member = (BEUOOMember)object;
                    if (PathServiceRemoveRetry.this.member == null || !PathServiceRemoveRetry.this.member.getDynamic() || !PathServiceRemoveRetry.this.member.getMemberId().equals(BEUOOState.this.destination.getName())) {
                        PathHelper.PathSvc.debug("DEBUG not deleting key:" + PathServiceRemoveRetry.this.key + " , value: " + PathServiceRemoveRetry.this.member + " from PathService on " + BEUOOState.this.destination.getName());
                        PathServiceRemoveRetry.this.completeProcessing();
                        return;
                    }
                    CompReqListener compReqListener = new CompReqListener(){

                        public final void onException(CompletionRequest completionRequest, Throwable throwable) {
                            BEUOOState.this.retryPathServiceLater(PathServiceRemoveRetry.this);
                        }

                        public final void onCompletion(CompletionRequest completionRequest, Object object) {
                            PathServiceRemoveRetry.this.completeProcessing();
                        }
                    };
                    Object object2 = retryListLock;
                    synchronized (object2) {
                        bl = PathServiceRemoveRetry.this.cancelled;
                    }
                    if (bl) {
                        compReqListener.onCompletion(compReqListener, Boolean.FALSE);
                        return;
                    }
                    try {
                        PathHelper.manager().cachedRemove(PathHelper.DEFAULT_PATH_SERVICE_JNDI, PathServiceRemoveRetry.this.key, PathServiceRemoveRetry.this.member, 33352, compReqListener);
                    }
                    catch (NamingException namingException) {
                        BEUOOState.this.retryPathServiceLater(PathServiceRemoveRetry.this);
                    }
                }
            };
        }

        private KeyString getKey() {
            return this.key;
        }

        public final void timerExpired(Timer timer) {
            this.processPendingEntry();
        }

        public final void run() {
            this.processPendingEntry();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void processPendingEntry() {
            boolean bl;
            block19: {
                block18: {
                    block17: {
                        bl = false;
                        try {
                            while (true) {
                                PathServiceRemoveRetry pathServiceRemoveRetry;
                                Object object = retryListLock;
                                synchronized (object) {
                                    if (!bl && delayedRemoveRunning) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 16, 6, 13] lbl7 : MonitorExitStatement: MONITOREXIT : var3_4
                                        Object var7_6 = null;
                                        if (!bl) return;
                                        break block17;
                                    }
                                    bl = delayedRemoveRunning = true;
                                    if (delayedRemoves == null || delayedRemove.isEmpty()) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 6, 13, 15] lbl14 : MonitorExitStatement: MONITOREXIT : var3_4
                                        break block18;
                                    }
                                    pathServiceRemoveRetry = (PathServiceRemoveRetry)delayedRemove.remove();
                                    delayedRemoves.remove(pathServiceRemoveRetry.key);
                                }
                                boolean bl2 = pathServiceRemoveRetry.processRemove();
                                Object object2 = retryListLock;
                                synchronized (object2) {
                                    if (!bl2) break;
                                    if (BEUOOState.this.destination.getBackEnd().getWorkManager().scheduleIfBusy((Runnable)this)) {
                                        bl = false;
                                        delayedRemoveRunning = false;
                                        break block19;
                                    }
                                }
                            }
                            {
                            }
                            break block19;
                        }
                        catch (Throwable throwable) {
                            Object var7_9 = null;
                            if (!bl) throw throwable;
                            Object object = retryListLock;
                            synchronized (object) {
                                delayedRemoveRunning = false;
                                throw throwable;
                            }
                        }
                    }
                    Object object = retryListLock;
                    synchronized (object) {
                        delayedRemoveRunning = false;
                        return;
                    }
                }
                Object var7_7 = null;
                if (!bl) return;
                Object object = retryListLock;
                synchronized (object) {
                    delayedRemoveRunning = false;
                    return;
                }
            }
            Object var7_8 = null;
            if (!bl) return;
            Object object = retryListLock;
            synchronized (object) {
                delayedRemoveRunning = false;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeProcessing() {
            if (this.state.completeRemove()) {
                Object object = retryListLock;
                synchronized (object) {
                    if (delayedRemoves == null) {
                        return;
                    }
                    delayedRemoves.remove(this.key);
                    delayedRemove.remove((Object)this);
                    if (delayedRemoveRunning || delayedRemove.isEmpty()) {
                        return;
                    }
                }
                BEUOOState.this.destination.getBackEnd().getTimerManager().schedule((TimerListener)this, PATH_SERVICE_RESUME_RETRY_DELAY);
            }
        }
    }

    private static class PathServiceCompReqListener
    extends CompReqListener {
        private final InheritableThreadContext context = InheritableThreadContext.getContext();
        private final BEProducerSendRequest sendRequest;

        PathServiceCompReqListener(BEProducerSendRequest bEProducerSendRequest) {
            this.sendRequest = bEProducerSendRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            this.context.push();
            try {
                super.run();
                Object var2_1 = null;
                this.context.pop();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.context.pop();
                throw throwable;
            }
        }

        public void setResult(Object object) {
            super.setResult(object);
        }

        public Object getResult() throws Throwable {
            return super.getResult();
        }

        public boolean hasResult() {
            return super.hasResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onCompletion(CompletionRequest completionRequest, Object object) {
            State state = this.sendRequest.getUooState();
            DelayedPutIfAbsent delayedPutIfAbsent = state == null ? null : state.computeSendToResume(this.sendRequest);
            State state2 = this.sendRequest.getUooState();
            try {
                state2.processPathServiceResult(this.sendRequest);
                Object var7_6 = null;
                if (delayedPutIfAbsent == null) return;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (delayedPutIfAbsent == null) throw throwable;
                state2.getBEUOOState().destination.getBackEnd().getWorkManager().schedule((Runnable)((Object)delayedPutIfAbsent));
                throw throwable;
            }
            state2.getBEUOOState().destination.getBackEnd().getWorkManager().schedule((Runnable)((Object)delayedPutIfAbsent));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onException(CompletionRequest completionRequest, Throwable throwable) {
            DelayedPutIfAbsent delayedPutIfAbsent = this.sendRequest.getUooState().computeSendToResume(this.sendRequest);
            State state = this.sendRequest.getUooState();
            try {
                this.sendRequest.resumeRequest(PathHelper.wrapExtensionImpl(throwable), false);
                Object var6_5 = null;
                if (delayedPutIfAbsent == null) return;
            }
            catch (Throwable throwable2) {
                Object var6_6 = null;
                if (delayedPutIfAbsent == null) throw throwable2;
                state.getBEUOOState().destination.getBackEnd().getWorkManager().schedule((Runnable)((Object)delayedPutIfAbsent));
                throw throwable2;
            }
            state.getBEUOOState().destination.getBackEnd().getWorkManager().schedule((Runnable)((Object)delayedPutIfAbsent));
        }
    }

    private static abstract class CompReqListener
    extends CompletionRequest
    implements CompletionListener {
        CompReqListener() {
            this.addListener(this);
        }
    }
}

