/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.common.BadSequenceNumberException;
import weblogic.jms.common.DuplicateSequenceNumberException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.OutOfSequenceRangeException;
import weblogic.messaging.Message;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.UOWCallback;
import weblogic.messaging.kernel.UOWCallbackCaller;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManagerFactory;

public class BEUOWCallback
implements UOWCallback,
TimerListener {
    private ArrayList messages = new ArrayList();
    private int lastSequenceNumber = Integer.MAX_VALUE;
    private int numberVisible = 0;
    private ObjectMessageImpl oneBigMessage = null;
    private BEDestinationImpl dest = null;
    private UOWCallbackCaller caller;
    private Timer expirationTimer;
    private String name;
    private int oneBigMessageNumber = -1;
    private Set adminDeletedMessages = new HashSet();

    public BEUOWCallback(UOWCallbackCaller uOWCallbackCaller, String string) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Creating BEUOWCallback(UOW) of name " + uOWCallbackCaller + " on queue " + string);
        }
        this.caller = uOWCallbackCaller;
        this.name = string;
    }

    public synchronized Message newVisibleMessage(Message message) {
        ++this.numberVisible;
        this.removeMarkerFromMessage(message);
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Number visible in UOW " + this.caller + " is now " + this.numberVisible);
        }
        if (this.numberVisible != this.lastSequenceNumber + 1) {
            return null;
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("UOW complete");
        }
        MessageImpl messageImpl = (MessageImpl)this.messages.get(this.lastSequenceNumber);
        this.oneBigMessage = new ObjectMessageImpl();
        try {
            this.oneBigMessage.initializeFromMessage(messageImpl);
            this.oneBigMessage.setObject(this.messages, PeerInfo.VERSION_920);
            this.oneBigMessage.setJMSDeliveryMode(1);
            this.oneBigMessage.setId(messageImpl.getId());
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
        }
        return this.oneBigMessage;
    }

    public void checkReplacement(Message message, Message message2) {
        try {
            MessageImpl messageImpl = (MessageImpl)message;
            MessageImpl messageImpl2 = (MessageImpl)message2;
            if (messageImpl2 instanceof TextMessage) {
                try {
                    ((TextMessage)messageImpl2).getText();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            if (messageImpl instanceof TextMessage) {
                try {
                    ((TextMessage)messageImpl).getText();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            if (!messageImpl2.propertyExists("JMS_BEA_DeliveryFailureReason")) {
                return;
            }
            messageImpl.setPropertiesWritable(true);
            messageImpl.setIntProperty("JMS_BEA_DeliveryFailureReason", messageImpl2.getIntProperty("JMS_BEA_DeliveryFailureReason"));
            messageImpl.setPropertiesWritable(false);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public Message getOneBigMessageReplacee() {
        if (this.oneBigMessageNumber == -1) {
            return null;
        }
        return (Message)this.messages.get(this.oneBigMessageNumber);
    }

    private void clean() {
        this.messages = new ArrayList();
        this.lastSequenceNumber = Integer.MAX_VALUE;
        this.numberVisible = 0;
        this.oneBigMessageNumber = -1;
        this.oneBigMessage = null;
        this.dest = null;
        this.caller = null;
        if (this.expirationTimer != null) {
            this.expirationTimer.cancel();
        }
        this.expirationTimer = null;
        this.adminDeletedMessages = new HashSet();
    }

    public synchronized void adminDeletedMessage(Message message) {
        if (message instanceof TextMessage) {
            try {
                ((TextMessage)message).getText();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        this.adminDeletedMessages.add(message);
    }

    public synchronized boolean removeMessage(Message message) {
        if (this.caller == null) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Caller is null, we've already cleaned up");
            }
            return true;
        }
        MessageImpl messageImpl = (MessageImpl)message;
        if (this.adminDeletedMessages.contains(messageImpl)) {
            this.adminDeletedMessages.remove(messageImpl);
        } else if (messageImpl == this.getOneBigMessageReplacee()) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                if (messageImpl instanceof TextMessage) {
                    try {
                        ((TextMessage)messageImpl).getText();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
                JMSDebug.JMSBackEnd.debug("Removing one big message: " + messageImpl + " within UOW: " + this.caller + " on " + this.name);
            }
            this.clean();
            return true;
        }
        try {
            if (!messageImpl.propertyExists("JMS_BEA_DeliveryFailureReason")) {
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    if (messageImpl instanceof TextMessage) {
                        ((TextMessage)messageImpl).getText();
                    }
                    JMSDebug.JMSBackEnd.debug("No delivery failure reason on " + messageImpl + " within UOW: " + this.caller + " on " + this.name);
                }
                int n = messageImpl.getIntProperty("JMS_BEA_UnitOfWorkSequenceNumber") - 1;
                --this.numberVisible;
                this.messages.set(n, null);
                if (this.numberVisible == 0) {
                    if (this.expirationTimer != null) {
                        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                            JMSDebug.JMSBackEnd.debug("Last message gone, cleaning up expiration timer");
                        }
                        this.expirationTimer.cancel();
                        this.expirationTimer = null;
                    }
                    this.clean();
                    return true;
                }
                if (this.expirationTimer == null) {
                    this.setWorkExpirationTimerIfNecessary();
                }
                this.oneBigMessageNumber = -1;
                this.oneBigMessage = null;
                return false;
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.clean();
        return true;
    }

    public synchronized void timerExpired(Timer timer) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Incomplete work expiration timer fired for work: " + this.caller + " on " + this.name);
        }
        ListIterator listIterator = this.messages.listIterator();
        while (listIterator.hasNext()) {
            MessageImpl messageImpl = (MessageImpl)listIterator.next();
            try {
                if (messageImpl == null) continue;
                messageImpl.setPropertiesWritable(true);
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    if (messageImpl instanceof TextMessage) {
                        ((TextMessage)messageImpl).getText();
                    }
                    JMSDebug.JMSBackEnd.debug("Setting delivery failure reason to WORK_EXPIRED on message: " + messageImpl + " within UOW: " + this.caller + " on " + this.name);
                }
                messageImpl.setIntProperty("JMS_BEA_DeliveryFailureReason", 1);
                messageImpl.setPropertiesWritable(false);
            }
            catch (JMSException jMSException) {}
        }
        this.caller.expireAll();
    }

    private TimerManager getTimerManager() {
        return TimerManagerFactory.getTimerManagerFactory().getTimerManager("weblogic.jms.backend.BEUOWCallback", WorkManagerFactory.getInstance().getSystem());
    }

    private boolean allMessagesHaveArrived() {
        if (this.lastSequenceNumber == Integer.MAX_VALUE) {
            return false;
        }
        ListIterator listIterator = this.messages.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (e != null) continue;
            return false;
        }
        return true;
    }

    private void setWorkExpirationTimerIfNecessary() {
        if (this.dest == null) {
            this.dest = JMSService.getJMSService().getBEDeployer().findBEDestination(this.name);
        }
        if (this.dest == null) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Cannot find destination: " + this.name + " assuming that we're going down");
            }
            return;
        }
        if (this.dest.getIncompleteWorkExpirationTime() > 0) {
            long l = System.currentTimeMillis() + (long)this.dest.getIncompleteWorkExpirationTime();
            this.caller.setUserData((Object)new Expiration(l));
            this.expirationTimer = this.getTimerManager().schedule((TimerListener)this, (long)this.dest.getIncompleteWorkExpirationTime());
        }
    }

    private void removeMarkerFromMessage(Message message) {
        try {
            MessageImpl messageImpl = (MessageImpl)message;
            if (!messageImpl.propertyExists("JMS_BEA_OneBigMessageNumber")) {
                return;
            }
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                if (messageImpl instanceof TextMessage) {
                    ((TextMessage)messageImpl).getText();
                }
                JMSDebug.JMSBackEnd.debug("Removing marker from in-memory copy of message");
            }
            messageImpl.removeProperty("JMS_BEA_OneBigMessageNumber");
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
        }
    }

    private void makeMarkerMessage(MessageImpl messageImpl, int n) {
        if (this.lastSequenceNumber == 0) {
            this.oneBigMessageNumber = 0;
            return;
        }
        this.oneBigMessageNumber = n == 0 ? 1 : 0;
        messageImpl.setPropertiesWritable(true);
        try {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                if (messageImpl instanceof TextMessage) {
                    ((TextMessage)messageImpl).getText();
                }
                JMSDebug.JMSBackEnd.debug("Setting one big message to message number " + this.oneBigMessageNumber + ", the message is " + this.getOneBigMessageReplacee() + " within UOW: " + this.caller + " on " + this.name);
            }
            messageImpl.setIntProperty("JMS_BEA_OneBigMessageNumber", this.oneBigMessageNumber);
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
        }
        messageImpl.setPropertiesWritable(false);
    }

    public synchronized boolean sendMessage(Message message) throws KernelException {
        MessageImpl messageImpl;
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Message sent in UOW: " + message);
        }
        if ((messageImpl = (MessageImpl)message) == this.oneBigMessage) {
            return false;
        }
        try {
            boolean bl;
            int n = messageImpl.getIntProperty("JMS_BEA_UnitOfWorkSequenceNumber") - 1;
            if (n < 0) {
                throw new KernelException("Dummy", (Throwable)((Object)new BadSequenceNumberException("A sequence number must be greater than or equal to zero")));
            }
            if (n > this.lastSequenceNumber) {
                throw new KernelException("Dummy", (Throwable)((Object)new OutOfSequenceRangeException("Normal message out of range")));
            }
            boolean bl2 = bl = messageImpl.propertyExists("JMS_BEA_IsUnitOfWorkEnd") && messageImpl.getBooleanProperty("JMS_BEA_IsUnitOfWorkEnd");
            if (n < this.messages.size() && this.messages.get(n) != null) {
                if (messageImpl.getSAFSequenceName() != null) {
                    return true;
                }
                throw new KernelException("Dummy", (Throwable)((Object)new DuplicateSequenceNumberException("Duplicate message")));
            }
            if (bl) {
                if (this.lastSequenceNumber != Integer.MAX_VALUE) {
                    throw new KernelException("Dummy", (Throwable)((Object)new DuplicateSequenceNumberException("Can't send two last messages")));
                }
                if (n < this.messages.size()) {
                    throw new KernelException("Dummy", (Throwable)((Object)new OutOfSequenceRangeException("End is too low")));
                }
            }
            while (this.messages.size() <= n) {
                this.messages.add(null);
            }
            this.messages.set(n, messageImpl);
            if (this.messages.size() == 1 && !this.allMessagesHaveArrived()) {
                this.setWorkExpirationTimerIfNecessary();
            }
            if (bl) {
                this.lastSequenceNumber = n;
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("lastSequenceNumber set to " + this.lastSequenceNumber);
                }
            }
            if (this.expirationTimer != null && this.allMessagesHaveArrived()) {
                this.expirationTimer.cancel();
                this.expirationTimer = null;
            }
            if (this.allMessagesHaveArrived()) {
                this.makeMarkerMessage(messageImpl, n);
            }
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
        }
        return false;
    }

    public synchronized void recoverMessage(Message message) throws KernelException {
        MessageImpl messageImpl = (MessageImpl)message;
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Message recovered in UOW: " + message);
        }
        try {
            boolean bl;
            int n = messageImpl.getIntProperty("JMS_BEA_UnitOfWorkSequenceNumber") - 1;
            boolean bl2 = bl = messageImpl.propertyExists("JMS_BEA_IsUnitOfWorkEnd") && messageImpl.getBooleanProperty("JMS_BEA_IsUnitOfWorkEnd");
            while (this.messages.size() <= n) {
                this.messages.add(null);
            }
            this.messages.set(n, messageImpl);
            if (bl) {
                this.lastSequenceNumber = n;
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("End message: lastSequenceNumber set to " + this.lastSequenceNumber);
                }
            }
            if (this.allMessagesHaveArrived()) {
                this.makeMarkerMessage(messageImpl, n);
            }
            if (messageImpl.propertyExists("JMS_BEA_OneBigMessageNumber")) {
                this.oneBigMessageNumber = messageImpl.getIntProperty("JMS_BEA_OneBigMessageNumber");
            }
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
        }
    }

    public void recoveryComplete() {
        if (this.caller.getUserData() == null) {
            return;
        }
        if (this.allMessagesHaveArrived()) {
            return;
        }
        if (this.oneBigMessageNumber != -1) {
            this.caller.deleteAll();
            return;
        }
        Expiration expiration = (Expiration)this.caller.getUserData();
        long l = expiration.getTime();
        long l2 = System.currentTimeMillis();
        if (l2 > l) {
            this.timerExpired(null);
            return;
        }
        this.expirationTimer = this.getTimerManager().schedule((TimerListener)this, l - l2);
    }

    public static class Expiration
    implements Externalizable {
        long expirationTime;

        public Expiration() {
        }

        public Expiration(long l) {
            this.expirationTime = l;
        }

        public long getTime() {
            return this.expirationTime;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeLong(this.expirationTime);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.expirationTime = objectInput.readLong();
        }
    }
}

