/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.naming.NamingException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.application.ModuleException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.DescriptorUpdateFailedException;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.health.HealthMonitorService;
import weblogic.health.HealthState;
import weblogic.health.LowMemoryNotificationService;
import weblogic.health.MemoryEvent;
import weblogic.health.MemoryListener;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.NamedEntityBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.j2ee.descriptor.wl.TemplateBean;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEConnection;
import weblogic.jms.backend.BEDestinationCreateRequest;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEDurableSubscriptionStore;
import weblogic.jms.backend.BEManager;
import weblogic.jms.backend.BEMultiSender;
import weblogic.jms.backend.BEQuota;
import weblogic.jms.backend.BEServerSession;
import weblogic.jms.backend.BEServerSessionGetRequest;
import weblogic.jms.backend.BEServerSessionGetResponse;
import weblogic.jms.backend.BEServerSessionPool;
import weblogic.jms.backend.BEServerSessionPoolCloseRequest;
import weblogic.jms.backend.BEServerSessionPoolCreateRequest;
import weblogic.jms.backend.BEServerSessionPoolFactory;
import weblogic.jms.backend.BETemporaryDestinationDestroyRequest;
import weblogic.jms.backend.BEThresholdHandler;
import weblogic.jms.backend.BackEndTempDestinationFactory;
import weblogic.jms.backend.DestinationEntityProvider;
import weblogic.jms.backend.JMSMessageCursorDelegate;
import weblogic.jms.backend.JMSMessageCursorRuntimeImpl;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.common.DurableSubscription;
import weblogic.jms.common.EntityName;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDestinationCreateResponse;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageOpenDataConverter;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSServerSessionPoolCreateResponse;
import weblogic.jms.common.LeaderManager;
import weblogic.jms.common.MessageStatisticsLogger;
import weblogic.jms.common.ModuleName;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.jms.extensions.JMSModuleHelper;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.JMSModuleManagedEntity;
import weblogic.jms.store.JMSObjectHandler;
import weblogic.logging.jms.JMSMessageLogger;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.JMSSessionPoolMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.JMSDestinationRuntimeMBean;
import weblogic.management.runtime.JMSServerRuntimeMBean;
import weblogic.management.runtime.JMSSessionPoolRuntimeMBean;
import weblogic.management.utils.BeanListenerCustomizer;
import weblogic.messaging.ID;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.common.ThresholdHandler;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.kernel.Cursor;
import weblogic.messaging.kernel.Destination;
import weblogic.messaging.kernel.Kernel;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.Quota;
import weblogic.messaging.kernel.QuotaPolicy;
import weblogic.messaging.kernel.Topic;
import weblogic.messaging.kernel.internal.KernelImpl;
import weblogic.messaging.kernel.runtime.MessagingKernelDiagnosticImageSource;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentStoreException;
import weblogic.store.TestStoreException;
import weblogic.store.gxa.internal.GXAResourceImpl;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.transaction.internal.XidImpl;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class BackEnd
extends JMSMessageCursorRuntimeImpl
implements JMSServerRuntimeMBean,
MessageStatisticsLogger,
Invocable,
MemoryListener,
BeanListenerCustomizer {
    static final long serialVersionUID = -3550452657980202118L;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String NORMAL_WM_NAME = ".System";
    private static final String LIMITED_WM_NAME = ".Limited";
    private static final String ASYNC_WM_NAME = ".AsyncPush";
    private Kernel kernel;
    private Quota backEndQuota;
    private HashMap BEQuotas = new HashMap();
    private TemporaryModule temporaryModule;
    private int temporaryCounter;
    private boolean isHostingTemporaryDestinations = false;
    private ModuleName temporaryTemplateResource;
    private String temporaryTemplateName;
    private final String name;
    private final String configType;
    private final JMSServerId backEndId;
    private HashMap durableSubscribers = new HashMap();
    private final HashMap serverSessionPoolsByName = new HashMap();
    private final HashMap serverSessionPoolsById = new HashMap();
    private long serverSessionPoolsCurrentCount;
    private long serverSessionPoolsHighCount;
    private long serverSessionPoolsTotalCount;
    private long destinationsHighCount;
    private long destinationsTotalCount;
    private boolean bound;
    private final HashMap name2Destination = new HashMap();
    private final HashMap createId2Destination = new HashMap();
    private TimerManager timerManager;
    private static final String BE_NAME_PREFIX = "weblogic.jms.";
    private static final String HEALTH_NAME_PREFIX = "JMSServer.";
    private PersistentStoreXA persistentStore;
    private boolean downgradeable;
    private String pagingDirectory;
    private final HashMap pagingConfig = new HashMap();
    private BEDurableSubscriptionStore durableSubscriptionStore;
    private BEMultiSender multiSender;
    private ThresholdHandler thresholdHandler;
    private static final int LIMITED_WM_NUM_THREADS = 8;
    private WorkManager workManager;
    private WorkManager limitedWorkManager;
    private WorkManager asyncPushWorkManager;
    private volatile boolean isMemoryLow;
    private BackEndTempDestinationFactory tempDestinationFactory;
    private BEServerSessionPoolFactory serverSessionPoolFactory;
    private JMSSessionPoolMBean[] sessionPoolMBeans;
    private int state;
    private int pausedState = this.state = 0;
    private final Object shutdownLock = new Object();
    private final Object destinationDeletionLock = new Object();
    private static final String DEFAULT_SESSION_POOL_FACTORY_JNDI = "weblogic.jms.ServerSessionPoolFactory:";
    private static final double JMS_ABOVE_QUOTA_RATE = 0.9;
    private static final long JMS_ABOVE_QUOTA_TIME = 3600000L;
    private static final HealthState OK_HEALTH_STATE = new HealthState(0);
    private Exception backEndHealthException = null;
    private long startupTime;
    private final InvocableMonitor invocableMonitor;
    private QuotaPolicy blockingSendPolicy;
    private JMSMessageLogger jmsMessageLogger = null;
    private static final String PRODUCTION = "Production";
    private static final String INSERTION = "Insertion";
    private static final String CONSUMPTION = "Consumption";
    private String productionPausedAtStartup = "default";
    private String insertionPausedAtStartup = "default";
    private String consumptionPausedAtStartup = "default";

    public BackEnd(String string, String string2) throws ManagementException {
        super(string, false);
        this.name = string;
        this.configType = string2;
        JMSService jMSService = JMSService.getJMSService();
        if (jMSService == null) {
            throw new ManagementException("JMSService is not active");
        }
        this.backEndId = jMSService.getNextServerId();
        this.initializeWorkManagers();
        try {
            HashMap<String, WorkManager> hashMap = new HashMap<String, WorkManager>(2);
            hashMap.put("WorkManager", this.workManager);
            hashMap.put("LimitedWorkManager", this.limitedWorkManager);
            this.kernel = new KernelImpl(this.name, hashMap);
            this.thresholdHandler = new BEThresholdHandler(this.kernel, this.name);
            this.multiSender = new BEMultiSender();
            this.backEndQuota = BackEnd.createQuota(this.kernel, this.name + ".Quota." + System.currentTimeMillis(), Long.MAX_VALUE, Integer.MAX_VALUE, QuotaPolicy.FIFO);
        }
        catch (KernelException kernelException) {
            throw new DeploymentException(kernelException);
        }
        LeaderManager.getLeaderManager(this.backEndId.getId());
        this.invocableMonitor = new InvocableMonitor(JMSService.getJMSService().getInvocableMonitor());
        this.serverSessionPoolFactory = new BEServerSessionPoolFactory(this.backEndId);
        this.startupTime = System.currentTimeMillis();
        LowMemoryNotificationService.addMemoryListener(this);
        HealthMonitorService.register(HEALTH_NAME_PREFIX + string, this, false);
        this.state = 1;
    }

    private static Quota createQuota(Kernel kernel, String string, long l, int n, QuotaPolicy quotaPolicy) throws KernelException {
        Quota quota = kernel.createQuota(string);
        quota.setPolicy(quotaPolicy);
        quota.setBytesMaximum(l);
        quota.setMessagesMaximum(n);
        return quota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BEQuota findBEQuota(String string) {
        HashMap hashMap = this.BEQuotas;
        synchronized (hashMap) {
            return (BEQuota)this.BEQuotas.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BEQuota createBEQuota(String string, QuotaBean quotaBean) throws BeanUpdateFailedException {
        Quota quota;
        int n = quotaBean.getMessagesMaximum() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)quotaBean.getMessagesMaximum();
        try {
            quota = BackEnd.createQuota(this.kernel, string, quotaBean.getBytesMaximum(), n, QuotaPolicy.get((String)quotaBean.getPolicy()));
        }
        catch (KernelException kernelException) {
            throw new BeanUpdateFailedException(kernelException.getMessage(), (Throwable)kernelException);
        }
        BEQuota bEQuota = new BEQuota(string, quota);
        HashMap hashMap = this.BEQuotas;
        synchronized (hashMap) {
            this.BEQuotas.put(string, bEQuota);
        }
        return bEQuota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBEQuota(String string) {
        BEQuota bEQuota = this.findBEQuota(string);
        if (bEQuota != null) {
            this.kernel.deleteQuota(string);
        }
        HashMap hashMap = this.BEQuotas;
        synchronized (hashMap) {
            this.BEQuotas.remove(string);
        }
    }

    WorkManager getWorkManager() {
        return this.workManager;
    }

    WorkManager getThreadLimitedWorkManager() {
        return this.limitedWorkManager;
    }

    public WorkManager getAsyncPushWorkManager() {
        return this.asyncPushWorkManager;
    }

    private void initializeWorkManagers() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getServer();
        if (serverMBean.getUse81StyleExecuteQueues()) {
            this.workManager = WorkManagerFactory.getInstance().getDefault();
            this.limitedWorkManager = WorkManagerFactory.getInstance().getDefault();
            this.asyncPushWorkManager = WorkManagerFactory.getInstance().getDefault();
        } else {
            this.workManager = WorkManagerFactory.getInstance().findOrCreate(BE_NAME_PREFIX + this.name + NORMAL_WM_NAME, 100, 1, -1);
            this.limitedWorkManager = WorkManagerFactory.getInstance().findOrCreate(BE_NAME_PREFIX + this.name + LIMITED_WM_NAME, 1, 8);
            this.asyncPushWorkManager = WorkManagerFactory.getInstance().findOrCreate(BE_NAME_PREFIX + this.name + ASYNC_WM_NAME, 100, 1, -1);
        }
        this.timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager(BE_NAME_PREFIX + this.name, this.workManager);
    }

    public JMSMessageLogger getJMSMessageLogger() {
        return this.jmsMessageLogger;
    }

    public void setPagingDirectory(String string) {
        this.pagingDirectory = string;
    }

    public void setPagingFileLockingEnabled(boolean bl) {
        this.pagingConfig.put("FileLockingEnabled", bl);
    }

    public void setPagingMinWindowBufferSize(int n) {
        this.pagingConfig.put("MinWindowBufferSize", n);
    }

    public void setPagingMaxWindowBufferSize(int n) {
        this.pagingConfig.put("MaxWindowBufferSize", n);
    }

    public void setPagingIoBufferSize(int n) {
        this.pagingConfig.put("IoBufferSize", n);
    }

    public void setPagingBlockSize(int n) {
        this.pagingConfig.put("BlockSize", n);
    }

    public void setPagingMaxFileSize(long l) {
        this.pagingConfig.put("MaxFileSize", l);
    }

    public void setPersistentStore(PersistentStoreXA persistentStoreXA) {
        this.persistentStore = persistentStoreXA;
    }

    public PersistentStoreXA getPersistentStore() {
        return this.persistentStore;
    }

    boolean isStoreEnabled() {
        return this.persistentStore != null;
    }

    boolean isAllowsPersistentDowngrade() {
        return this.downgradeable;
    }

    public void setAllowsPersistentDowngrade(boolean bl) {
        this.downgradeable = bl;
    }

    public void setJMSMessageLogger(JMSMessageLogger jMSMessageLogger) {
        this.jmsMessageLogger = jMSMessageLogger;
    }

    BEDurableSubscriptionStore getDurableSubscriptionStore() {
        return this.durableSubscriptionStore;
    }

    BEMultiSender getMultiSender() {
        return this.multiSender;
    }

    public JMSServerId getJMSServerId() {
        return this.backEndId;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setBlockingSendPolicy(String string) {
        if (string == null) {
            JMSLogger.logIllegalThresholdValue((String)this.name, (String)"BlockingSendPolicy");
            throw new IllegalArgumentException("Illegal BlockingSendPolicy value of null");
        }
        QuotaPolicy quotaPolicy = QuotaPolicy.get((String)string);
        if (quotaPolicy != this.blockingSendPolicy) {
            this.blockingSendPolicy = quotaPolicy;
            this.backEndQuota.setPolicy(this.blockingSendPolicy);
        }
    }

    public HealthState getHealthState() {
        if (this.backEndHealthException != null) {
            return new HealthState(3, this.backEndHealthException.toString());
        }
        if (this.thresholdHandler.isArmed()) {
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>(6);
            long l = System.currentTimeMillis();
            double d = l - this.startupTime;
            long l2 = l - this.thresholdHandler.getMessagesThresholdTime();
            if (l2 > 3600000L) {
                arrayList.add(JMSExceptionLogger.logMessagesThresholdTimeExceededLoggable((String)this.name).getMessage());
                n = 1;
            } else if ((double)l2 / d > 0.9) {
                arrayList.add(JMSExceptionLogger.logMessagesThresholdRunningTimeExceededLoggable((String)this.name).getMessage());
                n = 1;
            }
            l2 = l - this.thresholdHandler.getBytesThresholdTime();
            if (l2 > 3600000L) {
                arrayList.add(JMSExceptionLogger.logBytesThresholdTimeExceededLoggable((String)this.name).getMessage());
                n = 1;
            } else if ((double)l2 / d > 0.9) {
                arrayList.add(JMSExceptionLogger.logBytesThresholdRunningTimeExceededLoggable((String)this.name).getMessage());
                n = 1;
            }
            if (arrayList.isEmpty()) {
                return new HealthState(n);
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return new HealthState(n, stringArray);
        }
        return OK_HEALTH_STATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.temporaryModule != null) {
            TemporaryModule temporaryModule = this.temporaryModule;
            synchronized (temporaryModule) {
                this.temporaryModule.close();
            }
            this.temporaryModule = null;
        }
        LowMemoryNotificationService.removeMemoryListener(this);
        HealthMonitorService.unregister(HEALTH_NAME_PREFIX + this.name);
    }

    TimerManager getTimerManager() {
        return this.timerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createServerSessionPools() throws JMSException {
        Iterator iterator;
        Object object;
        if (this.sessionPoolMBeans == null) {
            return;
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("About to process " + this.sessionPoolMBeans.length + " sessionpools");
        }
        for (int i = 0; i < this.sessionPoolMBeans.length; ++i) {
            JMSID jMSID = JMSService.getJMSService().getNextId();
            try {
                object = new BEServerSessionPool(this.sessionPoolMBeans[i].getName(), jMSID, this, this.sessionPoolMBeans[i]);
                this.serverSessionPoolAdd((BEServerSessionPool)object);
                continue;
            }
            catch (Exception exception) {
                JMSLogger.logErrorCreateSSP((String)this.name, (String)this.sessionPoolMBeans[i].getName(), (Exception)exception);
                throw new weblogic.jms.common.JMSException("Error creating ServerSessionPool " + this.sessionPoolMBeans[i], (Throwable)exception);
            }
        }
        if (this.sessionPoolMBeans.length > 0) {
            JMSLogger.logServerSessionPoolsDeprecated();
        }
        JMSLogger.logCntPools((String)this.name, (int)this.sessionPoolMBeans.length);
        object = this.shutdownLock;
        synchronized (object) {
            iterator = ((HashMap)this.serverSessionPoolsById.clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            object = (BEServerSessionPool)iterator.next();
            ((BEServerSessionPool)object).start();
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug(this.sessionPoolMBeans.length + " sessionpools are created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void destroyServerSessionPools() {
        Iterator iterator;
        Object object = this.shutdownLock;
        synchronized (object) {
            iterator = ((HashMap)this.serverSessionPoolsByName.clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            this.serverSessionPoolRemove((BEServerSessionPool)iterator.next());
        }
        object = this.shutdownLock;
        synchronized (object) {
            this.serverSessionPoolsByName.clear();
            this.serverSessionPoolsById.clear();
        }
    }

    private void unAdvertise() {
        if (!this.bound) {
            return;
        }
        this.bound = false;
        if (this.tempDestinationFactory != null) {
            try {
                JMSService.getJMSService().getBEDeployer().removeTempDestinationFactory(this.tempDestinationFactory);
                this.tempDestinationFactory = null;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        this.bound = false;
        try {
            PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(), "weblogic.jms.backend." + this.name, KERNEL_ID);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (this.serverSessionPoolFactory != null) {
            try {
                PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(), DEFAULT_SESSION_POOL_FACTORY_JNDI + this.getName(), KERNEL_ID);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void advertise() throws JMSException {
        block34: {
            try {
                this.activateFinished();
            }
            catch (BeanUpdateFailedException var1_1) {
                throw new weblogic.jms.common.JMSException(var1_1);
            }
            var1_2 = false;
            try {
                try {
                    PrivilegedActionUtilities.bindAsSU(JMSService.getContext(), "weblogic.jms.backend." + this.name, this.backEndId, BackEnd.KERNEL_ID);
                }
                catch (NamingException var2_3) {
                    try {
                        PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(), "weblogic.jms.backend." + this.name, this.backEndId, BackEnd.KERNEL_ID);
                    }
                    catch (NamingException var3_5) {
                        // empty catch block
                    }
                    try {
                        PrivilegedActionUtilities.bindAsSU(JMSService.getContext(), "weblogic.jms.backend." + this.name, this.backEndId, BackEnd.KERNEL_ID);
                    }
                    catch (NamingException var3_6) {
                        if (JMSDebug.JMSConfig.isDebugEnabled()) {
                            JMSDebug.JMSConfig.debug("Failed to bind backend to jndiname");
                        }
                        JMSLogger.logBackEndBindingFailed((String)this.name, (String)("weblogic.jms.backend." + this.name));
                        throw new weblogic.jms.common.JMSException("Error binding JMSServer into JNDI", (Throwable)var2_3);
                    }
                }
                var1_2 = true;
                var5_9 = null;
                ** if (var1_2 || this.tempDestinationFactory == null) goto lbl-1000
            }
            catch (Throwable var4_13) {
                var5_10 = null;
                if (!var1_2 && this.tempDestinationFactory != null) {
                    try {
                        JMSService.getJMSService().getBEDeployer().removeTempDestinationFactory(this.tempDestinationFactory);
                        this.tempDestinationFactory = null;
                    }
                    catch (NamingException var6_12) {
                        // empty catch block
                    }
                }
                throw var4_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    JMSService.getJMSService().getBEDeployer().removeTempDestinationFactory(this.tempDestinationFactory);
                    this.tempDestinationFactory = null;
                }
                catch (NamingException var6_11) {}
            }
lbl-1000:
            // 2 sources

            {
            }
            var1_2 = false;
            try {
                if (this.serverSessionPoolFactory != null) {
                    try {
                        PrivilegedActionUtilities.bindAsSU(JMSService.getContext(), "weblogic.jms.ServerSessionPoolFactory:" + this.getName(), this.serverSessionPoolFactory, BackEnd.KERNEL_ID);
                    }
                    catch (NamingException var2_4) {
                        try {
                            PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(), "weblogic.jms.ServerSessionPoolFactory:" + this.getName(), this.serverSessionPoolFactory, BackEnd.KERNEL_ID);
                        }
                        catch (NamingException var3_7) {
                            // empty catch block
                        }
                        try {
                            PrivilegedActionUtilities.bindAsSU(JMSService.getContext(), "weblogic.jms.ServerSessionPoolFactory:" + this.getName(), this.serverSessionPoolFactory, BackEnd.KERNEL_ID);
                        }
                        catch (NamingException var3_8) {
                            throw new weblogic.jms.common.JMSException("Error binding weblogic.jms.ServerSessionPoolFactory:" + this.getName() + var2_4);
                        }
                    }
                }
                var1_2 = true;
                var8_14 = null;
                if (var1_2) break block34;
            }
            catch (Throwable var7_18) {
                var8_15 = null;
                if (!var1_2) {
                    try {
                        PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(), "weblogic.jms.backend." + this.name, BackEnd.KERNEL_ID);
                    }
                    catch (NamingException var9_17) {
                        // empty catch block
                    }
                    if (this.tempDestinationFactory != null) {
                        try {
                            JMSService.getJMSService().getBEDeployer().removeTempDestinationFactory(this.tempDestinationFactory);
                            this.tempDestinationFactory = null;
                        }
                        catch (NamingException var9_17) {
                            // empty catch block
                        }
                    }
                }
                throw var7_18;
            }
            try {
                PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(), "weblogic.jms.backend." + this.name, BackEnd.KERNEL_ID);
            }
            catch (NamingException var9_16) {
                // empty catch block
            }
            if (this.tempDestinationFactory != null) {
                try {
                    JMSService.getJMSService().getBEDeployer().removeTempDestinationFactory(this.tempDestinationFactory);
                    this.tempDestinationFactory = null;
                }
                catch (NamingException var9_16) {}
            }
        }
        this.bound = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Iterator iterator;
        HashMap hashMap;
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Suspending backend " + this.name);
        }
        JMSLogger.logJMSServerSuspending((String)this.name);
        boolean bl = false;
        Object object = this.shutdownLock;
        synchronized (object) {
            if ((this.state & 8) == 0) {
                this.markShuttingDown();
                bl = true;
            }
        }
        object = this.shutdownLock;
        synchronized (object) {
            hashMap = this.durableSubscribers;
            synchronized (hashMap) {
                iterator = ((HashMap)this.durableSubscribers.clone()).values().iterator();
            }
        }
        while (iterator.hasNext()) {
            try {
                object = (DurableSubscription)iterator.next();
                ((DurableSubscription)object).close();
            }
            catch (JMSException jMSException) {
                JMSLogger.logJMSServerShutdownError((String)this.name, (String)jMSException.toString(), (Throwable)jMSException);
            }
        }
        object = this.shutdownLock;
        synchronized (object) {
            hashMap = this.durableSubscribers;
            synchronized (hashMap) {
                this.durableSubscribers.clear();
            }
        }
        if (bl) {
            this.invocableMonitor.waitForInvocablesCompletion();
        }
        object = this.shutdownLock;
        synchronized (object) {
            iterator = ((HashMap)this.name2Destination.clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            this.removeDestination((BEDestinationImpl)iterator.next());
        }
        object = this.shutdownLock;
        synchronized (object) {
            this.name2Destination.clear();
            this.createId2Destination.clear();
        }
        this.timerManager.suspend();
        try {
            PrivilegedActionUtilities.unregister(this, KERNEL_ID);
        }
        catch (Exception exception) {
            JMSLogger.logErrorUnregisterJMSServer((String)this.name, (Exception)exception);
        }
        try {
            if (this.durableSubscriptionStore != null) {
                this.durableSubscriptionStore.close();
            }
            if (this.kernel != null) {
                this.kernel.close();
            }
        }
        catch (KernelException kernelException) {
            JMSLogger.logJMSServerShutdownError((String)this.name, (String)kernelException.toString(), (Throwable)kernelException);
        }
        object = this.shutdownLock;
        synchronized (object) {
            this.state = 16;
        }
        JMSLogger.logJMSServerSuspended((String)this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open() throws JMSException {
        block24: {
            Object object;
            block23: {
                if (JMSDebug.JMSConfig.isDebugEnabled()) {
                    JMSDebug.JMSConfig.debug("About to start backend " + this.name + " and state =" + this.state);
                }
                JMSLogger.logJMSServerResuming((String)this.name);
                try {
                    Object object2 = this.shutdownLock;
                    synchronized (object2) {
                        this.checkShutdown();
                        if ((this.state & 4) != 0) {
                            // MONITOREXIT @DISABLED, blocks:[0, 22, 9] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                            Object var5_4 = null;
                            object = this.shutdownLock;
                            break block23;
                        }
                        if ((this.state & 1) == 0) {
                            throw new weblogic.jms.common.JMSException("Failed to initialize JMSServer " + this.name + ": wrong state");
                        }
                        this.state |= 0x80;
                    }
                    try {
                        this.kernel.setProperty("Store", (Object)this.persistentStore);
                        this.kernel.setProperty("ObjectHandler", (Object)this.getJMSObjectHandler());
                        this.kernel.setProperty("PagingDirectory", (Object)this.pagingDirectory);
                        this.kernel.setProperty("PagingParams", (Object)this.pagingConfig);
                        this.kernel.open();
                    }
                    catch (KernelException kernelException) {
                        throw new weblogic.jms.common.JMSException(kernelException);
                    }
                    if (this.isStoreEnabled()) {
                        this.durableSubscriptionStore = new BEDurableSubscriptionStore(this.name, this.persistentStore);
                        this.durableSubscriptionStore.recover();
                    }
                    this.timerManager.resume();
                    try {
                        PrivilegedActionUtilities.register(this, KERNEL_ID);
                    }
                    catch (ManagementException managementException) {
                        try {
                            PrivilegedActionUtilities.unregister(this, KERNEL_ID);
                        }
                        catch (ManagementException managementException2) {
                            // empty catch block
                        }
                        try {
                            PrivilegedActionUtilities.register(this, KERNEL_ID);
                        }
                        catch (ManagementException managementException3) {
                            throw new weblogic.jms.common.JMSException("Error in resuming JMS server " + this.name, (Throwable)managementException);
                        }
                    }
                    this.advertise();
                    object2 = this.shutdownLock;
                    synchronized (object2) {
                        this.checkShutdown();
                        this.state = 4;
                    }
                    break block24;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    Object object3 = this.shutdownLock;
                    synchronized (object3) {
                        this.state &= 0xFFFFFF7F;
                        throw throwable;
                    }
                }
            }
            synchronized (object) {
                this.state &= 0xFFFFFF7F;
                return;
            }
        }
        Object var5_5 = null;
        Object object = this.shutdownLock;
        synchronized (object) {
            this.state &= 0xFFFFFF7F;
            return;
        }
    }

    private ObjectHandler getJMSObjectHandler() {
        JMSObjectHandler jMSObjectHandler = new JMSObjectHandler();
        if (ObjectMessageImpl.isTestStoreExceptionEnabled()) {
            return new ObjectHandlerTestStoreException((ObjectHandler)jMSObjectHandler);
        }
        return jMSObjectHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markShuttingDown() {
        boolean bl = false;
        Object object = this.shutdownLock;
        synchronized (object) {
            if ((this.state & 0x10) != 0) {
                return;
            }
            bl = (this.state & 3) == 0;
            this.state = 8;
            Iterator iterator = this.name2Destination.values().iterator();
            while (iterator.hasNext()) {
                ((BEDestinationImpl)iterator.next()).markShuttingDown();
            }
            iterator = this.serverSessionPoolsByName.values().iterator();
            while (iterator.hasNext()) {
                ((BEServerSessionPool)iterator.next()).markShuttingDown();
            }
        }
        if (bl) {
            this.preSuspendOrShutdown();
        }
    }

    private boolean isShutdown() {
        return (this.state & 0x18) != 0;
    }

    private boolean isShutdownOrSuspended() {
        return this.isShutdown() || (this.state & 3) != 0;
    }

    private void checkShutdown() throws JMSException {
        if (this.isShutdown()) {
            throw new weblogic.jms.common.JMSException("JMSServer is shutdown");
        }
    }

    private void checkShutdown(String string) throws JMSException {
        if (this.isShutdown()) {
            throw new weblogic.jms.common.JMSException("Failed to " + string + " because JMSServer is shutdown");
        }
    }

    public void checkShutdownOrSuspended(String string) throws JMSException {
        if (this.isShutdownOrSuspended()) {
            throw new weblogic.jms.common.JMSException("Failed to " + string + " because JMSServer is shutdown or " + "suspended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkShutdownNeedLock(String string) throws JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.isShutdown()) {
                throw new weblogic.jms.common.JMSException("Failed to " + string + " because JMSServer is shutdown");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkShutdownOrSuspendedNeedLock(String string) throws JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.isShutdown() || (this.state & 3) != 0) {
                throw new weblogic.jms.common.JMSException("Failed to " + string + " because JMSServer " + this.name + " is shutdown or suspended " + this.state);
            }
        }
    }

    private void preSuspendOrShutdown() {
        this.unAdvertise();
        this.destroyServerSessionPools();
    }

    public void setSessionPoolMBeans(JMSSessionPoolMBean[] jMSSessionPoolMBeanArray) {
        this.sessionPoolMBeans = jMSSessionPoolMBeanArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverSessionPoolAdd(BEServerSessionPool bEServerSessionPool) throws JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.checkShutdown("create server session pool");
            if (this.serverSessionPoolsById.put(bEServerSessionPool.getId(), bEServerSessionPool) == null && this.serverSessionPoolsByName.put(bEServerSessionPool.getName(), bEServerSessionPool) == null) {
                if (++this.serverSessionPoolsCurrentCount > this.serverSessionPoolsHighCount) {
                    this.serverSessionPoolsHighCount = this.serverSessionPoolsCurrentCount;
                }
                ++this.serverSessionPoolsTotalCount;
            }
        }
    }

    private int serverSessionGet(Request request) throws JMSException {
        this.checkShutdownOrSuspendedNeedLock("get server session");
        BEServerSessionGetRequest bEServerSessionGetRequest = (BEServerSessionGetRequest)request;
        BEServerSessionPool bEServerSessionPool = this.serverSessionPoolFind(bEServerSessionGetRequest.getServerSessionPoolId());
        if (bEServerSessionPool != null) {
            bEServerSessionGetRequest.setResult(new BEServerSessionGetResponse((BEServerSession)bEServerSessionPool.getServerSession(bEServerSessionPool.getBackEndId().getDispatcherId())));
            bEServerSessionGetRequest.setState(Integer.MAX_VALUE);
            return bEServerSessionGetRequest.getState();
        }
        throw new JMSException("Server session pool not found");
    }

    private int serverSessionPoolCreate(Request request) throws JMSException {
        BEServerSessionPool bEServerSessionPool;
        this.checkShutdownOrSuspendedNeedLock("create server session pool");
        BEServerSessionPoolCreateRequest bEServerSessionPoolCreateRequest = (BEServerSessionPoolCreateRequest)request;
        final JMSID jMSID = JMSService.getJMSService().getNextId();
        final BackEnd backEnd = this;
        final JMSConnectionFactory jMSConnectionFactory = bEServerSessionPoolCreateRequest.getConnectionFactory();
        final int n = bEServerSessionPoolCreateRequest.getSessionsMaximum();
        final int n2 = bEServerSessionPoolCreateRequest.getAcknowledgeMode();
        final boolean bl = bEServerSessionPoolCreateRequest.isTransacted();
        final String string = bEServerSessionPoolCreateRequest.getMessageListenerClass();
        final Serializable serializable = bEServerSessionPoolCreateRequest.getClientData();
        final String string2 = "ServerSessionPool" + jMSID.getCounter();
        try {
            try {
                bEServerSessionPool = (BEServerSessionPool)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ManagementException, JMSException {
                        return new BEServerSessionPool(string2, jMSID, backEnd, (ConnectionFactory)jMSConnectionFactory, n, n2, bl, string, serializable);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            this.serverSessionPoolAdd(bEServerSessionPool);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException("Error create server session pool", (Throwable)exception);
        }
        bEServerSessionPoolCreateRequest.setResult(new JMSServerSessionPoolCreateResponse((ServerSessionPool)bEServerSessionPool.getRemoteWrapper()));
        bEServerSessionPoolCreateRequest.setState(Integer.MAX_VALUE);
        return bEServerSessionPoolCreateRequest.getState();
    }

    private int serverSessionPoolRemove(Request request) throws JMSException {
        this.checkShutdownOrSuspendedNeedLock("remove server session pool");
        BEServerSessionPoolCloseRequest bEServerSessionPoolCloseRequest = (BEServerSessionPoolCloseRequest)request;
        BEServerSessionPool bEServerSessionPool = this.serverSessionPoolFind(bEServerSessionPoolCloseRequest.getServerSessionPoolId());
        if (bEServerSessionPool != null) {
            this.serverSessionPoolRemove(bEServerSessionPool);
            bEServerSessionPool.close();
            bEServerSessionPoolCloseRequest.setResult(new VoidResponse());
            bEServerSessionPoolCloseRequest.setState(Integer.MAX_VALUE);
            return bEServerSessionPoolCloseRequest.getState();
        }
        throw new JMSException("Error removing server session pool: instance not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverSessionPoolRemove(BEServerSessionPool bEServerSessionPool) {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.serverSessionPoolsByName.remove(bEServerSessionPool.getName()) != null || this.serverSessionPoolsById.remove(bEServerSessionPool.getId()) != null) {
                --this.serverSessionPoolsCurrentCount;
            }
        }
        bEServerSessionPool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BEServerSessionPool serverSessionPoolFind(JMSID jMSID) {
        Object object = this.shutdownLock;
        synchronized (object) {
            return (BEServerSessionPool)this.serverSessionPoolsById.get(jMSID);
        }
    }

    synchronized Queue findKernelQueue(String string) {
        return this.kernel.findQueue(string);
    }

    Queue createKernelQueue(String string, Map map) throws JMSException {
        try {
            return this.kernel.createQueue(string, map);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException("Can't create kernel queue", (Throwable)kernelException);
        }
    }

    synchronized Topic findKernelTopic(String string) {
        return this.kernel.findTopic(string);
    }

    Topic createKernelTopic(String string, Map map) throws JMSException {
        try {
            return this.kernel.createTopic(string, map);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException("Can't create kernel topic", (Throwable)kernelException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BEDestinationImpl createTemporaryDestination(DispatcherId dispatcherId, String string, JMSID jMSID, boolean bl, long l, String string2) throws JMSException {
        BEDestinationImpl bEDestinationImpl = null;
        if (this.temporaryModule == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logTemporaryTemplateNotConfiguredLoggable((String)this.name));
        }
        TemporaryModule temporaryModule = this.temporaryModule;
        synchronized (temporaryModule) {
            block13: {
                EntityName entityName = this.temporaryModule.prepareCreateTemporaryDestination(string.equalsIgnoreCase("Queue"), this.temporaryCounter++);
                boolean bl2 = false;
                try {
                    bEDestinationImpl = this.findDestination(entityName.toString());
                    if (bEDestinationImpl == null) {
                        throw new weblogic.jms.common.JMSException("ERROR: Creation of temporary destination failed to find the newly added destination");
                    }
                    bEDestinationImpl.setConnectionId(jMSID);
                    this.checkShutdownOrSuspendedNeedLock("create temporary destination");
                    Object object = this.shutdownLock;
                    synchronized (object) {
                        this.checkShutdownOrSuspended("create temporary destination");
                        BEConnection bEConnection = null;
                        JMSDispatcher jMSDispatcher = null;
                        try {
                            jMSDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(dispatcherId);
                        }
                        catch (DispatcherException dispatcherException) {
                            throw new weblogic.jms.common.JMSException("Error finding FE dispatcher: " + dispatcherId, (Throwable)dispatcherException);
                        }
                        bEConnection = BEManager.connectionFindOrCreate(jMSID, jMSDispatcher, bl, l, string2);
                        bEConnection.tempDestinationAdd(bEDestinationImpl);
                    }
                    bl2 = true;
                    Object var18_15 = null;
                    if (bl2) break block13;
                }
                catch (Throwable throwable) {
                    Object var18_16 = null;
                    if (bl2) throw throwable;
                    try {
                        this.temporaryModule.rollbackCreateTemporaryDestination();
                        throw throwable;
                    }
                    catch (weblogic.jms.common.JMSException jMSException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (weblogic.jms.common.JMSException jMSException) {}
                this.temporaryModule.rollbackCreateTemporaryDestination();
            }
            this.temporaryModule.activateCreateTemporaryDestination();
            return bEDestinationImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDestination(BEDestinationImpl bEDestinationImpl) throws JMSException {
        this.checkShutdown();
        Object object = this.shutdownLock;
        synchronized (object) {
            String string = bEDestinationImpl.getName();
            String string2 = bEDestinationImpl.getJMSCreateDestinationIdentifier();
            if (string2 == null) {
                string2 = string;
            }
            if (this.createId2Destination.containsKey(string2)) {
                BEDestinationImpl bEDestinationImpl2 = (BEDestinationImpl)this.createId2Destination.get(string2);
                String string3 = bEDestinationImpl2.getName();
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCreateDestinationIdentifierNameConflictLoggable((String)this.name, (String)string2, (String)string3, (String)string));
            }
            this.createId2Destination.put(string2, bEDestinationImpl);
            if (this.name2Destination.containsKey(string)) {
                this.createId2Destination.remove(string2);
                throw new JMSException(JMSExceptionLogger.logNameConflictLoggable((String)this.name, (String)string).getMessage());
            }
            this.name2Destination.put(bEDestinationImpl.getName(), bEDestinationImpl);
            try {
                InvocableManagerDelegate.delegate.invocableAdd(20, bEDestinationImpl);
                if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                    JMSDebug.JMSDistTopic.debug("Added destination " + bEDestinationImpl.getName() + bEDestinationImpl.getJMSID());
                }
            }
            catch (JMSException jMSException) {
                this.name2Destination.remove(bEDestinationImpl.getName());
                this.createId2Destination.remove(string2);
                throw jMSException;
            }
            ++this.destinationsTotalCount;
            this.destinationsHighCount = Math.max(this.destinationsHighCount, (long)this.name2Destination.size());
            if (JMSDebug.JMSBoot.isDebugEnabled()) {
                JMSDebug.JMSBoot.debug("Configured destination " + bEDestinationImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(BEDestinationImpl bEDestinationImpl) {
        String string = bEDestinationImpl.getJMSCreateDestinationIdentifier();
        if (string == null) {
            string = bEDestinationImpl.getName();
        }
        bEDestinationImpl.markShuttingDown();
        bEDestinationImpl.shutdown();
        Object object = this.shutdownLock;
        synchronized (object) {
            this.createId2Destination.remove(string);
            this.name2Destination.remove(bEDestinationImpl.getName());
            InvocableManagerDelegate.delegate.invocableRemove(20, bEDestinationImpl.getJMSID());
        }
    }

    private int findDestination(Request request) throws JMSException {
        this.checkShutdownOrSuspendedNeedLock("find destination");
        BEDestinationCreateRequest bEDestinationCreateRequest = (BEDestinationCreateRequest)request;
        BEDestinationImpl bEDestinationImpl = !bEDestinationCreateRequest.isForCreateDestination() ? this.findDestination(bEDestinationCreateRequest.getDestinationName()) : this.findDestinationByCreateName(bEDestinationCreateRequest.getDestinationName());
        if (bEDestinationImpl == null) {
            throw new weblogic.jms.common.JMSException("Destination " + bEDestinationCreateRequest.getDestinationName() + " not found");
        }
        if (bEDestinationCreateRequest.getDestType() == 1 && bEDestinationImpl.getDestinationImpl().isTopic()) {
            throw new weblogic.jms.common.JMSException("No destination " + bEDestinationCreateRequest.getDestinationName() + " of type queue");
        }
        if (bEDestinationCreateRequest.getDestType() == 2 && bEDestinationImpl.getDestinationImpl().isQueue()) {
            throw new weblogic.jms.common.JMSException("No destination " + bEDestinationCreateRequest.getDestinationName() + " of type topic");
        }
        if (!bEDestinationImpl.isStarted()) {
            throw new weblogic.jms.common.JMSException("Destination " + bEDestinationCreateRequest.getDestinationName() + " not found");
        }
        bEDestinationCreateRequest.setResult(new JMSDestinationCreateResponse(bEDestinationImpl.getDestinationImpl()));
        bEDestinationCreateRequest.setState(Integer.MAX_VALUE);
        return bEDestinationCreateRequest.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BEDestinationImpl findDestination(String string) {
        Object object = this.shutdownLock;
        synchronized (object) {
            return (BEDestinationImpl)this.name2Destination.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BEDestinationImpl findDestinationByCreateName(String string) {
        Object object = this.shutdownLock;
        synchronized (object) {
            return (BEDestinationImpl)this.createId2Destination.get(string);
        }
    }

    public final long getBytesMaximum() {
        long l = this.backEndQuota.getBytesMaximum();
        return l == Long.MAX_VALUE ? -1L : l;
    }

    public void setBytesMaximum(long l) {
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        this.backEndQuota.setBytesMaximum(l);
    }

    public long getBytesThresholdHigh() {
        return this.thresholdHandler.getBytesThresholdHigh();
    }

    public void setBytesThresholdHigh(long l) {
        this.thresholdHandler.setBytesThresholdHigh(l);
    }

    public long getBytesThresholdLow() {
        return this.thresholdHandler.getBytesThresholdLow();
    }

    public void setBytesThresholdLow(long l) {
        this.thresholdHandler.setBytesThresholdLow(l);
    }

    public final long getMessagesMaximum() {
        int n = this.backEndQuota.getMessagesMaximum();
        return n == Integer.MAX_VALUE ? -1L : (long)n;
    }

    public void setMessagesMaximum(long l) {
        if (l < 0L || l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        this.backEndQuota.setMessagesMaximum((int)l);
    }

    public long getMessagesThresholdHigh() {
        return this.thresholdHandler.getMessagesThresholdHigh();
    }

    public void setMessagesThresholdHigh(long l) {
        this.thresholdHandler.setMessagesThresholdHigh(l);
    }

    public long getMessagesThresholdLow() {
        return this.thresholdHandler.getMessagesThresholdLow();
    }

    public void setMessagesThresholdLow(long l) {
        this.thresholdHandler.setMessagesThresholdLow(l);
    }

    public void setMaximumMessageSize(int n) {
        try {
            this.kernel.setProperty("MaximumMessageSize", (Object)new Integer(n));
        }
        catch (KernelException kernelException) {
            throw new IllegalArgumentException(kernelException.toString());
        }
    }

    public void setMessageBufferSize(long l) {
        try {
            this.kernel.setProperty("MessageBufferSize", (Object)new Long(l));
        }
        catch (KernelException kernelException) {
            throw new IllegalArgumentException(kernelException.toString());
        }
    }

    public void setExpirationScanInterval(int n) {
    }

    public void setProductionPausedAtStartup(String string) {
        this.productionPausedAtStartup = string;
    }

    public String getProductionPausedAtStartup() {
        return this.productionPausedAtStartup;
    }

    public void setInsertionPausedAtStartup(String string) {
        this.insertionPausedAtStartup = string;
    }

    public String getInsertionPausedAtStartup() {
        return this.insertionPausedAtStartup;
    }

    public void setConsumptionPausedAtStartup(String string) {
        this.consumptionPausedAtStartup = string;
    }

    public String getConsumptionPausedAtStartup() {
        return this.consumptionPausedAtStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAddJMSSessionPools(JMSSessionPoolMBean jMSSessionPoolMBean) throws BeanUpdateRejectedException {
        BEServerSessionPool bEServerSessionPool;
        String string = jMSSessionPoolMBean.getName();
        JMSID jMSID = JMSService.getJMSService().getNextId();
        try {
            bEServerSessionPool = new BEServerSessionPool(string, jMSID, this, jMSSessionPoolMBean);
        }
        catch (ManagementException managementException) {
            throw new BeanUpdateRejectedException("Could not create a session pool", (Throwable)managementException);
        }
        catch (JMSException jMSException) {
            throw new BeanUpdateRejectedException("Could not create a session pool", (Throwable)jMSException);
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.serverSessionPoolsByName.get(string) != null) {
                bEServerSessionPool.cleanup();
                if (JMSDebug.JMSConfig.isDebugEnabled()) {
                    JMSDebug.JMSConfig.debug("Error adding server session pool: instance already exists");
                }
                throw new BeanUpdateRejectedException("Error adding server session pool: instance already exists");
            }
            try {
                this.serverSessionPoolAdd(bEServerSessionPool);
                if ((this.state & 4) != 0) {
                    bEServerSessionPool.start();
                }
            }
            catch (JMSException jMSException) {
                throw new BeanUpdateRejectedException("Could not add or start a session pool", (Throwable)jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishAddJMSSessionPools(JMSSessionPoolMBean jMSSessionPoolMBean, boolean bl) {
        if (bl) {
            return;
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            BEServerSessionPool bEServerSessionPool = (BEServerSessionPool)this.serverSessionPoolsByName.get(jMSSessionPoolMBean.getName());
            if (bEServerSessionPool == null) {
                return;
            }
            this.serverSessionPoolRemove(bEServerSessionPool);
        }
    }

    public void startRemoveJMSSessionPools(JMSSessionPoolMBean jMSSessionPoolMBean) throws BeanUpdateRejectedException {
        BEServerSessionPool bEServerSessionPool = null;
        Object object = this.shutdownLock;
        synchronized (object) {
            bEServerSessionPool = (BEServerSessionPool)this.serverSessionPoolsByName.get(jMSSessionPoolMBean.getName());
            if (bEServerSessionPool != null) {
                return;
            }
            if (JMSDebug.JMSConfig.isDebugEnabled()) {
                JMSDebug.JMSConfig.debug("Error removing SessionPool: instance doesn't exist");
            }
            throw new BeanUpdateRejectedException("Error removing SessionPool: instance doesn't exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRemoveJMSSessionPools(JMSSessionPoolMBean jMSSessionPoolMBean, boolean bl) {
        if (!bl) {
            return;
        }
        BEServerSessionPool bEServerSessionPool = null;
        Object object = this.shutdownLock;
        synchronized (object) {
            bEServerSessionPool = (BEServerSessionPool)this.serverSessionPoolsByName.get(jMSSessionPoolMBean.getName());
            if (bEServerSessionPool == null) {
                return;
            }
            this.serverSessionPoolRemove(bEServerSessionPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSSessionPoolRuntimeMBean[] getSessionPoolRuntimes() {
        Object object = this.shutdownLock;
        synchronized (object) {
            JMSSessionPoolRuntimeMBean[] jMSSessionPoolRuntimeMBeanArray = new JMSSessionPoolRuntimeMBean[this.serverSessionPoolsByName.size()];
            Iterator iterator = this.serverSessionPoolsByName.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                jMSSessionPoolRuntimeMBeanArray[n] = (JMSSessionPoolRuntimeMBean)iterator.next();
                ++n;
            }
            return jMSSessionPoolRuntimeMBeanArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BEServerSessionPool[] getSessionPools() {
        Object object = this.shutdownLock;
        synchronized (object) {
            BEServerSessionPool[] bEServerSessionPoolArray = new BEServerSessionPool[this.serverSessionPoolsByName.size()];
            Iterator iterator = this.serverSessionPoolsByName.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                bEServerSessionPoolArray[n] = (BEServerSessionPool)iterator.next();
                ++n;
            }
            return bEServerSessionPoolArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSessionPoolsCurrentCount() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.serverSessionPoolsCurrentCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getSessionPoolsHighCount() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.serverSessionPoolsHighCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getSessionPoolsTotalCount() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.serverSessionPoolsTotalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSDestinationRuntimeMBean[] getDestinations() {
        Object object = this.shutdownLock;
        synchronized (object) {
            JMSDestinationRuntimeMBean[] jMSDestinationRuntimeMBeanArray = new JMSDestinationRuntimeMBean[this.name2Destination.size()];
            Iterator iterator = this.name2Destination.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                BEDestinationImpl bEDestinationImpl = (BEDestinationImpl)iterator.next();
                jMSDestinationRuntimeMBeanArray[n++] = bEDestinationImpl.getRuntimeMBean();
            }
            return jMSDestinationRuntimeMBeanArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BEDestinationImpl[] getBEDestinations() {
        Object object = this.shutdownLock;
        synchronized (object) {
            BEDestinationImpl[] bEDestinationImplArray = new BEDestinationImpl[this.name2Destination.size()];
            Iterator iterator = this.name2Destination.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                bEDestinationImplArray[n++] = (BEDestinationImpl)iterator.next();
            }
            return bEDestinationImplArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDestinationsCurrentCount() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.name2Destination.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDestinationsHighCount() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.destinationsHighCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDestinationsTotalCount() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.destinationsTotalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeTempDestination(Request request) throws JMSException {
        BETemporaryDestinationDestroyRequest bETemporaryDestinationDestroyRequest = (BETemporaryDestinationDestroyRequest)request;
        try {
            this.checkShutdownOrSuspendedNeedLock("remove temporary destination");
        }
        catch (JMSException jMSException) {
            bETemporaryDestinationDestroyRequest.setResult(new VoidResponse());
            bETemporaryDestinationDestroyRequest.setState(Integer.MAX_VALUE);
            return bETemporaryDestinationDestroyRequest.getState();
        }
        BEDestinationImpl bEDestinationImpl = (BEDestinationImpl)InvocableManagerDelegate.delegate.invocableFind(20, bETemporaryDestinationDestroyRequest.getDestinationId());
        bEDestinationImpl.deleteTempDestination();
        BEConnection bEConnection = (BEConnection)InvocableManagerDelegate.delegate.invocableFind(15, bEDestinationImpl.getConnectionId());
        bEConnection.tempDestinationRemove(bEDestinationImpl.getJMSID());
        TemporaryModule temporaryModule = this.temporaryModule;
        synchronized (temporaryModule) {
            this.temporaryModule.removeTemporaryDestination(bEDestinationImpl.getName());
        }
        bETemporaryDestinationDestroyRequest.setResult(new VoidResponse());
        bETemporaryDestinationDestroyRequest.setState(Integer.MAX_VALUE);
        return bETemporaryDestinationDestroyRequest.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDurableSubscription(String string, DurableSubscription durableSubscription) {
        HashMap hashMap = this.durableSubscribers;
        synchronized (hashMap) {
            this.durableSubscribers.put(string, durableSubscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDurableSubscription(String string) {
        HashMap hashMap = this.durableSubscribers;
        synchronized (hashMap) {
            this.durableSubscribers.remove(string);
        }
    }

    Map getDurableSubscriptionsMap() {
        return this.durableSubscribers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DurableSubscription getDurableSubscription(String string) {
        HashMap hashMap = this.durableSubscribers;
        synchronized (hashMap) {
            return (DurableSubscription)this.durableSubscribers.get(string);
        }
    }

    public void logMessagesThresholdHigh() {
        JMSLogger.logMessagesThresholdHighServer((String)this.name);
    }

    public void logMessagesThresholdLow() {
        JMSLogger.logMessagesThresholdLowServer((String)this.name);
    }

    public void logBytesThresholdHigh() {
        JMSLogger.logBytesThresholdHighServer((String)this.name);
    }

    public void logBytesThresholdLow() {
        JMSLogger.logBytesThresholdLowServer((String)this.name);
    }

    public long getMessagesCurrentCount() {
        return this.kernel.getStatistics().getMessagesCurrent() - this.kernel.getStatistics().getMessagesPending();
    }

    public long getMessagesHighCount() {
        return this.kernel.getStatistics().getMessagesHigh();
    }

    public long getMessagesPendingCount() {
        return this.kernel.getStatistics().getMessagesPending();
    }

    public long getMessagesReceivedCount() {
        return this.kernel.getStatistics().getMessagesReceived();
    }

    public long getBytesCurrentCount() {
        return this.kernel.getStatistics().getBytesCurrent() - this.kernel.getStatistics().getBytesPending();
    }

    public long getBytesHighCount() {
        return this.kernel.getStatistics().getBytesHigh();
    }

    public long getBytesPendingCount() {
        return this.kernel.getStatistics().getBytesPending();
    }

    public long getBytesReceivedCount() {
        return this.kernel.getStatistics().getBytesReceived();
    }

    public long getMessagesThresholdTime() {
        return this.thresholdHandler.getMessagesThresholdTime();
    }

    public long getBytesThresholdTime() {
        return this.thresholdHandler.getBytesThresholdTime();
    }

    public int getMessagesPageableCurrentCount() {
        return this.kernel.getStatistics().getUnpagedMessages();
    }

    public long getBytesPageableCurrentCount() {
        return this.kernel.getStatistics().getUnpagedBytes();
    }

    public int getMessagesPagedOutTotalCount() {
        return this.kernel.getStatistics().getMessagesPagedOut();
    }

    public int getMessagesPagedInTotalCount() {
        return this.kernel.getStatistics().getMessagesPagedIn();
    }

    public long getBytesPagedOutTotalCount() {
        return this.kernel.getStatistics().getBytesPagedOut();
    }

    public long getBytesPagedInTotalCount() {
        return this.kernel.getStatistics().getBytesPagedIn();
    }

    public long getPagingAllocatedWindowBufferBytes() {
        return this.kernel.getStatistics().getPagingAllocatedWindowBufferBytes();
    }

    public long getPagingAllocatedIoBufferBytes() {
        return this.kernel.getStatistics().getPagingAllocatedIoBufferBytes();
    }

    public long getPagingPhysicalWriteCount() {
        return this.kernel.getStatistics().getPagingPhysicalWriteCount();
    }

    public String getName() {
        return this.name;
    }

    public String getConfigType() {
        return this.configType;
    }

    public String toString() {
        return "(" + System.identityHashCode(this) + ", name=" + this.name + ")";
    }

    public JMSID getJMSID() {
        return this.backEndId.getId();
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 11534: {
                return this.findDestination(request);
            }
            case 15118: {
                return this.removeTempDestination(request);
            }
            case 12558: {
                return this.serverSessionPoolRemove(request);
            }
            case 12814: {
                return this.serverSessionPoolCreate(request);
            }
            case 12302: {
                return this.serverSessionGet(request);
            }
        }
        throw new weblogic.jms.common.JMSException("No such method " + request.getMethodId());
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.bound) {
            try {
                PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(), "weblogic.jms.backend." + this.name, KERNEL_ID);
                this.bound = false;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Object getDestinationDeletionLock() {
        return this.destinationDeletionLock;
    }

    boolean needsFlowControl() {
        return this.isMemoryLow || this.thresholdHandler.isArmed();
    }

    public void memoryChanged(MemoryEvent memoryEvent) {
        if (memoryEvent.getEventType() == 1) {
            JMSLogger.logFlowControlEnabledDueToLowMemory((String)this.name);
            this.isMemoryLow = true;
            this.suspendMessageLogging();
        } else if (memoryEvent.getEventType() == 0) {
            this.isMemoryLow = false;
            this.resumeMessageLogging();
        }
    }

    public void pauseProduction() throws JMSException {
        this.pauseProduction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseProduction(boolean bl) throws JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (!this.isProductionPaused()) {
                this.pausedState |= 0x100;
                this.pauseDestinations(PRODUCTION, bl);
                this.pausedState &= 0xFFFFFEFF;
                this.pausedState |= 0x200;
            }
        }
        if (bl) {
            JMSLogger.logProductionPauseOfJMSServer((String)this.name);
        }
    }

    public void resumeProduction() throws JMSException {
        this.resumeProduction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeProduction(boolean bl) throws JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.pausedState |= 0x400;
            this.resumeDestinations(PRODUCTION, bl);
            this.pausedState &= 0xFFFFFBFF;
            this.pausedState &= 0xFFFFFDFF;
        }
        if (bl) {
            JMSLogger.logProductionResumeOfJMSServer((String)this.name);
        }
    }

    public boolean isProductionPaused() {
        return (this.pausedState & 0x300) != 0;
    }

    public String getProductionPausedState() {
        if ((this.pausedState & 0x100) != 0) {
            return "Production-Pausing";
        }
        if ((this.pausedState & 0x200) != 0) {
            return "Production-Paused";
        }
        return "Production-Enabled";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseInsertion() throws JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.pausedState |= 0x800;
            this.pauseDestinations(INSERTION, true);
            this.pausedState &= 0xFFFFF7FF;
            this.pausedState |= 0x1000;
        }
        JMSLogger.logInsertionPauseOfJMSServer((String)this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeInsertion() throws JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.pausedState |= 0x2000;
            this.resumeDestinations(INSERTION, true);
            this.pausedState &= 0xFFFFDFFF;
            this.pausedState &= 0xFFFFEFFF;
        }
        JMSLogger.logInsertionResumeOfJMSServer((String)this.name);
    }

    public boolean isInsertionPaused() {
        return (this.pausedState & 0x1800) != 0;
    }

    public String getInsertionPausedState() {
        if ((this.pausedState & 0x800) != 0) {
            return "Insertion-Pausing";
        }
        if ((this.pausedState & 0x1000) != 0) {
            return "Insertion-Paused";
        }
        return "Insertion-Enabled";
    }

    public void pauseConsumption() throws JMSException {
        this.pauseConsumption(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseConsumption(boolean bl) throws JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.pausedState |= 0x4000;
            this.pauseDestinations(CONSUMPTION, bl);
            this.pausedState &= 0xFFFFBFFF;
            this.pausedState |= 0x8000;
        }
        if (bl) {
            JMSLogger.logConsumptionPauseOfJMSServer((String)this.name);
        }
    }

    public void resumeConsumption() throws JMSException {
        this.resumeConsumption(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeConsumption(boolean bl) throws JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.pausedState |= 0x10000;
            this.resumeDestinations(CONSUMPTION, bl);
            this.pausedState &= 0xFFFEFFFF;
            this.pausedState &= 0xFFFF7FFF;
        }
        if (bl) {
            JMSLogger.logConsumptionResumeOfJMSServer((String)this.name);
        }
    }

    public boolean isConsumptionPaused() {
        return (this.pausedState & 0xC000) != 0;
    }

    public String getConsumptionPausedState() {
        if ((this.pausedState & 0x4000) != 0) {
            return "Consumption-Pausing";
        }
        if ((this.pausedState & 0x8000) != 0) {
            return "Consumption-Paused";
        }
        return "Consumption-Enabled";
    }

    private void pauseDestinations(String string, boolean bl) throws JMSException {
        this.checkShutdownOrSuspendedNeedLock("pausing " + string + " on all the destinations hosted by this JMSServer");
        BEDestinationImpl[] bEDestinationImplArray = this.getBEDestinations();
        for (int i = 0; i < bEDestinationImplArray.length; ++i) {
            BEDestinationImpl bEDestinationImpl = bEDestinationImplArray[i];
            if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                JMSDebug.JMSPauseResume.debug("Performing " + string + " pause operation on " + bEDestinationImpl.getName());
            }
            if (string.equals(PRODUCTION)) {
                bEDestinationImpl.pauseProduction(bl);
                continue;
            }
            if (string.equals(INSERTION)) {
                bEDestinationImpl.pauseInsertion();
                continue;
            }
            if (!string.equals(CONSUMPTION)) continue;
            bEDestinationImpl.pauseConsumption(bl);
        }
    }

    private void resumeDestinations(String string, boolean bl) throws JMSException {
        this.checkShutdownOrSuspendedNeedLock("resuming " + string + " on all the destinations hosted by this JMSServer");
        BEDestinationImpl[] bEDestinationImplArray = this.getBEDestinations();
        for (int i = 0; i < bEDestinationImplArray.length; ++i) {
            BEDestinationImpl bEDestinationImpl = bEDestinationImplArray[i];
            if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                JMSDebug.JMSPauseResume.debug("Performing " + string + " resume operation on " + bEDestinationImpl.getName());
            }
            if (string.equals(PRODUCTION)) {
                bEDestinationImpl.resumeProduction(bl);
                continue;
            }
            if (string.equals(INSERTION)) {
                bEDestinationImpl.resumeInsertion();
                continue;
            }
            if (!string.equals(CONSUMPTION)) continue;
            bEDestinationImpl.resumeConsumption(bl);
        }
    }

    public Quota getQuota() {
        return this.backEndQuota;
    }

    public void postDeploymentsStart() {
        if ((this.state & 4) == 0) {
            return;
        }
        try {
            this.createServerSessionPools();
        }
        catch (JMSException jMSException) {
            System.out.println("ERROR: Could not create server session pools: " + (Object)((Object)jMSException));
        }
        try {
            if (this.durableSubscriptionStore != null) {
                this.durableSubscriptionStore.deleteOrphanedSubscriptions();
            }
        }
        catch (JMSException jMSException) {
            JMSDebug.JMSBoot.debug("Error deleting orphaned topic subscriptions", (Throwable)jMSException);
        }
        Collection collection = this.kernel.getDestinations();
        for (Destination destination : collection) {
            if (!destination.isSuspended(16384) || destination.isCreated()) continue;
            if (JMSDebug.JMSBoot.isDebugEnabled()) {
                JMSDebug.JMSBoot.debug("Deleting orphaned kernel destination " + destination.getName());
            }
            try {
                KernelRequest kernelRequest = new KernelRequest();
                destination.delete(kernelRequest);
            }
            catch (KernelException kernelException) {
                JMSDebug.JMSBoot.debug("Error deleting kernel destination", (Throwable)kernelException);
            }
        }
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug(this.name + "is started");
        }
        JMSLogger.logJMSServerDeployed((String)this.name);
    }

    public void postDeploymentsStop() {
        if ((this.state & 0x10) == 0) {
            return;
        }
        this.destroyServerSessionPools();
    }

    private GXAResourceImpl getGXAResource() {
        PersistentStoreXA persistentStoreXA = (PersistentStoreXA)this.kernel.getProperty("Store");
        if (persistentStoreXA == null) {
            return null;
        }
        GXAResourceImpl gXAResourceImpl = null;
        try {
            gXAResourceImpl = (GXAResourceImpl)persistentStoreXA.getGXAResource();
        }
        catch (PersistentStoreException persistentStoreException) {
            return null;
        }
        return gXAResourceImpl;
    }

    private String[] convertXidsToStrings(Xid[] xidArray) {
        if (xidArray == null) {
            return null;
        }
        String[] stringArray = new String[xidArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = xidArray[i].toString();
        }
        return stringArray;
    }

    public String[] getTransactions() {
        GXAResourceImpl gXAResourceImpl = this.getGXAResource();
        if (gXAResourceImpl == null) {
            return null;
        }
        return this.convertXidsToStrings(gXAResourceImpl.getXIDs(-1));
    }

    public String[] getPendingTransactions() {
        GXAResourceImpl gXAResourceImpl = this.getGXAResource();
        if (gXAResourceImpl == null) {
            return null;
        }
        return this.convertXidsToStrings(gXAResourceImpl.getXIDs(3));
    }

    public Integer getTransactionStatus(String string) {
        GXAResourceImpl gXAResourceImpl = this.getGXAResource();
        if (gXAResourceImpl == null) {
            return new Integer(6);
        }
        XidImpl xidImpl = XidImpl.create((String)string);
        int n = gXAResourceImpl.getStatus((Xid)xidImpl);
        switch (n) {
            case 0: 
            case 1: {
                return new Integer(0);
            }
            case 2: {
                return new Integer(7);
            }
            case 3: {
                return new Integer(2);
            }
            case 6: {
                return new Integer(3);
            }
            case 4: {
                return new Integer(4);
            }
            case 5: {
                return new Integer(1);
            }
        }
        return new Integer(5);
    }

    public String getMessages(String string, Integer n) throws ManagementException {
        XidImpl xidImpl = XidImpl.create((String)string);
        Cursor cursor = null;
        try {
            cursor = this.kernel.createCursor((Xid)xidImpl);
        }
        catch (KernelException kernelException) {
            throw new ManagementException("Error creating message cursor for Xid " + string + " on server " + this.getName(), (Throwable)kernelException);
        }
        JMSMessageCursorDelegate jMSMessageCursorDelegate = new JMSMessageCursorDelegate(this, new JMSMessageOpenDataConverter(false), cursor, new JMSMessageOpenDataConverter(true), n);
        this.addCursorDelegate(jMSMessageCursorDelegate);
        return jMSMessageCursorDelegate.getHandle();
    }

    public Void forceCommit(String string) throws ManagementException {
        GXAResourceImpl gXAResourceImpl = this.getGXAResource();
        if (gXAResourceImpl == null) {
            throw new ManagementException("Resource not available for performing forceCommit operation.");
        }
        XidImpl xidImpl = XidImpl.create((String)string);
        try {
            if (gXAResourceImpl.getStatus((Xid)xidImpl) == 3) {
                gXAResourceImpl.commit((Xid)xidImpl, false);
            } else {
                gXAResourceImpl.commit((Xid)xidImpl, true);
            }
            JMSLogger.logAdminForceCommit((String)this.name, (String)string);
            return null;
        }
        catch (XAException xAException) {
            JMSLogger.logAdminForceCommitError((String)this.name, (String)string, (Exception)xAException);
            throw new ManagementException("Error on forceCommit of JMS transaction branch " + string + ". ", (Throwable)xAException);
        }
    }

    public Void forceRollback(String string) throws ManagementException {
        GXAResourceImpl gXAResourceImpl = this.getGXAResource();
        if (gXAResourceImpl == null) {
            throw new ManagementException("Resource not available for performing forceRollback operation.");
        }
        XidImpl xidImpl = XidImpl.create((String)string);
        try {
            gXAResourceImpl.rollback((Xid)xidImpl);
            JMSLogger.logAdminForceRollback((String)this.name, (String)string);
            return null;
        }
        catch (XAException xAException) {
            JMSLogger.logAdminForceRollbackError((String)this.name, (String)string, (Exception)xAException);
            throw new ManagementException("Error on forceRollback of JMS transaction branch " + string + ". ", (Throwable)xAException);
        }
    }

    private final void suspendMessageLogging() {
        BEDestinationImpl[] bEDestinationImplArray = this.getBEDestinations();
        for (int i = 0; i < bEDestinationImplArray.length; ++i) {
            BEDestinationImpl bEDestinationImpl = bEDestinationImplArray[i];
            if (!bEDestinationImpl.isMessageLoggingEnabled()) continue;
            try {
                bEDestinationImpl.suspendMessageLogging();
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    private final void resumeMessageLogging() {
        BEDestinationImpl[] bEDestinationImplArray = this.getBEDestinations();
        for (int i = 0; i < bEDestinationImplArray.length; ++i) {
            BEDestinationImpl bEDestinationImpl = bEDestinationImplArray[i];
            if (!bEDestinationImpl.isMessageLoggingEnabled()) continue;
            try {
                bEDestinationImpl.resumeMessageLogging();
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public final boolean isMemoryLow() {
        return this.isMemoryLow;
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        BEServerSessionPool[] bEServerSessionPoolArray2;
        Object object2;
        String string;
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("JMSServer");
        xMLStreamWriter.writeAttribute("name", this.name != null ? this.name : "");
        xMLStreamWriter.writeAttribute("id", this.backEndId != null ? this.backEndId.toString() : "");
        if (this.backEndQuota == null || (string = this.backEndQuota.getName()) == null) {
            string = "";
        }
        xMLStreamWriter.writeAttribute("quotaName", string);
        xMLStreamWriter.writeAttribute("destinationsHighCount", String.valueOf(this.destinationsHighCount));
        xMLStreamWriter.writeAttribute("destinationsTotalCount", String.valueOf(this.destinationsTotalCount));
        xMLStreamWriter.writeAttribute("serverSessionPoolsCurrentCount", String.valueOf(this.serverSessionPoolsCurrentCount));
        xMLStreamWriter.writeAttribute("serverSessionPoolsHighCount", String.valueOf(this.serverSessionPoolsHighCount));
        xMLStreamWriter.writeAttribute("serverSessionPoolsTotalCount", String.valueOf(this.serverSessionPoolsTotalCount));
        xMLStreamWriter.writeStartElement("Health");
        HealthState healthState = this.getHealthState();
        JMSDiagnosticImageSource.dumpHealthStateElement(xMLStreamWriter, healthState);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("Destinations");
        HashMap hashMap = (HashMap)this.name2Destination.clone();
        xMLStreamWriter.writeAttribute("currentCount", String.valueOf(hashMap.size()));
        for (Object object2 : hashMap.values()) {
            ((BEDestinationImpl)object2).dump(jMSDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("DurableSubscribers");
        object2 = (HashMap)this.durableSubscribers.clone();
        xMLStreamWriter.writeAttribute("currentCount", String.valueOf(((HashMap)object2).size()));
        for (BEServerSessionPool[] bEServerSessionPoolArray2 : ((HashMap)object2).values()) {
            if (bEServerSessionPoolArray2.getConsumer() == null) continue;
            bEServerSessionPoolArray2.getConsumer().dumpRef(jMSDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("ServerSessionPools");
        bEServerSessionPoolArray2 = this.getSessionPools();
        if (bEServerSessionPoolArray2 == null || bEServerSessionPoolArray2.length == 0) {
            xMLStreamWriter.writeAttribute("currentCount", "0");
        } else {
            xMLStreamWriter.writeAttribute("currentCount", String.valueOf(bEServerSessionPoolArray2.length));
            for (int i = 0; i < bEServerSessionPoolArray2.length; ++i) {
                bEServerSessionPoolArray2[i].dump(jMSDiagnosticImageSource, xMLStreamWriter);
            }
        }
        xMLStreamWriter.writeEndElement();
        ((KernelImpl)this.kernel).dump((MessagingKernelDiagnosticImageSource)jMSDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }

    public void setHostingTemporaryDestinations(boolean bl) {
        this.isHostingTemporaryDestinations = bl;
    }

    public void setTemporaryTemplateResource(String string) {
        this.temporaryTemplateResource = string == null ? null : new ModuleName(string, null);
        if (this.temporaryModule != null) {
            this.temporaryModule.setAuxiliaryModuleName(this.temporaryTemplateResource);
        }
    }

    public void setTemporaryTemplateName(String string) {
        this.temporaryTemplateName = string;
    }

    public void activateFinished() throws BeanUpdateFailedException {
        if (this.isHostingTemporaryDestinations) {
            if (this.temporaryTemplateResource != null) {
                JMSBean jMSBean;
                DomainMBean domainMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain();
                JMSSystemResourceMBean jMSSystemResourceMBean = null;
                if (this.temporaryTemplateResource.toString().equals("interop-jms") && ((JMSInteropModuleMBean[])(jMSBean = domainMBean.getJMSInteropModules())).length > 0) {
                    jMSSystemResourceMBean = jMSBean[0];
                }
                if (jMSSystemResourceMBean == null) {
                    jMSSystemResourceMBean = domainMBean.lookupJMSSystemResource(this.temporaryTemplateResource.toString());
                }
                jMSBean = jMSSystemResourceMBean.getJMSResource();
                TemplateBean templateBean = jMSBean.lookupTemplate(this.temporaryTemplateName);
                if (this.temporaryModule != null) {
                    this.temporaryModule.setTemplate(templateBean);
                } else {
                    this.temporaryModule = new TemporaryModule(this.name, templateBean, this.temporaryTemplateResource);
                }
            } else if (this.temporaryModule != null) {
                this.temporaryModule.setTemplate(null);
            } else {
                this.temporaryModule = new TemporaryModule(this.name);
            }
            if ((this.state & 0x10) == 0 && this.tempDestinationFactory == null) {
                try {
                    this.tempDestinationFactory = new BackEndTempDestinationFactory(this);
                    JMSService.getJMSService().getBEDeployer().addTempDestinationFactory(this.tempDestinationFactory);
                }
                catch (NamingException namingException) {
                    throw new BeanUpdateFailedException(namingException.toString());
                }
            }
        } else {
            if (this.temporaryModule != null) {
                this.temporaryModule.setTemplate(null);
            }
            if (this.tempDestinationFactory != null) {
                try {
                    JMSService.getJMSService().getBEDeployer().removeTempDestinationFactory(this.tempDestinationFactory);
                    this.tempDestinationFactory = null;
                }
                catch (NamingException namingException) {
                    throw new BeanUpdateFailedException(namingException.toString());
                }
            }
        }
    }

    public String getFullSAFDestinationName(String string) {
        return string + "@" + this.name;
    }

    public void setThresholdHandler(ThresholdHandler thresholdHandler) {
        this.thresholdHandler = thresholdHandler;
    }

    public void setHealthFailed(Exception exception) {
        this.backEndHealthException = exception;
        HealthMonitorService.subsystemFailed(HEALTH_NAME_PREFIX + this.getName(), exception.toString());
    }

    private static class TemplateListener
    implements BeanUpdateListener {
        private String backEndName;
        private String tempDestinationName;
        private JMSBean temporaryModule;
        private TemplateBean listenToMe;
        private boolean isQueue;
        private boolean updateInProgress = false;

        private TemplateListener(String string, String string2, JMSBean jMSBean, TemplateBean templateBean, boolean bl) {
            this.backEndName = string;
            this.tempDestinationName = string2;
            this.temporaryModule = jMSBean;
            this.listenToMe = templateBean;
            this.isQueue = bl;
            DescriptorBean descriptorBean = (DescriptorBean)this.listenToMe;
            descriptorBean.addBeanUpdateListener((BeanUpdateListener)this);
            descriptorBean = (DescriptorBean)this.listenToMe.getThresholds();
            descriptorBean.addBeanUpdateListener((BeanUpdateListener)this);
            descriptorBean = (DescriptorBean)this.listenToMe.getDeliveryParamsOverrides();
            descriptorBean.addBeanUpdateListener((BeanUpdateListener)this);
            descriptorBean = (DescriptorBean)this.listenToMe.getDeliveryFailureParams();
            descriptorBean.addBeanUpdateListener((BeanUpdateListener)this);
            descriptorBean = (DescriptorBean)this.listenToMe.getMulticast();
            descriptorBean.addBeanUpdateListener((BeanUpdateListener)this);
            descriptorBean = (DescriptorBean)this.listenToMe.getMessageLoggingParams();
            descriptorBean.addBeanUpdateListener((BeanUpdateListener)this);
        }

        private JMSBean getWholeModuleClone(JMSBean jMSBean) {
            DescriptorBean descriptorBean = (DescriptorBean)jMSBean;
            return (JMSBean)((Descriptor)descriptorBean.getDescriptor().clone()).getRootBean();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
            if (this.updateInProgress) {
                return;
            }
            this.updateInProgress = true;
            JMSBean jMSBean = this.temporaryModule;
            synchronized (jMSBean) {
                QuotaBean quotaBean;
                String string;
                QuotaBean quotaBean2;
                String string2;
                QuotaBean quotaBean3;
                DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
                if (descriptorBean == null) {
                    throw new BeanUpdateRejectedException("ERROR: proposed bean was null in update of temporary template for " + this.backEndName);
                }
                if (!(descriptorBean instanceof TemplateBean)) {
                    descriptorBean = descriptorBean.getParentBean();
                }
                if (descriptorBean == null || !(descriptorBean instanceof TemplateBean)) {
                    throw new BeanUpdateRejectedException("ERROR: normalized proposed bean was null in update of temporary template for " + this.backEndName);
                }
                TemplateBean templateBean = (TemplateBean)descriptorBean;
                DescriptorBean descriptorBean2 = (DescriptorBean)this.temporaryModule;
                JMSBean jMSBean2 = this.getWholeModuleClone(this.temporaryModule);
                TemplateBean templateBean2 = jMSBean2.lookupTemplate(this.listenToMe.getName());
                jMSBean2.destroyTemplate(templateBean2);
                templateBean2 = jMSBean2.createTemplate(this.listenToMe.getName());
                QueueBean queueBean = this.isQueue ? jMSBean2.lookupQueue(this.tempDestinationName) : jMSBean2.lookupTopic(this.tempDestinationName);
                queueBean.setTemplate(templateBean2);
                if (templateBean.isSet("Quota")) {
                    quotaBean3 = this.listenToMe.getQuota();
                    string2 = quotaBean3 == null ? "" : quotaBean3.getName();
                    quotaBean2 = templateBean.getQuota();
                    String string3 = string = quotaBean2 == null ? "" : quotaBean2.getName();
                    if (!string2.equals(string)) {
                        quotaBean = jMSBean2.lookupQuota(string2);
                        if (quotaBean != null) {
                            jMSBean2.destroyQuota(quotaBean);
                        }
                        if (quotaBean2 != null) {
                            jMSBean2.createQuota(string);
                        }
                    }
                } else {
                    quotaBean3 = this.listenToMe.getQuota();
                    if (quotaBean3 != null && (string2 = jMSBean2.lookupQuota(quotaBean3.getName())) != null) {
                        jMSBean2.destroyQuota((QuotaBean)string2);
                    }
                }
                if (templateBean.getDeliveryFailureParams().isSet("ErrorDestination")) {
                    quotaBean3 = this.listenToMe.getDeliveryFailureParams().getErrorDestination();
                    string2 = quotaBean3 == null ? "" : quotaBean3.getName();
                    quotaBean2 = templateBean.getDeliveryFailureParams().getErrorDestination();
                    String string4 = string = quotaBean2 == null ? "" : quotaBean2.getName();
                    if (!string2.equals(string)) {
                        if (quotaBean3 != null && (quotaBean = JMSModuleHelper.findDestinationBean(string2, jMSBean2)) != null) {
                            JMSBeanHelper.destroyDestination(jMSBean2, (DestinationBean)quotaBean);
                        }
                        if (quotaBean2 != null) {
                            if (quotaBean2 instanceof QueueBean) {
                                jMSBean2.createQueue(string);
                            } else {
                                jMSBean2.createTopic(string);
                            }
                        }
                    }
                } else {
                    quotaBean3 = this.listenToMe.getDeliveryFailureParams().getErrorDestination();
                    if (quotaBean3 != null && (string2 = JMSModuleHelper.findDestinationBean(quotaBean3.getName(), jMSBean2)) != null) {
                        JMSBeanHelper.destroyDestination(jMSBean2, (DestinationBean)string2);
                    }
                }
                try {
                    JMSBeanHelper.copyTemplateBean(templateBean2, jMSBean2, templateBean);
                }
                catch (ManagementException managementException) {
                    throw new BeanUpdateRejectedException("ERROR: Could not copy the proposed template bean in update of temporary template for " + this.backEndName, (Throwable)managementException);
                }
                quotaBean3 = descriptorBean2.getDescriptor();
                string2 = ((DescriptorBean)jMSBean2).getDescriptor();
                try {
                    quotaBean3.prepareUpdate((Descriptor)string2);
                }
                catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
                    throw new BeanUpdateRejectedException("ERROR: Could not prepare the temporary destination module of " + this.backEndName, (Throwable)descriptorUpdateRejectedException);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
            if (!this.updateInProgress) {
                return;
            }
            this.updateInProgress = false;
            JMSBean jMSBean = this.temporaryModule;
            synchronized (jMSBean) {
                Descriptor descriptor = ((DescriptorBean)this.temporaryModule).getDescriptor();
                try {
                    descriptor.activateUpdate();
                }
                catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
                    throw new BeanUpdateFailedException(descriptorUpdateFailedException.getMessage(), (Throwable)descriptorUpdateFailedException);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
            if (!this.updateInProgress) {
                return;
            }
            this.updateInProgress = false;
            JMSBean jMSBean = this.temporaryModule;
            synchronized (jMSBean) {
                Descriptor descriptor = ((DescriptorBean)this.temporaryModule).getDescriptor();
                descriptor.rollbackUpdate();
                return;
            }
        }

        private void close() {
            DescriptorBean descriptorBean = (DescriptorBean)this.listenToMe;
            descriptorBean.removeBeanUpdateListener((BeanUpdateListener)this);
            descriptorBean = (DescriptorBean)this.listenToMe.getThresholds();
            descriptorBean.removeBeanUpdateListener((BeanUpdateListener)this);
            descriptorBean = (DescriptorBean)this.listenToMe.getDeliveryParamsOverrides();
            descriptorBean.removeBeanUpdateListener((BeanUpdateListener)this);
            descriptorBean = (DescriptorBean)this.listenToMe.getDeliveryFailureParams();
            descriptorBean.removeBeanUpdateListener((BeanUpdateListener)this);
            descriptorBean = (DescriptorBean)this.listenToMe.getMulticast();
            descriptorBean.removeBeanUpdateListener((BeanUpdateListener)this);
            descriptorBean = (DescriptorBean)this.listenToMe.getMessageLoggingParams();
            descriptorBean.removeBeanUpdateListener((BeanUpdateListener)this);
        }
    }

    private static class BeansAndSauce {
        private JMSBean bean;
        private JMSModuleManagedEntity sauce;
        private TemplateListener listener;
        private boolean isQueue;

        private BeansAndSauce(JMSBean jMSBean, JMSModuleManagedEntity jMSModuleManagedEntity, boolean bl) {
            this.bean = jMSBean;
            this.sauce = jMSModuleManagedEntity;
            this.isQueue = bl;
        }

        private JMSBean getBean() {
            return this.bean;
        }

        private JMSModuleManagedEntity getSauce() {
            return this.sauce;
        }

        private void setListener(TemplateListener templateListener) {
            this.listener = templateListener;
        }

        private TemplateListener getListener() {
            return this.listener;
        }

        private boolean isQueue() {
            return this.isQueue;
        }
    }

    private static class TemporaryModule {
        private static final DestinationEntityProvider DESTINATION_PROVIDER = new DestinationEntityProvider();
        private String backEndName;
        private TemplateBean template;
        private ModuleName auxiliaryModuleName;
        private HashMap entityMap = new HashMap();
        private String proposedTemporaryDestinationName;

        private TemporaryModule(String string, TemplateBean templateBean, ModuleName moduleName) {
            this.backEndName = string;
            this.template = templateBean;
            this.auxiliaryModuleName = moduleName;
        }

        private TemporaryModule(String string) {
            this(string, null, new ModuleName(string, null));
        }

        private void setTemplate(TemplateBean templateBean) {
            this.template = templateBean;
        }

        private void setAuxiliaryModuleName(ModuleName moduleName) {
            this.auxiliaryModuleName = moduleName;
        }

        private void close() {
            for (String string : this.entityMap.keySet()) {
                BeansAndSauce beansAndSauce = (BeansAndSauce)this.entityMap.get(string);
                TemplateListener templateListener = beansAndSauce.getListener();
                if (templateListener == null) continue;
                templateListener.close();
            }
            this.entityMap.clear();
        }

        private EntityName prepareCreateTemporaryDestination(boolean bl, int n) throws weblogic.jms.common.JMSException {
            Object object;
            QuotaBean quotaBean;
            JMSBean jMSBean = (JMSBean)new DescriptorManager().createDescriptorRoot(JMSBean.class).getRootBean();
            TemplateBean templateBean = null;
            if (this.template != null) {
                String[] stringArray;
                templateBean = jMSBean.createTemplate(this.template.getName());
                quotaBean = this.template.getQuota();
                if (quotaBean != null) {
                    jMSBean.createQuota(quotaBean.getName());
                }
                if ((object = this.template.getDeliveryFailureParams().getErrorDestination()) != null) {
                    if (object instanceof QueueBean) {
                        jMSBean.createQueue(object.getName());
                    } else {
                        jMSBean.createTopic(object.getName());
                    }
                }
                if ((stringArray = this.template.getDestinationKeys()).length > 0) {
                    JMSBean jMSBean2;
                    DomainMBean domainMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain();
                    JMSSystemResourceMBean jMSSystemResourceMBean = null;
                    if (this.auxiliaryModuleName.toString().equals("interop-jms") && ((JMSInteropModuleMBean[])(jMSBean2 = domainMBean.getJMSInteropModules())).length > 0) {
                        jMSSystemResourceMBean = jMSBean2[0];
                    }
                    if (jMSSystemResourceMBean == null) {
                        jMSSystemResourceMBean = domainMBean.lookupJMSSystemResource(this.auxiliaryModuleName.toString());
                    }
                    jMSBean2 = jMSSystemResourceMBean.getJMSResource();
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            JMSBeanHelper.copyDestinationKeyBean(jMSBean, jMSBean2, stringArray[i]);
                            continue;
                        }
                        catch (ManagementException managementException) {
                            throw new weblogic.jms.common.JMSException(managementException);
                        }
                    }
                }
                try {
                    JMSBeanHelper.copyTemplateBean(templateBean, jMSBean, this.template);
                }
                catch (ManagementException managementException) {
                    throw new weblogic.jms.common.JMSException(managementException);
                }
            }
            if (bl) {
                this.proposedTemporaryDestinationName = this.backEndName + ".TemporaryQueue" + n;
                object = jMSBean.createQueue(this.proposedTemporaryDestinationName);
                quotaBean = object;
            } else {
                this.proposedTemporaryDestinationName = this.backEndName + ".TemporaryTopic" + n;
                object = jMSBean.createTopic(this.proposedTemporaryDestinationName);
                quotaBean = object;
            }
            if (templateBean != null) {
                quotaBean.setTemplate(templateBean);
            }
            quotaBean.getDeliveryParamsOverrides().setDeliveryMode("Non-Persistent");
            try {
                object = DESTINATION_PROVIDER.createTemporaryEntity(jMSBean, (NamedEntityBean)quotaBean, this.backEndName, this.auxiliaryModuleName);
                object.prepare();
                this.entityMap.put(JMSBeanHelper.getDecoratedName(this.backEndName, this.proposedTemporaryDestinationName), new BeansAndSauce(jMSBean, (JMSModuleManagedEntity)object, bl));
            }
            catch (ModuleException moduleException) {
                throw new weblogic.jms.common.JMSException((Throwable)((Object)moduleException));
            }
            return new EntityName(this.backEndName, null, this.proposedTemporaryDestinationName);
        }

        private void rollbackCreateTemporaryDestination() throws weblogic.jms.common.JMSException {
            weblogic.jms.common.JMSException jMSException = null;
            String string = JMSBeanHelper.getDecoratedName(this.backEndName, this.proposedTemporaryDestinationName);
            this.proposedTemporaryDestinationName = null;
            BeansAndSauce beansAndSauce = (BeansAndSauce)this.entityMap.remove(string);
            JMSModuleManagedEntity jMSModuleManagedEntity = beansAndSauce.getSauce();
            try {
                jMSModuleManagedEntity.unprepare();
                jMSModuleManagedEntity.destroy();
                jMSModuleManagedEntity.remove();
            }
            catch (ModuleException moduleException) {
                jMSException = new weblogic.jms.common.JMSException((Throwable)((Object)moduleException));
            }
            if (jMSException != null) {
                throw jMSException;
            }
        }

        private void activateCreateTemporaryDestination() throws weblogic.jms.common.JMSException {
            String string = JMSBeanHelper.getDecoratedName(this.backEndName, this.proposedTemporaryDestinationName);
            String string2 = this.proposedTemporaryDestinationName;
            this.proposedTemporaryDestinationName = null;
            BeansAndSauce beansAndSauce = (BeansAndSauce)this.entityMap.get(string);
            JMSModuleManagedEntity jMSModuleManagedEntity = beansAndSauce.getSauce();
            JMSBean jMSBean = beansAndSauce.getBean();
            try {
                jMSModuleManagedEntity.activate(jMSBean);
            }
            catch (ModuleException moduleException) {
                throw new weblogic.jms.common.JMSException((Throwable)((Object)moduleException));
            }
            if (this.template != null) {
                beansAndSauce.setListener(new TemplateListener(this.backEndName, string2, jMSBean, this.template, beansAndSauce.isQueue()));
            }
        }

        private void removeTemporaryDestination(String string) throws weblogic.jms.common.JMSException {
            weblogic.jms.common.JMSException jMSException = null;
            BeansAndSauce beansAndSauce = (BeansAndSauce)this.entityMap.remove(string);
            if (beansAndSauce == null) {
                return;
            }
            TemplateListener templateListener = beansAndSauce.getListener();
            if (templateListener != null) {
                templateListener.close();
            }
            JMSModuleManagedEntity jMSModuleManagedEntity = beansAndSauce.getSauce();
            try {
                jMSModuleManagedEntity.deactivate();
            }
            catch (ModuleException moduleException) {
                jMSException = new weblogic.jms.common.JMSException((Throwable)((Object)moduleException));
            }
            try {
                jMSModuleManagedEntity.unprepare();
            }
            catch (ModuleException moduleException) {
                if (jMSException != null) {
                    jMSException.printStackTrace();
                }
                jMSException = new weblogic.jms.common.JMSException((Throwable)((Object)moduleException));
            }
            try {
                jMSModuleManagedEntity.destroy();
            }
            catch (ModuleException moduleException) {
                if (jMSException != null) {
                    jMSException.printStackTrace();
                }
                jMSException = new weblogic.jms.common.JMSException((Throwable)((Object)moduleException));
            }
            try {
                jMSModuleManagedEntity.remove();
            }
            catch (ModuleException moduleException) {
                if (jMSException != null) {
                    jMSException.printStackTrace();
                }
                jMSException = new weblogic.jms.common.JMSException((Throwable)((Object)moduleException));
            }
            if (jMSException != null) {
                throw jMSException;
            }
        }
    }

    private class ObjectHandlerTestStoreException
    implements ObjectHandler,
    TestStoreException {
        ObjectHandler delegate;

        public ObjectHandlerTestStoreException(ObjectHandler objectHandler) {
            assert (ObjectMessageImpl.isTestStoreExceptionEnabled()) : "system property for store debug required";
            this.delegate = objectHandler;
        }

        public Object readObject(ObjectInput objectInput) throws ClassNotFoundException, IOException {
            return this.delegate.readObject(objectInput);
        }

        public void writeObject(ObjectOutput objectOutput, Object object) throws IOException {
            this.delegate.writeObject(objectOutput, object);
        }

        public PersistentStoreException getTestException() {
            return null;
        }
    }
}

