/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.security.AccessController;
import java.util.List;
import javax.naming.Context;
import weblogic.application.ApplicationContext;
import weblogic.application.ModuleException;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.NamedEntityBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEDestinationRuntimeDelegate;
import weblogic.jms.backend.BEQueueRuntimeDelegate;
import weblogic.jms.backend.BETopicRuntimeDelegate;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.EntityName;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.ModuleName;
import weblogic.jms.deployer.BEDeployer;
import weblogic.jms.module.JMSModuleManagedEntity;
import weblogic.jms.module.JMSModuleManagedEntityProvider;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class DestinationEntityProvider
implements JMSModuleManagedEntityProvider {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public JMSModuleManagedEntity createEntity(ApplicationContext applicationContext, EntityName entityName, Context context, JMSBean jMSBean, NamedEntityBean namedEntityBean, List list, DomainMBean domainMBean) throws ModuleException {
        DestinationBean destinationBean = (DestinationBean)namedEntityBean;
        String string = list == null ? destinationBean.getSubDeploymentName() : ((TargetMBean)list.get(0)).getName();
        return this.internalCreateEntity(entityName, context, false, jMSBean, namedEntityBean, string, entityName);
    }

    JMSModuleManagedEntity createTemporaryEntity(JMSBean jMSBean, NamedEntityBean namedEntityBean, String string, ModuleName moduleName) throws ModuleException {
        EntityName entityName = new EntityName(string, null, namedEntityBean.getName());
        return this.internalCreateEntity(entityName, null, true, jMSBean, namedEntityBean, string, moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSModuleManagedEntity internalCreateEntity(EntityName entityName, Context context, boolean bl, JMSBean jMSBean, NamedEntityBean namedEntityBean, String string, ModuleName moduleName) throws ModuleException {
        BEDeployer bEDeployer = JMSService.getJMSService().getBEDeployer();
        BackEnd backEnd = bEDeployer.findBackEnd(string);
        if (backEnd == null) {
            throw new ModuleException(JMSExceptionLogger.logNoBackEndLoggable((String)string, (String)entityName.getEntityName(), (String)entityName.getFullyQualifiedModuleName()).getMessage());
        }
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID);
        BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = null;
        try {
            bEDestinationRuntimeDelegate = namedEntityBean instanceof QueueBean ? new BEQueueRuntimeDelegate(entityName, backEnd, context, bl, moduleName, jMSBean, (QueueBean)namedEntityBean) : new BETopicRuntimeDelegate(entityName, backEnd, context, bl, moduleName, jMSBean, (TopicBean)namedEntityBean);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            throw throwable;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Destination " + entityName.getEntityName() + " from module " + entityName.getFullyQualifiedModuleName() + " successfully created");
        }
        return bEDestinationRuntimeDelegate;
    }
}

