/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.ArrayList;
import javax.jms.JMSException;
import weblogic.application.ModuleException;
import weblogic.j2ee.descriptor.wl.DestinationKeyBean;
import weblogic.jms.backend.BECursorDestinationKey;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.JMSMessageCursorComparator;
import weblogic.messaging.Message;
import weblogic.messaging.kernel.Cursor;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.runtime.MessageCursorDelegate;
import weblogic.messaging.runtime.CursorRuntimeImpl;
import weblogic.messaging.runtime.OpenDataConverter;

public class JMSMessageCursorDelegate
extends MessageCursorDelegate {
    private BEDestinationImpl destination;

    public JMSMessageCursorDelegate(CursorRuntimeImpl cursorRuntimeImpl, OpenDataConverter openDataConverter, Cursor cursor, OpenDataConverter openDataConverter2, BEDestinationImpl bEDestinationImpl, int n) {
        super(cursorRuntimeImpl, openDataConverter, cursor, openDataConverter2, n);
        this.destination = bEDestinationImpl;
    }

    public JMSMessageCursorDelegate(CursorRuntimeImpl cursorRuntimeImpl, OpenDataConverter openDataConverter, Cursor cursor, OpenDataConverter openDataConverter2, int n) {
        super(cursorRuntimeImpl, openDataConverter, cursor, openDataConverter2, n);
    }

    public long sort(long l, String[] stringArray, Boolean[] booleanArray) throws ModuleException {
        this.updateAccessTime();
        MessageElement messageElement = null;
        if (l != -1L) {
            this.cursorIterator.seek(l);
        }
        ArrayList<BECursorDestinationKey> arrayList = new ArrayList<BECursorDestinationKey>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = true;
                if (booleanArray != null && i < booleanArray.length && !booleanArray[i].booleanValue()) {
                    bl = false;
                }
                arrayList.add(new BECursorDestinationKey(this.destination, new CursorDestinationKeyBean(stringArray[i], bl)));
            }
        }
        this.cursorIterator.setComparator(new JMSMessageCursorComparator(arrayList));
        this.cursorIterator.rewind();
        if (messageElement != null) {
            this.cursorIterator.seek(messageElement);
            return this.cursorIterator.getPosition();
        }
        return 0L;
    }

    protected boolean compareMessageID(Message message, String string) {
        if (message == null || !(message instanceof javax.jms.Message)) {
            return false;
        }
        javax.jms.Message message2 = (javax.jms.Message)message;
        try {
            return message2.getJMSMessageID().equals(string);
        }
        catch (JMSException jMSException) {
            return false;
        }
    }

    class CursorDestinationKeyBean
    implements DestinationKeyBean {
        String name;
        String property;
        String order = "Ascending";

        CursorDestinationKeyBean(String string, boolean bl) {
            this.property = this.name = string;
            if (!bl) {
                this.order = "Descending";
            }
        }

        public String getKeyType() {
            return "String";
        }

        public void setKeyType(String string) {
        }

        public boolean isSetType() {
            return false;
        }

        public void unsetType() {
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String string) {
            this.property = string;
        }

        public boolean isSetProperty() {
            return this.property != null;
        }

        public void unsetProperty() {
            this.property = null;
        }

        public String getSortOrder() {
            return this.order;
        }

        public void setSortOrder(String string) {
            this.order = string;
        }

        public boolean isSetSortOrder() {
            return this.order != null;
        }

        public void unsetSortOrder() {
            this.order = null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public boolean isSetName() {
            return this.name != null;
        }

        public void unsetName() {
            this.name = null;
        }

        public String getNotes() {
            return null;
        }

        public void setNotes(String string) {
        }

        public boolean isSet(String string) {
            return true;
        }

        public void unSet(String string) {
        }
    }
}

