/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.Iterator;
import javax.jms.JMSException;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEForwardingConsumer;
import weblogic.jms.backend.BEQueueImpl;
import weblogic.jms.backend.ForwardingStatusListener;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDMember;
import weblogic.jms.dd.DDStatusListener;
import weblogic.timers.StopTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;

public final class QueueForwardingManager
implements StopTimerListener,
DDStatusListener,
ForwardingStatusListener {
    private long forwardingDelay;
    private Timer queueForwardingTimer;
    private DDMember forwardTo = null;
    private BEForwardingConsumer forwardingConsumer;
    private boolean forwardingTimerExpired = false;
    DDHandler ddHandler;
    DDMember member;

    public QueueForwardingManager(DDHandler dDHandler, DDMember dDMember) {
        this.ddHandler = dDHandler;
        this.member = dDMember;
        dDMember.setIsForwardingUp(true);
        dDHandler.addStatusListener(this, 7);
    }

    public synchronized void statusChange() {
        boolean bl;
        boolean bl2 = bl = this.member.isDestinationUp() && !this.member.isConsumptionPaused() && !this.member.hasConsumers() && this.ddHandler.getForwardDelay() >= 0;
        if (bl) {
            if (this.forwardTo == null) {
                this.start();
            } else if (!this.forwardTo.hasConsumers() && !this.pickAndForward()) {
                this.start();
            }
        } else if (!bl && this.forwardingConsumer != null) {
            this.stop();
        }
    }

    private synchronized boolean pickForwardTo() {
        this.forwardTo = null;
        Iterator iterator = this.ddHandler.memberCloneIterator();
        while (iterator.hasNext()) {
            DDMember dDMember = (DDMember)iterator.next();
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("QueueForwardingManager.pickForwardTo() " + dDMember.getName() + " hasConsumer " + dDMember.hasConsumers() + " is up? " + dDMember.isUp());
            }
            if (dDMember.getName().equals(this.member.getName()) || !dDMember.hasConsumers() || dDMember.isConsumptionPaused() || !dDMember.isUp()) continue;
            if (dDMember.isLocal() && dDMember.isPersistent()) {
                this.forwardTo = dDMember;
                break;
            }
            if (this.forwardTo == null) {
                this.forwardTo = dDMember;
                continue;
            }
            if (this.forwardTo.isPersistent() || !dDMember.isPersistent() && !dDMember.isLocal()) continue;
            this.forwardTo = dDMember;
        }
        return this.forwardTo != null;
    }

    private synchronized void start() {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("QueueForwardingManager.start() forwardingConsumer " + this.forwardingConsumer + " ddHandler " + this.ddHandler + " resetDeliveryCount " + this.ddHandler.getResetDeliveryCountOnForward() + " queueForwardDelay " + this.ddHandler.getForwardDelay());
        }
        if (this.forwardingConsumer == null) {
            JMSID jMSID = JMSService.getJMSService().getNextId();
            this.forwardingConsumer = new BEForwardingConsumer(this.member.getDestination().getBackEnd(), jMSID.toString(), jMSID, ((BEQueueImpl)this.member.getDestination()).getKernelQueue(), this.ddHandler.getResetDeliveryCountOnForward());
            this.forwardingConsumer.setStatusListener(this);
        }
        this.forwardingDelay = (long)this.ddHandler.getForwardDelay() * 1000L;
        if (this.forwardingTimerExpired) {
            this.pickAndForward();
            return;
        }
        if (this.forwardingDelay == 0L) {
            this.forwardingTimerExpired = true;
            this.pickAndForward();
            return;
        }
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Started dist queue forwarding timer for " + this.member.getName() + " to " + this.forwardingDelay);
        }
        this.queueForwardingTimer = this.member.getDestination().getBackEnd().getTimerManager().schedule((TimerListener)this, this.forwardingDelay, this.forwardingDelay);
    }

    private synchronized boolean pickAndForward() {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Trying to find candidate for forwarding for " + this.member.getName());
        }
        if (this.pickForwardTo()) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Forwarding to " + this.forwardTo.getName() + " from " + this.member.getName());
            }
            try {
                this.forwardingConsumer.start(this.forwardTo.getDDImpl(), this.forwardTo.getName(), this.forwardTo.getRemoteSecurityMode());
            }
            catch (JMSException jMSException) {
                this.forwardingFailed(this.forwardingConsumer);
                this.forwardTo = null;
                return false;
            }
            return true;
        }
        return false;
    }

    synchronized void stop() {
        this.forwardingTimerExpired = false;
        if (this.forwardingConsumer == null) {
            return;
        }
        if (this.forwardTo != null) {
            this.forwardTo = null;
        }
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Stopping dist queue forwarding for " + this.member.getName());
        }
        if (this.queueForwardingTimer != null) {
            this.queueForwardingTimer.cancel();
            this.queueForwardingTimer = null;
        }
        if (this.forwardingConsumer != null) {
            this.forwardingConsumer.stop();
            this.forwardingConsumer = null;
        }
    }

    public synchronized void forwardingFailed(BEForwardingConsumer bEForwardingConsumer) {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("QueueForwardingManager.forwardingFailed() reschedule forwarder " + bEForwardingConsumer);
        }
        if (this.queueForwardingTimer != null) {
            this.queueForwardingTimer.cancel();
        }
        this.queueForwardingTimer = this.member.getDestination().getBackEnd().getTimerManager().schedule((TimerListener)this, this.forwardingDelay, this.forwardingDelay);
    }

    public synchronized void timerExpired(Timer timer) {
        if (this.forwardingConsumer == null) {
            return;
        }
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Queue forwarding timer expired for " + this.member.getName());
        }
        this.forwardingTimerExpired = true;
        if (timer != null) {
            timer.cancel();
        }
        this.pickAndForward();
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("No forwarding candidate found for " + this.member.getName() + ", an event will need to occur");
        }
    }

    public void timerStopped(Timer timer) {
        this.stop();
    }

    public void statusChangeNotification(DDHandler dDHandler, int n) {
        if (dDHandler.findMemberByName(this.member.getName()) == null) {
            dDHandler.removeStatusListener(this);
            this.stop();
        } else {
            this.statusChange();
        }
    }

    public String toString() {
        return "QueueForwardingManager: " + this.member.getName() + " within " + this.ddHandler.getName() + ", hash: " + this.hashCode();
    }
}

