/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEForwardingConsumer;
import weblogic.jms.backend.BETopicImpl;
import weblogic.jms.backend.BEUOOTopicState;
import weblogic.jms.backend.ForwardingStatusListener;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSSQLExpression;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dd.DDMember;
import weblogic.jms.dd.DDStatusListener;
import weblogic.messaging.kernel.Destination;
import weblogic.messaging.kernel.Event;
import weblogic.messaging.kernel.EventListener;
import weblogic.messaging.kernel.GroupAddEvent;
import weblogic.messaging.kernel.GroupEvent;
import weblogic.messaging.kernel.GroupRemoveEvent;
import weblogic.messaging.kernel.Queue;
import weblogic.work.WorkManagerFactory;

public class TopicForwardingManager
implements EventListener,
DDStatusListener,
ForwardingStatusListener {
    private Map forwardGroupCounters = new HashMap();
    private Map forwarders;
    private static final String SYSTEM_DIST_SUBSCRIBER_CLIENT = "WeblogicJmsDistributedTopic";
    DDHandler ddHandler;
    DDMember member;
    BEUOOTopicState beUOOTopicState;

    public TopicForwardingManager(DDHandler dDHandler, DDMember dDMember, BEDestinationImpl bEDestinationImpl) {
        this.ddHandler = dDHandler;
        this.member = dDMember;
        dDMember.setIsForwardingUp(true);
        dDHandler.addStatusListener(this, 19);
        if ("PathService".equals(dDHandler.getUnitOfOrderRouting())) {
            this.beUOOTopicState = new BEUOOTopicState(bEDestinationImpl, dDHandler);
        }
        bEDestinationImpl.setExtension(this.beUOOTopicState);
    }

    public void statusChangeNotification(DDHandler dDHandler, int n) {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("TopicForwardingManager.statusChangeNotification() " + dDHandler.getName() + " events " + n);
        }
        if ((n & 0x10) != 0) {
            this.deactivate();
            return;
        }
        if ((n & 1) != 0 && dDHandler.findMemberByName(this.member.getName()) == null) {
            this.deactivate();
            return;
        }
        this.refreshMembers();
        this.member.setIsForwardingUp(true);
    }

    private void deactivate() {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Deactivate on topic forwarder for " + this.member.getName() + " within " + this.ddHandler.getName());
        }
        this.ddHandler.removeStatusListener(this);
        if (this.forwarders == null) {
            return;
        }
        for (Forwarder forwarder : this.forwarders.values()) {
            forwarder.deactivate();
        }
    }

    private void refreshMembers() {
        Object object;
        Object object2;
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Refreshing members for " + this.ddHandler.getName() + " with respect to " + this.member.getName() + ": this is " + this);
        }
        if (this.forwarders == null) {
            this.forwarders = new HashMap();
        }
        Iterator iterator = this.forwarders.values().iterator();
        while (iterator.hasNext()) {
            object2 = (Forwarder)iterator.next();
            object = this.ddHandler.findMemberByName(((Forwarder)object2).getName());
            if (object != null) continue;
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug(((Forwarder)object2).getName() + " is no longer a member of " + this.ddHandler.getName() + " so I won't forward from " + this.member.getName());
            }
            ((Forwarder)object2).deactivate();
            iterator.remove();
        }
        iterator = this.ddHandler.memberCloneIterator();
        while (iterator.hasNext()) {
            object2 = (DDMember)iterator.next();
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Looking for match between forwardTo " + ((DDMember)object2).getName() + " and member " + this.member.getName());
            }
            if (((DDMember)object2).getName().equals(this.member.getName())) continue;
            object = (Forwarder)this.forwarders.get(((DDMember)object2).getName());
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug(" Found match, forwarder " + object);
            }
            if (object == null) {
                try {
                    if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                        JMSDebug.JMSDistTopic.debug("Creating a forwarder to " + ((DDMember)object2).getName() + " from " + this.member.getName() + " within " + this.ddHandler.getName());
                    }
                    object = new Forwarder((DDMember)object2);
                    this.forwarders.put(((DDMember)object2).getName(), object);
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                if (object == null) continue;
            }
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug(" Forwarder info, isStarted " + ((Forwarder)object).isStarted() + ", isUp " + ((DDMember)object2).isUp());
            }
            if (!((Forwarder)object).isStarted() && ((DDMember)object2).isUp()) {
                ((Forwarder)object).start((DDMember)object2);
                continue;
            }
            if (!((Forwarder)object).isStarted() || ((DDMember)object2).isUp()) continue;
            ((Forwarder)object).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onEvent(Event event) {
        if (!(event instanceof GroupEvent)) {
            return;
        }
        boolean bl = event instanceof GroupAddEvent;
        assert (bl ^ event instanceof GroupRemoveEvent);
        String string = ((GroupEvent)event).getGroup().getName();
        TopicForwardingManager topicForwardingManager = this;
        synchronized (topicForwardingManager) {
            Counter counter = (Counter)this.forwardGroupCounters.get(string);
            if (bl) {
                if (counter != null) {
                    counter.increment();
                    return;
                }
                this.forwardGroupCounters.put(string, new Counter(1));
            } else {
                if (counter == null) return;
                if (counter.decrement() != 0) {
                    return;
                }
                this.forwardGroupCounters.remove(string);
            }
        }
        if (this.beUOOTopicState == null) return;
        if (bl) {
            this.beUOOTopicState.groupAddEvent(string);
            return;
        }
        this.beUOOTopicState.groupRemoveEvent(string);
    }

    public String toString() {
        return "TopicForwardingManager: " + this.member.getName() + " within " + this.ddHandler.getName() + ", hash: " + this.hashCode();
    }

    private static String systemSubscriberName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SYSTEM_DIST_SUBSCRIBER_CLIENT);
        stringBuffer.append("@Remote@");
        stringBuffer.append(string);
        stringBuffer.append("@Local@");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public synchronized void forwardingFailed(BEForwardingConsumer bEForwardingConsumer) {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("TopicForwardingManager.forwardingFailed() consumer " + bEForwardingConsumer);
        }
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new RefreshMembersThread());
    }

    protected final class Forwarder {
        private String name;
        private Queue subscriberQueue;
        private BEForwardingConsumer forwardingConsumer;
        private BETopicImpl topicImpl;

        Forwarder(DDMember dDMember) throws JMSException {
            this.name = dDMember.getName();
            String string = TopicForwardingManager.systemSubscriberName(this.name, TopicForwardingManager.this.member.getName());
            JMSSQLExpression jMSSQLExpression = new JMSSQLExpression(null, false, null, true);
            this.topicImpl = (BETopicImpl)TopicForwardingManager.this.member.getDestination();
            if (this.topicImpl == null) {
                this.stop();
                throw new JMSException("Error while creating a system subscriber, member has no valid destination");
            }
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Creating new system subscriber queue " + string + " for forwarding to " + this.name + " from " + TopicForwardingManager.this.member.getName());
            }
            try {
                this.subscriberQueue = this.topicImpl.createSubscriptionQueue(string, true);
                this.topicImpl.activateSubscriptionQueue(this.subscriberQueue, null, jMSSQLExpression, false, true);
            }
            catch (JMSException jMSException) {
                if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                    JMSDebug.JMSDistTopic.debug("Exception while creating a system subscriber: " + string, (Throwable)jMSException);
                }
                this.stop();
                throw jMSException;
            }
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Created new system subscriber queue " + string + " for forwarding to " + this.name + " from " + TopicForwardingManager.this.member.getName());
            }
            JMSID jMSID = JMSService.getJMSService().getNextId();
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Creating system subscriber " + this.name + " beUOOTopicState " + TopicForwardingManager.this.beUOOTopicState);
            }
            this.forwardingConsumer = new BEForwardingConsumer(TopicForwardingManager.this.member.getDestination().getBackEnd(), this.name, jMSID, this.subscriberQueue);
            if (TopicForwardingManager.this.beUOOTopicState != null) {
                BEDestinationImpl.addPropertyFlags((Destination)this.forwardingConsumer.getQueue(), "Logging", 16);
                this.forwardingConsumer.getQueue().addListener((EventListener)TopicForwardingManager.this);
            } else {
                this.forwardingConsumer.setStatusListener(TopicForwardingManager.this);
            }
        }

        boolean isStarted() {
            return this.forwardingConsumer.isStarted();
        }

        void start(DDMember dDMember) {
            DistributedDestinationImpl distributedDestinationImpl;
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Starting system subscriber to " + this.subscriberQueue.getName() + " for " + this.name + " from " + TopicForwardingManager.this.member.getName());
            }
            if ((distributedDestinationImpl = DDManager.findDDImplByMemberName(this.name)) == null) {
                if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                    JMSDebug.JMSDistTopic.debug("Cannot find the DDImpl for " + this.name + " to accept forwarding from " + TopicForwardingManager.this.member.getName());
                }
                return;
            }
            try {
                this.forwardingConsumer.start(distributedDestinationImpl, distributedDestinationImpl.getMemberName(), dDMember.getRemoteSecurityMode());
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }

        String getName() {
            return this.name;
        }

        synchronized void stop() {
            if (this.forwardingConsumer != null) {
                if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                    JMSDebug.JMSDistTopic.debug("Stopping system subscriber to " + this.subscriberQueue.getName() + " for " + this.name + " from " + TopicForwardingManager.this.member.getName());
                }
                this.forwardingConsumer.stop();
            }
        }

        synchronized void deactivate() {
            this.stop();
            if (this.subscriberQueue != null) {
                block4: {
                    DDMember dDMember = TopicForwardingManager.this.member;
                    if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                        JMSDebug.JMSDistTopic.debug("Permanently removing system subscriber to " + this.subscriberQueue.getName() + " for " + this.name + " from " + dDMember.getName());
                    }
                    try {
                        this.topicImpl.unsubscribe(this.subscriberQueue, false);
                    }
                    catch (JMSException jMSException) {
                        if (!JMSDebug.JMSDistTopic.isDebugEnabled()) break block4;
                        JMSDebug.JMSDistTopic.debug("Exception while shutting down forwarder", (Throwable)jMSException);
                    }
                }
                this.subscriberQueue = null;
            }
        }
    }

    private class RefreshMembersThread
    implements Runnable {
        private RefreshMembersThread() {
        }

        public void run() {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("TopicForwardingManager.RefreshMembersThread()");
            }
            TopicForwardingManager.this.refreshMembers();
            TopicForwardingManager.this.member.setIsForwardingUp(true);
        }
    }

    public static final class Counter {
        private int value;

        public Counter(int n) {
            this.value = n;
        }

        public int increment() {
            return ++this.value;
        }

        public int decrement() {
            return --this.value;
        }
    }
}

