/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend.udd;

import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.DeliveryFailureParamsBean;
import weblogic.j2ee.descriptor.wl.DeliveryParamsOverridesBean;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.MessageLoggingParamsBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.j2ee.descriptor.wl.TemplateBean;
import weblogic.j2ee.descriptor.wl.ThresholdParamsBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedTopicBean;
import weblogic.j2ee.descriptor.wl.constants.JMSConstants;
import weblogic.jms.backend.udd.SyntheticErrorDestinationBean;
import weblogic.jms.backend.udd.UDDEntity;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.extensions.JMSModuleHelper;
import weblogic.management.ManagementException;

public class SyntheticDestinationBean
implements DestinationBean,
DescriptorBean,
DeliveryFailureParamsBean {
    LinkedList listeners = new LinkedList();
    String serverName;
    boolean defaultTargetingEnabled;
    UDDEntity udd;

    public SyntheticDestinationBean(UDDEntity uDDEntity, String string) {
        this.udd = uDDEntity;
        this.serverName = string;
        try {
            JMSSecurityHelper.getSecurityHelper().mapDestinationName(this.getName(), uDDEntity.getUDestBean().getName());
        }
        catch (ManagementException managementException) {
            throw new AssertionError((Object)"Cannot find Security Helper");
        }
    }

    public void addDestinationKey(String string) {
        throw new AssertionError((Object)"Don't want to modify fake bean");
    }

    public String getAttachSender() {
        return this.udd.getUDestBean().getAttachSender();
    }

    public DeliveryFailureParamsBean getDeliveryFailureParams() {
        return this;
    }

    public MessageLoggingParamsBean getMessageLoggingParams() {
        return this.udd.getUDestBean().getMessageLoggingParams();
    }

    public DeliveryParamsOverridesBean getDeliveryParamsOverrides() {
        return this.udd.getUDestBean().getDeliveryParamsOverrides();
    }

    public String[] getDestinationKeys() {
        return this.udd.getUDestBean().getDestinationKeys();
    }

    public String getJMSCreateDestinationIdentifier() {
        return this.udd.getUDestBean().getJMSCreateDestinationIdentifier();
    }

    public String getJNDIName() {
        if (this.udd.getUDestBean().getJNDIName() == null) {
            return null;
        }
        return JMSModuleHelper.uddMakeName(this.serverName, this.udd.getUDestBean().getJNDIName());
    }

    public String getLocalJNDIName() {
        if (this.udd.getUDestBean().getLocalJNDIName() == null) {
            return null;
        }
        return JMSModuleHelper.uddMakeName(this.serverName, this.udd.getUDestBean().getLocalJNDIName());
    }

    public int getMaximumMessageSize() {
        return this.udd.getUDestBean().getMaximumMessageSize();
    }

    public int getMessagingPerformancePreference() {
        return this.udd.getUDestBean().getMessagingPerformancePreference();
    }

    public QuotaBean getQuota() {
        return this.udd.getUDestBean().getQuota();
    }

    public TemplateBean getTemplate() {
        return this.udd.getUDestBean().getTemplate();
    }

    public ThresholdParamsBean getThresholds() {
        return this.udd.getUDestBean().getThresholds();
    }

    public boolean isConsumptionPausedAtStartup() {
        return this.udd.getUDestBean().isConsumptionPausedAtStartup();
    }

    public boolean isInsertionPausedAtStartup() {
        return this.udd.getUDestBean().isInsertionPausedAtStartup();
    }

    public boolean isProductionPausedAtStartup() {
        return this.udd.getUDestBean().isProductionPausedAtStartup();
    }

    public String getSAFExportPolicy() {
        return this.udd.getUDestBean().getSAFExportPolicy();
    }

    public String getForwardingPolicy() {
        if (this.udd.getUDestBean() instanceof UniformDistributedTopicBean) {
            return ((UniformDistributedTopicBean)this.udd.getUDestBean()).getForwardingPolicy();
        }
        return JMSConstants.FORWARDING_POLICY_REPLICATED;
    }

    public void removeDestinationKey(String string) {
        throw new AssertionError((Object)"Don't want to modify fake bean");
    }

    public void setAttachSender(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setSAFExportPolicy(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setConsumptionPausedAtStartup(boolean bl) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setDestinationKeys(String[] stringArray) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setJMSCreateDestinationIdentifier(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setInsertionPausedAtStartup(boolean bl) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setJNDIName(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setLocalJNDIName(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setMaximumMessageSize(int n) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setMessagingPerformancePreference(int n) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setProductionPausedAtStartup(boolean bl) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setQuota(QuotaBean quotaBean) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setTemplate(TemplateBean templateBean) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public String getSubDeploymentName() {
        return this.serverName;
    }

    public boolean isDefaultTargetingEnabled() {
        return this.defaultTargetingEnabled;
    }

    public void setDefaultTargetingEnabled(boolean bl) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setSubDeploymentName(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public String getName() {
        return JMSModuleHelper.uddMakeName(this.serverName, this.udd.getUDestBean().getName());
    }

    public void setName(String string) {
        throw new AssertionError((Object)"Don't want to modify fake bean");
    }

    public String getNotes() {
        return this.udd.getUDestBean().getNotes();
    }

    public void setNotes(String string) {
        throw new AssertionError((Object)"Don't want to modify fake bean");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException();
    }

    public void addBeanUpdateListener(BeanUpdateListener beanUpdateListener) {
        this.listeners.add(beanUpdateListener);
    }

    public Descriptor getDescriptor() {
        return null;
    }

    public DescriptorBean getParentBean() {
        return ((DescriptorBean)this.udd.getUDestBean()).getParentBean();
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isSet(String string) {
        return false;
    }

    public void removeBeanUpdateListener(BeanUpdateListener beanUpdateListener) {
        this.listeners.remove(beanUpdateListener);
    }

    public void unSet(String string) {
    }

    public DescriptorBean createChildCopy(String string, DescriptorBean descriptorBean) {
        throw new UnsupportedOperationException();
    }

    public DescriptorBean createChildCopyIncludingObsolete(String string, DescriptorBean descriptorBean) {
        throw new UnsupportedOperationException();
    }

    public void setDefaultUnitOfOrder(boolean bl) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public boolean isDefaultUnitOfOrder() {
        return this.udd.getUDestBean().isDefaultUnitOfOrder();
    }

    public DestinationBean getErrorDestination() {
        DestinationBean destinationBean = this.udd.getUDestBean().getDeliveryFailureParams().getErrorDestination();
        if (destinationBean == null) {
            return null;
        }
        return new SyntheticErrorDestinationBean(this.serverName, destinationBean.getName());
    }

    public int getRedeliveryLimit() {
        return this.udd.getUDestBean().getDeliveryFailureParams().getRedeliveryLimit();
    }

    public String getExpirationPolicy() {
        return this.udd.getUDestBean().getDeliveryFailureParams().getExpirationPolicy();
    }

    public String getExpirationLoggingPolicy() {
        return this.udd.getUDestBean().getDeliveryFailureParams().getExpirationLoggingPolicy();
    }

    public String findSubDeploymentName() {
        return this.udd.getUDestBean().getDeliveryFailureParams().findSubDeploymentName();
    }

    public TemplateBean getTemplateBean() {
        return this.udd.getUDestBean().getDeliveryFailureParams().getTemplateBean();
    }

    public void setErrorDestination(DestinationBean destinationBean) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setRedeliveryLimit(int n) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setExpirationPolicy(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setExpirationLoggingPolicy(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public void setUnitOfWorkHandlingPolicy(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }

    public String getUnitOfWorkHandlingPolicy() {
        return this.udd.getUDestBean().getUnitOfWorkHandlingPolicy();
    }

    public int getIncompleteWorkExpirationTime() {
        return this.udd.getUDestBean().getIncompleteWorkExpirationTime();
    }

    public void setIncompleteWorkExpirationTime(int n) throws IllegalArgumentException {
        throw new IllegalArgumentException("Don't want to modify fake bean");
    }
}

