/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend.udd;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.naming.Context;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ModuleException;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.NamedEntityBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedDestinationBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedQueueBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedTopicBean;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEDestinationRuntimeDelegate;
import weblogic.jms.backend.BETopicImpl;
import weblogic.jms.backend.DestinationEntityProvider;
import weblogic.jms.backend.udd.SyntheticDDBean;
import weblogic.jms.backend.udd.SyntheticDQBean;
import weblogic.jms.backend.udd.SyntheticDTBean;
import weblogic.jms.backend.udd.SyntheticDestinationBean;
import weblogic.jms.backend.udd.SyntheticJMSBean;
import weblogic.jms.backend.udd.SyntheticMemberBean;
import weblogic.jms.backend.udd.SyntheticQueueBean;
import weblogic.jms.backend.udd.SyntheticTopicBean;
import weblogic.jms.common.EntityName;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSTargetsListener;
import weblogic.jms.dd.UniformDistributedDestination;
import weblogic.jms.extensions.JMSModuleHelper;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.JMSModuleManagedEntity;
import weblogic.jms.module.TargetListSave;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.JMSServerRuntimeMBean;
import weblogic.management.utils.GenericBeanListener;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class UDDEntity
implements JMSModuleManagedEntity,
JMSTargetsListener {
    private static LinkedList instances = new LinkedList();
    private static HashMap localJMSServers = new HashMap();
    private HashMap destinations = new HashMap();
    private HashMap destinationBeans = new HashMap();
    private UniformDistributedDestination udd;
    private String name;
    private UniformDistributedDestinationBean uDestBean;
    private SyntheticDDBean ddBean;
    private boolean isQueue;
    private ApplicationContextInternal appCtx;
    private String moduleName;
    private String earModuleName;
    private Context namingContext;
    private JMSBean wholeModule;
    private static final HashMap targetSignatures;
    private static final HashMap uDQueueBeanSignatures;
    private static final HashMap uDTopicBeanSignatures;
    private List lotsOfListeners = new LinkedList();
    private HashMap activeTargetedServers = new HashMap();
    private HashMap preparedTargetedServers = new HashMap();
    private LinkedList addedLocalDestinations = null;
    private LinkedList preparedForRemovalTargetedServers = new LinkedList();
    private SyntheticJMSBean fakeJMSBean;
    private boolean reconciled = false;
    private TargetListSave savedTargets = null;
    private static final AuthenticatedSubject kernelId;

    private String prTargets(List list) {
        ListIterator listIterator = list.listIterator();
        String string = "";
        while (listIterator.hasNext()) {
            if (string.length() != 0) {
                string = string + ", ";
            }
            string = string + ((TargetMBean)listIterator.next()).getName();
        }
        return string;
    }

    private void fillWithMyTargets(DomainMBean domainMBean, HashMap hashMap, List list) {
        if (list == null) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("fillWithMyTargets called for " + this.name + ": targets is null");
            }
            return;
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("fillWithMyTargets called for " + this.name + ": targets are: " + this.prTargets(list));
        }
        JMSModuleHelper.uddFillWithMyTargets((Map)hashMap, domainMBean, list.toArray(new TargetMBean[0]));
    }

    public JMSBean getJMSModuleBean() {
        return this.wholeModule;
    }

    public UDDEntity(String string, ApplicationContext applicationContext, String string2, String string3, Context context, JMSBean jMSBean, NamedEntityBean namedEntityBean, List list, DomainMBean domainMBean) throws ModuleException {
        this.name = string;
        this.uDestBean = (UniformDistributedDestinationBean)namedEntityBean;
        this.appCtx = (ApplicationContextInternal)applicationContext;
        this.moduleName = string2;
        this.earModuleName = string3;
        this.namingContext = context;
        this.wholeModule = jMSBean;
        this.isQueue = this.uDestBean instanceof UniformDistributedQueueBean;
        this.fakeJMSBean = new SyntheticJMSBean(this);
        if (list != null && list.size() == 0) {
            list = null;
        } else if (list != null && JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Constructor called for " + this.name + ": targets are: " + this.prTargets(list));
        }
        this.savedTargets = new TargetListSave(list);
        this.makeDD(domainMBean, list);
    }

    private void makeDestination(String string, SyntheticDestinationBean syntheticDestinationBean) throws BeanUpdateRejectedException {
        JMSModuleManagedEntity jMSModuleManagedEntity;
        EntityName entityName = new EntityName(this.appCtx.getApplicationId(), this.earModuleName, syntheticDestinationBean.getName());
        try {
            jMSModuleManagedEntity = new DestinationEntityProvider().createEntity(this.appCtx, entityName, this.namingContext, this.fakeJMSBean, (NamedEntityBean)syntheticDestinationBean, null, null);
        }
        catch (ModuleException moduleException) {
            throw new BeanUpdateRejectedException("Failed to create Destination", (Throwable)((Object)moduleException));
        }
        this.destinations.put(string, jMSModuleManagedEntity);
    }

    private SyntheticMemberBean addMember(DomainMBean domainMBean, String string) throws BeanUpdateRejectedException {
        SyntheticMemberBean syntheticMemberBean = this.ddBean.findMemberBean(string);
        if (syntheticMemberBean != null && this.destinations.containsKey(string)) {
            return syntheticMemberBean;
        }
        if (syntheticMemberBean == null) {
            syntheticMemberBean = this.ddBean.addMember(string);
        }
        SyntheticDestinationBean syntheticDestinationBean = this.isQueue ? new SyntheticQueueBean(this, string) : new SyntheticTopicBean(this, string);
        this.destinationBeans.put(JMSModuleHelper.uddMakeName(string, this.name), syntheticDestinationBean);
        if (UDDEntity.isJMSServerLocal(string)) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Making destination for " + this.name + " from jms server name: " + string + "; it has a JNDI name of " + syntheticDestinationBean.getJNDIName());
            }
            this.makeDestination(string, syntheticDestinationBean);
        }
        return syntheticMemberBean;
    }

    private void removeMember(String string) {
        this.ddBean.removeMember(string);
        this.destinationBeans.remove(JMSModuleHelper.uddMakeName(string, this.name));
        this.destinations.remove(string);
    }

    boolean isQueue() {
        return this.isQueue;
    }

    private void makeDD(DomainMBean domainMBean, List list) throws ModuleException {
        if (domainMBean == null) {
            if (list != null) {
                domainMBean = JMSBeanHelper.getDomain((TargetMBean)list.get(0));
            } else {
                ManagementService.getRuntimeAccess(kernelId).getDomain();
            }
        }
        this.ddBean = this.isQueue ? new SyntheticDQBean(this) : new SyntheticDTBean(this);
        this.fillWithMyTargets(domainMBean, this.preparedTargetedServers, list);
        for (String string : this.preparedTargetedServers.values()) {
            try {
                this.addMember(domainMBean, string);
            }
            catch (BeanUpdateRejectedException beanUpdateRejectedException) {
                throw new ModuleException("Could not create Uniform Distributed Destination", beanUpdateRejectedException);
            }
        }
        this.udd = new UniformDistributedDestination(this.name, this.fakeJMSBean, this.ddBean, this.earModuleName, this.moduleName, this.appCtx);
    }

    private static boolean isJMSServerLocal(String string) {
        return localJMSServers.get(string) != null;
    }

    public static Map getLocalJMSServers() {
        return localJMSServers;
    }

    private Iterator allDestinationsIterator() {
        return this.destinations.values().iterator();
    }

    private Iterator makeDestinationsIterator(HashMap hashMap) {
        LinkedList linkedList = new LinkedList();
        if (hashMap != null) {
            for (String string : hashMap.values()) {
                JMSModuleManagedEntity jMSModuleManagedEntity = (JMSModuleManagedEntity)this.destinations.get(string);
                if (jMSModuleManagedEntity == null) continue;
                linkedList.add(this.destinations.get(string));
            }
        }
        return linkedList.listIterator();
    }

    private Iterator preparedDestinationsIterator() {
        return this.makeDestinationsIterator(this.preparedTargetedServers);
    }

    private Iterator activeDestinationsIterator() {
        return this.makeDestinationsIterator(this.activeTargetedServers);
    }

    private JMSModuleManagedEntity findDestinationEntity(String string) {
        return (JMSModuleManagedEntity)this.destinations.get(string);
    }

    public void activate(JMSBean jMSBean) throws ModuleException {
        this.wholeModule = jMSBean;
        this.uDestBean = this.uDestBean instanceof UniformDistributedQueueBean ? this.wholeModule.lookupUniformDistributedQueue(this.getEntityName()) : this.wholeModule.lookupUniformDistributedTopic(this.getEntityName());
        Iterator iterator = this.preparedDestinationsIterator();
        while (iterator.hasNext()) {
            JMSModuleManagedEntity jMSModuleManagedEntity = (JMSModuleManagedEntity)iterator.next();
            jMSModuleManagedEntity.activate(null);
        }
        if (this.udd != null) {
            this.udd.activate(null);
        }
        this.activeTargetedServers = this.preparedTargetedServers;
        this.preparedTargetedServers = new HashMap();
        this.unregisterBeanUpdateListeners();
        this.registerBeanUpdateListeners();
    }

    private void registerBeanUpdateListeners() {
        JMSService.getJMSService().addJMSServerListener(this);
        if (this.isQueue) {
            this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)this.uDestBean, (Object)this, (Map)uDQueueBeanSignatures, null));
        } else {
            this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)this.uDestBean, (Object)this, (Map)uDTopicBeanSignatures, null));
            this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)((UniformDistributedTopicBean)this.uDestBean).getMulticast(), (Object)this, (Map)JMSBeanHelper.multicastBeanSignatures, null));
        }
        this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)this.uDestBean.getThresholds(), (Object)this, (Map)JMSBeanHelper.thresholdBeanSignatures, null));
        this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)this.uDestBean.getDeliveryParamsOverrides(), (Object)this, (Map)JMSBeanHelper.deliveryOverridesSignatures, null));
        this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)this.uDestBean.getDeliveryFailureParams(), (Object)this, (Map)JMSBeanHelper.deliveryFailureSignatures, null));
        this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)this.uDestBean.getDeliveryFailureParams(), (Object)this, (Map)JMSBeanHelper.localDeliveryFailureSignatures, null));
        this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)this.uDestBean.getMessageLoggingParams(), (Object)this, (Map)JMSBeanHelper.messageLoggingSignatures, null));
        this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)this.uDestBean, (Object)this, (Map)JMSBeanHelper.localDestinationBeanSignatures, null));
    }

    private void unregisterBeanUpdateListeners() {
        JMSService.getJMSService().removeJMSServerListener(this);
        ListIterator listIterator = this.lotsOfListeners.listIterator();
        while (listIterator.hasNext()) {
            ((GenericBeanListener)listIterator.next()).close();
        }
        this.lotsOfListeners.clear();
    }

    public void deactivate() throws ModuleException {
        this.unregisterBeanUpdateListeners();
        Iterator iterator = this.activeDestinationsIterator();
        while (iterator.hasNext()) {
            JMSModuleManagedEntity jMSModuleManagedEntity = (JMSModuleManagedEntity)iterator.next();
            jMSModuleManagedEntity.deactivate();
        }
        if (this.udd != null) {
            this.udd.deactivate();
        }
    }

    public void destroy() throws ModuleException {
        if (this.udd != null) {
            this.udd.destroy();
        }
        Iterator iterator = this.activeDestinationsIterator();
        while (iterator.hasNext()) {
            JMSModuleManagedEntity jMSModuleManagedEntity = (JMSModuleManagedEntity)iterator.next();
            jMSModuleManagedEntity.destroy();
        }
    }

    public String getEntityName() {
        return this.uDestBean.getName();
    }

    public String getName() {
        return this.name;
    }

    public void prepareChangeOfTargets(List list, DomainMBean domainMBean) throws ModuleException {
        if (domainMBean == null) {
            throw new AssertionError((Object)"Cannot find domain!");
        }
        this.savedTargets = new TargetListSave(list);
        try {
            this.reconcileTargets(domainMBean);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new ModuleException("Rejected targeting change", beanUpdateRejectedException);
        }
    }

    public void activateChangeOfTargets() throws ModuleException {
        try {
            this.activateTargetUpdates(true);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new ModuleException("Rejected targeting change", beanUpdateRejectedException);
        }
    }

    public void rollbackChangeOfTargets() {
        try {
            this.activateTargetUpdates(false);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new AssertionError((Object)("Rejected targeting change" + (Object)((Object)beanUpdateRejectedException)));
        }
    }

    public void prepare() throws ModuleException {
        if (instances.contains(this)) {
            return;
        }
        instances.add(this);
        Iterator iterator = this.preparedDestinationsIterator();
        while (iterator.hasNext()) {
            JMSModuleManagedEntity jMSModuleManagedEntity = (JMSModuleManagedEntity)iterator.next();
            jMSModuleManagedEntity.prepare();
        }
        if (this.udd != null) {
            this.udd.prepare();
        }
    }

    public void remove() throws ModuleException {
        Iterator iterator = this.activeDestinationsIterator();
        while (iterator.hasNext()) {
            JMSModuleManagedEntity jMSModuleManagedEntity = (JMSModuleManagedEntity)iterator.next();
            jMSModuleManagedEntity.remove();
        }
        if (this.udd != null) {
            this.udd.remove();
        }
    }

    public void unprepare() throws ModuleException {
        JMSModuleManagedEntity jMSModuleManagedEntity;
        Iterator iterator = this.preparedDestinationsIterator();
        while (iterator.hasNext()) {
            jMSModuleManagedEntity = (JMSModuleManagedEntity)iterator.next();
            jMSModuleManagedEntity.unprepare();
        }
        iterator = this.activeDestinationsIterator();
        while (iterator.hasNext()) {
            jMSModuleManagedEntity = (JMSModuleManagedEntity)iterator.next();
            jMSModuleManagedEntity.unprepare();
        }
        instances.remove(this);
        if (this.udd != null) {
            this.udd.unprepare();
        }
    }

    public void setIncompleteWorkExpirationTime(int n) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setIncompleteWorkExpirationTime(n);
        }
    }

    public void setUnitOfWorkHandlingPolicy(String string) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setUnitOfWorkHandlingPolicy(string);
        }
    }

    public void setAttachSender(String string) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setAttachSender(string);
        }
    }

    public void setConsumptionPausedAtStartup(boolean bl) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setConsumptionPausedAtStartup(bl);
        }
    }

    public QueueBean[] getQueues() {
        LinkedList<SyntheticDestinationBean> linkedList = new LinkedList<SyntheticDestinationBean>();
        for (SyntheticDestinationBean syntheticDestinationBean : this.destinationBeans.values()) {
            if (!(syntheticDestinationBean instanceof SyntheticQueueBean)) continue;
            linkedList.add(syntheticDestinationBean);
        }
        return linkedList.toArray(new QueueBean[0]);
    }

    public TopicBean[] getTopics() {
        LinkedList<SyntheticDestinationBean> linkedList = new LinkedList<SyntheticDestinationBean>();
        for (SyntheticDestinationBean syntheticDestinationBean : this.destinationBeans.values()) {
            if (!(syntheticDestinationBean instanceof SyntheticTopicBean)) continue;
            linkedList.add(syntheticDestinationBean);
        }
        return linkedList.toArray(new TopicBean[0]);
    }

    public TopicBean lookupTopic(String string) {
        Object v = this.destinationBeans.get(string);
        if (!(v instanceof TopicBean)) {
            return null;
        }
        return (TopicBean)v;
    }

    public QueueBean lookupQueue(String string) {
        Object v = this.destinationBeans.get(string);
        if (!(v instanceof QueueBean)) {
            return null;
        }
        return (QueueBean)v;
    }

    public void setDestinationKeys(String[] stringArray) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setDestinationKeys(stringArray);
        }
    }

    public void setJMSCreateDestinationIdentifier(String string) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            if (string == null) {
                bEDestinationRuntimeDelegate.getManagedDestination().setJMSCreateDestinationIdentifier(null);
                continue;
            }
            String string2 = JMSModuleHelper.uddMakeName(this.name, string);
            bEDestinationRuntimeDelegate.getManagedDestination().setJMSCreateDestinationIdentifier(string2);
        }
    }

    public void setInsertionPausedAtStartup(boolean bl) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setInsertionPausedAtStartup(bl);
        }
    }

    public void setJNDIName(String string) {
        JMSServerRuntimeMBean[] jMSServerRuntimeMBeanArray;
        this.udd.setJNDIName(string);
        for (JMSServerRuntimeMBean jMSServerRuntimeMBean : jMSServerRuntimeMBeanArray = JMSService.getJMSService().getJMSServers()) {
            String string2 = jMSServerRuntimeMBean.getName();
            if (!this.activeTargetedServers.containsKey(string2)) continue;
            JMSModuleManagedEntity jMSModuleManagedEntity = this.findDestinationEntity(string2);
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)jMSModuleManagedEntity;
            String string3 = string == null ? null : JMSModuleHelper.uddMakeName(string2, string);
            if (bEDestinationRuntimeDelegate == null) continue;
            bEDestinationRuntimeDelegate.getManagedDestination().setJNDIName(string3);
        }
    }

    UniformDistributedDestinationBean getUDestBean() {
        return this.uDestBean;
    }

    SyntheticDDBean getDDBean() {
        return this.ddBean;
    }

    public void setLocalJNDIName(String string) {
        for (String string2 : this.activeTargetedServers.values()) {
            JMSModuleManagedEntity jMSModuleManagedEntity = this.findDestinationEntity(string2);
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)jMSModuleManagedEntity;
            String string3 = string == null ? null : JMSModuleHelper.uddMakeName(string2, string);
            bEDestinationRuntimeDelegate.getManagedDestination().setJNDIName(string3);
        }
    }

    public void setMaximumMessageSize(int n) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setMaximumMessageSize(n);
        }
    }

    public void setMessagingPerformancePreference(int n) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setMessagingPerformancePreference(n);
        }
    }

    public void setProductionPausedAtStartup(boolean bl) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setProductionPausedAtStartup(bl);
        }
    }

    public void setQuota(QuotaBean quotaBean) throws BeanUpdateFailedException {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.setQuota(quotaBean);
        }
    }

    public void setTemplate(String string) {
    }

    public void setUnitOfOrderRouting(String string) {
        this.udd.setUnitOfOrderRouting(string);
        this.udd.activateFinished();
    }

    public void setSubDeploymentName(String string) throws BeanUpdateRejectedException {
        this.reconcileTargets(ManagementService.getRuntimeAccess(kernelId).getDomain());
        this.activateTargetUpdates(true);
    }

    public void setForwardDelay(int n) {
        this.udd.setForwardDelay(n);
        this.udd.activateFinished();
    }

    public void setResetDeliveryCountOnForward(boolean bl) {
        this.udd.setResetDeliveryCountOnForward(bl);
        this.udd.activateFinished();
    }

    public void setLoadBalancingPolicy(String string) {
        this.udd.setLoadBalancingPolicy(string);
        this.udd.activateFinished();
    }

    public String getForwardingPolicy() {
        return this.udd.getForwardingPolicy();
    }

    public void setForwardingPolicy(String string) {
        this.udd.setForwardingPolicy(string);
        this.udd.activateFinished();
    }

    public void setBytesHigh(long l) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setBytesHigh(l);
        }
    }

    public void setBytesLow(long l) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setBytesLow(l);
        }
    }

    public void setMessagesHigh(long l) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setMessagesHigh(l);
        }
    }

    public void setMessagesLow(long l) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setMessagesLow(l);
        }
    }

    public void setMessageLoggingEnabled(boolean bl) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setMessageLoggingEnabled(bl);
        }
    }

    public void setMessageLoggingFormat(String string) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setMessageLoggingFormat(string);
        }
    }

    public void setDeliveryMode(String string) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setDeliveryMode(string);
        }
    }

    public void setTimeToDeliver(String string) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setTimeToDeliver(string);
        }
    }

    public void setTimeToLive(long l) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setTimeToLive(l);
        }
    }

    public void setPriority(int n) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setPriority(n);
        }
    }

    public void setRedeliveryDelay(long l) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setRedeliveryDelay(l);
        }
    }

    public void setRedeliveryLimit(int n) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setRedeliveryLimit(n);
        }
    }

    public void setErrorDestination(DestinationBean destinationBean) {
        JMSServerRuntimeMBean[] jMSServerRuntimeMBeanArray;
        assert (destinationBean instanceof UniformDistributedDestinationBean);
        for (JMSServerRuntimeMBean jMSServerRuntimeMBean : jMSServerRuntimeMBeanArray = JMSService.getJMSService().getJMSServers()) {
            String string = jMSServerRuntimeMBean.getName();
            if (!this.activeTargetedServers.containsKey(string)) continue;
            JMSModuleManagedEntity jMSModuleManagedEntity = this.findDestinationEntity(string);
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)jMSModuleManagedEntity;
            SyntheticDestinationBean syntheticDestinationBean = (SyntheticDestinationBean)this.destinationBeans.get(JMSModuleHelper.uddMakeName(string, this.name));
            if (jMSModuleManagedEntity == null || syntheticDestinationBean == null) continue;
            bEDestinationRuntimeDelegate.setErrorDestination(syntheticDestinationBean.getErrorDestination());
        }
    }

    public void setExpirationPolicy(String string) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setExpirationPolicy(string);
        }
    }

    public void setExpirationLoggingPolicy(String string) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setExpirationLoggingPolicy(string);
        }
    }

    public void setMulticastAddress(String string) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            ((BETopicImpl)bEDestinationRuntimeDelegate.getManagedDestination()).setMulticastAddress(string);
        }
    }

    public void setMulticastPort(int n) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            ((BETopicImpl)bEDestinationRuntimeDelegate.getManagedDestination()).setMulticastPort(n);
        }
    }

    public void setMulticastTimeToLive(int n) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            ((BETopicImpl)bEDestinationRuntimeDelegate.getManagedDestination()).setMulticastTimeToLive(n);
        }
    }

    public void setSAFExportPolicy(String string) {
        for (BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate : this.destinations.values()) {
            ((BETopicImpl)bEDestinationRuntimeDelegate.getManagedDestination()).setSAFExportPolicy(string);
        }
    }

    public void setDefaultTargetingEnabled(boolean bl) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setDefaultTargetingEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void broadcastChangeToAllUDDs(DomainMBean domainMBean, boolean bl) throws DeploymentException {
        boolean bl2 = false;
        UDDEntity uDDEntity = null;
        try {
            ListIterator listIterator = instances.listIterator();
            while (listIterator.hasNext()) {
                uDDEntity = (UDDEntity)listIterator.next();
                try {
                    if (bl) {
                        uDDEntity.reconcileTargets(domainMBean);
                        continue;
                    }
                    uDDEntity.activateTargetUpdates(true);
                }
                catch (BeanUpdateRejectedException beanUpdateRejectedException) {
                    throw new DeploymentException("Rejected bean update", beanUpdateRejectedException);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            UDDEntity uDDEntity2;
            Object var7_7 = null;
            if (bl2 || !bl) throw throwable;
            ListIterator listIterator = instances.listIterator();
            while (listIterator.hasNext() && (uDDEntity2 = (UDDEntity)listIterator.next()) != uDDEntity) {
                try {
                    uDDEntity2.activateTargetUpdates(false);
                }
                catch (BeanUpdateRejectedException beanUpdateRejectedException) {}
            }
            throw throwable;
        }
    }

    public static void prepareLocalJMSServer(JMSServerMBean jMSServerMBean) throws DeploymentException {
        localJMSServers.put(jMSServerMBean.getName(), jMSServerMBean.getName());
        UDDEntity.broadcastChangeToAllUDDs(JMSBeanHelper.getDomain(jMSServerMBean), true);
    }

    public static void activateLocalJMSServer(JMSServerMBean jMSServerMBean) throws DeploymentException {
        localJMSServers.put(jMSServerMBean.getName(), jMSServerMBean.getName());
        UDDEntity.broadcastChangeToAllUDDs(JMSBeanHelper.getDomain(jMSServerMBean), true);
        UDDEntity.broadcastChangeToAllUDDs(JMSBeanHelper.getDomain(jMSServerMBean), false);
    }

    public static void deactivateLocalJMSServer(JMSServerMBean jMSServerMBean) {
        localJMSServers.remove(jMSServerMBean.getName());
        try {
            UDDEntity.broadcastChangeToAllUDDs(JMSBeanHelper.getDomain(jMSServerMBean), true);
            UDDEntity.broadcastChangeToAllUDDs(JMSBeanHelper.getDomain(jMSServerMBean), false);
        }
        catch (DeploymentException deploymentException) {
            // empty catch block
        }
    }

    public static void unprepareLocalJMSServer(JMSServerMBean jMSServerMBean) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reconcileAddedLocalDestinations(DomainMBean var1_1, HashMap var2_2) throws BeanUpdateRejectedException {
        this.addedLocalDestinations = new LinkedList<E>();
        var3_3 = var2_2.values().iterator();
        var4_4 = new LinkedList<E>();
        var5_5 = new LinkedList<E>();
        var6_6 = false;
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                if (!var3_3.hasNext()) {
                    return;
                }
                var7_7 = (String)var3_3.next();
                if (this.destinations.containsKey(var7_7) || !UDDEntity.isJMSServerLocal(var7_7)) continue;
                this.addedLocalDestinations.add(var7_7);
                this.makeDestination(var7_7, (SyntheticDestinationBean)this.destinationBeans.get(JMSModuleHelper.uddMakeName(var7_7, this.name)));
                var8_8 = this.findDestinationEntity(var7_7);
                try {
                    var8_8.prepare();
                    continue;
                }
                catch (ModuleException var9_9) {
                    throw new BeanUpdateRejectedException("Cannot prepare destination; ", (Throwable)var9_9);
                }
                break;
            }
        }
        catch (Throwable var10_16) {
            var11_11 = null;
            if (!var6_6) {
                var3_3 = var4_4.listIterator();
                while (var3_3.hasNext()) {
                    var12_13 = (JMSModuleManagedEntity)var3_3.next();
                    try {
                        var12_13.unprepare();
                    }
                    catch (ModuleException var13_15) {}
                }
                var3_3 = this.addedLocalDestinations.listIterator();
                while (var3_3.hasNext()) {
                    var12_13 = (String)var3_3.next();
                    this.destinations.remove(var12_13);
                }
                this.addedLocalDestinations = null;
            }
            throw var10_16;
        }
        {
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reconcileAddedMembers(DomainMBean var1_1, HashMap var2_2) throws BeanUpdateRejectedException {
        if (this.preparedTargetedServers == null) {
            this.preparedTargetedServers = new HashMap<K, V>();
        }
        var3_3 = var2_2.values().iterator();
        var4_4 = new LinkedList<String>();
        var5_5 = false;
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                if (!var3_3.hasNext()) {
                    return;
                }
                var6_6 = (String)var3_3.next();
                if (this.activeTargetedServers.containsKey(var6_6)) continue;
                var7_7 = this.addMember(var1_1, var6_6);
                var8_8 = this.findDestinationEntity(var6_6);
                if (var8_8 == null || this.preparedTargetedServers.containsKey(var6_6)) continue;
                try {
                    var8_8.prepare();
                    var4_4.add(var6_6);
                    this.preparedTargetedServers.put(var6_6, var6_6);
                    continue;
                }
                catch (ModuleException var9_9) {
                    throw new BeanUpdateRejectedException("Cannot prepare destination; ", (Throwable)var9_9);
                }
                break;
            }
        }
        catch (Throwable var10_18) {
            var11_11 = null;
            if (!var5_5) {
                var3_3 = var4_4.listIterator();
                while (var3_3.hasNext()) {
                    var12_13 = (String)var3_3.next();
                    var13_15 = this.findDestinationEntity(var12_13);
                    try {
                        var13_15.unprepare();
                        this.removeMember(var12_13);
                        this.preparedTargetedServers.remove(var12_13);
                    }
                    catch (ModuleException var14_17) {}
                }
            }
            throw var10_18;
        }
        {
            ** while (true)
        }
    }

    private void reconcileSubtractedMembers(HashMap hashMap) {
        this.preparedForRemovalTargetedServers = new LinkedList();
        for (String string : this.activeTargetedServers.values()) {
            if (hashMap.containsKey(string)) continue;
            SyntheticMemberBean syntheticMemberBean = this.ddBean.findMemberBean(string);
            this.preparedForRemovalTargetedServers.add(string);
        }
    }

    private void reconcileTargets(DomainMBean domainMBean) throws BeanUpdateRejectedException {
        HashMap hashMap = new HashMap();
        if (this.reconciled) {
            return;
        }
        this.reconciled = true;
        this.fillWithMyTargets(domainMBean, hashMap, this.savedTargets.restoreTargets(domainMBean));
        this.reconcileAddedMembers(domainMBean, hashMap);
        this.reconcileAddedLocalDestinations(domainMBean, hashMap);
        this.reconcileSubtractedMembers(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateAddedLocalDestinations(boolean bl) throws BeanUpdateRejectedException {
        block13: {
            ListIterator listIterator;
            if (this.addedLocalDestinations == null) {
                return;
            }
            LinkedList<JMSModuleManagedEntity> linkedList = new LinkedList<JMSModuleManagedEntity>();
            try {
                ListIterator listIterator2 = this.addedLocalDestinations.listIterator();
                while (listIterator2.hasNext()) {
                    String string = (String)listIterator2.next();
                    if (!bl) {
                        this.destinations.remove(string);
                        continue;
                    }
                    JMSModuleManagedEntity jMSModuleManagedEntity = this.findDestinationEntity(string);
                    try {
                        jMSModuleManagedEntity.activate(null);
                        linkedList.add(jMSModuleManagedEntity);
                    }
                    catch (ModuleException moduleException) {
                        throw new BeanUpdateRejectedException("activate failed", (Throwable)((Object)moduleException));
                    }
                }
                this.addedLocalDestinations = null;
                Object var8_7 = null;
                if (this.addedLocalDestinations == null) break block13;
                listIterator = linkedList.listIterator();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (this.addedLocalDestinations != null) {
                    ListIterator listIterator3 = linkedList.listIterator();
                    while (listIterator3.hasNext()) {
                        JMSModuleManagedEntity jMSModuleManagedEntity = (JMSModuleManagedEntity)listIterator3.next();
                        try {
                            jMSModuleManagedEntity.deactivate();
                        }
                        catch (ModuleException moduleException) {}
                    }
                }
                throw throwable;
            }
            while (listIterator.hasNext()) {
                JMSModuleManagedEntity jMSModuleManagedEntity = (JMSModuleManagedEntity)listIterator.next();
                try {
                    jMSModuleManagedEntity.deactivate();
                }
                catch (ModuleException moduleException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateAddedMembers(boolean bl) throws BeanUpdateRejectedException {
        block19: {
            ListIterator listIterator;
            if (this.preparedTargetedServers == null) {
                return;
            }
            LinkedList<JMSModuleManagedEntity> linkedList = new LinkedList<JMSModuleManagedEntity>();
            try {
                for (String string : this.preparedTargetedServers.values()) {
                    SyntheticMemberBean syntheticMemberBean = this.ddBean.findMemberBean(string);
                    JMSModuleManagedEntity jMSModuleManagedEntity = this.findDestinationEntity(string);
                    if (!bl) {
                        this.removeMember(string);
                        if (jMSModuleManagedEntity != null) {
                            try {
                                jMSModuleManagedEntity.unprepare();
                            }
                            catch (ModuleException moduleException) {
                                throw new AssertionError((Object)"Unprepare failed");
                            }
                        }
                    } else {
                        if (jMSModuleManagedEntity != null) {
                            try {
                                jMSModuleManagedEntity.activate(null);
                                linkedList.add(jMSModuleManagedEntity);
                            }
                            catch (ModuleException moduleException) {
                                throw new BeanUpdateRejectedException("activate failed", (Throwable)((Object)moduleException));
                            }
                        }
                        this.activeTargetedServers.put(string, string);
                    }
                    if (this.isQueue) {
                        this.udd.finishAddDistributedQueueMembers(syntheticMemberBean, bl);
                        continue;
                    }
                    this.udd.finishAddDistributedTopicMembers(syntheticMemberBean, bl);
                }
                this.preparedTargetedServers = null;
                Object var9_9 = null;
                if (this.preparedTargetedServers == null) break block19;
                listIterator = linkedList.listIterator();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (this.preparedTargetedServers != null) {
                    ListIterator listIterator2 = linkedList.listIterator();
                    while (listIterator2.hasNext()) {
                        JMSModuleManagedEntity jMSModuleManagedEntity = (JMSModuleManagedEntity)listIterator2.next();
                        try {
                            jMSModuleManagedEntity.deactivate();
                        }
                        catch (ModuleException moduleException) {}
                    }
                }
                throw throwable;
            }
            while (listIterator.hasNext()) {
                JMSModuleManagedEntity jMSModuleManagedEntity = (JMSModuleManagedEntity)listIterator.next();
                try {
                    jMSModuleManagedEntity.deactivate();
                }
                catch (ModuleException moduleException) {}
            }
        }
    }

    private void activateSubtractedMembers(boolean bl) throws BeanUpdateRejectedException {
        if (this.preparedForRemovalTargetedServers == null) {
            return;
        }
        ListIterator listIterator = this.preparedForRemovalTargetedServers.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            SyntheticMemberBean syntheticMemberBean = this.ddBean.findMemberBean(string);
            if (bl) {
                JMSModuleManagedEntity jMSModuleManagedEntity = this.findDestinationEntity(string);
                this.removeMember(string);
                if (jMSModuleManagedEntity != null) {
                    try {
                        jMSModuleManagedEntity.deactivate();
                        jMSModuleManagedEntity.destroy();
                        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
                        if (domainMBean.lookupJMSServer(string) == null) {
                            jMSModuleManagedEntity.remove();
                        }
                        jMSModuleManagedEntity.unprepare();
                    }
                    catch (ModuleException moduleException) {
                        throw new BeanUpdateRejectedException("Cannot bring down UDD member for " + string, (Throwable)((Object)moduleException));
                    }
                }
                this.activeTargetedServers.remove(string);
            }
            if (this.isQueue) {
                this.udd.finishRemoveDistributedQueueMembers(syntheticMemberBean, bl);
                continue;
            }
            this.udd.finishRemoveDistributedTopicMembers(syntheticMemberBean, bl);
        }
        this.preparedForRemovalTargetedServers = null;
    }

    private void activateSubtractedLocalDestinations() throws BeanUpdateRejectedException {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        Iterator iterator = this.destinations.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JMSModuleManagedEntity jMSModuleManagedEntity = this.findDestinationEntity(string);
            if (UDDEntity.isJMSServerLocal(string)) continue;
            try {
                jMSModuleManagedEntity.deactivate();
                jMSModuleManagedEntity.destroy();
                if (domainMBean.lookupJMSServer(string) == null) {
                    jMSModuleManagedEntity.remove();
                }
                jMSModuleManagedEntity.unprepare();
            }
            catch (ModuleException moduleException) {
                throw new BeanUpdateRejectedException("destroy failed", (Throwable)((Object)moduleException));
            }
            iterator.remove();
        }
    }

    private void activateTargetUpdates(boolean bl) throws BeanUpdateRejectedException {
        if (this.reconciled) {
            this.activateAddedLocalDestinations(bl);
            this.activateAddedMembers(bl);
            this.activateSubtractedMembers(bl);
            this.activateSubtractedLocalDestinations();
            this.udd.activateFinished();
            this.reconciled = false;
        }
    }

    private boolean onlyRemoteNewJMSServers(DomainMBean domainMBean) {
        HashMap hashMap = new HashMap();
        this.fillWithMyTargets(domainMBean, hashMap, this.savedTargets.restoreTargets(domainMBean));
        boolean bl = false;
        for (String string : hashMap.values()) {
            if (this.activeTargetedServers.containsKey(string)) continue;
            bl = true;
            if (!UDDEntity.isJMSServerLocal(string)) continue;
            return false;
        }
        for (String string : this.activeTargetedServers.values()) {
            if (hashMap.containsKey(string)) continue;
            bl = true;
        }
        return bl;
    }

    public void prepareUpdate(DomainMBean domainMBean, TargetMBean targetMBean, int n, boolean bl) throws BeanUpdateRejectedException {
        if (!this.onlyRemoteNewJMSServers(domainMBean)) {
            return;
        }
        this.reconcileTargets(domainMBean);
    }

    public void rollbackUpdate() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        if (!this.onlyRemoteNewJMSServers(domainMBean)) {
            return;
        }
        try {
            this.activateTargetUpdates(false);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new AssertionError((Object)"activateTargetUpdates failed");
        }
    }

    public void activateUpdate() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        if (!this.onlyRemoteNewJMSServers(domainMBean)) {
            return;
        }
        try {
            this.activateTargetUpdates(true);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new AssertionError((Object)"activateTargetUpdates failed");
        }
    }

    public void startAddTargets(TargetMBean targetMBean) throws BeanUpdateRejectedException {
        this.reconcileTargets(JMSBeanHelper.getDomain(targetMBean));
    }

    public void finishAddTargets(TargetMBean targetMBean, boolean bl) throws BeanUpdateRejectedException {
        this.activateTargetUpdates(bl);
    }

    public void startRemoveTargets(TargetMBean targetMBean) throws BeanUpdateRejectedException {
        this.reconcileTargets(JMSBeanHelper.getDomain(targetMBean));
    }

    public void finishRemoveTargets(TargetMBean targetMBean, boolean bl) throws BeanUpdateRejectedException {
        this.activateTargetUpdates(bl);
    }

    public void setDefaultUnitOfOrder(boolean bl) {
        Iterator iterator = this.allDestinationsIterator();
        while (iterator.hasNext()) {
            BEDestinationRuntimeDelegate bEDestinationRuntimeDelegate = (BEDestinationRuntimeDelegate)iterator.next();
            bEDestinationRuntimeDelegate.getManagedDestination().setDefaultUnitOfOrder(bl);
        }
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        uDQueueBeanSignatures = new HashMap();
        uDTopicBeanSignatures = new HashMap();
        targetSignatures = new HashMap();
        targetSignatures.put("Targets", TargetMBean.class);
        for (Map.Entry entry : JMSBeanHelper.distributedTopicBeanSignatures.entrySet()) {
            uDTopicBeanSignatures.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : JMSBeanHelper.distributedQueueBeanSignatures.entrySet()) {
            uDQueueBeanSignatures.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : JMSBeanHelper.destinationBeanSignatures.entrySet()) {
            uDQueueBeanSignatures.put(entry.getKey(), entry.getValue());
            uDTopicBeanSignatures.put(entry.getKey(), entry.getValue());
        }
    }
}

