/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.bridge.internal;

import java.util.Enumeration;
import java.util.Properties;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.jms.JMSLogger;
import weblogic.management.ManagementException;
import weblogic.management.configuration.BridgeDestinationCommonMBean;
import weblogic.management.configuration.BridgeDestinationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSBridgeDestinationMBean;
import weblogic.management.configuration.MessagingBridgeMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;

public class BridgeConfigUpdater
implements ConfigurationProcessor {
    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        try {
            int n;
            MessagingBridgeMBean[] messagingBridgeMBeanArray = domainMBean.getMessagingBridges();
            for (n = 0; messagingBridgeMBeanArray != null && n < messagingBridgeMBeanArray.length; ++n) {
                this.updateMessagingBridge(domainMBean, messagingBridgeMBeanArray[n]);
            }
            BridgeDestinationMBean[] bridgeDestinationMBeanArray = domainMBean.getBridgeDestinations();
            for (n = 0; bridgeDestinationMBeanArray != null && n < bridgeDestinationMBeanArray.length; ++n) {
                this.updateBridgeDestination(domainMBean, bridgeDestinationMBeanArray[n]);
            }
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UpdateException(invalidAttributeValueException);
        }
        catch (ManagementException managementException) {
            throw new UpdateException(managementException);
        }
    }

    private void updateMessagingBridge(DomainMBean domainMBean, MessagingBridgeMBean messagingBridgeMBean) throws InvalidAttributeValueException, ManagementException {
        BridgeDestinationCommonMBean bridgeDestinationCommonMBean;
        BridgeDestinationCommonMBean bridgeDestinationCommonMBean2 = messagingBridgeMBean.getSourceDestination();
        if (bridgeDestinationCommonMBean2 != null && bridgeDestinationCommonMBean2 instanceof BridgeDestinationMBean) {
            messagingBridgeMBean.setSourceDestination(null);
            this.updateBridgeDestination(domainMBean, (BridgeDestinationMBean)bridgeDestinationCommonMBean2);
            messagingBridgeMBean.setSourceDestination(this.updateBridgeDestination(domainMBean, (BridgeDestinationMBean)bridgeDestinationCommonMBean2));
        }
        if ((bridgeDestinationCommonMBean = messagingBridgeMBean.getTargetDestination()) != null && bridgeDestinationCommonMBean instanceof BridgeDestinationMBean) {
            messagingBridgeMBean.setTargetDestination(null);
            this.updateBridgeDestination(domainMBean, (BridgeDestinationMBean)bridgeDestinationCommonMBean);
            messagingBridgeMBean.setTargetDestination(this.updateBridgeDestination(domainMBean, (BridgeDestinationMBean)bridgeDestinationCommonMBean));
        }
    }

    private BridgeDestinationCommonMBean updateBridgeDestination(DomainMBean domainMBean, BridgeDestinationMBean bridgeDestinationMBean) throws InvalidAttributeValueException, ManagementException {
        JMSBridgeDestinationMBean jMSBridgeDestinationMBean = domainMBean.lookupJMSBridgeDestination(bridgeDestinationMBean.getName());
        if (jMSBridgeDestinationMBean != null) {
            this.destroyOldBean(domainMBean, bridgeDestinationMBean);
            return jMSBridgeDestinationMBean;
        }
        JMSLogger.logReplacingBridgeDestinationMBean((String)bridgeDestinationMBean.getName());
        jMSBridgeDestinationMBean = domainMBean.createJMSBridgeDestination(bridgeDestinationMBean.getName());
        if (bridgeDestinationMBean.getAdapterJNDIName() != null) {
            jMSBridgeDestinationMBean.setAdapterJNDIName(bridgeDestinationMBean.getAdapterJNDIName());
        }
        if (bridgeDestinationMBean.getUserName() != null) {
            jMSBridgeDestinationMBean.setUserName(bridgeDestinationMBean.getUserName());
        }
        if (bridgeDestinationMBean.getUserPassword() != null) {
            jMSBridgeDestinationMBean.setUserPassword(bridgeDestinationMBean.getUserPassword());
        }
        if (bridgeDestinationMBean.getClasspath() != null) {
            jMSBridgeDestinationMBean.setClasspath(bridgeDestinationMBean.getClasspath());
        }
        Properties properties = bridgeDestinationMBean.getProperties();
        int n = 0;
        if (properties != null && properties.size() != 0) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if (string.equalsIgnoreCase("ConnectionFactoryJNDI") || string.equalsIgnoreCase("ConnectionFactoryJNDIName")) {
                    jMSBridgeDestinationMBean.setConnectionFactoryJNDIName(string2);
                    ++n;
                    continue;
                }
                if (string.equalsIgnoreCase("ConnectionURL")) {
                    jMSBridgeDestinationMBean.setConnectionURL(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("InitialContextFactory")) {
                    jMSBridgeDestinationMBean.setInitialContextFactory(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("DestinationJNDI") || string.equalsIgnoreCase("DestinationJNDIName")) {
                    jMSBridgeDestinationMBean.setDestinationJNDIName(string2);
                    ++n;
                    continue;
                }
                if (!string.equalsIgnoreCase("DestinationType")) continue;
                jMSBridgeDestinationMBean.setDestinationType(string2);
            }
        }
        if (n < 2) {
            domainMBean.destroyJMSBridgeDestination(jMSBridgeDestinationMBean);
            return bridgeDestinationMBean;
        }
        this.destroyOldBean(domainMBean, bridgeDestinationMBean);
        return jMSBridgeDestinationMBean;
    }

    private void destroyOldBean(DomainMBean domainMBean, BridgeDestinationMBean bridgeDestinationMBean) {
        try {
            domainMBean.destroyBridgeDestination(bridgeDestinationMBean);
        }
        catch (BeanRemoveRejectedException beanRemoveRejectedException) {
            // empty catch block
        }
    }
}

