/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.bridge.internal;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import weblogic.cluster.migration.Migratable;
import weblogic.cluster.migration.MigrationException;
import weblogic.jms.BridgeLogger;
import weblogic.jms.BridgeService;
import weblogic.jms.bridge.AdapterConnection;
import weblogic.jms.bridge.AdapterConnectionFactory;
import weblogic.jms.bridge.AdapterMetaData;
import weblogic.jms.bridge.ConnectionSpec;
import weblogic.jms.bridge.LocalTransaction;
import weblogic.jms.bridge.ResourceTransactionRolledBackException;
import weblogic.jms.bridge.SourceConnection;
import weblogic.jms.bridge.TargetConnection;
import weblogic.jms.bridge.internal.BridgeDebug;
import weblogic.jms.bridge.internal.MessagingBridgeConfigurationException;
import weblogic.jms.bridge.internal.MessagingBridgeException;
import weblogic.jndi.Environment;
import weblogic.management.ManagementException;
import weblogic.management.configuration.BridgeDestinationCommonMBean;
import weblogic.management.configuration.BridgeDestinationMBean;
import weblogic.management.configuration.BridgeLegalHelper;
import weblogic.management.configuration.JMSBridgeDestinationMBean;
import weblogic.management.configuration.MessagingBridgeMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.MessagingBridgeRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.utils.GenericBeanListener;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManager;

public final class MessagingBridge
extends RuntimeMBeanDelegate
implements Runnable,
MessageListener,
ExceptionListener,
Migratable,
MessagingBridgeRuntimeMBean,
TimerListener {
    static final long serialVersionUID = 289399667450808114L;
    private static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private static final int STATE_INITIALIZING = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_STARTED = 2;
    private static final int STATE_CONNECTED = 3;
    private static final int STATE_RUNNING = 4;
    private static final int STATE_CONTINUE = 5;
    private static final int STATE_STOPPING = 6;
    private static final int STATE_STOPPED = 7;
    private static final int STATE_TOBESTARTED = 8;
    private static final int STATE_RESTARTING = 9;
    private static final int STATE_SHUTTING_DOWN = 10;
    private static final int STATE_CLOSED = 11;
    private static final int STATE_SUSPENDED = 12;
    private static final int TRANSACTION_MODE_NONE = 1;
    private static final int TRANSACTION_MODE_LOCAL = 2;
    private static final int TRANSACTION_MODE_XARESOURCE = 3;
    private static final int QOS_EXACTLY_ONCE = 0;
    private static final int QOS_DUP_OKAY = 1;
    private static final int QOS_ATMOST_ONCE = 2;
    private static final int POLICY_AUTO = 0;
    private static final int POLICY_SCHEDULED = 1;
    private static final int POLICY_MANUAL = 2;
    private static final int MAX_BATCHES_TO_PROCESS = 10;
    private static final int SCANUNIT_INTERNAL = 1000;
    private static final int AUTO_ACK_IGNORE_XA = 99;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String targetAdapterJndi;
    private Properties sourceProps;
    private AdapterMetaData sourceMetaData;
    private String sourceAdapterJndi;
    private Properties targetProps;
    private AdapterMetaData targetMetaData;
    private AdapterConnectionFactory sourceAdapterFactory;
    private ConnectionSpec sourceConnSpec;
    private SourceConnection sourceConn;
    private AdapterConnectionFactory targetAdapterFactory;
    private TargetConnection targetConn;
    private ConnectionSpec targetConnSpec;
    private MessagingBridgeMBean mbean;
    private int qos;
    private int forwardingPolicy;
    private boolean qosDegradAllowed;
    private boolean asyncEnabled = true;
    private boolean durabilityEnabled = true;
    private int transactionTimeout;
    private long maximumIdleTime;
    private String selector;
    private String scheduleTime;
    private boolean preserveMsgProperty;
    private int batchSize;
    private long batchInterval;
    private boolean idle;
    private boolean async;
    private boolean xaSupported;
    private boolean sourceXASupported;
    private boolean localTXSupported;
    private boolean stopped;
    private static final int EXACTLY_ONCE = 4;
    private static final int DUPLICATE_OKAY_LOCAL_TX = 3;
    private static final int DUPLICATE_OKAY_ACK = 2;
    private static final int DUPLICATE_OKAY_XA = 1;
    private static final int ATMOST_ONCE = 0;
    private int workMode;
    private RetryTimeController retryController;
    private boolean running;
    private boolean logBeginForwarding;
    private WorkManager workManager;
    private Context ctx;
    private TransactionManager tm;
    private BridgeService bridgeService;
    private static final long RELOOKUP_ADAPTERS_MILLISECONDS = 10000L;
    private long scanUnit = 1000L;
    private long lookupRetryTimeCurrent;
    private long connRetryTimeCurrent;
    private long connRetryTimeNext;
    private long onMessageIdleCurrent;
    private int logCount;
    private long flushingTime;
    private int state;
    private boolean sameMessageFormat;
    int health = 0;
    private ArrayList reasons = new ArrayList();
    private String[] stateCache = new String[2];
    private ClassLoader savedClassLoader;
    private static final String EOL = MessagingBridge.getEOL();
    private static final HashMap bridgeSignatures = new HashMap();
    private TimerManager timerManager;
    private Timer timer;
    private boolean lookupAdapterRetry = false;
    GenericBeanListener bridgeListener;
    private int count = 0;

    public MessagingBridge(MessagingBridgeMBean messagingBridgeMBean, BridgeService bridgeService) throws ManagementException {
        super(messagingBridgeMBean.getName());
        this.mbean = messagingBridgeMBean;
        this.bridgeService = bridgeService;
        this.state = 0;
        TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
        this.timerManager = timerManagerFactory.getDefaultTimerManager();
        this.timer = this.timerManager.scheduleAtFixedRate((TimerListener)this, 0L, this.scanUnit);
        this.retryController = new RetryTimeController();
        this.logBeginForwarding = true;
        this.health = 0;
        this.reasons.add(0, "Created but not yet active.");
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().setMessagingBridgeRuntime(this);
        Thread thread2 = Thread.currentThread();
        this.savedClassLoader = thread2.getContextClassLoader();
    }

    public void initialize() throws MessagingBridgeException {
        Object object;
        Object object2;
        Object object3;
        BridgeDestinationCommonMBean bridgeDestinationCommonMBean = this.mbean.getSourceDestination();
        if (bridgeDestinationCommonMBean == null) {
            BridgeLogger.logErrorNoSource((String)this.name);
            throw new MessagingBridgeConfigurationException("A messaging bridge must have a source destination configured");
        }
        this.sourceAdapterJndi = bridgeDestinationCommonMBean.getAdapterJNDIName();
        if (bridgeDestinationCommonMBean instanceof JMSBridgeDestinationMBean) {
            object3 = (JMSBridgeDestinationMBean)bridgeDestinationCommonMBean;
            if (!(object3.getConnectionURL() != null && object3.getConnectionURL().length() != 0 || object3.getInitialContextFactory().equals(JNDI_FACTORY))) {
                BridgeLogger.logErrorInvalidURL((String)object3.getName());
                throw new MessagingBridgeConfigurationException("A bridge destination's connection URL cannot be null if the initial context factory is not weblogic.jndi.WLInitialContextFactory");
            }
            if (object3.getConnectionFactoryJNDIName() == null || object3.getDestinationJNDIName() == null) {
                BridgeLogger.logErrorNeedsJNDINames((String)object3.getName());
                throw new MessagingBridgeConfigurationException("A bridge destination for JMS has to have a connection factory JNDI name and a destination JNDI name configured.");
            }
            this.sourceProps = BridgeLegalHelper.createProperties(((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean).getConnectionURL(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean).getInitialContextFactory(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean).getConnectionFactoryJNDIName(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean).getDestinationJNDIName(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean).getDestinationType());
        } else {
            this.sourceProps = this.copyProperties(((BridgeDestinationMBean)bridgeDestinationCommonMBean).getProperties());
        }
        if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
            object3 = new String();
            object3 = (String)object3 + EOL + "  AdapterJNDIName=" + this.sourceAdapterJndi;
            object3 = (String)object3 + EOL + "  Classpath=" + bridgeDestinationCommonMBean.getClasspath();
            object2 = this.sourceProps.propertyNames();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                object3 = (String)object3 + EOL + "  " + (String)object + " = " + this.sourceProps.get(object);
            }
            BridgeDebug.MessagingBridgeStartup.debug("Bridge " + this.name + "'s source configurations are:" + (String)object3 + EOL);
        }
        if ((object3 = this.mbean.getTargetDestination()) == null) {
            BridgeLogger.logErrorNoTarget((String)this.name);
            throw new MessagingBridgeConfigurationException("A messaging bridge must have a target destination configured");
        }
        this.targetAdapterJndi = object3.getAdapterJNDIName();
        if (object3 instanceof JMSBridgeDestinationMBean) {
            object2 = (JMSBridgeDestinationMBean)object3;
            if (!(object2.getConnectionURL() != null && object2.getConnectionURL().length() != 0 || object2.getInitialContextFactory().equals(JNDI_FACTORY))) {
                BridgeLogger.logErrorInvalidURL((String)object2.getName());
                throw new MessagingBridgeConfigurationException("A bridge destination's connection URL cannot be null if the initial context factory is not weblogic.jndi.WLInitialContextFactory");
            }
            if (object2.getConnectionFactoryJNDIName() == null || object2.getDestinationJNDIName() == null) {
                BridgeLogger.logErrorNeedsJNDINames((String)object2.getName());
                throw new MessagingBridgeConfigurationException("A bridge destination for JMS has to have a connection factory  JNDI name and a destination JNDI name configured.");
            }
            this.targetProps = BridgeLegalHelper.createProperties(((JMSBridgeDestinationMBean)object3).getConnectionURL(), ((JMSBridgeDestinationMBean)object3).getInitialContextFactory(), ((JMSBridgeDestinationMBean)object3).getConnectionFactoryJNDIName(), ((JMSBridgeDestinationMBean)object3).getDestinationJNDIName(), ((JMSBridgeDestinationMBean)object3).getDestinationType());
        } else {
            this.targetProps = this.copyProperties(((BridgeDestinationMBean)object3).getProperties());
        }
        if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
            object2 = new String();
            object2 = (String)object2 + EOL + "  AdapterJNDIName=" + this.targetAdapterJndi;
            object2 = (String)object2 + EOL + "  Classpath=" + object3.getClasspath();
            object = this.targetProps.propertyNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                object2 = (String)object2 + EOL + "  " + string + " = " + this.targetProps.get(string);
            }
            BridgeDebug.MessagingBridgeStartup.debug("Bridge " + this.name + "'s target configurations are:" + (String)object2 + EOL);
        }
        if (!BridgeLegalHelper.notSameDestinations(this.sourceProps, this.targetProps)) {
            BridgeLogger.logErrorSameSourceTarget((String)this.name);
            throw new MessagingBridgeConfigurationException("A messaging bridge's source destination cannot be the same as the target destination.");
        }
        this.stopped = !this.mbean.isStarted();
        this.asyncEnabled = this.mbean.isAsyncEnabled();
        this.durabilityEnabled = this.mbean.isDurabilityEnabled();
        long l = this.mbean.getReconnectDelayMinimum() * 1000;
        long l2 = this.mbean.getReconnectDelayMaximum() * 1000;
        long l3 = this.mbean.getReconnectDelayIncrease() * 1000;
        this.transactionTimeout = this.mbean.getTransactionTimeout();
        this.maximumIdleTime = this.mbean.getIdleTimeMaximum() * 1000;
        if (this.transactionTimeout <= 0) {
            this.transactionTimeout = 1;
        }
        if (l > l2) {
            l2 = l;
        }
        this.retryController.init(l, l3, l2);
        this.qosDegradAllowed = this.mbean.isQOSDegradationAllowed();
        this.selector = this.mbean.getSelector();
        this.batchSize = this.mbean.getBatchSize();
        this.batchInterval = this.mbean.getBatchInterval();
        this.flushingTime = this.batchInterval < 0L ? (long)(800 * this.transactionTimeout) : this.batchInterval;
        this.scheduleTime = this.mbean.getScheduleTime();
        this.preserveMsgProperty = this.mbean.getPreserveMsgProperty();
        String string = this.mbean.getForwardingPolicy();
        if (string == null) {
            this.forwardingPolicy = 0;
        } else if (string.equalsIgnoreCase("AUTOMATIC")) {
            this.forwardingPolicy = 0;
        } else if (string.equalsIgnoreCase("MANUAL")) {
            this.forwardingPolicy = 2;
        } else if (string.equalsIgnoreCase("SCHEDULED")) {
            this.forwardingPolicy = 1;
        }
        String string2 = this.mbean.getQualityOfService();
        if (string2 == null) {
            this.qos = 0;
        } else if (string2.equalsIgnoreCase("EXACTLY-ONCE")) {
            this.qos = 0;
        } else if (string2.equalsIgnoreCase("DUPLICATE-OKAY")) {
            this.qos = 1;
        } else if (string2.equalsIgnoreCase("ATMOST-ONCE")) {
            this.qos = 2;
        }
        this.bridgeListener = new GenericBeanListener(this.mbean, this, bridgeSignatures);
        this.state = 1;
        if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeStartup.debug("Bridge " + this.name + " is successfully initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws MessagingBridgeException {
        Object object = this;
        synchronized (object) {
            if (this.state != 1 && this.state != 12) {
                throw new MessagingBridgeException("Failed to initialize bridge " + this.name);
            }
        }
        this.workManager = this.bridgeService.getWorkManager();
        if (!this.bridgeService.findAdapterAndRegister(this.sourceAdapterJndi, this)) {
            if (this.lookupAdapterRetry) {
                BridgeLogger.logWarningAdapterNotFound((String)this.name, (String)this.sourceAdapterJndi);
                object = this.reasons;
                synchronized (object) {
                    this.health = 1;
                    this.reasons.add(0, "WARN: Failed to find the source adapter.");
                }
            } else {
                this.lookupAdapterRetry = true;
            }
            return;
        }
        if (!this.bridgeService.findAdapterAndRegister(this.targetAdapterJndi, this)) {
            BridgeLogger.logWarningAdapterNotFound((String)this.name, (String)this.targetAdapterJndi);
            object = this.reasons;
            synchronized (object) {
                this.health = 1;
                this.reasons.add(0, "WARN: Failed to find the target adapter.");
            }
            return;
        }
        object = this.reasons;
        synchronized (object) {
            this.health = 0;
            this.reasons.add(0, "Found both of the adapters and making the connections");
        }
        try {
            this.ctx = MessagingBridge.getContext();
        }
        catch (NamingException namingException) {
            throw new MessagingBridgeException("Failed to get initial context");
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = this.timerManager.scheduleAtFixedRate((TimerListener)this, 0L, this.scanUnit);
        object = this;
        synchronized (object) {
            if (this.isStopped()) {
                this.health = 1;
                this.reasons.add(0, "Stopped by the administrator.");
                BridgeLogger.logInfoInitiallyStopped((String)this.name);
                return;
            }
            this.state = 1;
            this.running = true;
        }
        this.workManager.schedule((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInternal() throws MessagingBridgeException {
        String string;
        Object object;
        Object object2;
        boolean bl = false;
        try {
            if (this.ctx == null) {
                try {
                    this.ctx = MessagingBridge.getContext();
                }
                catch (NamingException namingException) {
                    throw new MessagingBridgeException("Failed to get initial context");
                }
            }
            if (this.sourceAdapterFactory == null) {
                this.sourceAdapterFactory = (AdapterConnectionFactory)this.ctx.lookup(this.sourceAdapterJndi);
            }
            if (this.targetAdapterFactory == null) {
                this.targetAdapterFactory = (AdapterConnectionFactory)this.ctx.lookup(this.targetAdapterJndi);
            }
            this.sourceMetaData = this.sourceAdapterFactory.getMetaData();
            this.targetMetaData = this.targetAdapterFactory.getMetaData();
            this.sameMessageFormat = this.sourceMetaData.getNativeMessageFormat().equals(this.targetMetaData.getNativeMessageFormat());
            object2 = null;
            object = this.sourceAdapterFactory.getTransactionSupport();
            int n = ((String)object).equals("XATransaction") ? 3 : (((String)object).equals("LocalTransaction") ? 2 : 1);
            String string2 = this.targetAdapterFactory.getTransactionSupport();
            int n2 = string2.equals("XATransaction") ? 3 : (string2.equals("LocalTransaction") ? 2 : 1);
            if (n == 3) {
                this.sourceXASupported = true;
                if (n2 == 3) {
                    this.xaSupported = true;
                }
            } else if (n == 2) {
                this.localTXSupported = true;
            }
        }
        catch (NamingException namingException) {
            bl = true;
            if (this.logCount++ == 5) {
                BridgeLogger.logInfoAdaptersLookupFailed((String)this.name, (Exception)namingException);
                this.logCount = 0;
            }
        }
        catch (ResourceException resourceException) {
            BridgeLogger.logErrorFailGetAdpInfo((String)this.name, (Exception)((Object)resourceException));
            bl = true;
        }
        catch (Throwable throwable) {
            BridgeLogger.logStackTrace((Throwable)throwable);
            bl = true;
        }
        if (bl) {
            object2 = this.reasons;
            synchronized (object2) {
                this.health = 1;
                if (this.sourceAdapterFactory == null) {
                    this.reasons.add(0, "WARN: failed to look up the source adapter.");
                } else {
                    this.reasons.add(0, "WARN: failed to look up the target adapter.");
                }
            }
            return;
        }
        this.logCount = 0;
        BridgeLogger.logInfoAdaptersFound((String)this.name);
        object2 = this.reasons;
        synchronized (object2) {
            this.health = 0;
            this.reasons.add(0, "Found two adapters and about to make connections.");
        }
        this.sourceConnSpec = null;
        object2 = this.mbean.getSourceDestination().getUserName();
        if (object2 != null && ((String)object2).length() > 0) {
            this.sourceProps.put(new String("username"), object2);
            String string3 = this.mbean.getSourceDestination().getUserPassword();
            if (string3 == null) {
                string3 = "";
            }
            this.sourceProps.put(new String("password"), string3);
        }
        this.sourceProps.put(new String("name"), this.name);
        if (this.durabilityEnabled) {
            this.sourceProps.put(new String("durability"), new String("true"));
        } else {
            this.sourceProps.put(new String("durability"), new String("false"));
        }
        if (this.selector != null) {
            this.sourceProps.put(new String("selector"), this.selector);
        }
        if ((string = this.mbean.getSourceDestination().getClasspath()) != null) {
            this.sourceProps.put(new String("classpath"), string);
        }
        if (this.sourceProps != null && this.sourceProps.size() > 0) {
            try {
                this.sourceConnSpec = this.sourceAdapterFactory.createConnectionSpec(this.sourceProps);
            }
            catch (ResourceException resourceException) {
                BridgeLogger.logErrorInvalidSourceProps((String)this.name);
                return;
            }
        }
        this.targetConnSpec = null;
        this.targetProps.put(new String("name"), this.name);
        String string4 = this.mbean.getTargetDestination().getUserName();
        if (string4 != null && string4.length() > 0) {
            this.targetProps.put(new String("username"), string4);
            object = this.mbean.getTargetDestination().getUserPassword();
            if (object == null) {
                object = "";
            }
            this.targetProps.put(new String("password"), object);
        }
        if ((string = this.mbean.getTargetDestination().getClasspath()) != null) {
            this.targetProps.put(new String("classpath"), string);
        }
        if (this.preserveMsgProperty) {
            this.targetProps.put(new String("preserveMsgProperty"), "true");
        }
        if (this.targetProps != null && this.targetProps.size() > 0) {
            try {
                this.targetConnSpec = this.targetAdapterFactory.createConnectionSpec(this.targetProps);
            }
            catch (ResourceException resourceException) {
                BridgeLogger.logErrorInvalidTargetProps((String)this.name);
                return;
            }
        }
        if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeStartup.debug("BridgeBridge " + this.name + " forwarding policy is " + this.policyToString(this.forwardingPolicy));
        }
        object = this;
        synchronized (object) {
            this.state = 2;
        }
        this.retryController.reset();
        this.connRetryTimeNext = this.retryController.getNextRetryTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnections() {
        BridgeLogger.logInfoGetConnections((String)this.name);
        MessagingBridge messagingBridge = this;
        synchronized (messagingBridge) {
            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Bridge " + this.name + " In getConnections: isStopped = " + this.isStopped());
            }
            if (this.isShutdownOrSuspended() || this.isStopped()) {
                this.logBeginForwarding = true;
                BridgeLogger.logInfoShuttingdown((String)this.name);
                return;
            }
        }
        boolean bl = false;
        Throwable throwable = null;
        try {
            if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                BridgeDebug.MessagingBridgeRuntime.debug("Bridge " + this.name + " Getting source connection");
            }
            this.sourceConn = this.sourceAdapterFactory.getSourceConnection(this.sourceConnSpec);
        }
        catch (Throwable throwable2) {
            bl = true;
            throwable = throwable2;
        }
        if (bl || this.sourceConn == null) {
            this.connRetryTimeNext = this.retryController.getNextRetryTime();
            BridgeLogger.logErrorFailedToConnectToSource((String)this.name, (Exception)this.createExceptionWithLinkedExceptionInfo(throwable), (long)(this.connRetryTimeNext / 1000L));
            ArrayList arrayList = this.reasons;
            synchronized (arrayList) {
                this.health = 1;
                this.reasons.add(0, "WARN: failed to connect to the source.");
            }
            return;
        }
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Bridge " + this.name + " Successfully got connection to the source destination");
        }
        Object object = this.reasons;
        synchronized (object) {
            this.health = 0;
            this.reasons.add(0, "Connected to the source.");
        }
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Bridge " + this.name + " Getting target connection");
        }
        try {
            this.targetConn = this.targetAdapterFactory.getTargetConnection(this.targetConnSpec);
        }
        catch (Throwable throwable3) {
            bl = true;
            throwable = throwable3;
        }
        if (bl || this.targetConn == null) {
            object = this;
            synchronized (object) {
                if (this.sourceConn != null) {
                    this.closeConnection(this.sourceConn);
                    this.sourceConn = null;
                }
            }
            this.connRetryTimeNext = this.retryController.getNextRetryTime();
            BridgeLogger.logErrorFailedToConnectToTarget((String)this.name, (Exception)this.createExceptionWithLinkedExceptionInfo(throwable), (long)(this.connRetryTimeNext / 1000L));
            object = this.reasons;
            synchronized (object) {
                this.health = 1;
                this.reasons.add(0, "WARN: failed to connect to the target.");
            }
            return;
        }
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Bridge " + this.name + " Successfully got connection to the target destination");
        }
        object = this.reasons;
        synchronized (object) {
            this.health = 0;
            this.reasons.add(0, "Connected to the target.");
        }
        try {
            this.workMode = this.determineWorkMode(this.sourceMetaData);
        }
        catch (MessagingBridgeException messagingBridgeException) {
            BridgeLogger.logErrorQOSNotAvail((String)this.name, (String)this.mbean.getQualityOfService());
            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                messagingBridgeException.printStackTrace();
            }
            try {
                this.shutdown();
            }
            catch (MessagingBridgeException messagingBridgeException2) {
                // empty catch block
            }
            return;
        }
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Bridge " + this.name + " WorkMode = " + this.workModeToString(this.workMode));
        }
        BridgeLogger.logInfoWorkMode((String)this.name, (String)this.mbean.getQualityOfService(), (String)this.workModeToQOS(this.workMode));
        try {
            if (this.workMode == 2) {
                this.sourceConn.setAcknowledgeMode(2);
            }
            if (this.workMode == 0) {
                this.sourceConn.setAcknowledgeMode(99);
            }
        }
        catch (Throwable throwable4) {
            this.prepareForRebegin(throwable4);
        }
        object = this;
        synchronized (object) {
            this.state = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginForwarding() {
        block18: {
            if (this.logBeginForwarding) {
                BridgeLogger.logInfoBeginForwaring((String)this.name);
                this.logBeginForwarding = false;
            } else if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                BridgeLogger.logInfoBeginForwaring((String)this.name);
            }
            Object object = this;
            synchronized (object) {
                if (this.isNotAvail()) {
                    this.logBeginForwarding = true;
                    BridgeLogger.logInfoShuttingdown((String)this.name);
                    return;
                }
            }
            object = this.reasons;
            synchronized (object) {
                this.health = 0;
                this.reasons.add(0, "Forwarding messages.");
            }
            try {
                this.sourceConn.setExceptionListener(this);
                this.targetConn.setExceptionListener(this);
                if (this.async) {
                    this.idle = true;
                    if (this.maximumIdleTime <= 0L) {
                        this.maximumIdleTime = 60000L;
                    }
                    this.sourceConn.setMessageListener(this);
                    object = this;
                    synchronized (object) {
                        this.state = 4;
                        this.running = false;
                        break block18;
                    }
                }
                this.processMessages();
            }
            catch (NullPointerException nullPointerException) {
                this.prepareForRebegin(nullPointerException);
            }
            catch (Throwable throwable) {
                this.prepareForRebegin(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Bridge " + this.name + " in run(): state = " + this.state);
        }
        switch (this.state) {
            case 1: {
                MessagingBridge messagingBridge = this;
                synchronized (messagingBridge) {
                    if (this.isStopped()) {
                        this.running = false;
                        return;
                    }
                }
                try {
                    this.startInternal();
                }
                catch (Exception exception) {
                    this.running = false;
                    return;
                }
                messagingBridge = this;
                synchronized (messagingBridge) {
                    if (this.state != 2) {
                        this.running = false;
                        return;
                    }
                }
            }
            case 2: {
                MessagingBridge messagingBridge = this;
                synchronized (messagingBridge) {
                    if (this.isStopped()) {
                        this.running = false;
                        return;
                    }
                }
                try {
                    this.getConnections();
                }
                catch (Exception exception) {
                    if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                        BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Bridge " + this.name + " Failed to get connections because of " + exception);
                    }
                    this.running = false;
                    return;
                }
                messagingBridge = this;
                synchronized (messagingBridge) {
                    if (this.state != 3) {
                        this.running = false;
                        return;
                    }
                }
            }
            case 3: 
            case 5: {
                MessagingBridge messagingBridge = this;
                synchronized (messagingBridge) {
                    if (this.isStopped()) {
                        this.running = false;
                        return;
                    }
                }
                try {
                    this.beginForwarding();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                messagingBridge = this;
                synchronized (messagingBridge) {
                    this.running = false;
                    return;
                }
            }
            case 6: {
                try {
                    this.stopForwarding();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MessagingBridge messagingBridge = this;
                synchronized (messagingBridge) {
                    this.running = false;
                    return;
                }
            }
            case 8: {
                try {
                    this.stopForwarding();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MessagingBridge messagingBridge = this;
                synchronized (messagingBridge) {
                    this.state = 2;
                    this.running = false;
                    return;
                }
            }
            case 9: {
                MessagingBridge messagingBridge = this;
                synchronized (messagingBridge) {
                    if (this.isStopped()) {
                        this.running = false;
                        return;
                    }
                }
                try {
                    if (this.async && this.onMessageIdleCurrent >= this.maximumIdleTime) {
                        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                            BridgeLogger.logInfoAsyncReconnect((String)this.name);
                        }
                    } else {
                        BridgeLogger.logInfoSyncReconnect((String)this.name);
                    }
                    this.stopForwarding();
                    messagingBridge = this;
                    synchronized (messagingBridge) {
                        this.state = 2;
                    }
                    this.getConnections();
                    this.beginForwarding();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                messagingBridge = this;
                synchronized (messagingBridge) {
                    this.running = false;
                    return;
                }
            }
            case 7: 
            case 11: 
            case 12: {
                MessagingBridge messagingBridge = this;
                synchronized (messagingBridge) {
                    this.running = false;
                    return;
                }
            }
        }
        MessagingBridge messagingBridge = this;
        synchronized (messagingBridge) {
            this.running = false;
        }
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Internal error -- Invalid state: " + this.state);
        }
    }

    private void getTransactionManager() {
        this.tm = TxHelper.getTransactionManager();
        try {
            this.tm.setTransactionTimeout(this.transactionTimeout);
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    private void closeConnection(AdapterConnection adapterConnection) {
        try {
            adapterConnection.close();
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        AdapterConnection adapterConnection;
        if (this.sourceConn != null) {
            adapterConnection = this.sourceConn;
            synchronized (adapterConnection) {
                if (!this.async) {
                    try {
                        this.sourceConn.recover();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.closeConnection(this.sourceConn);
            }
            this.sourceConn = null;
        }
        if (this.targetConn != null) {
            adapterConnection = this.targetConn;
            synchronized (adapterConnection) {
                this.closeConnection(this.targetConn);
            }
            this.targetConn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopForwarding() {
        SourceConnection sourceConnection = null;
        TargetConnection targetConnection = null;
        Object object = this;
        synchronized (object) {
            if (this.isShutdownOrSuspended() || this.state == 7) {
                return;
            }
            this.state = 7;
            if (this.sourceConn != null) {
                sourceConnection = this.sourceConn;
            }
            if (this.targetConn != null) {
                targetConnection = this.targetConn;
            }
        }
        if (sourceConnection != null) {
            try {
                if (!this.async) {
                    sourceConnection.recover();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = sourceConnection;
            synchronized (object) {
                this.closeConnection(sourceConnection);
            }
        }
        if (targetConnection != null) {
            object = targetConnection;
            synchronized (object) {
                this.closeConnection(targetConnection);
            }
        }
        BridgeLogger.logInfoStopped((String)this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        try {
            thread2.setContextClassLoader(this.savedClassLoader);
            this.onMessageInternal(message);
        }
        finally {
            thread2.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessageInternal(Message message) {
        String string = null;
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (onMessage()) received message: " + EOL + this.constructLogForReceivedMessage(message));
            try {
                string = message.getJMSMessageID();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        boolean bl = false;
        MessagingBridge messagingBridge = this;
        synchronized (messagingBridge) {
            this.idle = false;
            if (this.isNotAvail()) {
                bl = true;
            }
        }
        if (bl && this.sourceConn != null) {
            this.logBeginForwarding = true;
            BridgeLogger.logInfoShuttingdown((String)this.name);
            try {
                this.sourceConn.recover();
                if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (onMessage()) recovered: " + message.getJMSMessageID());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            if (this.workMode == 4 || this.workMode == 1) {
                this.getTransactionManager();
                this.tm.begin("Messaging Bridge");
                this.sourceConn.associateTransaction(message);
                if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                    messagingBridge = TxHelper.getTransaction();
                    Xid xid = messagingBridge == null ? null : messagingBridge.getXID();
                    BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (onMessage()) associated msg " + message.getJMSMessageID() + " with transaction " + xid);
                }
            }
            messagingBridge = this.targetConn.createMessage(message);
            this.targetConn.send((Message)messagingBridge);
            if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (onMessage())" + " successfully sent message: " + EOL + this.constructLogForSentMessage(string, message));
            }
            if (this.workMode == 4 || this.workMode == 1) {
                this.tm.commit();
                if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (onMessage()) committed the transaction");
                }
            } else if (this.workMode == 2) {
                this.sourceConn.acknowledge(message);
                if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (onMessage()) acknowledged the msg");
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.workMode == 4 || this.workMode == 1) {
                    this.tm.rollback();
                    if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                        BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (onMessage()) rolled back the transaction");
                    }
                } else if (this.workMode == 2) {
                    if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                        BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (onMessage()) calling recover");
                    }
                    this.sourceConn.recover();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.prepareForRebegin(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessages() throws MessagingBridgeException {
        if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Bridge " + this.name + " Entering processMessages() ------ ");
        }
        if (this.async) {
            this.throwMessagingBridgeException("Messaging bridge internal error", null);
        }
        for (int i = 0; i < 10; ++i) {
            long l = System.currentTimeMillis();
            LocalTransaction localTransaction = null;
            Object object = this;
            synchronized (object) {
                if (this.isNotAvail() || this.sourceConn == null || this.targetConn == null) {
                    this.logBeginForwarding = true;
                    BridgeLogger.logInfoShuttingdown((String)this.name);
                    return;
                }
                this.state = 5;
            }
            object = this.sourceConn;
            synchronized (object) {
                TargetConnection targetConnection = this.targetConn;
                synchronized (targetConnection) {
                    block59: {
                        try {
                            Message message;
                            if (this.workMode == 4 || this.workMode == 1) {
                                this.getTransactionManager();
                                this.tm.begin("Messaging Bridge");
                                message = this.sourceConn.receive(this.flushingTime);
                            } else if (this.workMode == 3) {
                                localTransaction = this.sourceConn.getLocalTransaction();
                                localTransaction.begin();
                                message = this.sourceConn.receive(this.flushingTime);
                            } else {
                                message = this.sourceConn.receive(this.maximumIdleTime);
                            }
                            String string = null;
                            if (message != null) {
                                Message message2;
                                if (this.workMode == 4 || this.workMode == 1 || this.workMode == 3) {
                                    for (int j = 0; message != null && j < this.batchSize - 1; ++j) {
                                        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                                            BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (processMessages()) received message: " + EOL + this.constructLogForReceivedMessage(message));
                                            try {
                                                string = message.getJMSMessageID();
                                            }
                                            catch (JMSException jMSException) {
                                                // empty catch block
                                            }
                                        }
                                        message2 = this.targetConn.createMessage(message);
                                        this.targetConn.send(message2);
                                        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                                            BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (processMessages())" + " successfully sent message: " + EOL + this.constructLogForSentMessage(string, message));
                                        }
                                        if (this.workMode == 2) {
                                            this.sourceConn.acknowledge(message);
                                            if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                                                BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (processMessages())" + " successfully acknowledged message: " + string);
                                            }
                                        }
                                        if (this.workMode == 4 || this.workMode == 1) {
                                            long l2 = this.flushingTime - (System.currentTimeMillis() - l);
                                            if (l2 < 0L) {
                                                l2 = 0L;
                                            }
                                            message = this.sourceConn.receive(l2);
                                            continue;
                                        }
                                        message = this.sourceConn.receive(0L);
                                    }
                                }
                                if (message != null) {
                                    if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                                        BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (processMessages()) received message: " + EOL + this.constructLogForReceivedMessage(message));
                                        try {
                                            string = message.getJMSMessageID();
                                        }
                                        catch (JMSException jMSException) {
                                            // empty catch block
                                        }
                                    }
                                    message2 = this.targetConn.createMessage(message);
                                    this.targetConn.send(message2);
                                    if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                                        BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (processMessages())" + " successfully sent message: " + EOL + this.constructLogForSentMessage(string, message));
                                    }
                                    if (this.workMode == 2) {
                                        this.sourceConn.acknowledge(message);
                                        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                                            BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (processMessages())" + " successfully acknowledged message: " + string);
                                        }
                                    }
                                }
                                if (this.workMode == 4 || this.workMode == 1) {
                                    this.tm.commit();
                                    if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
                                        BridgeDebug.MessagingBridgeRuntime.debug("Bridge: " + this.name + " (processMessages())" + " committed the transaction");
                                    }
                                } else if (this.workMode == 3) {
                                    localTransaction.commit();
                                }
                                break block59;
                            }
                            try {
                                if (this.workMode == 4 || this.workMode == 1) {
                                    this.tm.rollback();
                                } else if (this.workMode == 3) {
                                    localTransaction.rollback();
                                } else if (this.workMode == 2) {
                                    this.sourceConn.recover();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            continue;
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof ResourceTransactionRolledBackException) {
                                continue;
                            }
                            BridgeLogger.logErrorProcessMsgs((String)this.name, (Throwable)this.createExceptionWithLinkedExceptionInfo(throwable));
                            try {
                                if (this.workMode == 4 || this.workMode == 1) {
                                    this.tm.rollback();
                                } else if (this.workMode == 3) {
                                    localTransaction.rollback();
                                } else if (this.workMode == 2) {
                                    this.sourceConn.recover();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            MessagingBridge messagingBridge = this;
                            synchronized (messagingBridge) {
                                this.state = 9;
                            }
                            this.throwMessagingBridgeException("Messaging bridge operation failed", throwable);
                        }
                    }
                }
            }
        }
    }

    public void onException(JMSException jMSException) {
        this.prepareForRebegin(jMSException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareForRebegin(Throwable throwable) {
        MessagingBridge messagingBridge = this;
        synchronized (messagingBridge) {
            if (this.state == 8 || this.state == 2) {
                return;
            }
        }
        BridgeLogger.logInfoReconnect((String)this.name, (Throwable)this.createExceptionWithLinkedExceptionInfo(throwable));
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            this.state = 8;
            if (this.async) {
                this.running = false;
            }
            if (!this.running) {
                bl = true;
                this.running = true;
            }
            this.logBeginForwarding = true;
        }
        object = this.reasons;
        synchronized (object) {
            this.health = 1;
            this.reasons.add(0, "WARN: failed and will reconnect later.");
        }
        this.retryController.reset();
        this.connRetryTimeNext = this.retryController.getNextRetryTime();
        if (bl) {
            this.workManager.schedule((Runnable)this);
        }
    }

    private int determineWorkMode(AdapterMetaData adapterMetaData) throws MessagingBridgeException {
        this.async = adapterMetaData.supportsAsynchronousMode() && this.asyncEnabled;
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Bridge " + this.name + ": both source and target adapters support XA = " + this.xaSupported);
        }
        if (this.qosDegradAllowed) {
            BridgeLogger.logInfoQOSDegradationAllowed((String)this.name);
        } else {
            BridgeLogger.logInfoQOSDegradationNotAllowed((String)this.name);
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = adapterMetaData.supportsMDBTransaction() && this.sourceConn.getMetaData().implementsMDBTransaction();
            bl2 = this.xaSupported && this.sourceConn.getMetaData().isXAConnection() && this.targetConn.getMetaData().isXAConnection();
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Bridge " + this.name + " supportsMDBTX = " + bl + " supportsXA = " + bl2 + " async = " + this.async);
        }
        switch (this.qos) {
            case 0: {
                if (bl2) {
                    if (this.async && !bl) {
                        this.async = false;
                    }
                    return 4;
                }
                if (!this.qosDegradAllowed) {
                    throw new MessagingBridgeException("QOS cannot be satisfied");
                }
            }
            case 1: {
                if (adapterMetaData.supportsAcknowledgement()) {
                    return 2;
                }
                if (this.sourceXASupported) {
                    if (!bl) {
                        this.async = false;
                    }
                    return 1;
                }
                if (this.localTXSupported) {
                    this.async = false;
                    return 3;
                }
                if (!this.qosDegradAllowed) {
                    throw new MessagingBridgeException("QOS cannot be satisfied");
                }
            }
            case 2: {
                return 0;
            }
        }
        throw new MessagingBridgeException("Invalid quality of service");
    }

    private String workModeToString(int n) {
        switch (n) {
            case 4: {
                return "Exactly-once";
            }
            case 3: {
                return "Duplicate-okay-local";
            }
            case 2: {
                return "Duplicate-okay-ack";
            }
            case 1: {
                return "Duplicate-okay-xa";
            }
            case 0: {
                return "Atmost-once";
            }
        }
        return "Mode not supported";
    }

    private String workModeToQOS(int n) {
        switch (n) {
            case 4: {
                return "Exactly-once";
            }
            case 1: 
            case 2: 
            case 3: {
                return "Duplicate-okay";
            }
            case 0: {
                return "Atmost_once";
            }
        }
        return "Mode not supported";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(boolean bl) {
        Object object = this;
        synchronized (object) {
            if (this.state == 11 || this.state == 12) {
                return;
            }
            this.state = 12;
        }
        object = this.reasons;
        synchronized (object) {
            this.health = 1;
            this.reasons.add(0, "WARN: Bridge " + this.name + " is suspended because of server suspension.");
        }
        this.timer.cancel();
        this.cleanup();
        this.sourceAdapterFactory = null;
        this.targetAdapterFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws MessagingBridgeException {
        MessagingBridge messagingBridge = this;
        synchronized (messagingBridge) {
            if (this.state == 11) {
                return;
            }
            this.state = 11;
        }
        try {
            if (this.bridgeListener != null) {
                this.bridgeListener.close();
            }
            this.timer.cancel();
            this.cleanup();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.unregister();
            }
            catch (Exception exception) {}
        }
        this.logBeginForwarding = true;
        BridgeLogger.logInfoShutdown((String)this.name);
    }

    public MessagingBridgeMBean getMBean() {
        return this.mbean;
    }

    public synchronized void markShuttingDown() {
        if (this.state != 10 && this.state != 11) {
            this.state = 10;
        }
    }

    private synchronized boolean isShutdownOrSuspended() {
        return this.state == 11 || this.state == 10 || this.state == 12;
    }

    private boolean isStopped() {
        return this.stopped;
    }

    private boolean isNotAvail() {
        return this.state == 11 || this.state == 10 || this.state == 12 || this.state == 8 || this.state == 2 || this.state == 7 || this.stopped;
    }

    public void migratableActivate() throws MigrationException {
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Activating bridge " + this.name);
        }
        try {
            this.resume();
        }
        catch (Exception exception) {
            BridgeLogger.logStackTrace((Throwable)exception);
            throw new MigrationException("Failed to activate Bridge " + this.name, exception);
        }
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Bridge " + this.name + " has been successfully activated.");
        }
    }

    public void migratableDeactivate() throws MigrationException {
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Deactivating bridge " + this.name);
        }
        try {
            this.suspend(true);
        }
        catch (Exception exception) {
            throw new MigrationException("Failed to suspend Messaging Bridge " + this.name, exception);
        }
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Bridge " + this.name + " has been successfully deactivated.");
        }
    }

    public void migratableInitialize() throws MigrationException {
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Initializging bridge " + this.name + " as a migratable");
        }
        try {
            this.initialize();
        }
        catch (Exception exception) {
            throw new MigrationException("Failed to initialize bridge " + this.name + " as a mibratable.", exception);
        }
        if (BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntime.debug("Bridge " + this.name + " has been successfully initialized as a migratable");
        }
    }

    private void throwMessagingBridgeException(String string, Throwable throwable) throws MessagingBridgeException {
        MessagingBridgeException messagingBridgeException = new MessagingBridgeException(string);
        if (throwable != null) {
            if (throwable instanceof Exception) {
                messagingBridgeException.setLinkedException((Exception)throwable);
            } else {
                messagingBridgeException.setLinkedThrowable(throwable);
            }
        }
        throw messagingBridgeException;
    }

    private String policyToString(int n) {
        switch (n) {
            case 0: {
                return new String("AUTO");
            }
            case 2: {
                return new String("MANUAL");
            }
            case 1: {
                return new String("SCHEDULED");
            }
        }
        return null;
    }

    private Properties copyProperties(Properties properties) {
        Properties properties2 = new Properties();
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                properties2.put(string, properties.get(string));
            }
        }
        return properties2;
    }

    public synchronized void setReconnectDelayMinimum(int n) {
        int n2 = (int)this.retryController.getInitial();
        this.retryController.setInitial((long)n * 1000L);
        BridgeLogger.logInfoAttributeChanged((String)this.name, (String)"ReconnectDelayMinimum", (long)n2, (long)n);
    }

    public synchronized void setReconnectDelayIncrease(int n) {
        int n2 = (int)this.retryController.getIncrement();
        this.retryController.setIncrement((long)n * 1000L);
        BridgeLogger.logInfoAttributeChanged((String)this.name, (String)"ReconnectDelayIncrease", (long)n2, (long)n);
    }

    public synchronized void setReconnectDelayMaximum(int n) {
        int n2 = (int)this.retryController.getMaximum();
        this.retryController.setMaximum((long)n * 1000L);
        BridgeLogger.logInfoAttributeChanged((String)this.name, (String)"ReconnectDelayMaximum", (long)n2, (long)n);
    }

    public synchronized void setTransactionTimeout(int n) {
        int n2 = this.transactionTimeout;
        if (n <= 0) {
            n = 1;
        }
        if (this.batchInterval < 0L) {
            this.flushingTime = 800 * n;
        }
        this.transactionTimeout = n;
        BridgeLogger.logInfoAttributeChanged((String)this.name, (String)"TransactionTimeout", (long)n2, (long)this.transactionTimeout);
    }

    public synchronized void setIdleTimeMaximum(int n) {
        int n2 = (int)(this.maximumIdleTime / 1000L);
        this.maximumIdleTime = (long)n * 1000L;
        if (this.maximumIdleTime <= 0L && this.async) {
            this.maximumIdleTime = 60000L;
        }
        BridgeLogger.logInfoAttributeChanged((String)this.name, (String)"IdleTimeMaximum", (long)n2, (long)(this.maximumIdleTime / 1000L));
    }

    public synchronized void setBatchSize(int n) {
        int n2 = this.batchSize;
        this.batchSize = n;
        BridgeLogger.logInfoAttributeChanged((String)this.name, (String)"BatchSize", (long)n2, (long)this.batchSize);
    }

    public synchronized void setBatchInterval(long l) {
        int n = (int)this.batchInterval;
        this.batchInterval = l;
        this.flushingTime = this.batchInterval < 0L ? (long)(800 * this.transactionTimeout) : this.batchInterval;
        BridgeLogger.logInfoAttributeChanged((String)this.name, (String)"BatchInterval", (long)n, (long)((int)this.batchInterval));
    }

    public synchronized void setStarted(boolean bl) {
        if (bl) {
            if (!this.isStopped()) {
                return;
            }
            if (this.isShutdownOrSuspended()) {
                BridgeLogger.logFailedStart((String)this.name);
                return;
            }
            this.health = 0;
            this.reasons.add(0, "Started by administrator.");
            BridgeLogger.logInfoAttributeStartedChanged((String)this.name, (String)"false", (String)"true");
            this.stopped = false;
            if (this.state == 1) {
                if (this.timer == null) {
                    this.timer = this.timerManager.scheduleAtFixedRate((TimerListener)this, 0L, this.scanUnit);
                }
                this.workManager.schedule((Runnable)this);
            }
            if (this.state == 6) {
                this.state = 3;
            }
            if (this.state == 7) {
                this.state = 2;
            }
            if (this.async) {
                this.running = false;
            }
            if (!this.running) {
                this.running = true;
                this.workManager.schedule((Runnable)this);
            }
        } else {
            if (this.isStopped()) {
                return;
            }
            this.stopped = true;
            this.logBeginForwarding = true;
            this.health = 1;
            this.reasons.add(0, "Stopped by administrator.");
            BridgeLogger.logInfoAttributeStartedChanged((String)this.name, (String)"true", (String)"false");
            if (this.state == 1 || this.state == 2) {
                return;
            }
            if (this.state == 4 || this.state == 5 || this.state == 8 || this.state == 3) {
                this.state = 6;
                try {
                    this.stopForwarding();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTrigger() {
        if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Bridge " + this.name + " doTrigger(): state = " + this.state + " stopped = " + this.stopped);
        }
        MessagingBridge messagingBridge = this;
        synchronized (messagingBridge) {
            if (this.isStopped()) {
                return;
            }
            switch (this.state) {
                case 1: {
                    if (this.lookupRetryTimeCurrent >= 10000L) {
                        this.lookupRetryTimeCurrent = 0L;
                    }
                    this.lookupRetryTimeCurrent += this.scanUnit;
                    if (this.lookupRetryTimeCurrent < 10000L) {
                        return;
                    }
                    if (this.running) {
                        return;
                    }
                    this.running = true;
                    break;
                }
                case 2: {
                    this.connRetryTimeCurrent += this.scanUnit;
                    if (this.connRetryTimeCurrent < this.connRetryTimeNext) {
                        return;
                    }
                    if (this.connRetryTimeCurrent >= this.connRetryTimeNext) {
                        this.connRetryTimeCurrent = 0L;
                    }
                    if (this.running) {
                        return;
                    }
                    this.running = true;
                    break;
                }
                case 4: {
                    if (!this.idle) {
                        return;
                    }
                    if (this.onMessageIdleCurrent >= this.maximumIdleTime) {
                        this.onMessageIdleCurrent = 0L;
                    }
                    this.onMessageIdleCurrent += this.scanUnit;
                    if (this.onMessageIdleCurrent < this.maximumIdleTime) {
                        return;
                    }
                    this.state = 9;
                    if (this.running) {
                        return;
                    }
                    this.running = true;
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (this.running) {
                        return;
                    }
                    this.running = true;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Bridge " + this.name + " doTrigger(): about to run workManager.schedule() state = " + this.state);
        }
        this.workManager.schedule((Runnable)this);
    }

    public static synchronized Context getContext() throws NamingException {
        Environment environment = new Environment();
        environment.setCreateIntermediateContexts(true);
        environment.setReplicateBindings(true);
        return environment.getInitialContext();
    }

    public void stop() {
        throw new UnsupportedOperationException("This method is not implemented on runtime mbean. The way of start/stop a bridge at runtime is to change the Started attribute on the configuration mbean");
    }

    public void start() {
        throw new UnsupportedOperationException("This method is not implemented on runtime mbean. The way of start/stop a bridge at runtime is to change the Started attribute on the configuration mbean");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getState() {
        String string = null;
        String[] stringArray = this.stateCache;
        synchronized (this.stateCache) {
            if (this.stateCache[0] == null || this.stateCache[1] == null) {
                switch (this.health) {
                    case 0: {
                        this.stateCache[0] = "Active";
                        this.stateCache[1] = (String)this.reasons.get(0);
                        break;
                    }
                    case 1: {
                        this.stateCache[0] = "Inactive";
                        this.stateCache[1] = (String)this.reasons.get(0);
                        break;
                    }
                }
            }
            if (this.stateCache[0] != null) {
                string = this.stateCache[0];
                this.stateCache[0] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        String string = null;
        String[] stringArray = this.stateCache;
        synchronized (this.stateCache) {
            if (this.stateCache[0] == null || this.stateCache[1] == null) {
                switch (this.health) {
                    case 0: {
                        this.stateCache[0] = "Active";
                        this.stateCache[1] = (String)this.reasons.get(0);
                        break;
                    }
                    case 1: {
                        this.stateCache[0] = "Inactive";
                        this.stateCache[1] = (String)this.reasons.get(0);
                        break;
                    }
                }
            }
            if (this.stateCache[1] != null) {
                string = this.stateCache[1];
                this.stateCache[1] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return string;
        }
    }

    private Exception createExceptionWithLinkedExceptionInfo(Throwable throwable) {
        if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled() || BridgeDebug.MessagingBridgeRuntime.isDebugEnabled()) {
            Exception exception;
            String string = StackTraceUtils.throwable2StackTrace((Throwable)throwable);
            if (throwable instanceof ResourceException && (exception = ((ResourceException)throwable).getLinkedException()) != null) {
                string = string + "-------------- Linked Exception ------------" + EOL + StackTraceUtils.throwable2StackTrace((Throwable)exception);
                Exception exception2 = null;
                if (exception instanceof ResourceException) {
                    exception2 = ((ResourceException)((Object)exception)).getLinkedException();
                }
                if (exception instanceof JMSException) {
                    exception2 = ((JMSException)((Object)exception)).getLinkedException();
                }
                if (exception2 != null) {
                    string = string + "-------------- Linked Exception 2 ------------" + EOL + StackTraceUtils.throwable2StackTrace((Throwable)exception2);
                    Exception exception3 = null;
                    if (exception2 instanceof JMSException) {
                        exception3 = ((JMSException)((Object)exception2)).getLinkedException();
                    }
                    if (exception3 != null) {
                        string = string + "-------------- Linked Exception 3 ------------" + EOL + StackTraceUtils.throwable2StackTrace((Throwable)exception3);
                    }
                }
            }
            return new Exception(string);
        }
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return new Exception(throwable.getMessage());
    }

    private String constructLogForReceivedMessage(Message message) {
        String string = null;
        string = this.getJMSHeaders(message);
        Transaction transaction = TxHelper.getTransaction();
        Xid xid = transaction == null ? null : transaction.getXID();
        string = string + EOL + "  Transaction Id: " + xid;
        if (message instanceof TextMessage) {
            try {
                String string2 = ((TextMessage)message).getText();
                string = string + EOL + "  " + (string2 == null ? "null" : (string2.length() < 53 ? string2 : string2.substring(0, 50) + "..."));
            }
            catch (JMSException jMSException) {
                string = string + EOL + "  Failed to get text. " + jMSException.toString();
            }
        }
        string = string + EOL;
        return string;
    }

    private String constructLogForSentMessage(String string, Message message) {
        String string2 = "  JMS Message Class: ";
        if (message instanceof TextMessage) {
            string2 = string2 + "TextMessage";
        }
        if (message instanceof ObjectMessage) {
            string2 = string2 + "ObjectMessage";
        }
        if (message instanceof BytesMessage) {
            string2 = string2 + "BytesMessage";
        }
        if (message instanceof MapMessage) {
            string2 = string2 + "MapMessage";
        }
        if (message instanceof StreamMessage) {
            string2 = string2 + "StreamMessage";
        }
        try {
            string2 = string2 + EOL + "  Old JMS MessageID: " + string;
            string2 = string2 + EOL + "  New JMS MessageID: " + message.getJMSMessageID();
            if (message instanceof TextMessage) {
                String string3 = ((TextMessage)message).getText();
                string2 = string2 + EOL + "  " + (string3 == null ? "null" : (string3.length() <= 53 ? string3 : string3.substring(0, 50) + "..."));
            }
        }
        catch (JMSException jMSException) {
            string2 = string2 + EOL + "  Failed to get fields. " + jMSException.toString();
        }
        string2 = string2 + EOL;
        return string2;
    }

    private String getJMSHeaders(Message message) {
        String string = "  JMS Message Class: ";
        if (message instanceof TextMessage) {
            string = string + "TextMessage";
        }
        if (message instanceof ObjectMessage) {
            string = string + "ObjectMessage";
        }
        if (message instanceof BytesMessage) {
            string = string + "BytesMessage";
        }
        if (message instanceof MapMessage) {
            string = string + "MapMessage";
        }
        if (message instanceof StreamMessage) {
            string = string + "StreamMessage";
        }
        try {
            String string2;
            String string3 = message.getJMSCorrelationID();
            if (string3 != null && string3.length() > 53) {
                string3 = string3.substring(0, 50) + "...";
            }
            if ((string2 = message.getJMSType()) != null && string2.length() > 53) {
                string2 = string2.substring(0, 50) + "...";
            }
            string = string + EOL + "  JMSMessageID: " + message.getJMSMessageID();
            string = string + EOL + "  JMSCorrelationID: " + string3;
            string = string + EOL + "  JMSDeliveryMode: " + (message.getJMSDeliveryMode() == 1 ? "NON_PERSISTENT" : "PERSISTENT");
            string = string + EOL + "  JMSDestination: " + message.getJMSDestination();
            string = string + EOL + "  JMSExpiration: " + MessagingBridge.dateToString(message.getJMSExpiration());
            string = string + EOL + "  JMSPriority: " + message.getJMSPriority();
            string = string + EOL + "  JMSRedelivered: " + message.getJMSRedelivered();
            string = string + EOL + "  JMSReplyTo: " + message.getJMSReplyTo();
            string = string + EOL + "  JMSTimestamp: " + MessagingBridge.dateToString(message.getJMSTimestamp());
            string = string + EOL + "  JMSType: " + string2;
        }
        catch (JMSException jMSException) {
            string = string + EOL + "  Failed to get all headers. " + jMSException.toString();
        }
        return string;
    }

    private static String dateToString(long l) {
        if (l <= 0L) {
            return "0";
        }
        return l + " (" + new Date(l) + ")";
    }

    private static String getEOL() {
        String string = System.getProperty("line.separator");
        if (string == null) {
            string = "\n";
        }
        return string;
    }

    public void timerExpired(Timer timer) {
        this.doTrigger();
    }

    public int getOrder() {
        return 100;
    }

    static {
        bridgeSignatures.put("ReconnectDelayMinimum", Integer.TYPE);
        bridgeSignatures.put("ReconnectDelayIncrease", Integer.TYPE);
        bridgeSignatures.put("ReconnectDelayMaximum", Integer.TYPE);
        bridgeSignatures.put("TransactionTimeout", Integer.TYPE);
        bridgeSignatures.put("IdleTimeMaximum", Integer.TYPE);
        bridgeSignatures.put("BatchSize", Integer.TYPE);
        bridgeSignatures.put("BatchInterval", Long.TYPE);
        bridgeSignatures.put("Started", Boolean.TYPE);
    }

    class RetryTimeController {
        long nextTime;
        long initial;
        long inc;
        long max;

        RetryTimeController() {
        }

        void init(long l, long l2, long l3) {
            this.initial = l;
            this.nextTime = l;
            this.inc = l2;
            this.max = l3;
        }

        synchronized void reset() {
            this.nextTime = this.initial - this.inc;
        }

        synchronized long getNextRetryTime() {
            this.nextTime = this.nextTime <= this.max ? (this.nextTime += this.inc) : this.max + this.inc;
            return this.nextTime - this.inc;
        }

        synchronized void setInitial(long l) {
            this.initial = l;
            if (this.initial > this.max) {
                this.max = this.initial;
            }
        }

        long getInitial() {
            return this.initial;
        }

        synchronized void setIncrement(long l) {
            this.inc = l;
        }

        long getIncrement() {
            return this.inc;
        }

        synchronized void setMaximum(long l) {
            this.max = l;
            if (this.initial > this.max) {
                this.initial = this.max;
            }
        }

        long getMaximum() {
            return this.max;
        }
    }
}

