/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.bridge.internal;

import java.io.PrintStream;
import java.io.PrintWriter;
import weblogic.jms.JMSLogger;

public class MessagingBridgeException
extends Exception {
    static final long serialVersionUID = 896851532291231868L;
    private static String reason;
    private Throwable throwable;

    public MessagingBridgeException(String string) {
        reason = string;
        this.throwable = null;
    }

    public MessagingBridgeException(String string, Throwable throwable) {
        reason = string;
        this.throwable = throwable;
    }

    public synchronized void setLinkedException(Exception exception) {
        this.throwable = exception;
    }

    public synchronized void setLinkedThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public Exception getLinkedException() {
        if (this.throwable != null && this.throwable instanceof Exception) {
            return (Exception)this.throwable;
        }
        Exception exception = new Exception("Linked Exception");
        return exception;
    }

    public void printStackTrace() {
        MessagingBridgeException.printWLJMSStackTrace(this.throwable);
    }

    public void printStackTrace(PrintStream printStream) {
        MessagingBridgeException.printWLJMSStackTrace(this.throwable, printStream);
    }

    public void printStackTrace(PrintWriter printWriter) {
        MessagingBridgeException.printWLJMSStackTrace(this.throwable, printWriter);
    }

    static void printWLJMSStackTrace(Throwable throwable) {
        System.out.println("MessagingBridgeException: " + reason);
        if (throwable != null) {
            JMSLogger.logStackTraceLinked((Throwable)throwable);
        }
    }

    static void printWLJMSStackTrace(Throwable throwable, PrintStream printStream) {
        printStream.println("MessagingBridgeException: " + reason);
        if (throwable != null) {
            JMSLogger.logStackTraceLinked((Throwable)throwable);
        }
    }

    static void printWLJMSStackTrace(Throwable throwable, PrintWriter printWriter) {
        printWriter.println("MessagingBridgeException: " + reason);
        if (throwable != null) {
            JMSLogger.logStackTraceLinked((Throwable)throwable);
        }
    }
}

