/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import weblogic.jms.extensions.ClientSAFFactory;
import weblogic.jms.safclient.ClientSAFImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSAFDiscover {
    private static final String HELP_OPT = "-help";
    private static final String ROOT_DIRECTORY_OPT = "-clientSAFRootDir";
    private static final String CUTOFF_TIME_FORMAT_OPT = "-cutoffFormat";
    private static final String CUTOFF_TIME_OPT = "-cutoffTime";
    private static final String DISCOVERY_FILE_OPT = "-discoveryFile";
    private static final String CONFIGURATION_FILE_OPT = "-configurationFile";
    private static Set<String> supportedOptions = new HashSet<String>();

    private static Map<String, String> parseOptions(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (supportedOptions.contains(string)) {
                if (HELP_OPT.equals(string)) {
                    hashMap.put(string, "");
                    break;
                }
                if (++i >= stringArray.length) {
                    ClientSAFDiscover.errorOut("missing option value for option " + string);
                }
                hashMap.put(string, stringArray[i]);
                continue;
            }
            ClientSAFDiscover.errorOut("unsupported option " + string);
        }
        if (hashMap.get(ROOT_DIRECTORY_OPT) != null && hashMap.get(CONFIGURATION_FILE_OPT) == null) {
            ClientSAFDiscover.errorOut("The configurationFile option must be specified when rootDir option is specified");
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void discover(Map<String, String> map) throws Throwable {
        Serializable serializable;
        String string;
        long l = -1L;
        String string2 = map.get(CUTOFF_TIME_OPT);
        if (string2 != null) {
            string = map.get(CUTOFF_TIME_FORMAT_OPT);
            if (string == null) {
                string = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
            }
            serializable = new SimpleDateFormat(string);
            try {
                l = ((DateFormat)serializable).parse(string2).getTime();
            }
            catch (ParseException parseException) {
                ClientSAFDiscover.throwJMSException(parseException, "The cutoff time option " + string2 + " is not of " + string + " format");
            }
        }
        serializable = (string = map.get(ROOT_DIRECTORY_OPT)) == null ? null : new File(string);
        String string3 = map.get(CONFIGURATION_FILE_OPT);
        InputStream inputStream = null;
        try {
            Object object;
            if (string3 != null) {
                object = new File(string3);
                if (!((File)object).exists()) {
                    ClientSAFDiscover.throwJMSException(null, "The configuration file " + string3 + " does not exist");
                }
                inputStream = new FileInputStream((File)object);
            }
            object = null;
            object = serializable == null ? (inputStream == null ? (ClientSAFImpl)ClientSAFFactory.getClientSAF() : (ClientSAFImpl)ClientSAFFactory.getClientSAF(inputStream)) : (ClientSAFImpl)ClientSAFFactory.getClientSAF((File)serializable, inputStream);
            String string4 = map.get(DISCOVERY_FILE_OPT);
            ((ClientSAFImpl)object).discover(string4, l);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static void main(String[] stringArray) {
        Map<String, String> map = ClientSAFDiscover.parseOptions(stringArray);
        if (map.containsKey(HELP_OPT)) {
            ClientSAFDiscover.printUsage();
            return;
        }
        try {
            ClientSAFDiscover.discover(map);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void throwJMSException(Throwable throwable, String string) throws JMSException {
        JMSException jMSException = new JMSException(string);
        if (throwable != null) {
            jMSException.initCause(throwable);
        }
        throw jMSException;
    }

    private static void errorOut(String string) {
        System.out.println(string + "\n");
        ClientSAFDiscover.printUsage();
        System.exit(1);
    }

    private static void printUsage() {
        String string = "Usage: java weblogic.jms.extensions.ClientSAFDiscover [options]\n\nThis command helps users to survey their existing local SAF messages\nbefore applying the fix for bug 8174629 or upgrading from WL 10.3.2 or\nprior releases to 11gR1PS2/10.3.3 or later. The survey can help determine\nwhether the upgrade needs to be tuned for non-default behavior.\nPlease check the description of bug 8174629 in the release note.\n\nThe options include:\n    -help             Print this usage information.\n    -clientSAFRootDir <client-saf-root-directory>  Optional, defaults to\n                      current directory. The client saf root directory of\n                      the target Client SAF that users want to discover.\n                      Any relative paths in the Client SAF configuration\n                      file are relative to this directory (for example,\n                      the store directory).\n    -configurationFile <configuration-file> Optional, defaults to\n                      \"ClientSAF.xml\". The location of the configuration\n                      file used for the target Client SAF. The configuration\n                      file is a well-formed xml file with respect to\n                      the weblogic-jmsmd.xsd schema and which has a \n                      root element of weblogic-client-jms. This option\n                      is required if the clientSAFRootDir option is specified.\n                      If neither clientSAFRootDir option nor this option is\n                      specified, SAFClientDiscover will use the\n                      \"ClientSAF.xml\" under the current working\n                      directory as the configuration file. In any case,\n                      Exception will be thrown if the specified\n                      configuration file does not exist.\n    -cutoffFormat <pattern> Optional, defaults to\n                      \"yyyy-MM-dd'T'HH:mm:ss.SSSZ\". The date and time\n                      pattern for the optional cutoff time of this\n                      ClientSAFDiscover. Check the javadoc for the\n                      java.text.SimpleDateFormat class for more\n                      information.\n    -cutoffTime <cutoff-time> Optional, defaults to \"not set\".\n                      Print data on messages that would be discarded\n                      during upgrade if the optional upgrade cut-off-time\n                      Java system property is set. Users can optionally\n                      specify a cutoff timestamp as a Java system property\n                      for the message upgrade to only upgrade messages\n                      sent after this timestamp. Messages before\n                      this timestamp will be discarded. No messages are\n                      discarded in the client SAF discovery process.\n                      The cutoff time format depends on the cutoffFormat\n                      option. For example, if the cutoffFormat is the default\n                      \"yyyy-MM-dd'T'HH:mm:ss.SSSZ\", an example cutoff\n                      time can be \"2009-12-16T10:34:17.887-0800\".\n                      An exception will be thrown if the specified cutoff\n                      time does not match the cutoffFormat pattern.\n                      If a cutoff time is not specified, the message\n                      upgrade will migrate all the messages and the\n                      SAFClientDiscover command line tool will not\n                      report any message to be discarded.\n    -discoveryFile <discovery-file> Optional, defaults to SAF_DISCOVERY.\n                      The discovery file contains the output for\n                      ClientSAFDiscover.  It is placed relative to the\n                      client SAF root directory unless an absolute path\n                      is specified. If the specified file already exists\n                      ClientSafDiscover deletes the file and creates a\n                      new one.\n\nExample:\nIf a program calls\n\nClientSAFFactory.getClientSAF(new File(\"c:\\\\foo\"),\n    new FileInputStream(\"c:\\\\ClientSAF-jms.xml\"));\n\nto create their client SAF, you can run the following\nClientSAFDiscover command to print out the automatic upgrade that\nwould occur(without actually causing an upgrade or changing any\nstored data):\n\njava weblogic.jms.client.ClientSAFDiscover -rootDir c:\\foo\n    -configurationFile c:\\ClientSAF-jms.xml\n\nThe discovery information will be written to the default location\nc:\\foo\\SAF_DISCOVERY.\n";
        System.out.println(string);
    }

    static {
        supportedOptions.add(HELP_OPT);
        supportedOptions.add(ROOT_DIRECTORY_OPT);
        supportedOptions.add(CUTOFF_TIME_FORMAT_OPT);
        supportedOptions.add(CUTOFF_TIME_OPT);
        supportedOptions.add(DISCOVERY_FILE_OPT);
        supportedOptions.add(CONFIGURATION_FILE_OPT);
    }
}

