/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.client.JMSContext;
import weblogic.jms.client.JMSExceptionContext;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.JMSXASession;
import weblogic.jms.client.LockedMap;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.SessionInternal;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.WLSessionImpl;
import weblogic.jms.client.XAConnectionInternalImpl;
import weblogic.jms.client.XASessionInternalImpl;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DestroyConnectionException;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.common.InvalidDestinationException;
import weblogic.jms.common.JMSConnectionConsumerCreateResponse;
import weblogic.jms.common.JMSConstants;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.JMSWorkManager;
import weblogic.jms.common.LostServerException;
import weblogic.jms.common.PasswordStore;
import weblogic.jms.common.PeerVersionable;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.frontend.FEConnectionCloseRequest;
import weblogic.jms.frontend.FEConnectionConsumerCreateRequest;
import weblogic.jms.frontend.FEConnectionSetClientIdRequest;
import weblogic.jms.frontend.FEConnectionStartRequest;
import weblogic.jms.frontend.FEConnectionStopRequest;
import weblogic.jms.frontend.FERemoveSubscriptionRequest;
import weblogic.jms.frontend.FESessionCreateRequest;
import weblogic.jms.frontend.FESessionCreateResponse;
import weblogic.jms.frontend.FETemporaryDestinationDestroyRequest;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherImpl;
import weblogic.messaging.dispatcher.DispatcherStateChangeListener;
import weblogic.messaging.dispatcher.DispatcherWrapperState;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.NestedThrowable;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class JMSConnection
implements ConnectionInternal,
DispatcherStateChangeListener,
Externalizable,
Invocable,
Runnable,
Reconnectable,
Cloneable,
TimerListener {
    static final long serialVersionUID = 7025750175126041724L;
    private static final AbstractSubject KernelID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    public static final byte EXTVERSION61 = 1;
    public static final byte EXTVERSION70 = 3;
    public static final byte EXTVERSION81 = 4;
    public static final byte EXTVERSION90 = 5;
    public static final byte EXTVERSION910 = 6;
    public static final byte EXTVERSION920 = 7;
    public static final byte EXTVERSION1033 = 8;
    private static final byte VERSION_MASK = 15;
    private static final byte TIMEOUT_MASK = 64;
    private static final byte EXTVERSION = 8;
    private static final byte COMPRESSION_MASK = 1;
    private static final byte UNIT_OF_ORDER_MASK = 2;
    private static final String JMS_PROVIDER_NAME = "BEA Systems, Inc.";
    private static final String PROVIDER_VERSION = "9.0.0";
    private static final int PROVIDER_MAJOR_VERSION = 9;
    private static final int PROVIDER_MINOR_VERSION = 0;
    public static final int SYNCHRONOUS_PREFETCH_DISABLED = 0;
    public static final int SYNCHRONOUS_PREFETCH_ENABLED = 1;
    public static final int SYNCHRONOUS_PREFETCH_TOPIC_SUBSCRIBER_ONLY = 2;
    public static final int ONE_WAY_SEND_DISABLED = 0;
    public static final int ONE_WAY_SEND_ENABLED = 1;
    public static final int ONE_WAY_SEND_TOPIC_ONLY = 2;
    static final int TYPE_UNSPECIFIED = 0;
    static final int TYPE_QUEUE = 1;
    static final int TYPE_TOPIC = 2;
    private JMSID connectionId;
    private String clientId;
    private int clientIdPolicy = 0;
    private int subscriptionSharingPolicy = 0;
    private int type;
    private int deliveryMode;
    private int priority;
    private long timeToDeliver;
    private long timeToLive;
    private long sendTimeout;
    private long redeliveryDelay;
    private boolean userTransactionsEnabled;
    private boolean allowCloseInOnMessage;
    private long transactionTimeout;
    private boolean isLocal;
    private int messagesMaximum;
    private int overrunPolicy;
    private int acknowledgePolicy;
    private String wlsServerName;
    private String runtimeMBeanName;
    private transient int refCount;
    private boolean flowControl;
    private int flowMinimum;
    private int flowMaximum;
    private double flowDecrease;
    private int flowIncrease;
    private long flowInterval;
    private boolean xaServerEnabled;
    private String unitOfOrder;
    private int synchronousPrefetchMode = 0;
    private boolean stopped = true;
    private final Object sublock = new Object();
    private LockedMap sessions = new LockedMap("sessions", null);
    private LockedMap durableSubscribers = new LockedMap("durables", null);
    private JMSDispatcher dispatcher;
    private DispatcherWrapper dispatcherWrapper;
    private JMSExceptionContext exceptionContext;
    private boolean firedExceptoinListener;
    private PeerVersionable peerVersionable;
    private byte version = (byte)8;
    private PeerInfo peerInfo;
    private String dispatchPolicyName = JMSWorkManager.getJMSSessionOnMessageWMName();
    private int compressionThreshold = Integer.MAX_VALUE;
    private int pipelineGeneration = 0;
    private WLConnectionImpl wlConnectionImpl;
    private JMSConnection preDisconnectState;
    private JMSConnection replacementConnection;
    private PasswordStore pwdStore;
    private Object uHandle;
    private Object pHandle;
    public int oneWaySendMode;
    public int oneWaySendWindowSize;
    private int reconnectPolicy = 7;
    private long reconnectBlockingMillis = 60000L;
    private long totalReconnectPeriodMillis = -1L;
    private boolean wantXAConnection;
    private volatile boolean isClosed;
    private static int INITIAL_RETRY_DELAY = 125;
    private long nextRetry = INITIAL_RETRY_DELAY;
    private static final long RETRY_DELAY_MAXIMUM = 300000L;
    private static final int RETRY_DELAY_LEFT_SHIFT = 1;
    private static final int RETRY_DELAY_MIN_INTERVAL = 5000;
    private volatile Timer timer;
    private static final String RECONNECT_ID = "weblogic.jms.Reconnect";
    private static final Object TIMER_WORKMANAGER_LOCK = new Object();
    private static WorkManager RECONNECT_WORK_MANAGER;
    private static TimerManager RECONNECT_TIMER_MANAGER;
    private static final boolean isT3Client;
    private final Object acknowledgePolicyLock = new Object();

    public JMSConnection(JMSID jMSID, String string, int n, int n2, int n3, int n4, long l, long l2, long l3, long l4, long l5, boolean bl, boolean bl2, int n5, int n6, int n7, boolean bl3, DispatcherWrapper dispatcherWrapper, boolean bl4, int n8, int n9, int n10, int n11, boolean bl5, String string2, PeerVersionable peerVersionable, String string3, String string4, PeerInfo peerInfo, int n12, int n13, int n14, int n15, int n16, long l6, long l7) {
        this.peerVersionable = peerVersionable;
        this.connectionId = jMSID;
        this.clientId = string;
        this.clientIdPolicy = n;
        this.subscriptionSharingPolicy = n2;
        this.unitOfOrder = string2;
        this.deliveryMode = n3;
        this.priority = n4;
        this.timeToDeliver = l;
        this.timeToLive = l2;
        this.sendTimeout = l3;
        this.redeliveryDelay = l4;
        this.transactionTimeout = l5;
        this.userTransactionsEnabled = bl;
        this.allowCloseInOnMessage = bl2;
        this.messagesMaximum = n5;
        this.overrunPolicy = n6;
        this.acknowledgePolicy = n7;
        this.isLocal = bl3;
        this.dispatcherWrapper = dispatcherWrapper;
        this.xaServerEnabled = bl5;
        this.flowControl = bl4;
        this.flowMinimum = n8;
        this.flowMaximum = n9;
        this.wlsServerName = string3;
        this.runtimeMBeanName = string4;
        this.flowIncrease = (n9 - n8) / n11;
        if (this.flowIncrease < 1) {
            this.flowIncrease = 1;
        }
        this.flowDecrease = (double)n8 / (double)n9;
        this.flowDecrease = Math.pow(this.flowDecrease, 1.0 / (double)n11);
        this.flowInterval = n10 * 1000 / n11;
        if (this.flowInterval < 1L) {
            this.flowInterval = 1L;
        }
        this.peerInfo = peerInfo;
        if (PeerInfo.VERSION_DIABLO.compareTo((Object)peerInfo) <= 0) {
            this.pipelineGeneration = 0xF00000;
        }
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("pipelineGeneration is " + JMSPushEntry.displayRecoverGeneration(this.pipelineGeneration));
        }
        this.compressionThreshold = n12;
        this.synchronousPrefetchMode = n13;
        this.oneWaySendMode = n14;
        this.oneWaySendWindowSize = n15;
        this.internalSetReconnect(n16, l6, l7);
    }

    private void internalSetReconnect(int n, long l, long l2) {
        if (JMSConnection.isT3Client()) {
            this.reconnectPolicy = n;
            this.reconnectBlockingMillis = l;
            this.totalReconnectPeriodMillis = l2;
        } else {
            this.reconnectPolicy = 0;
            this.reconnectBlockingMillis = 0L;
            this.totalReconnectPeriodMillis = 0L;
        }
    }

    static boolean isT3Client() {
        return isT3Client;
    }

    final void setupDispatcher() throws DispatcherException {
        if (!(this.dispatcherWrapper.getRemoteDispatcher() instanceof DispatcherImpl)) {
            DispatcherId dispatcherId = new DispatcherId(this.dispatcherWrapper.getId(), this.connectionId.getCounter());
            this.dispatcherWrapper.setId(dispatcherId);
        }
        this.dispatcher = JMSDispatcherManager.addDispatcherReference(this.dispatcherWrapper);
        this.dispatcher.addDispatcherPeerGoneListener(this);
    }

    final void setType(int n) {
        this.type = n;
    }

    final int getType() {
        return this.type;
    }

    public final ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.createConnectionConsumer((Destination)topic, string, serverSessionPool, n);
    }

    public final ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        this.checkClosed();
        if (this.type == 1) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation5Loggable());
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logUnsupportedSubscriptionLoggable());
    }

    public final QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        if (n == 128) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoMulticastOnQueueSessionsLoggable());
        }
        SessionInternal sessionInternal = this.createSessionInternal(bl, n, false, 2);
        return sessionInternal;
    }

    public final TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        SessionInternal sessionInternal = this.createSessionInternal(bl, n, false, 1);
        return sessionInternal;
    }

    public final Session createSession(boolean bl, int n) throws JMSException {
        return this.createSessionInternal(bl, n, false, 0);
    }

    protected final SessionInternal createSessionInternal(boolean bl, int n, boolean bl2, int n2) throws JMSException {
        JMSSession jMSSession = this.setupJMSSession(bl, n, bl2, n2);
        WLSessionImpl wLSessionImpl = bl2 ? new XASessionInternalImpl((JMSXASession)jMSSession, (XAConnectionInternalImpl)this.wlConnectionImpl) : new WLSessionImpl(jMSSession, this.wlConnectionImpl);
        jMSSession.setWLSessionImpl(wLSessionImpl);
        return wLSessionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JMSSession setupJMSSession(boolean bl, int n, boolean bl2, int n2) throws JMSException {
        JMSSession jMSSession;
        if (bl2) {
            bl = false;
            n = 2;
            jMSSession = new JMSXASession(this, bl, this.isStopped());
        } else {
            jMSSession = new JMSSession(this, bl, n, this.isStopped());
        }
        jMSSession.setType(n2);
        if (this.xaServerEnabled && KernelStatus.isServer()) {
            jMSSession.setUserTransactionsEnabled(true);
        }
        Response response = this.getFrontEndDispatcher().dispatchSync(new FESessionCreateRequest(this.connectionId, bl, bl2, n, null));
        jMSSession.setId(((FESessionCreateResponse)response).getSessionId());
        jMSSession.setRuntimeMBeanName(((FESessionCreateResponse)response).getRuntimeMBeanName());
        jMSSession.setUnitOfOrder(this.unitOfOrder);
        JMSConnection jMSConnection = this;
        synchronized (jMSConnection) {
            this.sessionAdd(jMSSession);
        }
        return jMSSession;
    }

    public final JMSDispatcher getFrontEndDispatcher() throws JMSException {
        if (this.isClosed()) {
            Object object = this.wlConnectionImpl.getConnectionStateLock();
            synchronized (object) {
                if (this.isReconnectControllerClosed()) {
                    throw new IllegalStateException(JMSClientExceptionLogger.logClosedConnectionLoggable());
                }
                throw new LostServerException(JMSClientExceptionLogger.logLostServerConnectionLoggable());
            }
        }
        return this.dispatcher;
    }

    private void sessionAdd(JMSSession jMSSession) throws JMSException {
        if (this.sessions.put(jMSSession.getJMSID(), jMSSession) != null) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logDuplicateSessionLoggable());
        }
        InvocableManagerDelegate.delegate.invocableAdd(4, jMSSession);
    }

    final synchronized void sessionRemove(JMSID jMSID) {
        if (this.sessions.remove(jMSID) != null) {
            InvocableManagerDelegate.delegate.invocableRemove(4, jMSID);
        }
    }

    public final ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.createConnectionConsumer((Destination)queue, string, serverSessionPool, n);
    }

    public final synchronized String getClientID() throws JMSException {
        this.checkClosed();
        return this.clientId;
    }

    final synchronized String getClientIDInternal() {
        return this.clientId;
    }

    public final synchronized void setClientID(String string) throws JMSException {
        this.setClientIDInternal(string, this.clientIdPolicy);
    }

    public final synchronized void setClientID(String string, String string2) throws IllegalArgumentException, JMSException {
        this.setClientIDInternal(string, WLConnectionImpl.validateAndConvertClientIdPolicy(string2));
    }

    public final synchronized void setClientIDInternal(String string, int n) throws JMSException {
        if (this.clientId != null) {
            throw new IllegalStateException(JMSClientExceptionLogger.logClientIDSetLoggable((String)string, (String)this.clientId));
        }
        if (string == null) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNullClientIDLoggable());
        }
        if (string.length() == 0) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logZeroClientIDLoggable());
        }
        Response response = this.getFrontEndDispatcher().dispatchSync(new FEConnectionSetClientIdRequest(this.connectionId, string, n));
        this.clientId = string;
        this.clientIdPolicy = n;
    }

    public String getClientIDPolicy() {
        return WLConnectionImpl.convertClientIdPolicy(this.clientIdPolicy);
    }

    public String getSubscriptionSharingPolicy() {
        return JMSConnection.getSubscriptionSharingPolicyAsString(this.subscriptionSharingPolicy);
    }

    public int getSubscriptionSharingPolicyAsInt() {
        return this.subscriptionSharingPolicy;
    }

    public void setSubscriptionSharingPolicy(String string) throws JMSException, IllegalArgumentException {
        int n;
        this.subscriptionSharingPolicy = n = JMSConnection.getSubscriptionSharingPolicyAsInt(string);
    }

    public int getClientIDPolicyInt() {
        return this.clientIdPolicy;
    }

    public static int getSubscriptionSharingPolicyAsInt(String string) {
        if (string.equals(JMSConstants.SUBSCRIPTION_EXCLUSIVE)) {
            return 0;
        }
        if (string.equals(JMSConstants.SUBSCRIPTION_SHARABLE)) {
            return 1;
        }
        throw new IllegalArgumentException("Unrecognized SubscriptionSharingPolicy " + string);
    }

    public static String getSubscriptionSharingPolicyAsString(int n) {
        switch (n) {
            case 0: {
                return JMSConstants.SUBSCRIPTION_EXCLUSIVE;
            }
            case 1: {
                return JMSConstants.SUBSCRIPTION_SHARABLE;
            }
        }
        throw new IllegalArgumentException("Unrecognized SubscriptionSharingPolicy " + n);
    }

    public final ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return this;
    }

    public final synchronized void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.checkClosed();
        this.exceptionContext = new JMSExceptionContext(exceptionListener);
    }

    void copyExceptionContext(JMSConnection jMSConnection) {
        this.exceptionContext = jMSConnection.exceptionContext;
    }

    synchronized boolean isStopped() {
        return this.stopped;
    }

    public final synchronized void start() throws JMSException {
        Object object2;
        JMSException jMSException = null;
        this.checkClosed();
        if (!this.stopped) {
            return;
        }
        for (Object object2 : this.sessions.values()) {
            try {
                ((JMSSession)object2).start();
            }
            catch (JMSException jMSException2) {
                if (jMSException != null) continue;
                jMSException = jMSException2;
            }
        }
        object2 = this.getFrontEndDispatcher().dispatchSync(new FEConnectionStartRequest(this.connectionId));
        this.stopped = false;
        if (jMSException != null) {
            throw jMSException;
        }
    }

    private synchronized void resume(JMSConnection jMSConnection) throws JMSException {
        Object object2;
        for (Object object2 : this.sessions.values()) {
            ((JMSSession)object2).resume();
        }
        this.stopped = true;
        if (jMSConnection.stopped) {
            return;
        }
        object2 = this.getFrontEndDispatcher().dispatchSync(new FEConnectionStartRequest(this.connectionId));
        this.stopped = false;
    }

    public final synchronized void stop() throws JMSException {
        this.checkClosed();
        JMSException jMSException = null;
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.isConnected()) {
            Response response = this.getFrontEndDispatcher().dispatchSync(new FEConnectionStopRequest(this.connectionId));
        }
        for (JMSSession jMSSession : this.sessions.values()) {
            try {
                jMSSession.stop();
            }
            catch (JMSException jMSException2) {
                if (jMSException != null) continue;
                jMSException = jMSException2;
            }
        }
        if (jMSException != null) {
            throw jMSException;
        }
    }

    public final void close() throws JMSException {
        this.mergedCloseAndOnException(null, true);
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    public final ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (!KernelStatus.isServer()) {
            throw new IllegalStateException(JMSClientExceptionLogger.logConnectionConsumerOnClientLoggable());
        }
        this.checkClosed();
        if (n == 0 || n < -1) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidMessagesMaximumLoggable((int)n));
        }
        if (destination == null) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logNullDestinationLoggable().getMessage());
        }
        if (!(destination instanceof DestinationImpl)) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logForeignDestinationLoggable().getMessage());
        }
        Response response = this.getFrontEndDispatcher().dispatchSync(new FEConnectionConsumerCreateRequest(this.getJMSID(), serverSessionPool, (DestinationImpl)destination, false, string, n, true));
        return ((JMSConnectionConsumerCreateResponse)response).getConnectionConsumer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupConnection(JMSException jMSException, boolean bl) throws JMSException {
        Externalizable externalizable = this;
        synchronized (externalizable) {
            Object object = this.wlConnectionImpl.getConnectionStateLock();
            synchronized (object) {
                this.markClosed();
            }
            this.stopped = true;
        }
        try {
            block12: {
                try {
                    if (this.isConnected()) {
                        externalizable = this.dispatcher.dispatchSync(new FEConnectionCloseRequest(this.connectionId));
                    }
                }
                catch (JMSException jMSException2) {
                    if (!bl) break block12;
                    throw jMSException2;
                }
            }
            if (bl && jMSException != null) {
                throw jMSException;
            }
            Object var8_8 = null;
            InvocableManagerDelegate.delegate.invocableRemove(3, this.getJMSID());
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            InvocableManagerDelegate.delegate.invocableRemove(3, this.getJMSID());
            JMSDispatcherManager.unexportLocalDispatcher();
            JMSDispatcherManager.removeDispatcherReference(this.dispatcher);
            this.dispatcher.removeDispatcherPeerGoneListener(this);
            throw throwable;
        }
        JMSDispatcherManager.unexportLocalDispatcher();
        JMSDispatcherManager.removeDispatcherReference(this.dispatcher);
        this.dispatcher.removeDispatcherPeerGoneListener(this);
    }

    boolean isConnected() {
        return this.dispatcher.isLocal() || this.dispatcher.getDelegate() instanceof DispatcherWrapperState && !((DispatcherWrapperState)this.dispatcher.getDelegate()).getPeerGoneCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void mergedCloseAndOnException(JMSException var1_1, boolean var2_2) throws JMSException {
        block81: {
            block82: {
                block80: {
                    var3_3 = null;
                    var4_4 = false;
                    var5_5 = false;
                    var6_6 = null;
                    v0 = var7_7 = var1_1 == null;
                    if (ReconnectController.TODOREMOVEDebug) {
                        JMSConnection.displayExceptionCauses("DEBUG JMSConnection onException", var1_1);
                    }
                    var8_8 = this.wlConnectionImpl.getConnectionStateLock();
                    try {
                        block70: {
                            block75: {
                                block76: {
                                    block71: {
                                        block73: {
                                            block74: {
                                                block72: {
                                                    var9_9 = this;
                                                    // MONITORENTER : var9_9
                                                    var10_10 = var8_8;
                                                    // MONITORENTER : var10_10
                                                    if (this.wlConnectionImpl.getPhysical() != this) {
                                                        block68: {
                                                            // MONITOREXIT : var10_10
                                                            // MONITOREXIT : var9_9
                                                            var15_11 = null;
                                                            try {
                                                                try {
                                                                    if (var4_4 || this.wlConnectionImpl.getPhysical() != this) {
                                                                        v1 = null;
                                                                        break block68;
                                                                    }
                                                                    this.cleanupConnection(null, var2_2);
                                                                }
                                                                catch (JMSException var16_15) {
                                                                    // empty catch block
                                                                }
                                                                v1 = null;
                                                            }
                                                            catch (Throwable var17_19) {
                                                                v1 = null;
                                                            }
                                                        }
                                                        var18_23 = v1;
                                                        var20_27 = var8_8;
                                                        // MONITORENTER : var20_27
                                                        if (var4_4 || this.wlConnectionImpl.getPhysical() != this) {
                                                            // MONITOREXIT : var20_27
                                                            return;
                                                        }
                                                        var19_31 = this.updateState(var5_5);
                                                        if (var7_7) {
                                                            this.wlConnectionImpl.updateFirstReconnectTime();
                                                            if (var19_31) {
                                                                this.scheduleReconnectTimer();
                                                            }
                                                            // MONITOREXIT : var20_27
                                                            return;
                                                        }
                                                        // MONITOREXIT : var20_27
                                                        try {
                                                            JMSConnection.onException(var1_1, var6_6);
                                                            var23_35 = null;
                                                            if (var19_31 == false) return;
                                                            var24_43 = var8_8;
                                                            // MONITORENTER : var24_43
                                                            if (this == this.wlConnectionImpl.getPhysical() && this.wlConnectionImpl.getReconnectPolicyInternal() != 0 && this.wlConnectionImpl.getState() == 512) {
                                                                this.wlConnectionImpl.updateFirstReconnectTime();
                                                                this.scheduleReconnectTimer();
                                                            }
                                                            // MONITOREXIT : var24_43
                                                            return;
                                                        }
                                                        catch (Throwable var22_51) {
                                                            var23_36 = null;
                                                            if (var19_31 == false) throw var22_51;
                                                            var24_44 = var8_8;
                                                            // MONITORENTER : var24_44
                                                            if (this == this.wlConnectionImpl.getPhysical() && this.wlConnectionImpl.getReconnectPolicyInternal() != 0 && this.wlConnectionImpl.getState() == 512) {
                                                                this.wlConnectionImpl.updateFirstReconnectTime();
                                                                this.scheduleReconnectTimer();
                                                            }
                                                            // MONITOREXIT : var24_44
                                                            throw var22_51;
                                                        }
                                                    }
                                                    var6_6 = this.exceptionContext;
                                                    var7_7 = var6_6 == null || var1_1 == null || this.firedExceptoinListener != false;
                                                    this.firedExceptoinListener = true;
                                                    var3_3 = this.sessions.cloneValuesIterator();
                                                    if (var1_1 != null) {
                                                        this.wlConnectionImpl.setLastProblem(var1_1);
                                                        for (var11_55 = var1_1; var11_55 != null; var11_55 = var11_55.getCause()) {
                                                            if (!(var11_55 instanceof DestroyConnectionException)) continue;
                                                            this.setPreDisconnectState(null);
                                                            this.wlConnectionImpl.setRecursiveStateNotify(-2304);
                                                            break;
                                                        }
                                                    }
                                                    if (!(var4_4 = this.isClosed())) break block71;
                                                    // MONITOREXIT : var10_10
                                                    // MONITOREXIT : var9_9
                                                    var15_12 = null;
                                                    ** try [egrp 6[TRYBLOCK] [14 : 356->393)] { 
lbl91:
                                                    // 1 sources

                                                    ** try [egrp 7[TRYBLOCK] [12 : 356->372)] { 
lbl92:
                                                    // 1 sources

                                                    if (!var4_4 && this.wlConnectionImpl.getPhysical() == this) break block72;
                                                    v2 = null;
                                                    break block73;
                                                }
                                                this.cleanupConnection(null, var2_2);
                                                break block74;
lbl98:
                                                // 1 sources

                                                catch (JMSException var16_16) {
                                                    // empty catch block
                                                }
                                            }
                                            v2 = null;
                                            break block73;
lbl103:
                                            // 1 sources

                                            catch (Throwable var17_20) {
                                                v2 = null;
                                            }
                                        }
                                        var18_24 = v2;
                                        var20_28 = var8_8;
                                        // MONITORENTER : var20_28
                                        if (var4_4 || this.wlConnectionImpl.getPhysical() != this) {
                                            // MONITOREXIT : var20_28
                                            return;
                                        }
                                        var19_32 = this.updateState(var5_5);
                                        if (var7_7) {
                                            this.wlConnectionImpl.updateFirstReconnectTime();
                                            if (var19_32) {
                                                this.scheduleReconnectTimer();
                                            }
                                            // MONITOREXIT : var20_28
                                            return;
                                        }
                                        // MONITOREXIT : var20_28
                                        try {}
                                        catch (Throwable var22_52) {
                                            var23_38 = null;
                                            if (var19_32 == false) throw var22_52;
                                            var24_46 = var8_8;
                                            // MONITORENTER : var24_46
                                            if (this == this.wlConnectionImpl.getPhysical() && this.wlConnectionImpl.getReconnectPolicyInternal() != 0 && this.wlConnectionImpl.getState() == 512) {
                                                this.wlConnectionImpl.updateFirstReconnectTime();
                                                this.scheduleReconnectTimer();
                                            }
                                            // MONITOREXIT : var24_46
                                            throw var22_52;
                                        }
                                        JMSConnection.onException(var1_1, var6_6);
                                        var23_37 = null;
                                        if (var19_32 == false) return;
                                        var24_45 = var8_8;
                                        // MONITORENTER : var24_45
                                        if (this == this.wlConnectionImpl.getPhysical() && this.wlConnectionImpl.getReconnectPolicyInternal() != 0 && this.wlConnectionImpl.getState() == 512) {
                                            this.wlConnectionImpl.updateFirstReconnectTime();
                                            this.scheduleReconnectTimer();
                                        }
                                        // MONITOREXIT : var24_45
                                        return;
                                    }
                                    var11_56 = this.wlConnectionImpl.getState();
                                    if (var1_1 == null) break block75;
                                    if (var11_56 != 0) break block76;
                                    var5_5 = this.wlConnectionImpl.rememberReconnectState(this, 1040);
                                    break block70;
                                }
                                if (var11_56 == 1028) {
                                    v3 = var5_5 = this.getPreDisconnectState() != null;
                                    if (var5_5) {
                                        this.wlConnectionImpl.setRecursiveStateNotify(1040);
                                        break block70;
                                    } else {
                                        this.setPreDisconnectState(null);
                                        this.recurseSetNoRetry(this.wlConnectionImpl);
                                    }
                                }
                                break block70;
                            }
                            if (var11_56 == 0 || var11_56 == 1028) {
                                this.wlConnectionImpl.setRecursiveStateNotify(1040);
                            }
                        }
                        // MONITOREXIT : var10_10
                        // MONITOREXIT : var9_9
                        this.closeSessions(var3_3);
                        var15_13 = null;
                    }
                    catch (Throwable var14_57) {
                        block78: {
                            block79: {
                                block77: {
                                    var15_14 = null;
                                    ** try [egrp 6[TRYBLOCK] [14 : 356->393)] { 
lbl175:
                                    // 1 sources

                                    ** try [egrp 7[TRYBLOCK] [12 : 356->372)] { 
lbl176:
                                    // 1 sources

                                    if (!var4_4 && this.wlConnectionImpl.getPhysical() == this) break block77;
                                    v4 = null;
                                    break block78;
                                }
                                this.cleanupConnection(null, var2_2);
                                break block79;
lbl182:
                                // 1 sources

                                catch (JMSException var16_18) {
                                    // empty catch block
                                }
                            }
                            v4 = null;
                            break block78;
lbl187:
                            // 1 sources

                            catch (Throwable var17_22) {
                                v4 = null;
                            }
                        }
                        var18_26 = v4;
                        var20_30 = var8_8;
                        // MONITORENTER : var20_30
                        if (var4_4 || this.wlConnectionImpl.getPhysical() != this) {
                            // MONITOREXIT : var20_30
                            return;
                        }
                        var19_34 = this.updateState(var5_5);
                        if (var7_7) {
                            this.wlConnectionImpl.updateFirstReconnectTime();
                            if (var19_34) {
                                this.scheduleReconnectTimer();
                            }
                            // MONITOREXIT : var20_30
                            return;
                        }
                        // MONITOREXIT : var20_30
                        try {}
                        catch (Throwable var22_54) {
                            var23_42 = null;
                            if (var19_34 == false) throw var22_54;
                            var24_50 = var8_8;
                            // MONITORENTER : var24_50
                            if (this == this.wlConnectionImpl.getPhysical() && this.wlConnectionImpl.getReconnectPolicyInternal() != 0 && this.wlConnectionImpl.getState() == 512) {
                                this.wlConnectionImpl.updateFirstReconnectTime();
                                this.scheduleReconnectTimer();
                            }
                            // MONITOREXIT : var24_50
                            throw var22_54;
                        }
                        JMSConnection.onException(var1_1, var6_6);
                        var23_41 = null;
                        if (var19_34 == false) throw var14_57;
                        var24_49 = var8_8;
                        // MONITORENTER : var24_49
                        if (this == this.wlConnectionImpl.getPhysical() && this.wlConnectionImpl.getReconnectPolicyInternal() != 0 && this.wlConnectionImpl.getState() == 512) {
                            this.wlConnectionImpl.updateFirstReconnectTime();
                            this.scheduleReconnectTimer();
                        }
                        // MONITOREXIT : var24_49
                        throw var14_57;
                    }
                    ** try [egrp 6[TRYBLOCK] [14 : 356->393)] { 
lbl231:
                    // 1 sources

                    ** try [egrp 7[TRYBLOCK] [12 : 356->372)] { 
lbl232:
                    // 1 sources

                    if (!var4_4 && this.wlConnectionImpl.getPhysical() == this) break block80;
                    v5 = null;
                    break block81;
                }
                this.cleanupConnection(null, var2_2);
                break block82;
lbl238:
                // 1 sources

                catch (JMSException var16_17) {
                    // empty catch block
                }
            }
            v5 = null;
            break block81;
lbl243:
            // 1 sources

            catch (Throwable var17_21) {
                v5 = null;
            }
        }
        var18_25 = v5;
        var20_29 = var8_8;
        // MONITORENTER : var20_29
        if (var4_4 || this.wlConnectionImpl.getPhysical() != this) {
            // MONITOREXIT : var20_29
            return;
        }
        var19_33 = this.updateState(var5_5);
        if (var7_7) {
            this.wlConnectionImpl.updateFirstReconnectTime();
            if (var19_33) {
                this.scheduleReconnectTimer();
            }
            // MONITOREXIT : var20_29
            return;
        }
        // MONITOREXIT : var20_29
        try {}
        catch (Throwable var22_53) {
            var23_40 = null;
            if (var19_33 == false) throw var22_53;
            var24_48 = var8_8;
            // MONITORENTER : var24_48
            if (this == this.wlConnectionImpl.getPhysical() && this.wlConnectionImpl.getReconnectPolicyInternal() != 0 && this.wlConnectionImpl.getState() == 512) {
                this.wlConnectionImpl.updateFirstReconnectTime();
                this.scheduleReconnectTimer();
            }
            // MONITOREXIT : var24_48
            throw var22_53;
        }
        JMSConnection.onException(var1_1, var6_6);
        var23_39 = null;
        if (var19_33 == false) return;
        var24_47 = var8_8;
        // MONITORENTER : var24_47
        if (this == this.wlConnectionImpl.getPhysical() && this.wlConnectionImpl.getReconnectPolicyInternal() != 0 && this.wlConnectionImpl.getState() == 512) {
            this.wlConnectionImpl.updateFirstReconnectTime();
            this.scheduleReconnectTimer();
        }
        // MONITOREXIT : var24_47
    }

    private boolean updateState(boolean bl) {
        int n = this.wlConnectionImpl.getState();
        int n2 = n == 1040 || n == 1028 ? (bl && this.preDisconnectState != null && this.wlConnectionImpl.getReconnectPolicyInternal() != 0 ? 512 : -2304) : n;
        if (n2 == -2304) {
            JMSConnection.recurseSetNoRetry(this.sessions, this);
        }
        this.wlConnectionImpl.setRecursiveStateNotify(n2);
        return 512 == n2;
    }

    static void displayExceptionCauses(String string, Throwable throwable) {
        String string2 = " exception  ";
        if (throwable == null) {
            System.err.println(string + string2 + " null argument");
        }
        for (int i = 1; i < 40 && throwable != null; ++i) {
            NestedThrowable nestedThrowable;
            String string3 = throwable instanceof LostServerException && ((LostServerException)((Object)throwable)).isReplayLastException() ? " and isReplay" : "";
            System.err.println(string + string2 + i + ", " + throwable.getClass() + string3);
            if (throwable instanceof NestedThrowable && (nestedThrowable = (NestedThrowable)throwable).getNested() != null) {
                if (null != throwable.getCause()) {
                    JMSConnection.displayExceptionCauses(string + "[has funky getCause()" + i + "]", throwable.getCause());
                }
                throwable = nestedThrowable.getNested();
                string2 = " NestedThrowable.getNested() ";
                continue;
            }
            throwable = throwable.getCause();
            string2 = " with cause ";
        }
    }

    private void closeSessions(Iterator iterator) throws JMSException {
        JMSException jMSException = null;
        while (iterator != null && iterator.hasNext()) {
            JMSSession jMSSession = (JMSSession)iterator.next();
            try {
                jMSSession.close();
            }
            catch (JMSException jMSException2) {
                if (jMSException != null) continue;
                jMSException = jMSException2;
            }
        }
        if (jMSException != null) {
            throw jMSException;
        }
    }

    Timer clearTimerInfo() {
        Timer timer = this.timer;
        this.timer = null;
        return timer;
    }

    private Timer resetIntervalClearTimer() {
        this.nextRetry = INITIAL_RETRY_DELAY;
        return this.clearTimerInfo();
    }

    boolean scheduleReconnectTimer() {
        if (ReconnectController.TODOREMOVEDebug) {
            new Exception("DEBUG 1054").printStackTrace();
        }
        long l = System.currentTimeMillis();
        long l2 = this.nextRetry;
        if (this.wlConnectionImpl.getLastReconnectTimer() > 0L && this.wlConnectionImpl.getLastReconnectTimer() - l < l2) {
            this.wlConnectionImpl.clearLastReconnectTimer();
            this.wlConnectionImpl.getConnectionStateLock().notifyAll();
            this.clearTimerInfo();
            return false;
        }
        this.nextRetry <<= 1;
        if (this.nextRetry > 300000L) {
            this.nextRetry = 300000L;
        } else if (this.nextRetry < 5000L) {
            this.nextRetry = 5000L;
        }
        if ((long)INITIAL_RETRY_DELAY == l2) {
            JMSConnection.getReconnectWorkManager().schedule((Runnable)this);
        } else {
            this.timer = this.getReconnectTimerManager(JMSConnection.getReconnectWorkManager()).schedule((TimerListener)this, l2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WorkManager getReconnectWorkManager() {
        Object object = TIMER_WORKMANAGER_LOCK;
        synchronized (object) {
            if (RECONNECT_WORK_MANAGER == null) {
                RECONNECT_WORK_MANAGER = WorkManagerFactory.getInstance().findOrCreate(RECONNECT_ID, 1, 5);
            }
            return RECONNECT_WORK_MANAGER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerManager getReconnectTimerManager(WorkManager workManager) {
        Object object = TIMER_WORKMANAGER_LOCK;
        synchronized (object) {
            if (RECONNECT_TIMER_MANAGER == null) {
                RECONNECT_TIMER_MANAGER = TimerManagerFactory.getTimerManagerFactory().getTimerManager(RECONNECT_ID, workManager);
            }
            return RECONNECT_TIMER_MANAGER;
        }
    }

    private boolean isWithinReconnectTime() {
        long l = System.currentTimeMillis();
        long l2 = this.wlConnectionImpl.getTotalReconnectPeriodMillis();
        return l2 == -1L || l - this.wlConnectionImpl.getFirstReconnectTime() <= l2;
    }

    public void timerExpired(Timer timer) {
        if (this.isWithinReconnectTime()) {
            this.wlConnectionImpl.processReconnectTimer(this);
        } else {
            this.setPreDisconnectState(null);
            this.recurseSetNoRetry(this.wlConnectionImpl);
            LostServerException lostServerException = new LostServerException("Failed to reconnect to Server within the configured reconnect time of " + this.getTotalReconnectPeriodMillis() / 1000L + " seconds");
            if (this.exceptionContext != null) {
                JMSConnection.onException(lostServerException, this.exceptionContext);
            } else if (ReconnectController.TODOREMOVEDebug) {
                JMSConnection.displayExceptionCauses("Failed to reconnect to Server within the configured reconnect time of " + this.getTotalReconnectPeriodMillis() / 1000L + " seconds", (Throwable)((Object)new LostServerException("Network or Server down")));
            }
        }
    }

    public void run() {
        this.wlConnectionImpl.processReconnectTimer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void onException(JMSException jMSException, JMSExceptionContext jMSExceptionContext) {
        if (ReconnectController.TODOREMOVEDebug) {
            new Exception("DEBUG 1137").printStackTrace();
        }
        JMSContext jMSContext = JMSContext.push(jMSExceptionContext, true);
        try {
            try {
                jMSExceptionContext.invokeListener(jMSException);
            }
            catch (Exception exception) {
                JMSClientExceptionLogger.logStackTrace((Throwable)exception);
                Object var5_4 = null;
                JMSContext.pop(jMSContext, true);
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            JMSContext.pop(jMSContext, true);
            throw throwable;
        }
        JMSContext.pop(jMSContext, true);
    }

    private static boolean isJMS110() {
        Field field;
        try {
            Class<?> clazz = Class.forName("javax.jms.Session");
            field = clazz.getDeclaredField("SESSION_TRANSACTED");
        }
        catch (Throwable throwable) {
            field = null;
        }
        return field != null;
    }

    public final String getJMSVersion() {
        if (JMSConnection.isJMS110()) {
            return "1.1";
        }
        return "1.0.2b";
    }

    public final int getJMSMajorVersion() {
        return 1;
    }

    public final int getJMSMinorVersion() {
        if (JMSConnection.isJMS110()) {
            return 1;
        }
        return 0;
    }

    public final String getJMSProviderName() {
        return JMS_PROVIDER_NAME;
    }

    public final String getProviderVersion() {
        return PROVIDER_VERSION;
    }

    public final int getProviderMajorVersion() {
        return 9;
    }

    public final int getProviderMinorVersion() {
        return 0;
    }

    void setWlConnectionImpl(WLConnectionImpl wLConnectionImpl) {
        if (this.wlConnectionImpl == null || wLConnectionImpl.getConnectionStateLock() != this.wlConnectionImpl.getConnectionStateLock()) {
            this.sessions.setLock(wLConnectionImpl.getConnectionStateLock());
            this.durableSubscribers.setLock(wLConnectionImpl.getConnectionStateLock());
        }
        this.wlConnectionImpl = wLConnectionImpl;
    }

    JMSConnection getReplacementConnection() {
        return this.replacementConnection;
    }

    void setReplacementConnection(JMSConnection jMSConnection) {
        this.replacementConnection = jMSConnection;
    }

    public final Enumeration getJMSXPropertyNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("JMSXDeliveryCount");
        vector.add("JMSXGroupID");
        vector.add("JMSXGroupSeq");
        vector.add("JMSXUserID");
        return vector.elements();
    }

    public int incrementRefCount() {
        return ++this.refCount;
    }

    public int decrementRefCount() {
        return --this.refCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChangeListener(DispatcherStateChangeListener dispatcherStateChangeListener, Throwable throwable) {
        if (dispatcherStateChangeListener != this) {
            return;
        }
        JMSConnection jMSConnection = this;
        synchronized (jMSConnection) {
            Object object = this.wlConnectionImpl.getConnectionStateLock();
            synchronized (object) {
                if (this.wlConnectionImpl.getPhysical() == this && this.wlConnectionImpl.getState() == 0) {
                    this.wlConnectionImpl.rememberReconnectState(this, 1028);
                }
            }
        }
    }

    public boolean holdsLock() {
        if (Thread.holdsLock(this)) {
            return true;
        }
        WLConnectionImpl wLConnectionImpl = this.wlConnectionImpl;
        if (wLConnectionImpl == null) {
            return false;
        }
        Object object = wLConnectionImpl.getConnectionStateLock();
        if (object == null) {
            return false;
        }
        return Thread.holdsLock(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void dispatcherPeerGone(Exception exception, Dispatcher dispatcher) {
        LostServerException lostServerException = new LostServerException(exception);
        AbstractSubject abstractSubject = SubjectManager.getSubjectManager().getCurrentSubject(KernelID);
        try {
            try {
                if (abstractSubject.equals(KernelID)) {
                    SubjectManager.getSubjectManager().pushSubject(KernelID, SubjectManager.getSubjectManager().getAnonymousSubject());
                }
                this.mergedCloseAndOnException(lostServerException, false);
            }
            catch (JMSException jMSException) {
                Object var7_6 = null;
                if (!abstractSubject.equals(KernelID)) return;
                SubjectManager.getSubjectManager().popSubject(KernelID);
                return;
            }
            Object var7_5 = null;
            if (!abstractSubject.equals(KernelID)) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!abstractSubject.equals(KernelID)) throw throwable;
            SubjectManager.getSubjectManager().popSubject(KernelID);
            throw throwable;
        }
        SubjectManager.getSubjectManager().popSubject(KernelID);
    }

    private void markClosed() {
        this.isClosed = true;
    }

    public ReconnectController getReconnectController() {
        return this.wlConnectionImpl;
    }

    JMSConnection getPreDisconnectState() {
        return this.preDisconnectState;
    }

    void setPreDisconnectState(JMSConnection jMSConnection) {
        this.preDisconnectState = jMSConnection;
    }

    public Reconnectable getReconnectState(int n) throws CloneNotSupportedException {
        JMSConnection jMSConnection = (JMSConnection)this.clone();
        jMSConnection.sessions = WLConnectionImpl.reconnectPolicyHas(2, n) ? JMSConnection.recurseGetReconnectState(jMSConnection.sessions, n) : JMSConnection.recurseSetNoRetry(jMSConnection.sessions, this);
        jMSConnection.preDisconnectState = null;
        this.preDisconnectState = jMSConnection;
        return jMSConnection;
    }

    static LockedMap recurseGetReconnectState(LockedMap lockedMap, int n) throws CloneNotSupportedException {
        Iterator iterator = lockedMap.valuesIterator();
        LockedMap lockedMap2 = new LockedMap(lockedMap.getName(), lockedMap.getLock());
        while (iterator.hasNext()) {
            Reconnectable reconnectable = (Reconnectable)iterator.next();
            if (reconnectable.isReconnectControllerClosed() || (reconnectable = reconnectable.getReconnectState(n)) == null) continue;
            lockedMap2.put(reconnectable, reconnectable);
        }
        return lockedMap2;
    }

    static LockedMap recurseSetNoRetry(LockedMap lockedMap, JMSConnection jMSConnection) {
        boolean bl = false;
        Iterator iterator = lockedMap.valuesIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Reconnectable)) continue;
            ReconnectController reconnectController = ((Reconnectable)e).getReconnectController();
            if (reconnectController != null && reconnectController.getWLConnectionImpl().getPhysical() == jMSConnection) {
                bl = true;
                reconnectController.setRecursiveState(-2304);
            }
            ((Reconnectable)e).forgetReconnectState();
        }
        if (bl) {
            jMSConnection.wlConnectionImpl.getConnectionStateLock().notifyAll();
        }
        return new LockedMap(lockedMap.getName(), lockedMap.getLock());
    }

    void recurseSetNoRetry(WLConnectionImpl wLConnectionImpl) {
        JMSConnection.recurseSetNoRetry(this.sessions, this);
        wLConnectionImpl.setRecursiveStateNotify(-2304);
    }

    boolean hasTemporaryDestination() {
        Iterator iterator = this.sessions.valuesIterator();
        while (iterator.hasNext()) {
            if (!((JMSSession)iterator.next()).hasTemporaryDestination()) continue;
            return true;
        }
        return false;
    }

    static void recursePreCreateReplacement(Reconnectable reconnectable, LockedMap lockedMap) throws JMSException {
        Iterator iterator = lockedMap.cloneValuesIterator();
        while (iterator.hasNext()) {
            Reconnectable reconnectable2 = (Reconnectable)iterator.next();
            if (reconnectable2.isReconnectControllerClosed()) continue;
            reconnectable2.preCreateReplacement(reconnectable);
        }
    }

    static void recursePostCreateReplacement(LockedMap lockedMap) {
        Iterator iterator = lockedMap.cloneValuesIterator();
        while (iterator.hasNext()) {
            Reconnectable reconnectable = (Reconnectable)iterator.next();
            if (reconnectable.isReconnectControllerClosed()) continue;
            reconnectable.postCreateReplacement();
        }
    }

    void rememberCredentials(String string, String string2, boolean bl) {
        this.wantXAConnection = bl;
        try {
            this.pwdStore = new PasswordStore();
            this.uHandle = this.pwdStore.storePassword(string);
            this.pHandle = this.pwdStore.storePassword(string2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.pwdStore = null;
            this.uHandle = string;
            this.pHandle = string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reconnectable preCreateReplacement(Reconnectable reconnectable) throws JMSException {
        String string;
        String string2;
        JMSConnection jMSConnection = this.preDisconnectState;
        if (jMSConnection == null) {
            return null;
        }
        WLConnectionImpl wLConnectionImpl = jMSConnection.wlConnectionImpl;
        Object object = wLConnectionImpl.getConnectionStateLock();
        synchronized (object) {
            if (jMSConnection.pwdStore != null) {
                try {
                    string2 = (String)jMSConnection.pwdStore.retrievePassword(jMSConnection.uHandle);
                    string = (String)jMSConnection.pwdStore.retrievePassword(jMSConnection.pHandle);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new weblogic.jms.common.JMSException(generalSecurityException);
                }
                catch (IOException iOException) {
                    throw new weblogic.jms.common.JMSException(iOException);
                }
            } else {
                string2 = (String)jMSConnection.uHandle;
                string = (String)jMSConnection.pHandle;
            }
        }
        object = ((JMSConnectionFactory)reconnectable).setupJMSConnection(string2, string, jMSConnection.wantXAConnection, jMSConnection.type);
        try {
            Object object2;
            ((JMSConnection)object).setWlConnectionImpl(wLConnectionImpl);
            if (jMSConnection.clientId != null && ((JMSConnection)object).clientId == null) {
                ((JMSConnection)object).setClientID(jMSConnection.clientId);
            }
            ((JMSConnection)object).setAllowCloseInOnMessage(jMSConnection.allowCloseInOnMessage);
            ((JMSConnection)object).setDispatchPolicy(jMSConnection.dispatchPolicyName);
            JMSConnection.recursePreCreateReplacement((Reconnectable)object, jMSConnection.sessions);
            Object object3 = wLConnectionImpl.getConnectionStateLock();
            synchronized (object3) {
                int n = wLConnectionImpl.getState();
                if (n != 1536) throw new LostServerException(wLConnectionImpl.wrongStateString(n));
                Object object4 = object;
                this.setReplacementConnection((JMSConnection)object4);
                object = null;
                object2 = object4;
            }
            Object var13_13 = null;
            try {
                if (object == null) return object2;
                ((JMSConnection)object).close();
                return object2;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            return object2;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {}
            catch (JMSException jMSException) {
                throw throwable;
            }
            if (object == null) throw throwable;
            ((JMSConnection)object).close();
            throw throwable;
        }
    }

    public void postCreateReplacement() {
        Timer timer;
        if (ReconnectController.TODOREMOVEDebug) {
            System.err.println("debug JMSConnection stale " + this.preDisconnectState.debugMaps());
        }
        if ((timer = this.resetIntervalClearTimer()) != null) {
            timer.cancel();
        }
        JMSConnection.recursePostCreateReplacement(this.preDisconnectState.sessions);
        JMSContext jMSContext = this.preDisconnectState.wlConnectionImpl.getConnectionEstablishContext();
        this.getReplacementConnection().setWlConnectionImpl(this.preDisconnectState.wlConnectionImpl);
        JMSConnection jMSConnection = this.preDisconnectState;
        jMSConnection.forgetReconnectState();
        this.preDisconnectState = null;
        this.getReplacementConnection().wlConnectionImpl.setConnectionEstablishContext(jMSContext);
        this.wlConnectionImpl.setPhysicalReconnectable(this.getReplacementConnection());
        if (ReconnectController.TODOREMOVEDebug) {
            System.err.println("debug JMSConnection reconnect " + this.getReplacementConnection().debugMaps());
        }
    }

    String debugMaps() {
        String string = null;
        Iterator iterator = this.sessions.valuesIterator();
        while (iterator.hasNext()) {
            String string2 = ((JMSSession)iterator.next()).debugMaps();
            if (string == null) {
                string = "< " + string2;
                continue;
            }
            string = string + "\n  " + string2;
        }
        return string + "\n>";
    }

    public Object clone() throws CloneNotSupportedException {
        JMSConnection jMSConnection = (JMSConnection)super.clone();
        jMSConnection.sessions = (LockedMap)this.sessions.clone();
        jMSConnection.durableSubscribers = (LockedMap)this.durableSubscribers.clone();
        return jMSConnection;
    }

    public boolean isReconnectControllerClosed() {
        return this.wlConnectionImpl.isClosed();
    }

    public final synchronized ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        if (this.exceptionContext != null) {
            return this.exceptionContext.getExceptionListener();
        }
        return null;
    }

    public final synchronized JMSExceptionContext getJMSExceptionContext() throws JMSException {
        this.checkClosed();
        return this.exceptionContext;
    }

    public final ClientRuntimeInfo getParentInfo() {
        return this;
    }

    public final String getWLSServerName() {
        return this.wlsServerName;
    }

    public final String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public final String toString() {
        return this.getRuntimeMBeanName();
    }

    final int getDeliveryMode() {
        return this.deliveryMode;
    }

    final int getPriority() {
        return this.priority;
    }

    final long getTimeToDeliver() {
        return this.timeToDeliver;
    }

    final long getTimeToLive() {
        return this.timeToLive;
    }

    final long getSendTimeout() {
        return this.sendTimeout;
    }

    final long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAcknowledgePolicy(int n) {
        Object object = this.acknowledgePolicyLock;
        synchronized (object) {
            this.acknowledgePolicy = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getAcknowledgePolicy() {
        Object object = this.acknowledgePolicyLock;
        synchronized (object) {
            return this.acknowledgePolicy;
        }
    }

    final int getOverrunPolicy() {
        return this.overrunPolicy;
    }

    public final boolean isXAServerEnabled() {
        return this.xaServerEnabled;
    }

    final boolean isFlowControlEnabled() {
        return this.flowControl;
    }

    final int getFlowMinimum() {
        return this.flowMinimum;
    }

    final int getFlowMaximum() {
        return this.flowMaximum;
    }

    final int getFlowIncrease() {
        return this.flowIncrease;
    }

    final double getFlowDecrease() {
        return this.flowDecrease;
    }

    final long getFlowInterval() {
        return this.flowInterval;
    }

    final int getMessagesMaximum() {
        return this.messagesMaximum;
    }

    public final boolean getUserTransactionsEnabled() {
        return this.userTransactionsEnabled;
    }

    public final boolean getAllowCloseInOnMessage() {
        return this.allowCloseInOnMessage;
    }

    public final void setAllowCloseInOnMessage(boolean bl) {
        this.allowCloseInOnMessage = bl;
    }

    public void setReconnectPolicy(String string) {
        this.wlConnectionImpl.setReconnectPolicy(string);
    }

    public String getReconnectPolicy() {
        return this.wlConnectionImpl.getReconnectPolicy();
    }

    public void setReconnectBlockingMillis(long l) {
        this.wlConnectionImpl.setReconnectBlockingMillis(l);
    }

    public long getReconnectBlockingMillis() {
        return this.wlConnectionImpl.getReconnectBlockingMillis();
    }

    public long getTotalReconnectPeriodMillis() {
        return this.wlConnectionImpl.getTotalReconnectPeriodMillis();
    }

    public void setTotalReconnectPeriodMillis(long l) {
        this.wlConnectionImpl.setTotalReconnectPeriodMillis(l);
    }

    public int getPipelineGeneration() {
        return this.pipelineGeneration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean markDurableSubscriber(String string) {
        Object object = this.sublock;
        synchronized (object) {
            if (this.durableSubscribers.get(string) != null) {
                return false;
            }
            return this.durableSubscribers.put(string, new Object()) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addDurableSubscriber(String string, Object object) {
        Object object2 = this.sublock;
        synchronized (object2) {
            this.durableSubscribers.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean removeDurableSubscriber(String string) {
        Object object = this.sublock;
        synchronized (object) {
            return this.durableSubscribers.remove(string) != null;
        }
    }

    final synchronized String getDispatchPolicy() {
        return this.dispatchPolicyName;
    }

    public final synchronized void setDispatchPolicy(String string) {
        this.dispatchPolicyName = string;
    }

    public final JMSID getJMSID() {
        return this.connectionId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    final int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    final int getSynchronousPrefetchMode() {
        return this.synchronousPrefetchMode;
    }

    final int getOneWaySendMode() {
        return this.oneWaySendMode;
    }

    final int getOneWaySendWindowSize() {
        return this.oneWaySendWindowSize;
    }

    public final InvocableMonitor getInvocableMonitor() {
        return null;
    }

    final int getReconnectPolicyInternal() {
        if (PeerInfo.VERSION_901.compareTo((Object)this.getFEPeerInfo()) > 0) {
            this.reconnectPolicy = 0;
        }
        return this.reconnectPolicy;
    }

    final long getReconnectBlockingMillisInternal() {
        return this.reconnectBlockingMillis;
    }

    final long getTotalReconnectPeriodMillisInternal() {
        return this.totalReconnectPeriodMillis;
    }

    public final void destroyTemporaryDestination(JMSServerId jMSServerId, JMSID jMSID) throws JMSException {
        this.checkClosed();
        Response response = this.dispatcher.dispatchSync(new FETemporaryDestinationDestroyRequest(this.getJMSID(), jMSID));
    }

    final void consumerRemove(String string) throws JMSException {
        Response response = this.dispatcher.dispatchSync(new FERemoveSubscriptionRequest(this.clientId, string));
    }

    final void consumerRemove(DestinationImpl destinationImpl, String string) throws JMSException {
        Response response = this.dispatcher.dispatchSync(new FERemoveSubscriptionRequest(this.clientId, string, this.clientIdPolicy, destinationImpl));
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkClosed() throws JMSException {
        this.getFrontEndDispatcher();
    }

    public final void publicCheckClosed() throws JMSException {
        this.checkClosed();
    }

    public final byte getPeerVersion() {
        return this.version;
    }

    public JMSConnection() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        byte by;
        byte by2 = by = this.getVersion(objectOutput);
        if (by >= 4) {
            if (this.sendTimeout != 10L) {
                by2 = (byte)(by2 | 0x40);
            }
            if (by >= 5) {
                n = 1 | this.pipelineGeneration;
                if (this.unitOfOrder != null) {
                    n |= 2;
                }
            } else {
                n = 0;
            }
        } else {
            n = 0;
        }
        if (this.peerVersionable != null) {
            this.peerVersionable.setPeerVersion(by);
        }
        objectOutput.writeByte(by2);
        this.connectionId.writeExternal(objectOutput);
        if (this.clientId == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.clientId);
        }
        objectOutput.writeInt(this.deliveryMode);
        objectOutput.writeInt(this.priority);
        objectOutput.writeInt(this.messagesMaximum);
        objectOutput.writeInt(this.overrunPolicy);
        objectOutput.writeLong(this.timeToDeliver);
        objectOutput.writeLong(this.timeToLive);
        objectOutput.writeLong(this.redeliveryDelay);
        objectOutput.writeLong(this.transactionTimeout);
        objectOutput.writeBoolean(this.userTransactionsEnabled);
        objectOutput.writeBoolean(this.allowCloseInOnMessage);
        objectOutput.writeInt(this.acknowledgePolicy);
        this.dispatcherWrapper.writeExternal(objectOutput);
        if (by >= 3) {
            objectOutput.writeBoolean(this.flowControl);
            if (this.flowControl) {
                objectOutput.writeInt(this.flowMinimum);
                objectOutput.writeInt(this.flowMaximum);
                objectOutput.writeInt(this.flowIncrease);
                objectOutput.writeDouble(this.flowDecrease);
                objectOutput.writeLong(this.flowInterval);
            }
            objectOutput.writeBoolean(this.xaServerEnabled);
        }
        if (by >= 4) {
            objectOutput.writeUTF(this.wlsServerName);
            objectOutput.writeUTF(this.runtimeMBeanName);
            if (this.sendTimeout != 10L) {
                objectOutput.writeLong(this.sendTimeout);
            }
        }
        if (by >= 5) {
            objectOutput.writeInt(n);
            if ((n & 1) != 0) {
                objectOutput.writeInt(this.compressionThreshold);
            }
            if ((n & 2) != 0) {
                objectOutput.writeUTF(this.unitOfOrder);
            }
            if (by >= 6) {
                objectOutput.writeInt(this.synchronousPrefetchMode);
            }
            if (by >= 7) {
                objectOutput.writeInt(this.oneWaySendMode);
                objectOutput.writeInt(this.oneWaySendWindowSize);
                objectOutput.writeInt(this.reconnectPolicy);
                objectOutput.writeLong(this.reconnectBlockingMillis);
                objectOutput.writeLong(this.totalReconnectPeriodMillis);
            }
        }
        if (by >= 8) {
            objectOutput.writeInt(this.clientIdPolicy);
            objectOutput.writeInt(this.subscriptionSharingPolicy);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        byte by2 = (byte)(by & 0xF);
        switch (by2) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.version = by2;
                break;
            }
            default: {
                throw JMSUtilities.versionIOException(by2, 1, 8);
            }
        }
        this.connectionId = new JMSID();
        this.connectionId.readExternal(objectInput);
        if (objectInput.readBoolean()) {
            this.clientId = objectInput.readUTF();
        }
        this.deliveryMode = objectInput.readInt();
        this.priority = objectInput.readInt();
        this.messagesMaximum = objectInput.readInt();
        this.overrunPolicy = objectInput.readInt();
        this.timeToDeliver = objectInput.readLong();
        this.timeToLive = objectInput.readLong();
        this.redeliveryDelay = objectInput.readLong();
        this.transactionTimeout = objectInput.readLong();
        this.userTransactionsEnabled = objectInput.readBoolean();
        this.allowCloseInOnMessage = objectInput.readBoolean();
        this.acknowledgePolicy = objectInput.readInt();
        this.dispatcherWrapper = new DispatcherWrapper();
        this.dispatcherWrapper.readExternal(objectInput);
        if (by2 >= 3) {
            this.flowControl = objectInput.readBoolean();
            if (this.flowControl) {
                this.flowMinimum = objectInput.readInt();
                this.flowMaximum = objectInput.readInt();
                this.flowIncrease = objectInput.readInt();
                this.flowDecrease = objectInput.readDouble();
                this.flowInterval = objectInput.readLong();
            }
            this.xaServerEnabled = objectInput.readBoolean();
        }
        if (by2 >= 4) {
            this.wlsServerName = objectInput.readUTF();
            this.runtimeMBeanName = objectInput.readUTF();
            this.sendTimeout = (by & 0x40) != 0 ? objectInput.readLong() : 10L;
        }
        if (by2 >= 5) {
            int n = objectInput.readInt();
            this.pipelineGeneration = 0xF00000 & n;
            if ((n & 1) != 0) {
                this.compressionThreshold = objectInput.readInt();
            }
            if ((n & 2) != 0) {
                this.unitOfOrder = objectInput.readUTF();
            }
            if (by2 >= 6) {
                this.synchronousPrefetchMode = objectInput.readInt();
            }
            if (by2 >= 7) {
                this.oneWaySendMode = objectInput.readInt();
                this.oneWaySendWindowSize = objectInput.readInt();
                this.internalSetReconnect(objectInput.readInt(), objectInput.readLong(), objectInput.readLong());
            }
            if (by2 >= 8) {
                this.clientIdPolicy = objectInput.readInt();
                this.subscriptionSharingPolicy = objectInput.readInt();
            }
        }
    }

    private int pushException(Request request) {
        JMSPushExceptionRequest jMSPushExceptionRequest = (JMSPushExceptionRequest)request;
        try {
            this.mergedCloseAndOnException(jMSPushExceptionRequest.getException(), false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        jMSPushExceptionRequest.setState(Integer.MAX_VALUE);
        return jMSPushExceptionRequest.getState();
    }

    public final int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 15363: {
                return this.pushException(request);
            }
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoSuchMethodLoggable((int)request.getMethodId()));
    }

    private byte getVersion(Object object) {
        PeerInfo peerInfo;
        PeerInfo peerInfo2 = this.peerInfo;
        if (object instanceof PeerInfoable && (peerInfo = ((PeerInfoable)object).getPeerInfo()) != null) {
            peerInfo2 = peerInfo;
        }
        if (peerInfo2 != null) {
            if (peerInfo2.compareTo((Object)PeerInfo.VERSION_1033) >= 0) {
                return 8;
            }
            if (peerInfo2.compareTo((Object)PeerInfo.VERSION_920) >= 0) {
                return 7;
            }
            if (peerInfo2.compareTo((Object)PeerInfo.VERSION_910) >= 0) {
                return 6;
            }
            if (peerInfo2.compareTo((Object)PeerInfo.VERSION_901) >= 0) {
                return 6;
            }
            if (peerInfo2.compareTo((Object)PeerInfo.VERSION_DIABLO) >= 0) {
                return 5;
            }
            if (peerInfo2.compareTo((Object)PeerInfo.VERSION_81) >= 0) {
                return 4;
            }
            if (peerInfo2.compareTo((Object)PeerInfo.VERSION_70) >= 0) {
                return 3;
            }
            return 1;
        }
        return 8;
    }

    public void forgetReconnectState() {
        PasswordStore passwordStore;
        JMSConnection jMSConnection;
        JMSConnection jMSConnection2 = this.preDisconnectState;
        if (jMSConnection2 != null) {
            jMSConnection2.forgetReconnectState();
            this.preDisconnectState = null;
        }
        if ((jMSConnection = this.replacementConnection) != null) {
            jMSConnection.forgetReconnectState();
            this.replacementConnection = null;
        }
        if ((passwordStore = this.pwdStore) != null) {
            Object object = this.pHandle;
            Object object2 = this.uHandle;
            if (object != null) {
                passwordStore.removePassword(object);
            }
            if (object2 != null) {
                passwordStore.removePassword(object2);
            }
            this.pwdStore = null;
        }
        this.pHandle = null;
        this.uHandle = null;
        this.wlConnectionImpl.setConnectionEstablishContext(null);
    }

    public PeerInfo getFEPeerInfo() {
        return this.dispatcherWrapper.getPeerInfo();
    }

    public static int convertPrefetchMode(String string) {
        if (string == null || string.equals("disabled")) {
            return 0;
        }
        if (string.equals("enabled")) {
            return 1;
        }
        if (string.equals("topicSubscriberOnly")) {
            return 2;
        }
        return 0;
    }

    public static int convertOneWaySendMode(String string) {
        if (string == null || string.equals("disabled")) {
            return 0;
        }
        if (string.equals("enabled")) {
            return 1;
        }
        if (string.equals("topicOnly")) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void reconnect() {
        JMSConnection jMSConnection = null;
        Throwable throwable = null;
        JMSContext jMSContext = this.wlConnectionImpl.getConnectionEstablishContext();
        try {
            block12: {
                JMSContext jMSContext2 = jMSContext != null ? JMSContext.push(jMSContext, true) : null;
                try {
                    try {
                        jMSConnection = (JMSConnection)this.preCreateReplacement(this.wlConnectionImpl.getJmsConnectionFactory());
                        JMSConnection jMSConnection2 = this.preDisconnectState;
                        if (jMSConnection != null && jMSConnection2 != null) {
                            jMSConnection.resume(jMSConnection2);
                        }
                    }
                    catch (JMSException jMSException) {
                        if (ReconnectController.TODOREMOVEDebug) {
                            jMSException.printStackTrace();
                        }
                        throwable = jMSException;
                    }
                    catch (Error error) {
                        if (ReconnectController.TODOREMOVEDebug) {
                            error.printStackTrace();
                        }
                        throwable = error;
                        throw error;
                    }
                    catch (RuntimeException runtimeException) {
                        if (ReconnectController.TODOREMOVEDebug) {
                            runtimeException.printStackTrace();
                        }
                        throwable = runtimeException;
                        throw runtimeException;
                    }
                    Object var7_9 = null;
                    if (jMSContext == null) break block12;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    if (jMSContext == null) throw throwable2;
                    JMSContext.pop(jMSContext2, true);
                    throw throwable2;
                }
                JMSContext.pop(jMSContext2, true);
            }
            Object var9_12 = null;
            this.wlConnectionImpl.reconnectComplete(this, jMSConnection, throwable);
            return;
        }
        catch (Throwable throwable3) {
            Object var9_13 = null;
            this.wlConnectionImpl.reconnectComplete(this, jMSConnection, throwable);
            throw throwable3;
        }
    }

    static {
        boolean bl = false;
        try {
            Class.forName("weblogic.rjvm.RJVM");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isT3Client = bl;
    }
}

