/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSServerSessionPool;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.frontend.FEConnectionConsumerCloseRequest;
import weblogic.messaging.dispatcher.Response;

public final class JMSConnectionConsumer
implements ConnectionConsumer,
Externalizable {
    static final long serialVersionUID = -4442173828993452834L;
    private static final byte EXTVERSION = 1;
    private JMSID connectionId;
    private ServerSessionPool serverSessionPool;
    private JMSID connectionConsumerId;

    public JMSConnectionConsumer(JMSID jMSID, ServerSessionPool serverSessionPool, JMSID jMSID2) {
        this.connectionId = jMSID;
        this.serverSessionPool = serverSessionPool;
        this.connectionConsumerId = jMSID2;
    }

    public JMSConnectionConsumer() {
    }

    public synchronized void close() throws JMSException {
        JMSConnection jMSConnection = (JMSConnection)InvocableManagerDelegate.delegate.invocableFind(3, this.connectionId);
        Response response = jMSConnection.getFrontEndDispatcher().dispatchSync(new FEConnectionConsumerCloseRequest(this.connectionId, this.connectionConsumerId));
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        this.connectionId.writeExternal(objectOutput);
        ((JMSServerSessionPool)this.serverSessionPool).writeExternal(objectOutput);
        this.connectionConsumerId.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        this.connectionId = new JMSID();
        this.connectionId.readExternal(objectInput);
        this.serverSessionPool = new JMSServerSessionPool();
        ((JMSServerSessionPool)this.serverSessionPool).readExternal(objectInput);
        this.connectionConsumerId = new JMSID();
        this.connectionConsumerId.readExternal(objectInput);
    }
}

