/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSXAConnection;
import weblogic.jms.client.JMSXAConnectionFactory;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.XAConnectionInternalImpl;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.frontend.FEConnectionCreateRequest;
import weblogic.jms.frontend.FEConnectionFactoryRemote;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.server.RemoteWrapper;

public class JMSConnectionFactory
implements QueueConnectionFactory,
TopicConnectionFactory,
Externalizable,
RemoteWrapper,
Reconnectable {
    static final long serialVersionUID = 2752718129231506407L;
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte INTERFACE_VERSION_PRE_81 = 0;
    private static final byte INTERFACE_VERSION_81 = 1;
    private static final byte INTERFACE_VERSION_CURRENT = 1;
    private FEConnectionFactoryRemote feConnectionFactoryRemote;
    private byte interfaceVersion = 1;
    private String fullyQualifiedName;
    private static long RECONNECT_TIMEOUT_DEFAULT;
    private static long RECONNECT_PERIOD_DEFAULT;

    public JMSConnectionFactory() {
    }

    public JMSConnectionFactory(FEConnectionFactoryRemote fEConnectionFactoryRemote, String string) {
        this.feConnectionFactoryRemote = fEConnectionFactoryRemote;
        this.fullyQualifiedName = string;
    }

    public Reconnectable getReconnectState(int n) throws CloneNotSupportedException {
        assert (false);
        return null;
    }

    public boolean isClosed() {
        return false;
    }

    public void publicCheckClosed() {
    }

    public ReconnectController getReconnectController() {
        return null;
    }

    public boolean isReconnectControllerClosed() {
        assert (false);
        return false;
    }

    public Reconnectable preCreateReplacement(Reconnectable reconnectable) throws JMSException {
        assert (false);
        return null;
    }

    public void postCreateReplacement() {
        assert (false);
    }

    public void forgetReconnectState() {
        assert (false);
    }

    public PeerInfo getFEPeerInfo() {
        assert (false);
        return null;
    }

    public void close() {
        assert (false);
    }

    public final QueueConnection createQueueConnection(String string, String string2) throws JMSException {
        ConnectionInternal connectionInternal = this.createConnectionInternal(string, string2, false, 1);
        return connectionInternal;
    }

    public final QueueConnection createQueueConnection() throws JMSException {
        ConnectionInternal connectionInternal = this.createConnectionInternal(null, null, false, 1);
        return connectionInternal;
    }

    public final TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        ConnectionInternal connectionInternal = this.createConnectionInternal(string, string2, false, 2);
        return connectionInternal;
    }

    public final TopicConnection createTopicConnection() throws JMSException {
        ConnectionInternal connectionInternal = this.createConnectionInternal(null, null, false, 2);
        return connectionInternal;
    }

    public final Connection createConnection() throws JMSException {
        return this.createConnectionInternal(null, null, false, 0);
    }

    public final Connection createConnection(String string, String string2) throws JMSException {
        return this.createConnectionInternal(string, string2, false, 0);
    }

    final JMSConnection setupJMSConnection(String string, String string2, boolean bl, int n) throws JMSException {
        JMSConnection jMSConnection;
        DispatcherWrapper dispatcherWrapper = null;
        try {
            JMSDispatcherManager.exportLocalDispatcher();
            dispatcherWrapper = JMSDispatcherManager.getLocalDispatcherWrapper();
            if (this.interfaceVersion >= 1) {
                FEConnectionCreateRequest fEConnectionCreateRequest = new FEConnectionCreateRequest(dispatcherWrapper, string, string2, bl);
                jMSConnection = this.feConnectionFactoryRemote.connectionCreateRequest(fEConnectionCreateRequest);
            } else {
                jMSConnection = string != null ? this.feConnectionFactoryRemote.connectionCreate(dispatcherWrapper, string, string2) : this.feConnectionFactoryRemote.connectionCreate(dispatcherWrapper);
            }
        }
        catch (UnmarshalException unmarshalException) {
            try {
                jMSConnection = string != null ? this.feConnectionFactoryRemote.connectionCreate(dispatcherWrapper, string, string2) : this.feConnectionFactoryRemote.connectionCreate(dispatcherWrapper);
                this.interfaceVersion = 0;
            }
            catch (RemoteException remoteException) {
                JMSDispatcherManager.unexportLocalDispatcher();
                throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logErrorCreatingConnectionLoggable((RemoteException)remoteException), (Throwable)remoteException);
            }
        }
        catch (RemoteException remoteException) {
            JMSDispatcherManager.unexportLocalDispatcher();
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logErrorCreatingConnectionLoggable((RemoteException)remoteException), (Throwable)remoteException);
        }
        try {
            jMSConnection.setupDispatcher();
        }
        catch (DispatcherException dispatcherException) {
            JMSDispatcherManager.unexportLocalDispatcher();
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logErrorFindingDispatcherLoggable((Throwable)dispatcherException), (Throwable)dispatcherException);
        }
        InvocableManagerDelegate.delegate.invocableAdd(3, jMSConnection);
        jMSConnection.setType(n);
        jMSConnection.rememberCredentials(string, string2, bl);
        return jMSConnection;
    }

    final ConnectionInternal createConnectionInternal(String string, String string2, boolean bl, int n) throws JMSException {
        long l;
        long l2;
        int n2;
        JMSConnection jMSConnection = this.setupJMSConnection(string, string2, bl, n);
        WLConnectionImpl wLConnectionImpl = bl ? new XAConnectionInternalImpl((JMSXAConnectionFactory)this, (JMSXAConnection)jMSConnection) : new WLConnectionImpl(this, jMSConnection);
        jMSConnection.setWlConnectionImpl(wLConnectionImpl);
        if (JMSConnection.isT3Client()) {
            n2 = jMSConnection.getReconnectPolicyInternal();
            l2 = jMSConnection.getReconnectBlockingMillisInternal();
            l = jMSConnection.getTotalReconnectPeriodMillisInternal();
        } else {
            n2 = 0;
            l2 = 0L;
            l = 0L;
        }
        wLConnectionImpl.setReconnectPolicy(WLConnectionImpl.convertReconnectPolicy(n2));
        wLConnectionImpl.setReconnectBlockingMillis(l2);
        wLConnectionImpl.setTotalReconnectPeriodMillis(l);
        return wLConnectionImpl;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        PeerInfo peerInfo = null;
        if (objectOutput instanceof PeerInfoable) {
            peerInfo = ((PeerInfoable)objectOutput).getPeerInfo();
        }
        int n = 1;
        if (peerInfo != null && peerInfo.compareTo((Object)PeerInfo.VERSION_81) >= 0) {
            n = peerInfo.compareTo((Object)PeerInfo.VERSION_DIABLO) >= 0 ? 3 : 2;
        } else if (peerInfo == null) {
            n = 3;
        }
        objectOutput.writeByte(n);
        if (n >= 2) {
            objectOutput.writeByte(1);
        }
        objectOutput.writeObject(this.feConnectionFactoryRemote);
        if (n >= 3) {
            if (this.fullyQualifiedName == null) {
                objectOutput.writeUTF("");
            } else {
                objectOutput.writeUTF(this.fullyQualifiedName);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by < 1 || by > 3) {
            throw JMSUtilities.versionIOException(by, 1, 3);
        }
        this.interfaceVersion = by >= 2 ? objectInput.readByte() : (byte)0;
        this.feConnectionFactoryRemote = (FEConnectionFactoryRemote)PortableRemoteObject.narrow((Object)objectInput.readObject(), FEConnectionFactoryRemote.class);
        if (by >= 3) {
            this.fullyQualifiedName = objectInput.readUTF();
            if (this.fullyQualifiedName.length() <= 0) {
                this.fullyQualifiedName = null;
            }
        } else {
            this.fullyQualifiedName = null;
        }
    }

    public Remote getRemoteDelegate() {
        return this.feConnectionFactoryRemote;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName == null ? "" : this.fullyQualifiedName;
    }

    static {
        long l;
        String string;
        RECONNECT_TIMEOUT_DEFAULT = 60000L;
        try {
            string = System.getProperty("weblogic.jms.ReconnectBlockingMillis");
            if (string != null) {
                l = Long.parseLong(string);
                WLConnectionImpl.validateReconnectMillis(l);
                RECONNECT_TIMEOUT_DEFAULT = l;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        RECONNECT_PERIOD_DEFAULT = -1L;
        try {
            string = System.getProperty("weblogic.jms.ReconnectPeriodMillis");
            if (string != null) {
                l = Long.parseLong(string);
                WLConnectionImpl.validateReconnectMillis(l);
                RECONNECT_PERIOD_DEFAULT = l;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }
}

