/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.security.AccessController;
import javax.naming.Context;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.kernel.KernelStatus;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public class JMSContext {
    private static final AbstractSubject KERNEL_ID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    private static final SubjectManager subjectManager = SubjectManager.getSubjectManager();
    protected ClassLoader classLoader;
    protected Context context;
    protected AbstractSubject subject = subjectManager.getCurrentSubject(KERNEL_ID);
    private static boolean isWLSServerSet;
    private static boolean isWLSServer;

    public JMSContext() {
        if (KernelStatus.isServer()) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (JMSContext.isWLSServer()) {
                this.context = this.getLocalJNDIContext();
            }
        }
    }

    private static synchronized boolean isWLSServer() {
        if (isWLSServerSet) {
            return isWLSServer;
        }
        try {
            Class.forName("weblogic.jms.common.JMSServerUtilities");
            isWLSServer = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isWLSServerSet = true;
        return isWLSServer;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public AbstractSubject getSubject() {
        return this.subject;
    }

    public void setSubject(AbstractSubject abstractSubject) {
        this.subject = abstractSubject;
    }

    public AbstractSubject getKernelId() {
        return KERNEL_ID;
    }

    public SubjectManager getSubjectManager() {
        return subjectManager;
    }

    static JMSContext push(JMSContext jMSContext) {
        return JMSContext.push(null, jMSContext, false);
    }

    static JMSContext push(JMSContext jMSContext, boolean bl) {
        return JMSContext.push(null, jMSContext, bl);
    }

    static void pop(JMSContext jMSContext) {
        JMSContext.pop(null, jMSContext, false);
    }

    static void pop(JMSContext jMSContext, boolean bl) {
        JMSContext.pop(null, jMSContext, bl);
    }

    static JMSContext push(Thread thread2, JMSContext jMSContext, boolean bl) {
        if (bl && jMSContext != null) {
            JMSContext.pushSubject(jMSContext.getSubject());
        }
        if (KernelStatus.isServer()) {
            Thread thread3 = thread2 != null ? thread2 : Thread.currentThread();
            JMSContext jMSContext2 = new JMSContext();
            if (jMSContext != null) {
                ClassLoader classLoader = jMSContext.getClassLoader();
                if (classLoader != jMSContext2.getClassLoader()) {
                    thread3.setContextClassLoader(classLoader);
                }
                if (JMSContext.isWLSServer() && jMSContext.getContext() != null) {
                    JMSContext.pushLocalJNDIContext(jMSContext.getContext());
                }
            }
            return jMSContext2;
        }
        return null;
    }

    static void pop(Thread thread2, JMSContext jMSContext, boolean bl) {
        if (KernelStatus.isServer()) {
            Thread thread3;
            Thread thread4 = thread3 = thread2 != null ? thread2 : Thread.currentThread();
            if (jMSContext != null) {
                if (JMSContext.isWLSServer() && jMSContext.getContext() != null) {
                    JMSContext.popLocalJNDIContext();
                }
                thread3.setContextClassLoader(jMSContext.getClassLoader());
            }
        }
        if (bl) {
            JMSContext.popSubject();
        }
    }

    static void pushSubject(AbstractSubject abstractSubject) {
        subjectManager.pushSubject(KERNEL_ID, abstractSubject);
    }

    static void popSubject() {
        subjectManager.popSubject(KERNEL_ID);
    }

    private Context getLocalJNDIContext() {
        return JMSServerUtilities.getLocalJNDIContext();
    }

    private static void pushLocalJNDIContext(Context context) {
        JMSServerUtilities.pushLocalJNDIContext(context);
    }

    private static void popLocalJNDIContext() {
        JMSServerUtilities.popLocalJNDIContext();
    }

    static boolean equals(JMSContext jMSContext, JMSContext jMSContext2) {
        if (jMSContext.getClassLoader() != jMSContext2.getClassLoader()) {
            return false;
        }
        if (jMSContext.getContext() != jMSContext2.getContext()) {
            return false;
        }
        return jMSContext.getSubject() == jMSContext2.getSubject();
    }
}

