/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import weblogic.jms.client.JMSContext;

public class JMSExceptionContext
extends JMSContext {
    private ExceptionListener listener = null;

    public JMSExceptionContext() {
    }

    public JMSExceptionContext(ExceptionListener exceptionListener) {
        if (exceptionListener != null) {
            this.setClassLoader(exceptionListener.getClass().getClassLoader());
        }
        this.listener = exceptionListener;
    }

    public JMSExceptionContext(ExceptionListener exceptionListener, ClassLoader classLoader) {
        this.setClassLoader(classLoader);
        this.listener = exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.listener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeListener(JMSException jMSException) throws Exception {
        if (this.listener != null) {
            ExceptionListener exceptionListener = this.listener;
            synchronized (exceptionListener) {
                final ExceptionListener exceptionListener2 = this.listener;
                final JMSException jMSException2 = jMSException;
                try {
                    this.subject.doAs(this.getKernelId(), new PrivilegedExceptionAction(){

                        public Object run() throws JMSException {
                            exceptionListener2.onException(jMSException2);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
        }
    }
}

