/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.JMSEnumeration;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.common.JMSBrowserGetEnumerationResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.frontend.FEBrowserGetEnumerationRequest;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class JMSQueueBrowser
implements QueueBrowser,
Invocable {
    private final JMSDispatcher frontEndDispatcher;
    private JMSID browserId;
    private final Queue queue;
    private final String selector;
    private final JMSSession session;

    public JMSQueueBrowser(Queue queue, String string, JMSSession jMSSession) throws JMSException {
        this.queue = queue;
        this.selector = string;
        this.session = jMSSession;
        this.frontEndDispatcher = jMSSession.getConnection().getFrontEndDispatcher();
        this.browserId = jMSSession.createBackEndBrowser((DestinationImpl)queue, string);
    }

    void setId(JMSID jMSID) {
        this.browserId = jMSID;
    }

    public JMSID getJMSID() {
        return this.browserId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    public Queue getQueue() throws JMSException {
        this.checkClosed();
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.checkClosed();
        Response response = this.frontEndDispatcher.dispatchSync(new FEBrowserGetEnumerationRequest(this.browserId));
        return new JMSEnumeration(this.queue, this, ((JMSBrowserGetEnumerationResponse)response).getEnumerationId(), this.frontEndDispatcher);
    }

    public JMSSession getSession() throws JMSException {
        this.checkClosed();
        return this.session;
    }

    boolean isClosed() {
        return this.browserId == null;
    }

    private void checkClosed() throws JMSException {
        if (!this.isClosed()) {
            return;
        }
        throw new IllegalStateException(JMSClientExceptionLogger.logClosedBrowserLoggable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        JMSID jMSID;
        JMSQueueBrowser jMSQueueBrowser = this;
        synchronized (jMSQueueBrowser) {
            if (this.isClosed()) {
                return;
            }
            jMSID = this.browserId;
            this.browserId = null;
        }
        this.session.closeBrowser(jMSID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pushException(Request request) throws JMSException {
        JMSID jMSID;
        JMSPushExceptionRequest jMSPushExceptionRequest = (JMSPushExceptionRequest)request;
        JMSQueueBrowser jMSQueueBrowser = this;
        synchronized (jMSQueueBrowser) {
            jMSID = this.browserId;
            this.browserId = null;
        }
        if (jMSID != null) {
            this.session.closeBrowser(jMSID, true);
        }
        jMSPushExceptionRequest.setState(Integer.MAX_VALUE);
        return jMSPushExceptionRequest.getState();
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 15382: {
                return this.pushException(request);
            }
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoSuchMethod3Loggable((int)request.getMethodId(), (String)this.getClass().getName()));
    }
}

