/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import weblogic.jms.backend.BEServerSessionGetRequest;
import weblogic.jms.backend.BEServerSessionGetResponse;
import weblogic.jms.backend.BEServerSessionPoolCloseRequest;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.Response;

public final class JMSServerSessionPool
implements ServerSessionPool,
Externalizable {
    static final long serialVersionUID = -6985998084744986160L;
    private static final byte EXTVERSION = 1;
    private boolean isLocal;
    private JMSServerId backEndId;
    private JMSID serverSessionPoolId;

    public JMSServerSessionPool(JMSServerId jMSServerId, JMSID jMSID) {
        this.backEndId = jMSServerId;
        this.serverSessionPoolId = jMSID;
    }

    public synchronized void close() throws JMSException {
        try {
            Response response = JMSDispatcherManager.dispatcherFindOrCreate(this.backEndId.getDispatcherId()).dispatchSync(new BEServerSessionPoolCloseRequest(this.backEndId.getId(), this.serverSessionPoolId));
        }
        catch (DispatcherException dispatcherException) {
            throw new weblogic.jms.common.JMSException("Error closing server session pool", (Throwable)dispatcherException);
        }
    }

    public ServerSession getServerSession() throws JMSException {
        Response response;
        try {
            response = JMSDispatcherManager.dispatcherFindOrCreate(this.backEndId.getDispatcherId()).dispatchSync(new BEServerSessionGetRequest(this.backEndId.getId(), this.serverSessionPoolId));
        }
        catch (DispatcherException dispatcherException) {
            throw new weblogic.jms.common.JMSException("Error getting server session", (Throwable)dispatcherException);
        }
        return ((BEServerSessionGetResponse)response).getServerSession();
    }

    public JMSID getServerSessionPoolId() {
        return this.serverSessionPoolId;
    }

    public JMSServerId getBackEndId() {
        return this.backEndId;
    }

    public JMSServerSessionPool() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        if (this.isLocal) {
            objectOutput.writeBoolean(true);
        } else {
            objectOutput.writeBoolean(false);
        }
        this.backEndId.writeExternal(objectOutput);
        this.serverSessionPoolId.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        this.isLocal = objectInput.readBoolean();
        this.backEndId = new JMSServerId();
        this.backEndId.readExternal(objectInput);
        this.serverSessionPoolId = new JMSID();
        this.serverSessionPoolId.readExternal(objectInput);
    }
}

