/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.transaction.Transaction;
import org.w3c.dom.Document;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.ConsumerInternal;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConsumer;
import weblogic.jms.client.JMSContext;
import weblogic.jms.client.JMSExceptionContext;
import weblogic.jms.client.JMSMessageContext;
import weblogic.jms.client.JMSMessageReference;
import weblogic.jms.client.JMSProducer;
import weblogic.jms.client.JMSQueueBrowser;
import weblogic.jms.client.JMSXASession;
import weblogic.jms.client.LockedMap;
import weblogic.jms.client.MMessageAsyncSession;
import weblogic.jms.client.MMessageListener;
import weblogic.jms.client.MessageWrapper;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.SessionInternal;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.WLConsumerImpl;
import weblogic.jms.client.WLProducerImpl;
import weblogic.jms.client.WLSessionImpl;
import weblogic.jms.common.AlreadyClosedException;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.common.InvalidDestinationException;
import weblogic.jms.common.JMSBrowserCreateResponse;
import weblogic.jms.common.JMSConsumerReceiveResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDestinationCreateResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.JMSSessionRecoverResponse;
import weblogic.jms.common.JMSWorkContextHelper;
import weblogic.jms.common.JMSWorkManager;
import weblogic.jms.common.LostServerException;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.MessageList;
import weblogic.jms.common.MessageReference;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.extensions.DataOverrunException;
import weblogic.jms.extensions.JMSMessageFactoryImpl;
import weblogic.jms.extensions.WLAcknowledgeInfo;
import weblogic.jms.extensions.WLAsyncSession;
import weblogic.jms.extensions.WLMessageFactory;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.jms.extensions.XMLMessage;
import weblogic.jms.frontend.FEBrowserCloseRequest;
import weblogic.jms.frontend.FEBrowserCreateRequest;
import weblogic.jms.frontend.FEConsumerCloseRequest;
import weblogic.jms.frontend.FEConsumerCreateRequest;
import weblogic.jms.frontend.FEConsumerCreateResponse;
import weblogic.jms.frontend.FEConsumerIncrementWindowCurrentOneWayRequest;
import weblogic.jms.frontend.FEConsumerIncrementWindowCurrentRequest;
import weblogic.jms.frontend.FEConsumerReceiveRequest;
import weblogic.jms.frontend.FEDestinationCreateRequest;
import weblogic.jms.frontend.FEProducerCloseRequest;
import weblogic.jms.frontend.FEProducerCreateRequest;
import weblogic.jms.frontend.FEProducerCreateResponse;
import weblogic.jms.frontend.FESessionAcknowledgeRequest;
import weblogic.jms.frontend.FESessionCloseRequest;
import weblogic.jms.frontend.FESessionRecoverRequest;
import weblogic.jms.frontend.FESessionSetRedeliveryDelayRequest;
import weblogic.jms.frontend.FETemporaryDestinationCreateRequest;
import weblogic.jms.frontend.FETemporaryDestinationCreateResponse;
import weblogic.jms.multicast.JMSTDMSocket;
import weblogic.jms.multicast.JMSTDMSocketIPM;
import weblogic.jms.multicast.JMSTMSocket;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.transaction.TransactionHelper;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class JMSSession
implements SessionInternal,
Invocable,
Reconnectable,
Cloneable,
WLAsyncSession,
MMessageAsyncSession {
    private static final AbstractSubject KERNEL_ID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    private static final WLMessageFactory MESSAGEFACTORY = JMSMessageFactoryImpl.getFactory();
    private static int DUPSACKINTERVAL = 50;
    private static boolean IGNOREWINDOWCURRENT = false;
    private static boolean DECWINDOWCURRENT = true;
    private SubjectManager subjectManager = SubjectManager.getSubjectManager();
    private long expectedSequenceNumber = 1L;
    private long highMark = 1L;
    private JMSPushRequest firstPushRequest;
    private JMSPushRequest lastPushRequest;
    private JMSPushRequest firstReceivePushRequest;
    private JMSPushRequest lastReceivePushRequest;
    private UnackedMessage firstUnackedMessage;
    private PendingWTMessage firstPendingWTMessage;
    private volatile JMSID sessionId;
    private int messagesMaximum;
    private int overrunPolicy;
    private final int acknowledgePolicy;
    private final int subscriptionSharingPolicy;
    private int pushRequestCount;
    private final JMSConnection connection;
    private final boolean transacted;
    private final int acknowledgeMode;
    private int deliveryMode;
    private int priority;
    private long timeToLive;
    private final long sendTimeout;
    private boolean userTransactionsEnabled;
    private final boolean allowCloseInOnMessage;
    private long redeliveryDelay = -1L;
    private final String clientID;
    private boolean decrementWindow;
    private final WorkManager dispatchWorkManager;
    private final String dispatchPolicyName;
    private final Object lockObject = new Object();
    private boolean synchronousListener = false;
    private JMSPushRequest shortCutPushRequest = null;
    private boolean needToRemoveIt = true;
    private JMSPushRequest shortCutPrevPushRequest = null;
    private boolean waitForNewMessage = false;
    private boolean notifyNewMessage = false;
    private final Object synchronousListenerObject = new Object();
    private LockedMap consumers = new LockedMap("consumers", null);
    private LockedMap producers = new LockedMap("producers", null);
    private LockedMap browsers = new LockedMap("browsers", null);
    static final int IDLE = 0;
    static final int IN_CLOSE = 1;
    static final int IN_RECEIVE = 2;
    static final int IN_LISTENER = 4;
    static final int TYPE_UNSPECIFIED = 0;
    static final int TYPE_TOPIC = 1;
    static final int TYPE_QUEUE = 2;
    private JMSMessageContext messageContext;
    private JMSExceptionContext exceptionContext;
    private int consumerListenerCount;
    private int state = 0;
    private Thread listenerThread;
    private String runtimeMBeanName;
    private int waiterCount;
    private boolean stopped;
    private boolean running;
    private boolean recovering;
    private int type;
    private long lastSequenceNumber;
    private MessageList clientAckList;
    private JMSPushRequest recoverableClientAckMessages;
    private JMSPushRequest carryForwardOnReconnect;
    private JMSMessageReference mRefCache;
    private JMSTDMSocket dgmSock;
    private JMSTMSocket mSock;
    private int pipelineGeneration;
    private String unitOfOrder;
    private UseForRunnable useForRunnable;
    private WLSessionImpl wlSessionImpl;
    private JMSSession replacementSession;
    private boolean pendingWork;
    private volatile boolean refreshedWithPendingWork;
    private boolean prefetchStarted = false;
    private boolean prefetchDisabled = false;
    private int dupsOKAckCountDown;
    private int dupsOKAckCount = 0;
    private boolean allowDelayAckForDupsOK = true;
    private boolean requireAckForDupsOK = false;
    private boolean session_clientResponsibleForAck = false;
    private boolean connectionOlderThan90;
    private boolean recoversFor90HasBeenCalled = false;
    private JMSMessageId lastExposedMsgId;
    private JMSMessageId previousExposedMsgId;
    private JMSMessageId lastAckMsgId;
    private long lastAckSequenceNumber;
    private HashMap replacementConsumerMap;
    private boolean consumersReconnect;
    private boolean closeStarted;
    private JMSSession staleJMSSession;
    private static boolean IGNORE_JmsAsyncQueue = false;
    private boolean ignoreJmsAsyncQueue = false;
    private MMessageListener mmListener;
    private long realLastSequenceNumber;
    private boolean realLastSequenceNumberShouldApply = false;
    private int proxyGenerationForOlderServer = 0;
    private boolean closeWithExternalSequenceNumber = false;
    static final TextMessageImpl ASYNC_RESERVED_MSG;
    private boolean isRemoteDomain;
    int checkSeqGap = 1;
    int msgIndex = 1;

    protected JMSSession(JMSConnection jMSConnection, boolean bl, int n, boolean bl2) throws JMSException {
        this.connection = jMSConnection;
        this.transacted = bl;
        this.useForRunnable = new UseForRunnable(this);
        this.acknowledgeMode = bl ? 2 : n;
        this.stopped = bl2;
        this.userTransactionsEnabled = jMSConnection.getUserTransactionsEnabled();
        this.allowCloseInOnMessage = jMSConnection.getAllowCloseInOnMessage();
        this.messagesMaximum = jMSConnection.getMessagesMaximum();
        this.deliveryMode = jMSConnection.getDeliveryMode();
        this.priority = jMSConnection.getPriority();
        this.timeToLive = jMSConnection.getTimeToLive();
        this.acknowledgePolicy = jMSConnection.getAcknowledgePolicy();
        this.subscriptionSharingPolicy = jMSConnection.getSubscriptionSharingPolicyAsInt();
        this.overrunPolicy = jMSConnection.getOverrunPolicy();
        this.clientID = jMSConnection.getClientIDInternal();
        this.sendTimeout = jMSConnection.getSendTimeout();
        this.pipelineGeneration = jMSConnection.getPipelineGeneration();
        this.dispatchPolicyName = jMSConnection.getDispatchPolicy();
        this.dispatchWorkManager = WorkManagerFactory.getInstance().find(this.dispatchPolicyName);
        if (IGNORE_JmsAsyncQueue && this.dispatchPolicyName.equals("JmsAsyncQueue")) {
            this.ignoreJmsAsyncQueue = true;
        }
        if (this.userTransactionsEnabled) {
            this.allowDelayAckForDupsOK = false;
        }
        this.dupsOKAckCount = this.dupsOKAckCountDown = this.messagesMaximum != -1 || this.messagesMaximum <= 100 ? this.messagesMaximum / 2 : DUPSACKINTERVAL;
        try {
            if (System.getProperty("weblogic.jms.dupsOKCountDownSize") != null) {
                this.dupsOKAckCountDown = Integer.parseInt(System.getProperty("weblogic.jms.dupsOKCountDownSize"));
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        boolean bl3 = this.connectionOlderThan90 = jMSConnection.getPeerVersion() < 5;
        if (this.pipelineGeneration == 0) {
            if (PeerInfo.VERSION_DIABLO.compareTo((Object)this.getFEPeerInfo()) <= 0 && PeerInfo.VERSION_920.compareTo((Object)this.getFEPeerInfo()) > 0) {
                this.pipelineGeneration = 0xF00000;
            }
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("CLIENT/JMSSession (id: " + this.sessionId + ") : zero pipelineGeneration 0x" + Integer.toHexString(this.pipelineGeneration) + " peerinfo " + this.getFEPeerInfo());
            }
        }
        try {
            this.isRemoteDomain = CrossDomainSecurityManager.getCrossDomainSecurityUtil().isRemoteDomain(jMSConnection.getFrontEndDispatcher());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JMSSession jMSSession = (JMSSession)super.clone();
        jMSSession.consumers = (LockedMap)this.consumers.clone();
        jMSSession.producers = (LockedMap)this.producers.clone();
        jMSSession.browsers = (LockedMap)this.browsers.clone();
        return jMSSession;
    }

    public ReconnectController getReconnectController() {
        return this.wlSessionImpl;
    }

    public Reconnectable getReconnectState(int n) throws CloneNotSupportedException {
        JMSSession jMSSession = (JMSSession)this.clone();
        jMSSession.producers = WLConnectionImpl.reconnectPolicyHas(4, n) ? JMSConnection.recurseGetReconnectState(jMSSession.producers, n) : JMSConnection.recurseSetNoRetry(jMSSession.producers, this.connection);
        jMSSession.staleJMSSession = this;
        if (WLConnectionImpl.reconnectPolicyHas(8, n)) {
            jMSSession.consumers = JMSConnection.recurseGetReconnectState(jMSSession.consumers, n);
            jMSSession.consumersReconnect = true;
            jMSSession.session_clientResponsibleForAck = this.session_clientResponsibleForAck;
        } else {
            if (ReconnectController.TODOREMOVEDebug && jMSSession.consumersCount() > 0) {
                System.out.println("DEBUG JMSSession reconnectState recurseSetNoRetry consumers ignored " + jMSSession.consumers);
            }
            jMSSession.consumers = JMSConnection.recurseSetNoRetry(jMSSession.consumers, this.connection);
            jMSSession.consumersReconnect = false;
            jMSSession.session_clientResponsibleForAck = false;
        }
        if (jMSSession.consumersReconnect && !this.transacted && this.firstUnackedMessage != null && this.acknowledgeMode == 2) {
            jMSSession.setPendingWork(true);
        }
        return jMSSession;
    }

    public Reconnectable preCreateReplacement(Reconnectable reconnectable) throws JMSException {
        JMSSession jMSSession = ((JMSConnection)reconnectable).setupJMSSession(this.transacted, this.acknowledgeMode, this instanceof JMSXASession, this.type);
        jMSSession.setMapLocks(this.producers.getLock());
        jMSSession.exceptionContext = this.exceptionContext;
        jMSSession.messagesMaximum = this.messagesMaximum;
        jMSSession.overrunPolicy = this.overrunPolicy;
        jMSSession.deliveryMode = this.deliveryMode;
        jMSSession.priority = this.priority;
        jMSSession.timeToLive = this.timeToLive;
        jMSSession.synchronousListener = this.synchronousListener;
        jMSSession.unitOfOrder = this.unitOfOrder;
        if (this.redeliveryDelay != -1L && this.redeliveryDelay != jMSSession.redeliveryDelay) {
            jMSSession.setRedeliveryDelay(this.redeliveryDelay);
        }
        if (this.staleJMSSession != null) {
            jMSSession.refreshedWithPendingWork = this.transacted ? this.staleJMSSession.pendingWork : this.staleJMSSession.firstUnackedMessage != null;
        }
        jMSSession.subjectManager = this.subjectManager;
        jMSSession.consumersReconnect = this.consumersReconnect;
        jMSSession.replacementConsumerMap = new HashMap();
        JMSConnection.recursePreCreateReplacement(jMSSession, this.consumers);
        JMSConnection.recursePreCreateReplacement(jMSSession, this.producers);
        this.transferClientRspForAckMessages(jMSSession);
        jMSSession.replacementConsumerMap.clear();
        this.replacementSession = jMSSession;
        return jMSSession;
    }

    String debugMaps() {
        return this.producers + "\n" + this.consumers + "\n" + this.browsers;
    }

    public void postCreateReplacement() {
        JMSConnection.recursePostCreateReplacement(this.consumers);
        JMSConnection.recursePostCreateReplacement(this.producers);
        JMSSession jMSSession = this.replacementSession;
        jMSSession.setWLSessionImpl(this.wlSessionImpl);
        jMSSession.forgetReconnectState();
        this.wlSessionImpl.setPhysicalReconnectable(jMSSession);
    }

    public void forgetReconnectState() {
        Object e;
        this.staleJMSSession = null;
        Iterator iterator = this.producers.cloneValuesIterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (!(e instanceof Reconnectable)) continue;
            ((Reconnectable)e).forgetReconnectState();
        }
        iterator = this.consumers.cloneValuesIterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (!(e instanceof Reconnectable)) continue;
            ((Reconnectable)e).forgetReconnectState();
        }
        this.replacementSession = null;
    }

    boolean hasTemporaryDestination() {
        Iterator iterator = this.consumers.valuesIterator();
        while (iterator.hasNext()) {
            if (!((JMSConsumer)iterator.next()).hasTemporaryDestination()) continue;
            WLSessionImpl wLSessionImpl = this.wlSessionImpl;
            return wLSessionImpl != null && wLSessionImpl.getState() != -2304 && wLSessionImpl.getState() != -1280;
        }
        iterator = this.producers.valuesIterator();
        while (iterator.hasNext()) {
            if (!((JMSProducer)iterator.next()).hasTemporaryDestination()) continue;
            WLSessionImpl wLSessionImpl = this.wlSessionImpl;
            return wLSessionImpl != null && wLSessionImpl.getState() != -2304 && wLSessionImpl.getState() != -1280;
        }
        return false;
    }

    public PeerInfo getFEPeerInfo() {
        return this.connection.getFEPeerInfo();
    }

    public final synchronized int getMessagesMaximum() throws JMSException {
        this.checkClosed();
        return this.messagesMaximum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setMessagesMaximum(int n) throws JMSException {
        this.checkClosed();
        Object object = this.lockObject;
        synchronized (object) {
            if (n < -1 || n == 0) {
                throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidMessagesMaximumValueLoggable());
            }
            this.messagesMaximum = n;
        }
    }

    public int getSubscriptionSharingPolicy() throws JMSException {
        this.checkClosed();
        return this.subscriptionSharingPolicy;
    }

    public final synchronized int getOverrunPolicy() throws JMSException {
        this.checkClosed();
        return this.overrunPolicy;
    }

    public final synchronized void setOverrunPolicy(int n) throws JMSException {
        this.checkClosed();
        if (n != 0 && n != 1) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidOverrunPolicyLoggable((int)n));
        }
        this.overrunPolicy = n;
    }

    public final long getRedeliveryDelay() throws JMSException {
        this.checkClosed();
        return this.getRedeliveryDelayInternal();
    }

    private long getRedeliveryDelayInternal() {
        return this.redeliveryDelay == -1L ? this.getConnection().getRedeliveryDelay() : this.redeliveryDelay;
    }

    public final void setRedeliveryDelay(long l) throws JMSException {
        this.checkClosed();
        if (l < -1L) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidRedeliveryDelayLoggable().getMessage());
        }
        long l2 = this.getRedeliveryDelayInternal();
        if (l != l2 && this.consumers.size() != 0) {
            this.redeliveryDelay = l;
            Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FESessionSetRedeliveryDelayRequest(this.sessionId, l));
        }
    }

    public final int getDeliveryMode() {
        return this.deliveryMode;
    }

    public final void setDeliveryMode(int n) {
        this.deliveryMode = n;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setPriority(int n) {
        this.priority = n;
    }

    public final long getTimeToLive() {
        return this.timeToLive;
    }

    public final void setTimeToLive(long l) {
        this.timeToLive = l;
    }

    final long getSendTimeout() {
        return this.sendTimeout;
    }

    final void setId(JMSID jMSID) {
        this.sessionId = jMSID;
    }

    public final JMSID getJMSID() {
        return this.sessionId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public final void setType(int n) {
        this.type = n;
    }

    public void setPipelineGeneration(int n) {
        this.pipelineGeneration = n;
    }

    public synchronized int getPipelineGenerationFromProxy() {
        if (this.connectionOlderThan90) {
            return this.proxyGenerationForOlderServer;
        }
        return this.pipelineGeneration;
    }

    final int getType() {
        return this.type;
    }

    public final InvocableMonitor getInvocableMonitor() {
        return null;
    }

    final long getLastSequenceNumber() {
        if (this.realLastSequenceNumberShouldApply) {
            return this.realLastSequenceNumber;
        }
        return this.lastSequenceNumber;
    }

    final synchronized void setRealLastSequenceNumber(long l) {
        this.realLastSequenceNumber = l;
        this.realLastSequenceNumberShouldApply = true;
    }

    final boolean isTransacted() {
        return this.transacted;
    }

    final boolean userTransactionsEnabled() {
        return this.userTransactionsEnabled;
    }

    final void setUserTransactionsEnabled(boolean bl) {
        this.userTransactionsEnabled = bl;
    }

    public String getWLSServerName() {
        return this.connection.getWLSServerName();
    }

    public ClientRuntimeInfo getParentInfo() {
        return this.connection;
    }

    public final void setRuntimeMBeanName(String string) {
        this.runtimeMBeanName = string;
    }

    public final String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public final JMSConnection getConnection() {
        return this.connection;
    }

    public final String toString() {
        return this.connection.getRuntimeMBeanName() + "." + this.getRuntimeMBeanName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MessageImpl receiveMessage(ConsumerInternal consumerInternal, long l, CompletionListener completionListener) throws JMSException {
        Externalizable externalizable;
        block26: {
            boolean bl;
            long l2;
            JMSPushRequest jMSPushRequest;
            JMSID jMSID = consumerInternal.getJMSID();
            JMSConsumerReceiveResponsePrivate jMSConsumerReceiveResponsePrivate = null;
            long l3 = System.currentTimeMillis();
            long l4 = l;
            Object object = this;
            synchronized (object) {
                while (this.stopped) {
                    if (this.isClosed() || l == 0x7FFFFFFFFFFFFFFEL) {
                        return null;
                    }
                    if (this.firstReceivePushRequest != null) {
                        try {
                            this.wait(l4);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new weblogic.jms.common.JMSException(interruptedException);
                        }
                        if (l == Long.MAX_VALUE) continue;
                        long l5 = System.currentTimeMillis() - l3;
                        if (l5 >= l) {
                            return null;
                        }
                        l4 = l - l5;
                        if (l4 > 0L) continue;
                    }
                    if (!this.stopped && !this.isClosed()) continue;
                    return null;
                }
                Object object2 = this.lockObject;
                synchronized (object2) {
                    JMSPushRequest jMSPushRequest2 = null;
                    for (jMSPushRequest = this.firstReceivePushRequest; jMSPushRequest != null; jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext()) {
                        externalizable = jMSPushRequest.getFirstPushEntry();
                        if (consumerInternal.getJMSID().equals(externalizable.getConsumerId())) {
                            externalizable = jMSPushRequest.removePushEntry();
                            jMSConsumerReceiveResponsePrivate = new JMSConsumerReceiveResponsePrivate(jMSPushRequest.getMessage(), externalizable.getFrontEndSequenceNumber(), false, externalizable.getDeliveryCount());
                            break;
                        }
                        jMSPushRequest2 = jMSPushRequest;
                    }
                    if (jMSConsumerReceiveResponsePrivate != null && (externalizable = jMSPushRequest.getFirstPushEntry()) == null) {
                        JMSPushRequest jMSPushRequest3 = (JMSPushRequest)jMSPushRequest.getNext();
                        jMSPushRequest.setNext(null);
                        if (jMSPushRequest2 == null) {
                            this.firstReceivePushRequest = jMSPushRequest3;
                        } else {
                            jMSPushRequest2.setNext(jMSPushRequest3);
                        }
                        if (jMSPushRequest3 == null) {
                            this.lastReceivePushRequest = null;
                        }
                    }
                }
            }
            if (jMSConsumerReceiveResponsePrivate != null) {
                return this.proccessReceiveResponse(consumerInternal, jMSConsumerReceiveResponsePrivate, completionListener);
            }
            l4 = l4 <= 0L || l == Long.MAX_VALUE || l == 0x7FFFFFFFFFFFFFFEL ? l : l - (l3 - System.currentTimeMillis());
            if (!this.transacted && this.userTransactionsEnabled) {
                l2 = l;
                bl = false;
            } else {
                l2 = l4;
                bl = true;
            }
            object = new FEConsumerReceiveRequest(jMSID, l2, completionListener, consumerInternal);
            if (completionListener == null) {
                return this.proccessReceiveResponse(consumerInternal, bl ? this.connection.getFrontEndDispatcher().dispatchSyncNoTran((Request)object) : this.connection.getFrontEndDispatcher().dispatchSyncTran((Request)object), completionListener);
            }
            jMSPushRequest = bl ? TransactionHelper.getTransactionHelper().getTransactionManager().forceSuspend() : null;
            try {
                this.connection.getFrontEndDispatcher().dispatchAsync((Request)object);
                externalizable = ASYNC_RESERVED_MSG;
                Object var20_21 = null;
                if (jMSPushRequest == null) break block26;
            }
            catch (DispatcherException dispatcherException) {
                try {
                    throw new weblogic.jms.common.JMSException(dispatcherException);
                }
                catch (Throwable throwable) {
                    block27: {
                        Object var20_22 = null;
                        if (jMSPushRequest == null) break block27;
                        TransactionHelper.getTransactionHelper().getTransactionManager().forceResume((Transaction)jMSPushRequest);
                    }
                    throw throwable;
                }
            }
            TransactionHelper.getTransactionHelper().getTransactionManager().forceResume((Transaction)jMSPushRequest);
        }
        return externalizable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageImpl proccessReceiveResponse(ConsumerInternal consumerInternal, Object object, CompletionListener completionListener) throws JMSException {
        JMSConsumerReceiveResponse jMSConsumerReceiveResponse = (JMSConsumerReceiveResponse)object;
        MessageImpl messageImpl = null;
        MessageImpl messageImpl2 = jMSConsumerReceiveResponse.getMessage();
        if (messageImpl2 != null) {
            this.session_clientResponsibleForAck |= messageImpl2.getClientResponsibleForAcknowledge();
            int n = jMSConsumerReceiveResponse instanceof JMSConsumerReceiveResponsePrivate ? ((JMSConsumerReceiveResponsePrivate)jMSConsumerReceiveResponse).getDeliveryCount() : messageImpl2.getDeliveryCount();
            if (this.connection.isLocal()) {
                messageImpl = messageImpl2.copy();
                messageImpl.setSequenceNumber(messageImpl2.getSequenceNumber());
                messageImpl.setClientResponsibleForAcknowledge(messageImpl2.getClientResponsibleForAcknowledge());
                messageImpl.setDeliveryCount(n);
            } else {
                messageImpl = messageImpl2;
                messageImpl.setDeliveryCount(n);
            }
            long l = jMSConsumerReceiveResponse.getSequenceNumber();
            messageImpl.setSequenceNumber(l);
            messageImpl.setDDForwarded(false);
            if (this.transacted) {
                this.setPendingWork(true);
            }
            if (jMSConsumerReceiveResponse.isTransactional()) {
                JMSSession jMSSession = this;
                synchronized (jMSSession) {
                    this.rememberLastSequenceNumber(l, messageImpl.getId());
                }
            }
            JMSSession jMSSession = this;
            synchronized (jMSSession) {
                this.rememberLastSequenceNumber(l, messageImpl.getId());
                this.addUnackedMessage(consumerInternal, messageImpl);
            }
            if (this.acknowledgeMode == 2) {
                messageImpl.setSession(this);
            } else if (this.acknowledgeMode != 4) {
                if (this.acknowledgeMode == 3 && this.checkDelayAckForDupsOK(messageImpl) && --this.dupsOKAckCount > 0) {
                    this.requireAckForDupsOK = true;
                } else {
                    this.acknowledge(messageImpl, this.acknowledgePolicy, false);
                    this.requireAckForDupsOK = false;
                    this.dupsOKAckCount = this.dupsOKAckCountDown;
                }
            }
        }
        if (messageImpl != null) {
            messageImpl.setJMSDestinationImpl((DestinationImpl)consumerInternal.getDestination());
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("CLIENT/JMSSession (id: " + this.sessionId + ") : " + "Received message " + messageImpl.getJMSMessageID());
            }
        }
        return this.afterReceive(messageImpl, consumerInternal.getJMSID(), completionListener);
    }

    final MessageImpl afterReceive(MessageImpl messageImpl, JMSID jMSID, CompletionListener completionListener) {
        if (messageImpl != null) {
            messageImpl.setSerializeDestination(true);
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("CLIENT/JMSConsumer (id: " + jMSID + ") : Received message " + messageImpl.getJMSMessageID());
            }
            messageImpl.setForward(true);
        }
        if (completionListener != null) {
            completionListener.onCompletion(messageImpl);
        }
        return messageImpl;
    }

    private void setPendingWorkOnMsgRecv() {
        if (this.acknowledgeMode == 2) {
            this.setPendingWork(true);
        }
    }

    private void rememberLastSequenceNumber(long l, JMSMessageId jMSMessageId) {
        this.previousExposedMsgId = this.lastExposedMsgId;
        this.lastSequenceNumber = l;
        this.lastExposedMsgId = jMSMessageId;
    }

    void rememberLastServerAck(JMSMessageId jMSMessageId) {
        if (this.transacted) {
            return;
        }
        this.lastAckMsgId = jMSMessageId;
    }

    public JMSMessageId getLastAckMsgId() {
        return this.lastAckMsgId;
    }

    public JMSMessageId getLastExposedMsgId() {
        return this.lastExposedMsgId;
    }

    public final BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createBytesMessage();
    }

    public final MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createMapMessage();
    }

    public final Message createMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createMessage();
    }

    public final ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createObjectMessage();
    }

    public final ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createObjectMessage(serializable);
    }

    public final StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createStreamMessage();
    }

    public final TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createTextMessage();
    }

    public final TextMessage createTextMessage(String string) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createTextMessage(string);
    }

    public final XMLMessage createXMLMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createXMLMessage();
    }

    public final XMLMessage createXMLMessage(String string) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createXMLMessage(string);
    }

    public final XMLMessage createXMLMessage(Document document) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createXMLMessage(document);
    }

    public final TextMessage createTextMessage(StringBuffer stringBuffer) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createTextMessage(stringBuffer);
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    public final int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        if (this.transacted) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    public void commit() throws JMSException {
        this.commit(-1L);
    }

    synchronized void commit(long l) throws JMSException {
        this.checkClosed();
        if (l != -1L) {
            this.setRealLastSequenceNumber(l);
        }
        if (!this.transacted) {
            throw new IllegalStateException(JMSClientExceptionLogger.logNoTransaction3Loggable());
        }
        this.firstUnackedMessage = null;
        this.firstPendingWTMessage = null;
        try {
            Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionAcknowledgeRequest(this.getJMSID(), this.getLastSequenceNumber(), 1, true));
            this.decrementWindow = false;
        }
        catch (JMSException jMSException) {
            if ("ReservedRollbackOnly".equals(jMSException.getErrorCode())) {
                try {
                    this.recoverGuts(false, -1L);
                }
                catch (JMSException jMSException2) {
                    // empty catch block
                }
            }
            throw jMSException;
        }
    }

    void rollback(long l) throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException(JMSClientExceptionLogger.logNoTransaction4Loggable());
        }
        this.recoverGuts(false, l);
    }

    public void rollback() throws JMSException {
        this.rollback(-1L);
    }

    final void consumerIncrementWindowCurrent(final JMSID jMSID, final int n, final boolean bl) throws JMSException {
        byte by = this.connection.getPeerVersion();
        if (by < 3) {
            Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEConsumerIncrementWindowCurrentRequest(jMSID, n, bl));
        } else {
            final JMSConnection jMSConnection = this.connection;
            CrossDomainSecurityManager.doAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(this.getConnection().getFrontEndDispatcher(), CrossDomainSecurityManager.getCurrentSubject(), true), new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    jMSConnection.getFrontEndDispatcher().dispatchNoReply(new FEConsumerIncrementWindowCurrentOneWayRequest(jMSID, n, bl));
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stop() throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            if (this.stopped) {
                return;
            }
            if (!this.inListener() || !this.allowCloseInOnMessage) {
                this.waitForState(-5);
            }
            this.checkClosed();
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start() throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            Object object = this.lockObject;
            synchronized (object) {
                if (!this.stopped) {
                    return;
                }
                this.checkClosed();
                this.stopped = false;
                this.notifyAll();
                if (!(!this.running && this.havePushRequests() || this.synchronousListener)) {
                    return;
                }
                this.running = true;
            }
        }
        this.dispatchWorkManager.schedule((Runnable)this.useForRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resume() throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            Object object = this.lockObject;
            synchronized (object) {
                this.stopped = false;
                if (!this.havePushRequests() && !this.synchronousListener) {
                    return;
                }
                this.running = true;
            }
        }
        this.dispatchWorkManager.schedule((Runnable)this.useForRunnable);
    }

    public final void close() throws JMSException {
        this.close(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final void close(long var1_1) throws JMSException {
        block55: {
            var3_2 = null;
            var4_3 = false;
            var5_4 = this;
            synchronized (var5_4) {
                if (var1_1 == -1L) {
                    this.realLastSequenceNumberShouldApply = false;
                } else {
                    this.setRealLastSequenceNumber(var1_1);
                }
                this.closeStarted = true;
                this.realLastSequenceNumberShouldApply = false;
                if (!this.inListener() || !this.allowCloseInOnMessage) {
                    this.waitForState(-5);
                }
                if (!this.isClosed()) ** break block45
            }
            var8_5 = null;
            try {
                var9_8 = this;
                synchronized (var9_8) {
                    this.waitForState(-3);
                    try {
                        this.removeDurableConsumers();
                        var11_11 = null;
                        this.consumers.clear();
                        this.producers.clear();
                        this.browsers.clear();
                        this.firstUnackedMessage = null;
                        this.firstPendingWTMessage = null;
                        this.clientAckList = null;
                        this.clearState(1);
                        this.notify();
                    }
                    catch (Throwable var10_17) {
                        var11_12 = null;
                        this.consumers.clear();
                        this.producers.clear();
                        this.browsers.clear();
                        this.firstUnackedMessage = null;
                        this.firstPendingWTMessage = null;
                        this.clientAckList = null;
                        this.clearState(1);
                        this.notify();
                        throw var10_17;
                    }
                }
                var14_23 = null;
                var15_29 = this.synchronousListenerObject;
            }
            catch (Throwable var13_41) {
                var14_24 = null;
                var15_30 = this.synchronousListenerObject;
                synchronized (var15_30) {
                    this.synchronousListenerObject.notifyAll();
                }
                if (var4_3) {
                    this.connection.sessionRemove(var3_2);
                }
                throw var13_41;
            }
            synchronized (var15_29) {
                this.synchronousListenerObject.notifyAll();
            }
            if (var4_3) {
                this.connection.sessionRemove(var3_2);
            }
            {
                return;
                {
                    if (this.requireAckForDupsOK) {
                        this.acknowledge(true, false);
                    }
                    var4_3 = true;
                    var3_2 = this.poisonSession();
                    if (this.mSock != null) {
                        this.mSock.close();
                        this.mSock = null;
                    }
                    this.poisonConsumersAndCloseLocaly();
                    this.poisonProducers();
                    this.poisonBrowsers();
                    this.setState(1);
                }
                this.dispatchSessionCloseRequest(var3_2);
            }
            var8_6 = null;
            try {
                var9_9 = this;
                synchronized (var9_9) {
                    this.waitForState(-3);
                    try {
                        this.removeDurableConsumers();
                        var11_13 = null;
                        this.consumers.clear();
                        this.producers.clear();
                        this.browsers.clear();
                        this.firstUnackedMessage = null;
                        this.firstPendingWTMessage = null;
                        this.clientAckList = null;
                        this.clearState(1);
                        this.notify();
                    }
                    catch (Throwable var10_18) {
                        var11_14 = null;
                        this.consumers.clear();
                        this.producers.clear();
                        this.browsers.clear();
                        this.firstUnackedMessage = null;
                        this.firstPendingWTMessage = null;
                        this.clientAckList = null;
                        this.clearState(1);
                        this.notify();
                        throw var10_18;
                    }
                }
                var14_25 = null;
                var15_31 = this.synchronousListenerObject;
            }
            catch (Throwable var13_42) {
                var14_26 = null;
                var15_32 = this.synchronousListenerObject;
                synchronized (var15_32) {
                    this.synchronousListenerObject.notifyAll();
                }
                if (var4_3) {
                    this.connection.sessionRemove(var3_2);
                }
                throw var13_42;
            }
            synchronized (var15_31) {
                this.synchronousListenerObject.notifyAll();
            }
            if (var4_3) {
                this.connection.sessionRemove(var3_2);
            }
            break block55;
            catch (Throwable var7_45) {
                var8_7 = null;
                try {
                    var9_10 = this;
                    synchronized (var9_10) {
                        this.waitForState(-3);
                        try {
                            this.removeDurableConsumers();
                            var11_15 = null;
                            this.consumers.clear();
                            this.producers.clear();
                            this.browsers.clear();
                            this.firstUnackedMessage = null;
                            this.firstPendingWTMessage = null;
                            this.clientAckList = null;
                            this.clearState(1);
                            this.notify();
                        }
                        catch (Throwable var10_19) {
                            var11_16 = null;
                            this.consumers.clear();
                            this.producers.clear();
                            this.browsers.clear();
                            this.firstUnackedMessage = null;
                            this.firstPendingWTMessage = null;
                            this.clientAckList = null;
                            this.clearState(1);
                            this.notify();
                            throw var10_19;
                        }
                    }
                    var14_27 = null;
                    var15_33 = this.synchronousListenerObject;
                }
                catch (Throwable var13_43) {
                    var14_28 = null;
                    var15_34 = this.synchronousListenerObject;
                    synchronized (var15_34) {
                        this.synchronousListenerObject.notifyAll();
                    }
                    if (var4_3) {
                        this.connection.sessionRemove(var3_2);
                    }
                    throw var13_43;
                }
                synchronized (var15_33) {
                    this.synchronousListenerObject.notifyAll();
                }
                if (var4_3) {
                    this.connection.sessionRemove(var3_2);
                }
                throw var7_45;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSID poisonSession() {
        JMSSession jMSSession;
        JMSSession jMSSession2 = jMSSession = this.wlSessionImpl == null ? this : this.wlSessionImpl.getConnectionStateLock();
        synchronized (jMSSession2) {
            JMSID jMSID = this.sessionId;
            this.sessionId = null;
            return jMSID;
        }
    }

    private void removeDurableConsumers() {
        Iterator iterator = this.consumers.cloneValuesIterator();
        while (iterator.hasNext()) {
            ConsumerInternal consumerInternal = (ConsumerInternal)iterator.next();
            if (!consumerInternal.isDurable()) continue;
            consumerInternal.removeDurableConsumer();
        }
    }

    private void poisonBrowsers() {
        Iterator iterator = this.browsers.cloneValuesIterator();
        while (iterator.hasNext()) {
            JMSQueueBrowser jMSQueueBrowser = (JMSQueueBrowser)iterator.next();
            jMSQueueBrowser.setId(null);
        }
    }

    private void poisonConsumersAndCloseLocaly() throws JMSException {
        Iterator iterator = this.consumers.cloneValuesIterator();
        while (iterator.hasNext()) {
            ConsumerInternal consumerInternal = (ConsumerInternal)iterator.next();
            this.consumerCloseLocal(consumerInternal, false);
        }
    }

    private void poisonProducers() {
        Iterator iterator = this.producers.cloneValuesIterator();
        while (iterator.hasNext()) {
            JMSProducer jMSProducer = (JMSProducer)iterator.next();
            jMSProducer.setId(null);
        }
    }

    private void dispatchSessionCloseRequest(JMSID jMSID) throws JMSException {
        if (!this.connection.isConnected()) {
            return;
        }
        Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionCloseRequest(jMSID, this.getLastSequenceNumber()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutstandingReceives() throws JMSException {
        try {
            this.setState(1);
            this.waitForState(-3);
            Object var2_1 = null;
            this.clearState(1);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clearState(1);
            throw throwable;
        }
    }

    public final void recover() throws JMSException {
        this.recover(-1L);
    }

    final void recover(long l) throws JMSException {
        if (this.transacted) {
            throw new IllegalStateException(JMSClientExceptionLogger.logTransactedLoggable());
        }
        this.recoverGuts(true, l);
    }

    private void recoverGuts(boolean bl, long l) throws JMSException {
        this.checkClosed();
        if (this.connection.getPeerVersion() < 5) {
            this.recoverGuts81(bl, l);
        } else {
            this.recoverGuts90(bl, l);
        }
    }

    private final synchronized void recoverGuts81(boolean bl, long l) throws JMSException {
        ConsumerInternal consumerInternal;
        Object object;
        Object object2;
        boolean bl2;
        if (l != -1L) {
            this.setRealLastSequenceNumber(l);
        }
        if (this.requireAckForDupsOK) {
            this.acknowledge(false, false);
        }
        this.decrementWindow = false;
        long l2 = this.getLastSequenceNumber();
        this.rememberLastSequenceNumber(0L, null);
        boolean bl3 = bl2 = this.transacted || this.firstUnackedMessage != null;
        if (bl2) {
            object2 = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionRecoverRequest(this.getJMSID(), l2, !bl, this.pipelineGeneration));
            this.setExpectedSequenceNumber81(((JMSSessionRecoverResponse)object2).getSequenceNumber(), false);
            object = this.consumers.cloneValuesIterator();
            while (object.hasNext()) {
                consumerInternal = (ConsumerInternal)object.next();
                consumerInternal.setWindowCurrent(consumerInternal.getWindowMaximum());
                consumerInternal.setExpectedSequenceNumber(this.expectedSequenceNumber);
            }
            this.firstUnackedMessage = null;
            this.firstPendingWTMessage = null;
        }
        if ((object2 = this.clientAckList) != null) {
            this.clientAckList = null;
            Request request = null;
            JMSPushRequest jMSPushRequest = null;
            JMSPushRequest jMSPushRequest2 = null;
            long l3 = this.expectedSequenceNumber;
            for (object = (JMSMessageReference)((MessageList)object2).getLast(); object != null; object = (JMSMessageReference)((MessageReference)object).getPrev()) {
                consumerInternal = ((JMSMessageReference)object).getConsumer();
                l3 = ((MessageReference)object).getSequenceNumber();
                consumerInternal.setExpectedSequenceNumber(l3, true);
            }
            this.setExpectedSequenceNumber81(l3, true);
            for (object = (JMSMessageReference)((MessageList)object2).getFirst(); object != null; object = (JMSMessageReference)((MessageReference)object).getNext()) {
                MessageImpl messageImpl = ((MessageReference)object).getMessage();
                messageImpl.incrementDeliveryCount();
                messageImpl = ((MessageReference)object).getMessage();
                messageImpl.reset();
                messageImpl.setPropertiesWritable(false);
                jMSPushRequest = new JMSPushRequest(0, null, messageImpl);
                if (request != null) {
                    request.setNext(jMSPushRequest);
                } else {
                    jMSPushRequest2 = jMSPushRequest;
                }
                request = jMSPushRequest;
                jMSPushRequest = null;
                consumerInternal = ((JMSMessageReference)object).getConsumer();
                long l4 = ((MessageReference)object).getSequenceNumber();
                JMSPushEntry jMSPushEntry = new JMSPushEntry(null, consumerInternal.getJMSID(), 0L, l4, messageImpl.getDeliveryCount(), 0x200000);
                jMSPushEntry.setClientResponsibleForAcknowledge(true);
                ((JMSPushRequest)request).setPushEntries(jMSPushEntry);
            }
            if (jMSPushRequest2 != null) {
                this.pushMessage(jMSPushRequest2, this.consumerListenerCount == 0);
            }
        }
        if (this.inState(4)) {
            this.recovering = true;
        }
        this.proxyGenerationForOlderServer = this.proxyGenerationForOlderServer == Integer.MAX_VALUE ? 0 : ++this.proxyGenerationForOlderServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recoverGuts90(boolean bl, long l) throws JMSException {
        FESessionRecoverRequest fESessionRecoverRequest;
        Object object = this;
        synchronized (object) {
            if (l != -1L) {
                this.setRealLastSequenceNumber(l);
            }
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("CLIENT/JMSSession (id: " + this.sessionId + ") : " + "Recover msg " + this.getLastSequenceNumber() + ", info " + (this.firstUnackedMessage == null) + "/" + (this.clientAckList == null) + "/" + this.transacted);
            }
            if (this.requireAckForDupsOK) {
                this.acknowledge(false, false);
            }
            long l2 = this.getLastSequenceNumber();
            this.rememberLastSequenceNumber(0L, null);
            if (this.acknowledgeMode == 4 || this.acknowledgeMode == 128) {
                return;
            }
            if (this.inState(4)) {
                this.recovering = true;
            }
            this.decrementWindow = false;
            Object object2 = this.lockObject;
            synchronized (object2) {
                Object object3;
                int n = this.pipelineGeneration;
                this.pipelineGeneration = JMSPushEntry.nextRecoverGeneration(this.pipelineGeneration);
                this.recoversFor90HasBeenCalled = true;
                if (this.session_clientResponsibleForAck) {
                    object3 = this.firstPushRequest;
                    this.lastPushRequest = null;
                    this.setFirstPushRequest(null);
                    this.pushRequestCount = 0;
                    this.restoreClientAckMessages(l2, (JMSPushRequest)object3);
                } else {
                    for (object3 = this.firstPushRequest; object3 != null; object3 = (JMSPushRequest)((Request)object3).getNext()) {
                        if (!this.connection.isLocal() || ((JMSPushRequest)object3).getFirstPushEntry().getPipelineGeneration() != 0) continue;
                        ((JMSPushRequest)object3).getFirstPushEntry().setPipelineGeneration(0x100000);
                    }
                }
                object3 = this.consumers.cloneValuesIterator();
                while (object3.hasNext()) {
                    ConsumerInternal consumerInternal = (ConsumerInternal)object3.next();
                    consumerInternal.setWindowCurrent(consumerInternal.getWindowMaximum());
                }
            }
            this.firstUnackedMessage = null;
            this.firstPendingWTMessage = null;
            fESessionRecoverRequest = new FESessionRecoverRequest(this.getJMSID(), l2, !bl, this.pipelineGeneration);
        }
        object = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(fESessionRecoverRequest);
    }

    private void restoreClientAckMessages(long l, JMSPushRequest jMSPushRequest) {
        Externalizable externalizable;
        Object object;
        MessageList messageList = this.clientAckList;
        this.clientAckList = null;
        ConsumerInternal consumerInternal = null;
        JMSID jMSID = null;
        if (messageList != null) {
            for (object = (JMSMessageReference)messageList.getFirst(); object != null; object = (JMSMessageReference)((MessageReference)object).getNext()) {
                if (((JMSMessageReference)object).getConsumer().isClosed()) continue;
                if (!((JMSMessageReference)object).getConsumer().getJMSID().equals(jMSID)) {
                    jMSID = ((JMSMessageReference)object).getConsumer().getJMSID();
                    consumerInternal = this.consumerFind(jMSID);
                }
                if (consumerInternal == null) continue;
                externalizable = ((MessageReference)object).getMessage();
                try {
                    ((MessageImpl)externalizable).setMessageReference(null);
                    externalizable = ((MessageImpl)externalizable).copy();
                    ((MessageImpl)externalizable).setMessageReference((MessageReference)object);
                    ((MessageReference)object).setMessage((MessageImpl)externalizable);
                    ((MessageImpl)externalizable).reset();
                    ((MessageImpl)externalizable).setPropertiesWritable(false);
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                if (((MessageReference)object).getSequenceNumber() <= l) {
                    ((MessageReference)object).incrementDeliveryCount();
                }
                JMSPushEntry jMSPushEntry = new JMSPushEntry(this.getJMSID(), ((JMSMessageReference)object).getConsumer().getJMSID(), 0L, ((MessageReference)object).getSequenceNumber(), ((MessageReference)object).getDeliveryCount(), 0x200000);
                jMSPushEntry.setClientResponsibleForAcknowledge(true);
                this.fabricateClientAckPushEntry(consumerInternal, (MessageImpl)externalizable, jMSPushEntry);
            }
        }
        for (object = this.recoverableClientAckMessages; object != null; object = (JMSPushRequest)((Request)object).getNext()) {
            for (externalizable = ((JMSPushRequest)object).removePushEntry(); externalizable != null; externalizable = ((JMSPushEntry)externalizable).getNext()) {
                if (!((JMSPushEntry)externalizable).getClientResponsibleForAcknowledge()) continue;
                if (!((JMSPushEntry)externalizable).getConsumerId().equals(jMSID)) {
                    jMSID = ((JMSPushEntry)externalizable).getConsumerId();
                    consumerInternal = this.consumerFind(jMSID);
                }
                if (consumerInternal == null) continue;
                this.fabricateClientAckPushEntry(consumerInternal, ((JMSPushRequest)object).getMessage(), (JMSPushEntry)externalizable);
            }
        }
        for (object = jMSPushRequest; object != null; object = (JMSPushRequest)((Request)object).getNext()) {
            for (externalizable = ((JMSPushRequest)object).removePushEntry(); externalizable != null; externalizable = ((JMSPushEntry)externalizable).getNext()) {
                if (!((JMSPushEntry)externalizable).getClientResponsibleForAcknowledge()) continue;
                if (!((JMSPushEntry)externalizable).getConsumerId().equals(jMSID)) {
                    jMSID = ((JMSPushEntry)externalizable).getConsumerId();
                    consumerInternal = this.consumerFind(jMSID);
                }
                if (consumerInternal == null) continue;
                this.fabricateClientAckPushEntry(consumerInternal, ((JMSPushRequest)object).getMessage(), (JMSPushEntry)externalizable);
            }
        }
    }

    private void fabricateClientAckPushEntry(ConsumerInternal consumerInternal, MessageImpl messageImpl, JMSPushEntry jMSPushEntry) {
        jMSPushEntry.setPipelineGeneration(0x200000);
        JMSPushRequest jMSPushRequest = new JMSPushRequest(0, this.getJMSID(), messageImpl, jMSPushEntry);
        if (consumerInternal.getMessageListenerContext() == null) {
            this.addPushRequests(jMSPushRequest, true);
            if (consumerInternal.getExpectedSequenceNumber() > this.firstReceivePushRequest.getFrontEndSequenceNumber()) {
                consumerInternal.setExpectedSequenceNumber(this.firstReceivePushRequest.getFrontEndSequenceNumber());
            }
            return;
        }
        if (this.lastPushRequest != null) {
            this.lastPushRequest.setNext(jMSPushRequest);
        } else {
            this.setFirstPushRequest(jMSPushRequest);
        }
        this.lastPushRequest = jMSPushRequest;
        ++this.pushRequestCount;
    }

    private boolean duplicateMessage(MessageImpl messageImpl, JMSID jMSID, MessageList messageList) {
        Object object;
        if (messageList != null) {
            for (object = (JMSMessageReference)messageList.getFirst(); object != null; object = (JMSMessageReference)((MessageReference)object).getNext()) {
                if (((MessageReference)object).getMessage() != messageImpl) continue;
                return true;
            }
        }
        for (object = this.firstPushRequest; object != null; object = (JMSPushRequest)((Request)object).getNext()) {
            if (messageImpl == ((JMSPushRequest)object).getMessage()) {
                return true;
            }
            for (JMSPushEntry jMSPushEntry = ((JMSPushRequest)object).getFirstPushEntry(); jMSPushEntry != null; jMSPushEntry = jMSPushEntry.getNext()) {
                if (!jMSID.equals(jMSPushEntry.getConsumerId()) || !messageImpl.getId().equals(((JMSPushRequest)object).getMessage().getId())) continue;
                return true;
            }
        }
        return false;
    }

    public final void acknowledge() throws JMSException {
        this.acknowledge(null, 1, false);
    }

    public final void acknowledge(Message message) throws JMSException {
        this.throwForAckRefreshedSessionRules();
        this.acknowledge((WLAcknowledgeInfo)message, this.acknowledgePolicy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void acknowledge(boolean bl, boolean bl2) throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            block10: {
                JMSMessageId jMSMessageId;
                long l;
                if (this.inListener()) {
                    l = this.getLastSequenceNumber() - 1L;
                    jMSMessageId = this.previousExposedMsgId;
                } else {
                    l = this.getLastSequenceNumber();
                    jMSMessageId = this.lastExposedMsgId;
                }
                this.checkClosed();
                try {
                    block9: {
                        try {
                            if (bl2) break block9;
                            this.rememberLastServerAck(jMSMessageId);
                            if (!bl || this.connection.isConnected()) {
                                this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionAcknowledgeRequest(this.getJMSID(), l, 1, false));
                            }
                            this.rememberLastServerAck(null);
                        }
                        catch (Exception exception) {
                            JMSSession.handleException(exception);
                            Object var9_7 = null;
                            this.removePendingWTMessage(l, IGNOREWINDOWCURRENT);
                            this.removeUnackedMessage(l, bl2, false);
                            break block10;
                        }
                    }
                    Object var9_6 = null;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    this.removePendingWTMessage(l, IGNOREWINDOWCURRENT);
                    this.removeUnackedMessage(l, bl2, false);
                    throw throwable;
                }
                this.removePendingWTMessage(l, IGNOREWINDOWCURRENT);
                this.removeUnackedMessage(l, bl2, false);
            }
            return;
        }
    }

    public final void acknowledge(WLAcknowledgeInfo wLAcknowledgeInfo) throws JMSException {
        this.throwForAckRefreshedSessionRules();
        this.acknowledge(wLAcknowledgeInfo, this.acknowledgePolicy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void acknowledge(WLAcknowledgeInfo wLAcknowledgeInfo, int n, boolean bl) throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            block14: {
                JMSMessageId jMSMessageId;
                long l;
                boolean bl2;
                if (wLAcknowledgeInfo == null) {
                    bl2 = false;
                    l = this.getLastSequenceNumber();
                    jMSMessageId = this.lastExposedMsgId;
                } else {
                    bl2 = wLAcknowledgeInfo.getClientResponsibleForAcknowledge();
                    if (n == 1 && this.mmListener == null) {
                        l = this.getLastSequenceNumber();
                        jMSMessageId = this.lastExposedMsgId;
                    } else {
                        l = wLAcknowledgeInfo.getSequenceNumber();
                        jMSMessageId = wLAcknowledgeInfo.getMessageId();
                    }
                }
                this.checkClosed();
                if (this.transacted) {
                    return;
                }
                try {
                    block13: {
                        try {
                            if (bl2) break block13;
                            if (bl) {
                                this.connection.getFrontEndDispatcher().dispatchSyncTran(new FESessionAcknowledgeRequest(this.getJMSID(), l, n, false));
                            } else {
                                this.rememberLastServerAck(jMSMessageId);
                                this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionAcknowledgeRequest(this.getJMSID(), l, n, false));
                                this.rememberLastServerAck(null);
                            }
                            if (l != this.getLastSequenceNumber()) break block13;
                            this.decrementWindow = false;
                        }
                        catch (Exception exception) {
                            JMSSession.handleException(exception);
                            Object var11_9 = null;
                            this.removePendingWTMessage(l, IGNOREWINDOWCURRENT);
                            this.removeUnackedMessage(l, bl2, bl);
                            break block14;
                        }
                    }
                    Object var11_8 = null;
                }
                catch (Throwable throwable) {
                    Object var11_10 = null;
                    this.removePendingWTMessage(l, IGNOREWINDOWCURRENT);
                    this.removeUnackedMessage(l, bl2, bl);
                    throw throwable;
                }
                this.removePendingWTMessage(l, IGNOREWINDOWCURRENT);
                this.removeUnackedMessage(l, bl2, bl);
            }
            return;
        }
    }

    void throwForAckRefreshedSessionRules() throws LostServerException {
        if (this.checkRefreshedWithPendingWork()) {
            throw new LostServerException(JMSClientExceptionLogger.logLostServerConnectionLoggable());
        }
    }

    public final void associateTransaction(Message message) throws JMSException {
        MessageImpl messageImpl = (MessageImpl)message;
        if (!this.userTransactionsEnabled && messageImpl.getUnitOfOrder() != null) {
            throw new JMSException("associateTransaction with Unit of Order requires XASession");
        }
        this.acknowledge(messageImpl, 1, true);
    }

    public final MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        if (this.messageContext != null) {
            return this.messageContext.getMessageListener();
        }
        return null;
    }

    public final synchronized JMSMessageContext getJMSMessageContext() {
        return this.messageContext;
    }

    public final synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkClosed();
        if (this.consumerListenerCount > 0) {
            throw new IllegalStateException(JMSClientExceptionLogger.logSessionHasConsumersLoggable());
        }
        this.messageContext = new JMSMessageContext(messageListener);
    }

    public final synchronized void setMMessageListener(MMessageListener mMessageListener) {
        this.mmListener = mMessageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        boolean bl;
        Object object;
        block12: {
            block11: {
                object = this;
                synchronized (object) {
                    Object object2 = this.lockObject;
                    synchronized (object2) {
                        this.lastPushRequest = null;
                        this.setFirstPushRequest(null);
                        this.pushRequestCount = 0;
                    }
                    this.setState(4);
                }
                object = null;
                bl = false;
                try {
                    try {
                        MessageListener messageListener = this.getMessageListener();
                        if (messageListener == null) {
                            Object var9_6 = null;
                            this.clearState(4);
                            if (!bl) return;
                            break block11;
                        }
                        object = JMSContext.push(this.messageContext, true);
                        bl = true;
                        for (JMSPushRequest jMSPushRequest = this.firstPushRequest; jMSPushRequest != null; jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext()) {
                            MessageImpl messageImpl = jMSPushRequest.getMessage().copy();
                            messageImpl.setDDForwarded(false);
                            JMSPushEntry jMSPushEntry = jMSPushRequest.getFirstPushEntry();
                            ConsumerInternal consumerInternal = this.consumerFind(jMSPushEntry.getConsumerId());
                            messageImpl.setSequenceNumber(jMSPushEntry.getFrontEndSequenceNumber());
                            messageImpl.setDeliveryCount(jMSPushEntry.getDeliveryCount());
                            this.onMessage(consumerInternal, messageListener, messageImpl);
                        }
                        break block12;
                    }
                    catch (JMSException jMSException) {
                        JMSClientExceptionLogger.logStackTrace((Throwable)jMSException);
                        Object var9_8 = null;
                        this.clearState(4);
                        if (!bl) return;
                        JMSContext.pop((JMSContext)object, true);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    this.clearState(4);
                    if (!bl) throw throwable;
                    JMSContext.pop((JMSContext)object, true);
                    throw throwable;
                }
            }
            JMSContext.pop((JMSContext)object, true);
            return;
        }
        Object var9_7 = null;
        this.clearState(4);
        if (!bl) return;
        JMSContext.pop((JMSContext)object, true);
    }

    public final synchronized Topic createTopic(String string) throws JMSException {
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperationLoggable());
        }
        return (Topic)this.createDestination(string, 2);
    }

    public final synchronized TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkClosed();
        byte by = 5;
        return (TopicSubscriber)this.createConsumer((javax.jms.Destination)topic, null, false, null, by);
    }

    public final synchronized TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        this.checkClosed();
        byte by = 5;
        return (TopicSubscriber)this.createConsumer((javax.jms.Destination)topic, string, bl, null, by);
    }

    public final TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation2Loggable());
        }
        return this.createDurableSubscriber(topic, string, null, false);
    }

    public final TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        if (string == null) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoSubscriberNameLoggable());
        }
        if (string.length() == 0) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logZeroLengthSubscriberNameLoggable());
        }
        if (topic instanceof DistributedDestinationImpl) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidDistributedTopicLoggable());
        }
        byte by = 5;
        return (TopicSubscriber)this.createConsumer((javax.jms.Destination)topic, string2, bl, string, by);
    }

    public final TopicPublisher createPublisher(Topic topic) throws JMSException {
        byte by = 4;
        return (TopicPublisher)this.createProducer((javax.jms.Destination)topic, by);
    }

    public final TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation3Loggable());
        }
        return (TemporaryTopic)this.createTemporaryDestination(8);
    }

    public final synchronized void unsubscribe(String string) throws JMSException {
        this.checkClosed();
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation4Loggable());
        }
        if (string == null || string.length() == 0) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logInvalidSubscriptionLoggable().getMessage());
        }
        if (this.clientID == null) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidUnsubscribeLoggable());
        }
        if (this.connection.getClientIDPolicyInt() == 1) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logInvalidUnrestrictedUnsubscribeLoggable((String)string, (String)this.clientID));
        }
        this.subscriptionRemove(string);
    }

    public synchronized void unsubscribe(Topic topic, String string) throws JMSException {
        this.checkClosed();
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation4Loggable());
        }
        if (string == null || string.length() == 0) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logInvalidSubscriptionLoggable().getMessage());
        }
        if (this.clientID == null) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidUnsubscribeLoggable());
        }
        if (this.connection.getClientIDPolicyInt() == 1 && (topic == null || topic instanceof DistributedDestinationImpl)) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logInvalidUnrestrictedUnsubscribe2Loggable((String)string, (String)this.clientID));
        }
        this.subscriptionRemove((DestinationImpl)topic, string);
    }

    public final synchronized Queue createQueue(String string) throws JMSException {
        if (this.type == 1) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedQueueOperationLoggable());
        }
        return (Queue)this.createDestination(string, 1);
    }

    public final QueueReceiver createReceiver(Queue queue) throws JMSException {
        byte by = 3;
        return (QueueReceiver)this.createConsumer((javax.jms.Destination)queue, null, false, null, by);
    }

    public final QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        byte by = 3;
        return (QueueReceiver)this.createConsumer((javax.jms.Destination)queue, string, false, null, by);
    }

    public final QueueSender createSender(Queue queue) throws JMSException {
        byte by = 2;
        return (QueueSender)this.createProducer((javax.jms.Destination)queue, by);
    }

    public final QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public final synchronized QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        this.checkClosed();
        if (this.type == 1) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedQueueOperation2Loggable());
        }
        byte by = 3;
        Destination.checkDestinationType((javax.jms.Destination)queue, by);
        JMSQueueBrowser jMSQueueBrowser = new JMSQueueBrowser(queue, string, this);
        this.browsers.put(jMSQueueBrowser.getJMSID(), jMSQueueBrowser);
        try {
            InvocableManagerDelegate.delegate.invocableAdd(22, jMSQueueBrowser);
        }
        catch (Exception exception) {
            JMSClientExceptionLogger.logStackTrace((Throwable)exception);
        }
        return jMSQueueBrowser;
    }

    final synchronized void closeBrowser(JMSID jMSID, boolean bl) throws JMSException {
        if (this.browsers.remove(jMSID) == null) {
            return;
        }
        if (!bl) {
            Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEBrowserCloseRequest(jMSID));
        }
        InvocableManagerDelegate.delegate.invocableRemove(22, jMSID);
    }

    public final MessageConsumer createConsumer(javax.jms.Destination destination) throws JMSException {
        this.checkClosed();
        return this.createConsumer(destination, null, false, null, (byte)0);
    }

    public final MessageConsumer createConsumer(javax.jms.Destination destination, String string) throws JMSException {
        return this.createConsumer(destination, string, false, null, (byte)0);
    }

    public final MessageConsumer createConsumer(javax.jms.Destination destination, String string, boolean bl) throws JMSException {
        return this.createConsumer(destination, string, bl, null, (byte)0);
    }

    private MessageConsumer createConsumer(javax.jms.Destination destination, String string, boolean bl, String string2, byte by) throws JMSException {
        JMSConsumer jMSConsumer = this.setupConsumer(destination, string, bl, string2, by, this.wlSessionImpl.getWLConnectionImpl().computeConsumerReconnectInfo());
        WLConsumerImpl wLConsumerImpl = new WLConsumerImpl(jMSConsumer, this.wlSessionImpl);
        jMSConsumer.setWlConsumerImpl(wLConsumerImpl);
        return wLConsumerImpl;
    }

    synchronized JMSConsumer setupConsumer(javax.jms.Destination destination, String string, boolean bl, String string2, byte by, ConsumerReconnectInfo consumerReconnectInfo) throws JMSException {
        Object object;
        JMSConsumer jMSConsumer;
        this.checkClosed();
        if (destination == null) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logNullDestinationLoggable().getMessage());
        }
        Destination.checkDestinationType(destination, by);
        if (this.acknowledgeMode != 128) {
            string2 = this.throwWhenInvalidSubscriberName(destination, string2);
            jMSConsumer = new JMSConsumer(this, string2, (DestinationImpl)destination, string, bl, this.messagesMaximum, by);
        } else {
            if (string2 != null) {
                string2 = null;
            }
            object = this.setupMulticastInternal(destination);
            jMSConsumer = new JMSConsumer(this, string2, (DestinationImpl)destination, string, bl, this.messagesMaximum, by);
            try {
                this.mSock.joinGroup((DestinationImpl)destination, jMSConsumer);
            }
            catch (IOException iOException) {
                throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logCannotJoinMulticastGroupLoggable((String)object, (IOException)iOException));
            }
        }
        if (jMSConsumer.isDurable() && consumerReconnectInfo != null) {
            consumerReconnectInfo.setDelayServerClose(0L);
        }
        object = this.consumerCreate(string2, (DestinationImpl)destination, string, bl, this.messagesMaximum, consumerReconnectInfo);
        jMSConsumer.setId(((FEConsumerCreateResponse)object).getConsumerId());
        jMSConsumer.setRuntimeMBeanName(((FEConsumerCreateResponse)object).getRuntimeMBeanName());
        jMSConsumer.setConsumerReconnectInfo(((FEConsumerCreateResponse)object).getConsumerReconnectInfo());
        this.consumerAdd(jMSConsumer);
        return jMSConsumer;
    }

    private String throwWhenInvalidSubscriberName(javax.jms.Destination destination, String string) throws IllegalStateException {
        if (!((DestinationImpl)destination).isTopic()) {
            string = null;
        } else if (string != null) {
            if (string.length() == 0) {
                string = null;
            } else if (this.clientID == null) {
                throw new IllegalStateException(JMSClientExceptionLogger.logInvalidConsumerCreationLoggable((String)string));
            }
        }
        return string;
    }

    private String setupMulticastInternal(javax.jms.Destination destination) throws weblogic.jms.common.JMSException {
        if (((DestinationImpl)destination).isQueue()) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoMulticastForQueuesLoggable());
        }
        String string = ((DestinationImpl)destination).getMulticastAddress();
        int n = ((DestinationImpl)destination).getPort();
        if (string == null || n <= 0) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logTopicNoMulticastLoggable((String)destination.toString()));
        }
        try {
            if (this.mSock == null) {
                this.dgmSock = new JMSTDMSocketIPM(n);
                this.dgmSock.setSoTimeout(1000);
                this.mSock = new JMSTMSocket(this, this.dgmSock, 1, n);
                this.dispatchWorkManager.schedule((Runnable)this.mSock);
            }
        }
        catch (IOException iOException) {
            if (this.mSock != null) {
                this.mSock.close();
            }
            if (this.dgmSock != null) {
                this.dgmSock.close();
            }
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logCannotOpenMulticastSocketLoggable((IOException)iOException));
        }
        return string;
    }

    public final synchronized MessageProducer createProducer(javax.jms.Destination destination) throws JMSException {
        return this.createProducer(destination, (byte)0);
    }

    synchronized JMSProducer setupJMSProducer(javax.jms.Destination destination, byte by) throws JMSException {
        this.checkClosed();
        Destination.checkDestinationType(destination, by);
        Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEProducerCreateRequest(this.sessionId, (DestinationImpl)destination));
        JMSID jMSID = ((FEProducerCreateResponse)response).getProducerId();
        JMSProducer jMSProducer = new JMSProducer(this, jMSID, (DestinationImpl)destination, ((FEProducerCreateResponse)response).getRuntimeMBeanName());
        if (this.unitOfOrder != null) {
            jMSProducer.setUnitOfOrder(this.unitOfOrder);
        }
        jMSProducer.setDestinationFlags(by);
        this.producerAdd(jMSProducer);
        return jMSProducer;
    }

    private MessageProducer createProducer(javax.jms.Destination destination, byte by) throws JMSException {
        JMSProducer jMSProducer = this.setupJMSProducer(destination, by);
        WLProducerImpl wLProducerImpl = new WLProducerImpl(jMSProducer, this.wlSessionImpl);
        jMSProducer.setWlProducerImpl(wLProducerImpl);
        return wLProducerImpl;
    }

    public final TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.type == 1) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedQueueOperation3Loggable());
        }
        return (TemporaryQueue)this.createTemporaryDestination(4);
    }

    public final synchronized void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.checkClosed();
        this.exceptionContext = new JMSExceptionContext(exceptionListener);
    }

    public final synchronized JMSExceptionContext getJMSExceptionContext() {
        return this.exceptionContext;
    }

    public final synchronized ExceptionListener getExceptionListener() {
        if (this.exceptionContext != null) {
            return this.exceptionContext.getExceptionListener();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onException(JMSException jMSException) {
        JMSContext jMSContext = null;
        try {
            block5: {
                try {
                    JMSExceptionContext jMSExceptionContext;
                    if (this.exceptionContext != null) {
                        jMSContext = JMSContext.push(this.exceptionContext);
                        this.exceptionContext.invokeListener(jMSException);
                        break block5;
                    }
                    if (!(jMSException instanceof weblogic.jms.common.JMSException) || ((weblogic.jms.common.JMSException)jMSException).isInformational() || (jMSExceptionContext = this.getConnection().getJMSExceptionContext()) == null) break block5;
                    JMSConnection.onException(jMSException, jMSExceptionContext);
                }
                catch (Throwable throwable) {
                    JMSClientExceptionLogger.logStackTrace((Throwable)throwable);
                    Object var5_6 = null;
                    if (jMSContext == null) return;
                    JMSContext.pop(jMSContext);
                    return;
                }
            }
            Object var5_5 = null;
            if (jMSContext == null) return;
            JMSContext.pop(jMSContext);
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (jMSContext == null) throw throwable;
            JMSContext.pop(jMSContext);
            throw throwable;
        }
    }

    private FEConsumerCreateResponse consumerCreate(String string, DestinationImpl destinationImpl, String string2, boolean bl, int n, ConsumerReconnectInfo consumerReconnectInfo) throws JMSException {
        Response response;
        if (!(destinationImpl.getType() != 4 && destinationImpl.getType() != 8 || destinationImpl.getConnection() != null && this.connection.getJMSID().equals(destinationImpl.getConnection().getJMSID()))) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logInvalidConnectionLoggable().getMessage());
        }
        if (string != null && this.getConnection().getClientIDPolicyInt() == 0 && this.subscriptionSharingPolicy == 0 && !this.connection.markDurableSubscriber(string)) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logSubscriptionNameInUseLoggable((String)string));
        }
        try {
            response = this.connection.getFrontEndDispatcher().dispatchSync(new FEConsumerCreateRequest(this.sessionId, this.clientID, string, destinationImpl, string2, bl, n, this.getRedeliveryDelay(), consumerReconnectInfo, this.subscriptionSharingPolicy));
        }
        catch (JMSException jMSException) {
            if (string != null) {
                this.connection.removeDurableSubscriber(string);
            }
            throw jMSException;
        }
        if (!(response instanceof FEConsumerCreateResponse)) {
            if (string != null) {
                this.connection.removeDurableSubscriber(string);
            }
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidFrontEndResponseLoggable((Object)response));
        }
        if (string != null && this.getConnection().getClientIDPolicyInt() == 0) {
            this.connection.addDurableSubscriber(string, ((FEConsumerCreateResponse)response).getConsumerId());
        }
        return (FEConsumerCreateResponse)response;
    }

    private synchronized void consumerAdd(JMSConsumer jMSConsumer) {
        this.consumers.put(jMSConsumer.getJMSID(), jMSConsumer);
        try {
            InvocableManagerDelegate.delegate.invocableAdd(6, jMSConsumer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int consumersCount() {
        return this.consumers.size();
    }

    public int producersCount() {
        return this.producers.size();
    }

    final synchronized void consumerClose(ConsumerInternal consumerInternal) throws JMSException {
        this.consumerClose(consumerInternal, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void consumerClose(ConsumerInternal consumerInternal, long l) throws JMSException {
        JMSID jMSID;
        if (l != -1L) {
            this.setRealLastSequenceNumber(l);
        }
        if (!this.inListener() || !this.allowCloseInOnMessage) {
            this.waitForState(-5);
        }
        Object object = consumerInternal;
        synchronized (object) {
            if (consumerInternal.isClosed()) {
                return;
            }
            jMSID = this.consumerCloseLocal(consumerInternal, true);
        }
        object = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FEConsumerCloseRequest(jMSID, this.getLastSequenceNumber()));
        this.waitForOutstandingReceives();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSID consumerCloseLocal(ConsumerInternal consumerInternal, boolean bl) throws JMSException {
        JMSID jMSID;
        ConsumerInternal consumerInternal2 = consumerInternal;
        synchronized (consumerInternal2) {
            this.consumerRemove(consumerInternal, bl);
            jMSID = consumerInternal.getJMSID();
            consumerInternal.setClosed(true);
            if (bl && this.acknowledgeMode == 128) {
                this.leaveGroup((DestinationImpl)consumerInternal.getDestination(), consumerInternal);
            }
        }
        return jMSID;
    }

    private synchronized ConsumerInternal consumerFind(JMSID jMSID) {
        return (ConsumerInternal)this.consumers.get(jMSID);
    }

    private synchronized void consumerRemove(ConsumerInternal consumerInternal, boolean bl) {
        if (bl) {
            this.consumers.remove(consumerInternal.getJMSID());
        }
        InvocableManagerDelegate.delegate.invocableRemove(6, consumerInternal.getJMSID());
    }

    private synchronized void producerAdd(JMSProducer jMSProducer) {
        this.producers.put(jMSProducer.getJMSID(), jMSProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void producerClose(JMSID jMSID) throws JMSException {
        this.checkClosed();
        Object object = this;
        synchronized (object) {
            this.producers.remove(jMSID);
        }
        object = this.connection.getFrontEndDispatcher().dispatchSync(new FEProducerCloseRequest(jMSID));
    }

    public static final JMSException handleException(Exception exception) throws JMSException {
        if (exception instanceof JMSException) {
            throw (JMSException)((Object)exception);
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logSystemErrorLoggable((Exception)exception), (Throwable)exception);
    }

    private javax.jms.Destination createDestination(String string, int n) throws JMSException {
        this.checkClosed();
        Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FEDestinationCreateRequest(string, n, false));
        return ((JMSDestinationCreateResponse)response).getDestination();
    }

    final JMSID createBackEndBrowser(DestinationImpl destinationImpl, String string) throws JMSException {
        Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEBrowserCreateRequest(this.connection.getJMSID(), this.sessionId, destinationImpl, string));
        return ((JMSBrowserCreateResponse)response).getBrowserId();
    }

    private synchronized javax.jms.Destination createTemporaryDestination(int n) throws JMSException {
        this.checkClosed();
        Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FETemporaryDestinationCreateRequest(this.connection.getJMSID(), n, true));
        ((FETemporaryDestinationCreateResponse)response).getDestination().setConnection(this.connection);
        return ((FETemporaryDestinationCreateResponse)response).getDestination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscriptionRemove(String string) throws JMSException {
        if (!this.connection.markDurableSubscriber(string)) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logSubscriptionNameInUse2Loggable((String)string));
        }
        try {
            this.connection.consumerRemove(string);
            Object var3_2 = null;
            this.connection.removeDurableSubscriber(string);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.connection.removeDurableSubscriber(string);
            throw throwable;
        }
    }

    private void subscriptionRemove(DestinationImpl destinationImpl, String string) throws JMSException {
        if (this.getConnection().getClientIDPolicyInt() == 0) {
            this.subscriptionRemove(string);
            return;
        }
        this.connection.consumerRemove(destinationImpl, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushMessage(MessageImpl messageImpl, JMSPushEntry jMSPushEntry) {
        JMSPushRequest jMSPushRequest = new JMSPushRequest(0, this.sessionId, messageImpl, jMSPushEntry);
        Object object = this.lockObject;
        synchronized (object) {
            this.addSelfSequencePushRequest(jMSPushRequest);
        }
    }

    public final JMSPushRequest getFirstPushRequest() {
        return this.firstPushRequest;
    }

    private void setFirstPushRequest(JMSPushRequest jMSPushRequest) {
        this.firstPushRequest = jMSPushRequest;
    }

    private final void addSelfSequencePushRequest(JMSPushRequest jMSPushRequest) {
        if (this.acknowledgeMode == 128) {
            if (this.messagesMaximum != -1 && this.pushRequestCount >= this.messagesMaximum) {
                if (this.overrunPolicy == 0) {
                    this.onException(new DataOverrunException(JMSClientExceptionLogger.logDropNewerLoggable().getMessage(), jMSPushRequest.getMessage().getJMSMessageID(), jMSPushRequest.getMessage().getJMSCorrelationID(), jMSPushRequest.getMessage().getJMSDestination()));
                    return;
                }
                this.onException(new DataOverrunException(JMSClientExceptionLogger.logDropOlderLoggable().getMessage(), this.firstPushRequest.getMessage().getJMSMessageID(), this.firstPushRequest.getMessage().getJMSCorrelationID(), this.firstPushRequest.getMessage().getJMSDestination()));
                this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                --this.pushRequestCount;
            }
            ++this.pushRequestCount;
        }
        if (this.firstPushRequest == null) {
            this.setFirstPushRequest(jMSPushRequest);
        } else {
            this.lastPushRequest.setNext(jMSPushRequest);
        }
        this.lastPushRequest = jMSPushRequest;
    }

    private final void addPushRequests(JMSPushRequest jMSPushRequest, boolean bl) {
        Externalizable externalizable;
        Request request = jMSPushRequest;
        Request request2 = null;
        Request request3 = request;
        this.session_clientResponsibleForAck |= ((JMSPushRequest)request).getFirstPushEntry().getClientResponsibleForAcknowledge();
        if (!this.connectionOlderThan90) {
            for (externalizable = request; externalizable != null; externalizable = (JMSPushRequest)((Request)externalizable).getNext()) {
                if (bl || !this.connection.isLocal() || ((JMSPushRequest)externalizable).getFirstPushEntry().getPipelineGeneration() != 0 || !this.recoversFor90HasBeenCalled) continue;
                ((JMSPushRequest)externalizable).getFirstPushEntry().setPipelineGeneration(0x100000);
            }
        }
        while (!bl && request3 != null && ((JMSPushRequest)request3).getFrontEndSequenceNumber() < this.expectedSequenceNumber) {
            externalizable = null;
            for (JMSPushEntry jMSPushEntry = ((JMSPushRequest)request3).getFirstPushEntry(); jMSPushEntry != null; jMSPushEntry = jMSPushEntry.getNext()) {
                if (!jMSPushEntry.getClientResponsibleForAcknowledge()) continue;
                if (externalizable == null) {
                    ((JMSPushRequest)request3).setFirstPushEntry(jMSPushEntry);
                } else {
                    ((JMSPushEntry)externalizable).setNext(jMSPushEntry);
                }
                externalizable = jMSPushEntry;
            }
            if (externalizable == null) {
                if (request == request3) {
                    request = (JMSPushRequest)request3.getNext();
                }
                request3 = (JMSPushRequest)request3.getNext();
                continue;
            }
            ((JMSPushEntry)externalizable).setNext(null);
            ((JMSPushRequest)request3).setLastPushEntry((JMSPushEntry)externalizable);
            if (request2 == null) {
                request = request3;
            } else {
                request2.setNext(request3);
            }
            request2 = request3;
            request3 = (JMSPushRequest)request3.getNext();
        }
        if (request == null) {
            return;
        }
        if (request2 != null) {
            request2.setNext(request3);
            request3 = request2;
        }
        while (request3 != null) {
            for (externalizable = ((JMSPushRequest)request3).getFirstPushEntry(); externalizable != null; externalizable = ((JMSPushEntry)externalizable).getNext()) {
                int n = ((JMSPushEntry)externalizable).getPipelineGeneration();
                if (n == this.pipelineGeneration || n == 0 || ((JMSPushEntry)externalizable).getClientResponsibleForAcknowledge()) continue;
                if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                    JMSDebug.JMSMessagePath.debug("ignore stale pipelineGeneration " + JMSPushEntry.displayRecoverGeneration(n) + " when expecting " + JMSPushEntry.displayRecoverGeneration(this.pipelineGeneration));
                }
                ((JMSPushEntry)externalizable).setPipelineGeneration(0x100000);
            }
            if (request3.getNext() == null) break;
            request3 = (JMSPushRequest)request3.getNext();
        }
        externalizable = request3;
        if (bl) {
            if (this.firstReceivePushRequest == null) {
                this.firstReceivePushRequest = request;
                this.lastReceivePushRequest = externalizable;
                return;
            }
        } else if (this.firstPushRequest == null) {
            this.setFirstPushRequest((JMSPushRequest)request);
            this.lastPushRequest = externalizable;
            return;
        }
        if (bl) {
            if (((JMSPushRequest)externalizable).getFrontEndSequenceNumber() < this.firstReceivePushRequest.getFrontEndSequenceNumber()) {
                ((Request)externalizable).setNext(this.firstReceivePushRequest);
                this.firstReceivePushRequest = request;
                return;
            }
        } else if (((JMSPushRequest)externalizable).getFrontEndSequenceNumber() < this.firstPushRequest.getFrontEndSequenceNumber()) {
            ((Request)externalizable).setNext(this.firstPushRequest);
            this.firstPushRequest = request;
            return;
        }
        if (bl) {
            if (((JMSPushRequest)request).getFrontEndSequenceNumber() > this.lastReceivePushRequest.getFrontEndSequenceNumber()) {
                this.lastReceivePushRequest.setNext(request);
                this.lastReceivePushRequest = externalizable;
                return;
            }
        } else if (((JMSPushRequest)request).getFrontEndSequenceNumber() > this.lastPushRequest.getFrontEndSequenceNumber()) {
            this.lastPushRequest.setNext(request);
            this.lastPushRequest = externalizable;
            return;
        }
        JMSPushRequest jMSPushRequest2 = bl ? this.firstReceivePushRequest : this.firstPushRequest;
        while (jMSPushRequest2.getNext() != null) {
            if (bl && ((JMSPushRequest)request).getFrontEndSequenceNumber() == ((JMSPushRequest)jMSPushRequest2.getNext()).getFrontEndSequenceNumber()) {
                return;
            }
            if (((JMSPushRequest)externalizable).getFrontEndSequenceNumber() < ((JMSPushRequest)jMSPushRequest2.getNext()).getFrontEndSequenceNumber() && jMSPushRequest2.getFrontEndSequenceNumber() < ((JMSPushRequest)request).getFrontEndSequenceNumber()) {
                ((Request)externalizable).setNext(jMSPushRequest2.getNext());
                jMSPushRequest2.setNext(request);
                return;
            }
            jMSPushRequest2 = (JMSPushRequest)jMSPushRequest2.getNext();
        }
    }

    private final JMSPushRequest removePushRequests() {
        JMSPushRequest jMSPushRequest = this.firstPushRequest;
        if (jMSPushRequest == null) {
            return null;
        }
        if (this.acknowledgeMode == 128) {
            this.lastPushRequest = null;
            this.setFirstPushRequest(null);
            this.pushRequestCount = 0;
            return jMSPushRequest;
        }
        if (this.expectedSequenceNumber < jMSPushRequest.getFrontEndSequenceNumber()) {
            return null;
        }
        JMSPushRequest jMSPushRequest2 = null;
        while (this.firstPushRequest != null && this.firstPushRequest.getLastPushEntry().getFrontEndSequenceNumber() < this.expectedSequenceNumber) {
            jMSPushRequest2 = this.firstPushRequest;
            this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
        }
        if (this.firstPushRequest == null) {
            this.lastPushRequest = null;
            return jMSPushRequest;
        }
        assert (this.firstPushRequest.getFrontEndSequenceNumber() >= this.expectedSequenceNumber == this.firstPushRequest.getLastPushEntry().getFrontEndSequenceNumber() >= this.expectedSequenceNumber);
        if (this.expectedSequenceNumber < this.firstPushRequest.getFrontEndSequenceNumber()) {
            if (jMSPushRequest2 != null) {
                jMSPushRequest2.setNext(null);
            }
            return jMSPushRequest;
        }
        do {
            this.expectedSequenceNumber = this.firstPushRequest.getLastPushEntry().getFrontEndSequenceNumber() + 1L;
            jMSPushRequest2 = this.firstPushRequest;
            this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
        } while (this.firstPushRequest != null && this.firstPushRequest.getFrontEndSequenceNumber() < this.expectedSequenceNumber);
        if (this.firstPushRequest == null) {
            this.lastPushRequest = null;
        } else {
            jMSPushRequest2.setNext(null);
        }
        return jMSPushRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setExpectedSequenceNumber81(long l, boolean bl) {
        Object object = this.lockObject;
        synchronized (object) {
            JMSPushRequest jMSPushRequest = this.firstPushRequest;
            JMSPushRequest jMSPushRequest2 = null;
            if (bl || l > this.expectedSequenceNumber) {
                this.expectedSequenceNumber = l;
            }
            if (bl || jMSPushRequest == null) {
                return;
            }
            while (jMSPushRequest != null && jMSPushRequest.getFrontEndSequenceNumber() < this.expectedSequenceNumber) {
                boolean bl2 = true;
                JMSPushEntry jMSPushEntry = null;
                for (JMSPushEntry jMSPushEntry2 = jMSPushRequest.getFirstPushEntry(); jMSPushEntry2 != null; jMSPushEntry2 = jMSPushEntry2.getNext()) {
                    if (jMSPushEntry2.getClientResponsibleForAcknowledge()) {
                        bl2 = false;
                    } else if (jMSPushEntry == null) {
                        jMSPushRequest.removePushEntry();
                    } else {
                        jMSPushEntry.setNext(jMSPushEntry2.getNext());
                    }
                    jMSPushEntry = jMSPushEntry2;
                }
                if (bl2) {
                    if (jMSPushRequest2 == null) {
                        this.setFirstPushRequest((JMSPushRequest)jMSPushRequest.getNext());
                        if (this.firstPushRequest == null) {
                            this.lastPushRequest = null;
                            return;
                        }
                    } else {
                        jMSPushRequest2.setNext(jMSPushRequest.getNext());
                    }
                } else {
                    jMSPushRequest2 = jMSPushRequest;
                }
                jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext();
            }
        }
    }

    private final boolean havePushRequests() {
        if (this.firstPushRequest == null) {
            return false;
        }
        if (this.acknowledgeMode == 128) {
            return true;
        }
        return this.firstPushRequest.getFrontEndSequenceNumber() <= this.expectedSequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushMessage(Request request, boolean bl) {
        JMSPushRequest jMSPushRequest = (JMSPushRequest)request;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.acknowledgeMode == 128) {
                this.addSelfSequencePushRequest(jMSPushRequest);
            } else {
                this.addPushRequests(jMSPushRequest, bl);
                if (!bl && this.synchronousListener) {
                    this.adjustHighMark();
                }
            }
            if (this.running || this.stopped || this.synchronousListener) {
                return;
            }
            if (!this.havePushRequests()) {
                return;
            }
            this.running = true;
        }
        object = Thread.currentThread();
        boolean bl2 = JMSWorkManager.isThinclient() ? true : (this.ignoreJmsAsyncQueue && !this.connection.isLocal() ? false : (this.connection.isLocal() && this.dispatchWorkManager.getType() == 2 ? true : !this.dispatchWorkManager.isThreadOwner((Thread)object)));
        if (bl2) {
            this.dispatchWorkManager.schedule((Runnable)this.useForRunnable);
        } else {
            this.executeMessage();
        }
    }

    private void executeMessage() {
        if (this.mmListener == null) {
            this.execute();
            return;
        }
        this.executeMM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustHighMark() {
        boolean bl = true;
        if (this.firstPushRequest == null || this.highMark < this.firstPushRequest.getFrontEndSequenceNumber()) {
            return;
        }
        JMSPushRequest jMSPushRequest = null;
        JMSPushRequest jMSPushRequest2 = this.firstPushRequest;
        while (jMSPushRequest2.getFrontEndSequenceNumber() <= this.highMark) {
            if (jMSPushRequest2.getFrontEndSequenceNumber() == this.highMark) {
                ++this.highMark;
                if (bl && jMSPushRequest2.getFirstPushEntry().getPipelineGeneration() != 0x100000) {
                    Object object = this.synchronousListenerObject;
                    synchronized (object) {
                        if (this.waitForNewMessage) {
                            if (this.notifyNewMessage) {
                                if (jMSPushRequest == null) {
                                    this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                                } else {
                                    jMSPushRequest.setNext(jMSPushRequest2.getNext());
                                }
                                this.needToRemoveIt = false;
                            } else {
                                this.shortCutPrevPushRequest = jMSPushRequest;
                                this.needToRemoveIt = true;
                            }
                            this.shortCutPushRequest = jMSPushRequest2;
                            this.waitForNewMessage = false;
                            this.synchronousListenerObject.notify();
                        }
                    }
                    bl = false;
                }
            }
            jMSPushRequest = jMSPushRequest2;
            if ((jMSPushRequest2 = (JMSPushRequest)jMSPushRequest2.getNext()) != null) continue;
        }
        this.expectedSequenceNumber = this.highMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getAsyncMessageForConsumer(ConsumerInternal consumerInternal, long l) throws JMSException {
        JMSPushEntry jMSPushEntry = null;
        MessageImpl messageImpl = null;
        boolean bl = false;
        long l2 = System.currentTimeMillis();
        long l3 = l;
        Object object = this;
        synchronized (object) {
            while (this.stopped) {
                if (this.isClosed() || l == 0x7FFFFFFFFFFFFFFEL) {
                    return null;
                }
                try {
                    this.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                    throw new weblogic.jms.common.JMSException(interruptedException);
                }
                if (l == Long.MAX_VALUE) continue;
                long l4 = System.currentTimeMillis() - l2;
                if (l4 >= l) {
                    return null;
                }
                l3 = l - l4;
                if (l3 <= 0L) continue;
            }
        }
        object = this.lockObject;
        synchronized (object) {
            boolean bl2 = false;
            while (this.firstPushRequest != null && this.firstPushRequest.getFrontEndSequenceNumber() < this.highMark) {
                jMSPushEntry = this.firstPushRequest.getFirstPushEntry();
                if (!jMSPushEntry.getClientResponsibleForAcknowledge()) {
                    if (this.connection.isLocal()) {
                        bl2 = true;
                        if (jMSPushEntry.getPipelineGeneration() == 0) {
                            bl2 = false;
                        } else if (jMSPushEntry.getPipelineGeneration() == 0x100000) {
                            bl2 = true;
                        } else if (jMSPushEntry.getPipelineGeneration() == this.pipelineGeneration) {
                            bl2 = false;
                        }
                    } else {
                        bl2 = false;
                        if (jMSPushEntry.getPipelineGeneration() == 0x100000 || jMSPushEntry.getPipelineGeneration() != this.pipelineGeneration) {
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        jMSPushEntry = null;
                        this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                        continue;
                    }
                }
                if (!jMSPushEntry.getConsumerId().equals(consumerInternal.getId())) {
                    jMSPushEntry = null;
                    this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                    continue;
                }
                messageImpl = this.firstPushRequest.getMessage();
                if (this.connection.isLocal()) {
                    messageImpl = messageImpl.copy();
                }
                this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                break;
            }
            if (jMSPushEntry == null) {
                if (l != 0x7FFFFFFFFFFFFFFEL) {
                    this.waitForNewMessage = true;
                    this.notifyNewMessage = l == Long.MAX_VALUE;
                } else {
                    this.notifyNewMessage = false;
                    this.waitForNewMessage = false;
                }
            }
            this.shortCutPrevPushRequest = null;
            this.shortCutPushRequest = null;
        }
        if (jMSPushEntry == null && l != 0x7FFFFFFFFFFFFFFEL) {
            JMSPushRequest jMSPushRequest;
            boolean bl3 = false;
            Object object2 = this.synchronousListenerObject;
            synchronized (object2) {
                if (this.shortCutPushRequest == null) {
                    try {
                        this.synchronousListenerObject.wait(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                object = this.shortCutPushRequest;
                jMSPushRequest = this.shortCutPrevPushRequest;
                this.shortCutPrevPushRequest = null;
                this.shortCutPushRequest = null;
                bl3 = this.needToRemoveIt;
                this.needToRemoveIt = false;
            }
            if (object != null) {
                if (bl3) {
                    object2 = this;
                    synchronized (object2) {
                        Object object3 = this.lockObject;
                        synchronized (object3) {
                            if (jMSPushRequest == null) {
                                this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                            } else {
                                jMSPushRequest.setNext(((Request)object).getNext());
                            }
                        }
                    }
                }
                messageImpl = ((JMSPushRequest)object).getMessage();
                if (this.connection.isLocal()) {
                    messageImpl = messageImpl.copy();
                }
                jMSPushEntry = ((JMSPushRequest)object).getFirstPushEntry();
            } else {
                object2 = this;
                synchronized (object2) {
                    if (this.isClosed()) {
                        throw new IllegalStateException(JMSClientExceptionLogger.logSessionIsClosedLoggable());
                    }
                }
            }
        }
        if (jMSPushEntry != null) {
            boolean bl4 = jMSPushEntry.getClientResponsibleForAcknowledge();
            messageImpl.setJMSDestinationImpl((DestinationImpl)consumerInternal.getDestination());
            messageImpl.setSequenceNumber(jMSPushEntry.getFrontEndSequenceNumber());
            messageImpl.setDeliveryCount(jMSPushEntry.getDeliveryCount());
            messageImpl.setClientResponsibleForAcknowledge(bl4);
            this.rememberLastSequenceNumber(jMSPushEntry.getFrontEndSequenceNumber(), messageImpl.getId());
            if (this.acknowledgeMode == 2) {
                messageImpl.setSession(this);
                this.addUnackedMessage(consumerInternal, messageImpl);
                consumerInternal.decrementWindowCurrent(bl4);
            } else if (this.acknowledgeMode == 1 || this.acknowledgeMode == 3) {
                this.addUnackedMessage(consumerInternal, messageImpl);
                if (this.acknowledgeMode != 3 || !this.checkDelayAckForDupsOK(messageImpl) || --this.dupsOKAckCount <= 0) {
                    this.requireAckForDupsOK = false;
                    this.acknowledge(messageImpl, 1, false);
                    this.dupsOKAckCount = this.dupsOKAckCountDown;
                } else {
                    this.requireAckForDupsOK = true;
                }
                consumerInternal.decrementWindowCurrent(bl4);
            } else {
                consumerInternal.decrementWindowCurrent(bl4);
            }
            return messageImpl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void execute() {
        boolean bl = false;
        AbstractSubject abstractSubject = null;
        ClassLoader classLoader = null;
        Context context = null;
        ClassLoader classLoader2 = null;
        if (KernelStatus.isServer()) {
            classLoader = classLoader2 = Thread.currentThread().getContextClassLoader();
        }
        try {
            do {
                Object object;
                JMSSession jMSSession;
                Object var28_24;
                JMSPushRequest jMSPushRequest;
                Object object2;
                JMSSession jMSSession2 = this;
                synchronized (jMSSession2) {
                    object2 = this.lockObject;
                    synchronized (object2) {
                        int n;
                        if (this.stopped || bl) {
                            this.running = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 20, 21, 73, 42] lbl16 : MonitorExitStatement: MONITOREXIT : var11_12
                            // MONITOREXIT @DISABLED, blocks:[0, 20, 73, 42] lbl17 : MonitorExitStatement: MONITOREXIT : var10_10
                            Object var34_27 = null;
                            if (!KernelStatus.isServer()) return;
                            Thread.currentThread().setContextClassLoader(classLoader2);
                            if (context != null) {
                                JMSServerUtilities.popLocalJNDIContext();
                            }
                            if (abstractSubject == null) return;
                            this.subjectManager.popSubject(KERNEL_ID);
                            return;
                        }
                        jMSPushRequest = this.removePushRequests();
                        if (!this.connectionOlderThan90 && jMSPushRequest != null && (n = jMSPushRequest.getFirstPushEntry().getPipelineGeneration()) != this.pipelineGeneration && n != 0x200000 && n != 0) {
                            jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext();
                            this.assignClientAckCarryForward(jMSPushRequest);
                            continue;
                        }
                        this.assignClientAckCarryForward(jMSPushRequest);
                        if (jMSPushRequest == null) {
                            this.running = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 20, 21, 70, 42] lbl37 : MonitorExitStatement: MONITOREXIT : var11_12
                            // MONITOREXIT @DISABLED, blocks:[0, 20, 70, 42] lbl38 : MonitorExitStatement: MONITOREXIT : var10_10
                            Object var34_28 = null;
                            if (!KernelStatus.isServer()) return;
                            Thread.currentThread().setContextClassLoader(classLoader2);
                            if (context != null) {
                                JMSServerUtilities.popLocalJNDIContext();
                            }
                            if (abstractSubject == null) return;
                            this.subjectManager.popSubject(KERNEL_ID);
                            return;
                        }
                    }
                    this.setState(4);
                }
                try {
                    try {
                        do {
                            Object object3;
                            object2 = jMSPushRequest.getMessage();
                            if (this.connection.isLocal()) {
                                object2 = ((MessageImpl)object2).copy();
                            }
                            ((MessageImpl)object2).setDDForwarded(false);
                            JMSPushEntry jMSPushEntry = jMSPushRequest.removePushEntry();
                            while (jMSPushEntry != null && jMSPushRequest != null && !bl) {
                                Object object4;
                                Object object5;
                                object3 = this.consumerFind(jMSPushEntry.getConsumerId());
                                boolean bl2 = jMSPushEntry.getClientResponsibleForAcknowledge();
                                if (object3 == null || object3.isClosed()) {
                                    object5 = this;
                                    synchronized (object5) {
                                        if (bl |= this.stopped || this.closeStarted) {
                                            object4 = this.lockObject;
                                            synchronized (object4) {
                                                jMSPushEntry.setNext(jMSPushRequest.getFirstPushEntry());
                                                jMSPushRequest.setFirstPushEntry(jMSPushEntry);
                                                for (JMSPushEntry jMSPushEntry2 = jMSPushEntry; jMSPushEntry2 != null; jMSPushEntry2 = jMSPushEntry2.getNext()) {
                                                    jMSPushRequest.setLastPushEntry(jMSPushEntry2);
                                                }
                                                break;
                                            }
                                        }
                                    }
                                } else if (bl2 || !(this.pipelineGeneration != 0 ? jMSPushEntry.getPipelineGeneration() == 0x100000 : jMSPushEntry.getFrontEndSequenceNumber() < object3.getExpectedSequenceNumber() && !bl2)) {
                                    jMSSession2 = object3.getMessageListener();
                                    if (jMSSession2 != null) {
                                        Object object6;
                                        JMSSession jMSSession3;
                                        Object var21_21;
                                        ((MessageImpl)object2).setJMSDestinationImpl((DestinationImpl)object3.getDestination());
                                        object5 = jMSPushEntry.getNext() == null ? object2 : ((MessageImpl)object2).copy();
                                        ((MessageImpl)object5).setSequenceNumber(jMSPushEntry.getFrontEndSequenceNumber());
                                        ((MessageImpl)object5).setDeliveryCount(jMSPushEntry.getDeliveryCount());
                                        ((MessageImpl)object5).setClientResponsibleForAcknowledge(bl2);
                                        this.addUnackedMessage((ConsumerInternal)object3, (MessageImpl)object5);
                                        object4 = object3.getMessageListenerContext();
                                        Context context2 = ((JMSContext)object4).getContext();
                                        ClassLoader classLoader3 = ((JMSContext)object4).getClassLoader();
                                        AbstractSubject abstractSubject2 = ((JMSContext)object4).getSubject();
                                        if (abstractSubject2 != abstractSubject) {
                                            if (abstractSubject != null) {
                                                this.subjectManager.popSubject(KERNEL_ID);
                                            }
                                            this.subjectManager.pushSubject(KERNEL_ID, abstractSubject2);
                                            abstractSubject = abstractSubject2;
                                        }
                                        if (KernelStatus.isServer()) {
                                            if (context2 != context) {
                                                if (context != null) {
                                                    JMSServerUtilities.popLocalJNDIContext();
                                                }
                                                JMSServerUtilities.pushLocalJNDIContext(context2);
                                                context = context2;
                                            }
                                            if (classLoader3 != classLoader) {
                                                Thread.currentThread().setContextClassLoader(classLoader3);
                                                classLoader = classLoader3;
                                            }
                                        }
                                        try {
                                            try {
                                                this.decrementWindow = true;
                                                this.recoverableClientAckMessages = jMSPushRequest;
                                                this.onMessage((ConsumerInternal)object3, (MessageListener)jMSSession2, (MessageImpl)object5);
                                            }
                                            catch (Throwable throwable) {
                                                JMSClientExceptionLogger.logStackTrace((Throwable)throwable);
                                                var21_21 = null;
                                                this.recoverableClientAckMessages = null;
                                                if (this.recovering) {
                                                    jMSSession3 = this;
                                                    synchronized (jMSSession3) {
                                                        object6 = this.lockObject;
                                                        synchronized (object6) {
                                                            if (this.recovering) {
                                                                this.recovering = false;
                                                                this.carryForwardOnReconnect = null;
                                                                jMSPushRequest = null;
                                                            }
                                                        }
                                                    }
                                                }
                                                if (this.decrementWindow) {
                                                    object3.decrementWindowCurrent(bl2);
                                                }
                                            }
                                            var21_21 = null;
                                            this.recoverableClientAckMessages = null;
                                            if (this.recovering) {
                                                jMSSession3 = this;
                                                synchronized (jMSSession3) {
                                                    object6 = this.lockObject;
                                                    synchronized (object6) {
                                                        if (this.recovering) {
                                                            this.recovering = false;
                                                            this.carryForwardOnReconnect = null;
                                                            jMSPushRequest = null;
                                                        }
                                                    }
                                                }
                                            }
                                            if (this.decrementWindow) {
                                                object3.decrementWindowCurrent(bl2);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            var21_21 = null;
                                            this.recoverableClientAckMessages = null;
                                            if (this.recovering) {
                                                jMSSession3 = this;
                                                synchronized (jMSSession3) {
                                                    object6 = this.lockObject;
                                                    synchronized (object6) {
                                                        if (this.recovering) {
                                                            this.recovering = false;
                                                            this.carryForwardOnReconnect = null;
                                                            jMSPushRequest = null;
                                                        }
                                                    }
                                                }
                                            }
                                            if (!this.decrementWindow) throw throwable;
                                            object3.decrementWindowCurrent(bl2);
                                            throw throwable;
                                        }
                                    }
                                }
                                jMSPushEntry = jMSPushRequest == null ? null : jMSPushRequest.removePushEntry();
                            }
                            if (bl) break;
                            if (jMSPushRequest != null) {
                                jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext();
                                object3 = this.lockObject;
                                synchronized (object3) {
                                    this.assignClientAckCarryForward(jMSPushRequest);
                                }
                            }
                            if (jMSPushRequest == null) break;
                        } while (!bl);
                    }
                    catch (Throwable throwable) {
                        var28_24 = null;
                        jMSSession = this;
                        synchronized (jMSSession) {
                            this.clearState(4);
                            object = this.lockObject;
                            synchronized (object) {
                                if (this.stopped || bl || !this.havePushRequests()) {
                                    this.running = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 51, 7, 39, 23, 25, 42] lbl211 : MonitorExitStatement: MONITOREXIT : var30_26
                                    // MONITOREXIT @DISABLED, blocks:[0, 51, 7, 39, 23, 42] lbl212 : MonitorExitStatement: MONITOREXIT : var29_25
                                    Object var34_30 = null;
                                    if (!KernelStatus.isServer()) return;
                                    Thread.currentThread().setContextClassLoader(classLoader2);
                                    if (context != null) {
                                        JMSServerUtilities.popLocalJNDIContext();
                                    }
                                    if (abstractSubject == null) return;
                                    this.subjectManager.popSubject(KERNEL_ID);
                                    return;
                                }
                                continue;
                            }
                        }
                    }
                    var28_24 = null;
                    jMSSession = this;
                    synchronized (jMSSession) {
                        this.clearState(4);
                        object = this.lockObject;
                        synchronized (object) {
                            if (this.stopped || bl || !this.havePushRequests()) {
                                this.running = false;
                                // MONITOREXIT @DISABLED, blocks:[0, 53, 7, 42, 26, 29] lbl187 : MonitorExitStatement: MONITOREXIT : var30_26
                                // MONITOREXIT @DISABLED, blocks:[0, 53, 7, 42, 26] lbl188 : MonitorExitStatement: MONITOREXIT : var29_25
                                Object var34_29 = null;
                                if (!KernelStatus.isServer()) return;
                                Thread.currentThread().setContextClassLoader(classLoader2);
                                if (context != null) {
                                    JMSServerUtilities.popLocalJNDIContext();
                                }
                                if (abstractSubject == null) return;
                                this.subjectManager.popSubject(KERNEL_ID);
                                return;
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    var28_24 = null;
                    jMSSession = this;
                    synchronized (jMSSession) {
                        this.clearState(4);
                        object = this.lockObject;
                        synchronized (object) {
                            if (!this.stopped && !bl) {
                                if (this.havePushRequests()) throw throwable;
                            }
                            this.running = false;
                        }
                    }
                    Object var34_31 = null;
                    if (!KernelStatus.isServer()) return;
                    Thread.currentThread().setContextClassLoader(classLoader2);
                    if (context != null) {
                        JMSServerUtilities.popLocalJNDIContext();
                    }
                    if (abstractSubject == null) return;
                    this.subjectManager.popSubject(KERNEL_ID);
                    return;
                }
            } while (!this.dispatchWorkManager.scheduleIfBusy((Runnable)this.useForRunnable));
            Object var34_32 = null;
            if (!KernelStatus.isServer()) return;
            Thread.currentThread().setContextClassLoader(classLoader2);
            if (context != null) {
                JMSServerUtilities.popLocalJNDIContext();
            }
            if (abstractSubject == null) return;
            this.subjectManager.popSubject(KERNEL_ID);
            return;
        }
        catch (Throwable throwable) {
            Object var34_33 = null;
            if (!KernelStatus.isServer()) throw throwable;
            Thread.currentThread().setContextClassLoader(classLoader2);
            if (context != null) {
                JMSServerUtilities.popLocalJNDIContext();
            }
            if (abstractSubject == null) throw throwable;
            this.subjectManager.popSubject(KERNEL_ID);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void executeMM() {
        do {
            var1_1 = null;
            var2_2 = null;
            var3_3 = null;
            var4_4 = 0;
            var5_5 = false;
            try {
                block20: while (true) {
                    var6_6 = this;
                    synchronized (var6_6) {
                        if (this.stopped) {
                            // MONITOREXIT @DISABLED, blocks:[0, 34, 19, 20, 11] lbl12 : MonitorExitStatement: MONITOREXIT : var6_6
                            v0 = null;
                            break;
                        }
                        var7_7 = this.lockObject;
                        synchronized (var7_7) {
                            var4_4 = this.pipelineGeneration;
                            var1_1 = this.removePushRequests();
                            if (var1_1 == null) {
                                // MONITOREXIT @DISABLED, blocks:[0, 33, 19, 20, 11, 12] lbl20 : MonitorExitStatement: MONITOREXIT : var7_7
                                // MONITOREXIT @DISABLED, blocks:[0, 33, 19, 20, 11] lbl21 : MonitorExitStatement: MONITOREXIT : var6_6
                                v0 = null;
                                break;
                            }
                            if (!this.connectionOlderThan90 && (var8_8 = var1_1.getFirstPushEntry().getPipelineGeneration()) != this.pipelineGeneration && var8_8 != 0x200000 && var8_8 != 0) {
                                continue;
                            }
                            ** if (var5_5) goto lbl28
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.setState(4);
                        }
lbl28:
                        // 2 sources

                        var5_5 = true;
                    }
                    while (true) {
                        if (var1_1 != null) ** break;
                        continue block20;
                        var6_6 = var1_1.getMessage();
                        var6_6.setDDForwarded(false);
                        var7_7 = var1_1.removePushEntry();
                        while (var7_7 != null) {
                            block36: {
                                if (!JMSSession.$assertionsDisabled && var7_7.getClientResponsibleForAcknowledge()) {
                                    throw new AssertionError();
                                }
                                var8_9 = this.consumerFind(var7_7.getConsumerId());
                                if (var8_9 != null && !var8_9.isClosed() && (this.pipelineGeneration != 0 || var7_7.getFrontEndSequenceNumber() >= var8_9.getExpectedSequenceNumber() && var7_7.getPipelineGeneration() != 0x100000)) {
                                    try {
                                        if (var8_9.getMessageListener() == null) {
                                        }
                                    }
                                    catch (JMSException var9_11) {}
                                    break block36;
                                    var6_6.setJMSDestinationImpl((DestinationImpl)var8_9.getDestination());
                                    var6_6.setClientResponsibleForAcknowledge(false);
                                    var6_6.setSequenceNumber(var7_7.getFrontEndSequenceNumber());
                                    this.addPendingWTMessage(var8_9, var7_7.getFrontEndSequenceNumber());
                                    this.addUnackedMessage(var8_9, (MessageImpl)var6_6);
                                    var9_10 = new MessageWrapper(((JMSConsumer)var8_9).getWLConsumerImpl().getProxyID(), this.connectionOlderThan90 != false ? this.proxyGenerationForOlderServer : var4_4, var7_7.getFrontEndSequenceNumber(), var7_7.getDeliveryCount(), (MessageImpl)var6_6);
                                    if (var3_3 == null) {
                                        var2_2 = var9_10;
                                    } else {
                                        var3_3.next(var9_10);
                                    }
                                    var3_3 = var9_10;
                                }
                            }
                            var7_7 = var1_1.removePushEntry();
                        }
                        var1_1 = (JMSPushRequest)var1_1.getNext();
                    }
                    break;
                }
            }
            catch (Throwable var11_12) {
                v0 = null;
            }
            var12_13 = v0;
            try {
                if (var3_3 == null) {
                    v1 = null;
                }
                var13_14 = this;
                synchronized (var13_14) {
                    this.rememberLastSequenceNumber(var3_3.getSequence(), var3_3.getMessageImpl().getId());
                }
                this.mmListener.onMessages(var2_2, this.messagesMaximum);
                v1 = null;
            }
            catch (Throwable var15_15) {
                v1 = null;
            }
            var16_16 = v1;
            var17_17 = this;
            synchronized (var17_17) {
                if (var5_5) {
                    this.clearState(4);
                }
                var18_18 = this.lockObject;
                synchronized (var18_18) {
                    if (this.stopped || !this.havePushRequests()) {
                        this.running = false;
                        return;
                    }
                }
            }
        } while (!this.dispatchWorkManager.scheduleIfBusy((Runnable)this.useForRunnable));
    }

    private void assignClientAckCarryForward(JMSPushRequest jMSPushRequest) {
        this.carryForwardOnReconnect = jMSPushRequest != null && jMSPushRequest.getMessage().getClientResponsibleForAcknowledge() ? jMSPushRequest : jMSPushRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessage(ConsumerInternal consumerInternal, MessageListener messageListener, MessageImpl messageImpl) {
        if (!this.transacted && this.acknowledgeMode == 2) {
            messageImpl.setSession(this);
        }
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            this.rememberLastSequenceNumber(messageImpl.getSequenceNumber(), messageImpl.getId());
        }
        boolean bl = messageImpl.getClientResponsibleForAcknowledge();
        try {
            try {
                JMSWorkContextHelper.infectThread(messageImpl);
                messageImpl.setSerializeDestination(true);
                messageImpl.setForward(true);
                messageListener.onMessage((Message)messageImpl);
            }
            catch (Throwable throwable) {
                this.handleOnMessageFailure(throwable);
                Object var7_11 = null;
                JMSWorkContextHelper.disinfectThread();
                return;
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            JMSWorkContextHelper.disinfectThread();
            throw throwable;
        }
        JMSWorkContextHelper.disinfectThread();
        if (this.acknowledgeMode != 3 && this.acknowledgeMode != 1 || this.getLastSequenceNumber() == 0L || this.transacted) {
            return;
        }
        try {
            if (this.acknowledgeMode != 3 || !this.checkDelayAckForDupsOK(messageImpl) || --this.dupsOKAckCount <= 0) {
                this.requireAckForDupsOK = false;
                this.refreshedWithPendingWork = false;
                if (this.isRemoteDomain) {
                    final MessageImpl messageImpl2 = messageImpl;
                    CrossDomainSecurityManager.doAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(this.getConnection().getFrontEndDispatcher(), null, false), new PrivilegedExceptionAction(){

                        public Object run() throws JMSException {
                            JMSSession.this.acknowledge(messageImpl2);
                            return null;
                        }
                    });
                } else {
                    this.acknowledge(messageImpl);
                }
                this.dupsOKAckCount = this.dupsOKAckCountDown;
            } else {
                this.requireAckForDupsOK = true;
            }
        }
        catch (JMSException jMSException) {
            this.onException(jMSException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOnMessageFailure(Throwable throwable) {
        JMSClientExceptionLogger.logStackTrace((Throwable)throwable);
        try {
            if (!(this.transacted || this.acknowledgeMode != 1 && this.acknowledgeMode != 3)) {
                try {
                    if (this.isRemoteDomain) {
                        CrossDomainSecurityManager.doAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(this.getConnection().getFrontEndDispatcher(), null, false), new PrivilegedExceptionAction(){

                            public Object run() throws JMSException {
                                JMSSession.this.recover();
                                return null;
                            }
                        });
                    } else {
                        this.recover();
                    }
                }
                catch (JMSException jMSException) {
                    JMSClientExceptionLogger.logStackTrace((Throwable)jMSException);
                }
            }
            Object var4_3 = null;
            RuntimeException runtimeException = new RuntimeException(JMSClientExceptionLogger.logClientThrowingExceptionLoggable().getMessage(), throwable);
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(runtimeException);
            this.onException(jMSException);
        }
        catch (Throwable throwable2) {
            Object var4_4 = null;
            RuntimeException runtimeException = new RuntimeException(JMSClientExceptionLogger.logClientThrowingExceptionLoggable().getMessage(), throwable);
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(runtimeException);
            this.onException(jMSException);
            throw throwable2;
        }
    }

    final void decrementConsumerListenerCount() {
        --this.consumerListenerCount;
    }

    final void incrementConsumerListenerCount() {
        ++this.consumerListenerCount;
    }

    final void setState(int n) {
        this.state |= n;
        if ((n & 4) != 0) {
            this.listenerThread = Thread.currentThread();
        }
    }

    private boolean inState(int n) {
        return (this.state & n) != 0;
    }

    private boolean inListener() {
        return Thread.currentThread().equals(this.listenerThread);
    }

    final synchronized void clearState(int n) {
        this.state &= ~n;
        if ((n & 4) != 0) {
            this.listenerThread = null;
        }
        if (this.waiterCount > 0) {
            this.notifyAll();
        }
    }

    private void waitForState(int n) throws JMSException {
        while ((this.state & ~n) != 0) {
            Object var4_2;
            ++this.waiterCount;
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new weblogic.jms.common.JMSException(interruptedException);
                }
                var4_2 = null;
                --this.waiterCount;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waiterCount;
                throw throwable;
            }
        }
    }

    public boolean isClosed() {
        return this.sessionId == null;
    }

    public boolean isReconnectControllerClosed() {
        return this.wlSessionImpl == null || this.wlSessionImpl.isClosed();
    }

    final synchronized void checkClosed() throws JMSException {
        if (this.isClosed()) {
            JMSSession jMSSession;
            JMSSession jMSSession2 = jMSSession = this.wlSessionImpl == null ? this : this.wlSessionImpl.getConnectionStateLock();
            synchronized (jMSSession2) {
                if (this.isReconnectControllerClosed()) {
                    throw new AlreadyClosedException(JMSClientExceptionLogger.logSessionIsClosedLoggable());
                }
                throw new LostServerException(JMSClientExceptionLogger.logLostServerConnectionLoggable());
            }
        }
    }

    public final void publicCheckClosed() throws JMSException {
        this.checkClosed();
    }

    public final synchronized void checkSAFClosed() throws JMSException {
        if (!this.isClosed()) {
            return;
        }
        throw new IllegalStateException(JMSClientExceptionLogger.logSessionIsClosedLoggable());
    }

    private void leaveGroup(DestinationImpl destinationImpl, ConsumerInternal consumerInternal) throws JMSException {
        try {
            this.mSock.leaveGroup(destinationImpl, consumerInternal);
        }
        catch (IOException iOException) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logCannotLeaveMulticastGroupLoggable((String)destinationImpl.getMulticastAddress(), (IOException)iOException));
        }
    }

    private synchronized void addUnackedMessage(ConsumerInternal consumerInternal, MessageImpl messageImpl) {
        if (this.acknowledgeMode == 4 || this.acknowledgeMode == 128) {
            return;
        }
        if (!messageImpl.getClientResponsibleForAcknowledge()) {
            UnackedMessage unackedMessage = new UnackedMessage(consumerInternal, messageImpl.getSequenceNumber());
            unackedMessage.next = this.firstUnackedMessage;
            this.firstUnackedMessage = unackedMessage;
            this.setPendingWorkOnMsgRecv();
        } else {
            JMSMessageReference jMSMessageReference;
            if (this.clientAckList == null) {
                this.clientAckList = new MessageList();
            }
            long l = messageImpl.getSequenceNumber();
            if (this.mRefCache != null) {
                jMSMessageReference = this.mRefCache;
                this.mRefCache = null;
                jMSMessageReference.reset(messageImpl, consumerInternal);
            } else {
                jMSMessageReference = new JMSMessageReference(messageImpl, consumerInternal);
            }
            messageImpl.setMessageReference(jMSMessageReference);
            jMSMessageReference.setSequenceNumber(l);
            this.clientAckList.addLast(jMSMessageReference);
        }
    }

    private synchronized void addPendingWTMessage(ConsumerInternal consumerInternal, long l) {
        PendingWTMessage pendingWTMessage = new PendingWTMessage(consumerInternal, l);
        pendingWTMessage.next = this.firstPendingWTMessage;
        this.firstPendingWTMessage = pendingWTMessage;
    }

    public synchronized void removePendingWTMessage(long l, boolean bl) throws JMSException {
        PendingWTMessage pendingWTMessage = this.firstPendingWTMessage;
        PendingWTMessage pendingWTMessage2 = null;
        while (pendingWTMessage != null && l != pendingWTMessage.sequenceNumber) {
            pendingWTMessage2 = pendingWTMessage;
            pendingWTMessage = pendingWTMessage.next;
        }
        if (pendingWTMessage != null) {
            if (pendingWTMessage == this.firstPendingWTMessage) {
                this.firstPendingWTMessage = null;
            } else {
                pendingWTMessage2.next = null;
            }
            while (pendingWTMessage != null) {
                ConsumerInternal consumerInternal = pendingWTMessage.consumer;
                if (bl) {
                    consumerInternal.decrementWindowCurrent(false);
                }
                pendingWTMessage = pendingWTMessage.next;
            }
        }
    }

    private synchronized void removeUnackedMessage(long l, boolean bl, boolean bl2) {
        if (!bl) {
            UnackedMessage unackedMessage = this.firstUnackedMessage;
            UnackedMessage unackedMessage2 = null;
            while (unackedMessage != null && l != unackedMessage.sequenceNumber) {
                unackedMessage2 = unackedMessage;
                unackedMessage = unackedMessage.next;
            }
            if (unackedMessage != null) {
                if (unackedMessage == this.firstUnackedMessage) {
                    this.firstUnackedMessage = null;
                } else {
                    unackedMessage2.next = null;
                }
                while (unackedMessage != null) {
                    ConsumerInternal consumerInternal = unackedMessage.consumer;
                    if (!bl2 && consumerInternal.getWindowCurrent() < consumerInternal.getWindowMaximum()) {
                        consumerInternal.setWindowCurrent(consumerInternal.getWindowCurrent() + 1);
                    }
                    unackedMessage = unackedMessage.next;
                }
            }
            return;
        }
        if (this.clientAckList == null) {
            return;
        }
        JMSMessageReference jMSMessageReference = (JMSMessageReference)this.clientAckList.removeBeforeSequenceNumber(l);
        if (this.mRefCache == null && jMSMessageReference != null) {
            jMSMessageReference.prepareForCache();
            this.mRefCache = jMSMessageReference;
        }
    }

    public final int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 15620: {
                this.pushMessage(request, false);
                return Integer.MAX_VALUE;
            }
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoSuchMethod2Loggable((int)request.getMethodId(), (String)this.getClass().getName()));
    }

    public static String unitOfOrderFromID(JMSID jMSID) {
        return "weblogicUOO.T" + Long.toString(jMSID.getTimestamp(), 36) + ".S" + Long.toString(jMSID.getSeed(), 36) + ".C" + jMSID.getCounter();
    }

    public void setUnitOfOrder(String string) {
        if (".System".equals(string)) {
            string = JMSSession.unitOfOrderFromID(this.getJMSID());
        }
        this.unitOfOrder = string;
    }

    public void markAsSystemMessageListener(boolean bl) {
        this.synchronousListener = bl;
        this.prefetchStarted = false;
    }

    void setWLSessionImpl(WLSessionImpl wLSessionImpl) {
        this.wlSessionImpl = wLSessionImpl;
        this.setMapLocks(this.wlSessionImpl.getConnectionStateLock());
    }

    void setMapLocks(Object object) {
        this.consumers.setLock(object);
        this.producers.setLock(object);
        this.browsers.setLock(object);
    }

    void setPendingWork(boolean bl) {
        this.pendingWork = bl;
    }

    boolean checkRefreshedWithPendingWork() {
        this.setPendingWork(false);
        if (this.refreshedWithPendingWork) {
            this.refreshedWithPendingWork = false;
            return true;
        }
        return false;
    }

    boolean prefetchStarted() {
        return this.prefetchStarted;
    }

    void startPrefetch() {
        this.prefetchStarted = true;
    }

    boolean prefetchDisabled() {
        return this.prefetchDisabled;
    }

    void disablePrefetch() {
        this.prefetchDisabled = true;
    }

    private boolean checkDelayAckForDupsOK(MessageImpl messageImpl) {
        if (this.allowDelayAckForDupsOK && messageImpl.getClientResponsibleForAcknowledge()) {
            this.allowDelayAckForDupsOK = false;
        }
        return this.allowDelayAckForDupsOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferClientRspForAckMessages(JMSSession jMSSession) {
        boolean bl;
        boolean bl2;
        Object object;
        if (jMSSession.session_clientResponsibleForAck && this.staleJMSSession != null && this.staleJMSSession.session_clientResponsibleForAck) {
            JMSSession jMSSession2 = this.staleJMSSession;
            synchronized (jMSSession2) {
                Object object2 = this.staleJMSSession.lockObject;
                synchronized (object2) {
                    this.carryForwardOnReconnect = this.staleJMSSession.carryForwardOnReconnect;
                    if (this.carryForwardOnReconnect != null) {
                        if (this.firstPushRequest == null) {
                            this.firstPushRequest = this.carryForwardOnReconnect;
                            this.setFirstPushRequest(this.firstPushRequest);
                            this.lastPushRequest = this.lastPushInList(this.firstPushRequest);
                        } else {
                            object = this.lastPushInList(this.carryForwardOnReconnect);
                            while (((Request)object).getNext() != null && ((JMSPushRequest)((Request)object).getNext()).getFrontEndSequenceNumber() < this.firstPushRequest.getFrontEndSequenceNumber()) {
                                object = (JMSPushRequest)((Request)object).getNext();
                            }
                            if (((JMSPushRequest)object).getFrontEndSequenceNumber() < this.firstPushRequest.getFrontEndSequenceNumber()) {
                                ((Request)object).setNext(this.firstPushRequest);
                                this.setFirstPushRequest(this.carryForwardOnReconnect);
                            }
                        }
                    }
                }
            }
        }
        if (!this.consumersReconnect || !this.session_clientResponsibleForAck) {
            return;
        }
        jMSSession.session_clientResponsibleForAck = true;
        long l = 0L;
        if (this.clientAckList != null && (object = (JMSMessageReference)this.clientAckList.getLast()) != null) {
            l = ((MessageReference)object).getSequenceNumber();
        }
        boolean bl3 = bl2 = this.firstPushRequest != null && this.firstPushRequest.getMessage().getClientResponsibleForAcknowledge();
        if (bl2) {
            l = this.getMaxSequenceNumber(this.firstPushRequest, l);
        }
        boolean bl4 = bl = this.firstReceivePushRequest != null && this.firstReceivePushRequest.getMessage().getClientResponsibleForAcknowledge();
        if (bl) {
            l = this.getMaxSequenceNumber(this.firstReceivePushRequest, l);
        }
        if (this.clientAckList != null) {
            for (JMSMessageReference jMSMessageReference = (JMSMessageReference)this.clientAckList.getFirst(); jMSMessageReference != null; jMSMessageReference = (JMSMessageReference)jMSMessageReference.getNext()) {
                JMSConsumer jMSConsumer;
                MessageImpl messageImpl = jMSMessageReference.getMessage();
                jMSMessageReference.setSequenceNumber(jMSMessageReference.getSequenceNumber() - l);
                messageImpl.setSequenceNumber(messageImpl.getSequenceNumber() - l);
                ConsumerInternal consumerInternal = jMSMessageReference.getConsumer();
                if (consumerInternal == null || (jMSConsumer = (JMSConsumer)jMSSession.replacementConsumerMap.get(consumerInternal.getJMSID())) == null) continue;
                jMSMessageReference.reset(messageImpl, jMSConsumer);
            }
        }
        jMSSession.clientAckList = this.clientAckList;
        if (bl2) {
            jMSSession.setFirstPushRequest(this.refreshPushRequests(jMSSession, this.firstPushRequest, l));
            jMSSession.lastPushRequest = this.lastPushInList(jMSSession.firstPushRequest);
        }
        if (bl) {
            jMSSession.firstReceivePushRequest = this.refreshPushRequests(jMSSession, this.firstReceivePushRequest, l);
            jMSSession.lastReceivePushRequest = this.lastPushInList(jMSSession.firstReceivePushRequest);
        }
    }

    private JMSPushRequest lastPushInList(JMSPushRequest jMSPushRequest) {
        JMSPushRequest jMSPushRequest2 = jMSPushRequest;
        for (JMSPushRequest jMSPushRequest3 = jMSPushRequest; jMSPushRequest3 != null; jMSPushRequest3 = (JMSPushRequest)jMSPushRequest3.getNext()) {
            jMSPushRequest2 = jMSPushRequest3;
        }
        return jMSPushRequest2;
    }

    void mapReplacementConsumer(JMSConsumer jMSConsumer, JMSConsumer jMSConsumer2) {
        this.replacementConsumerMap.put(jMSConsumer.getJMSID(), jMSConsumer2);
    }

    private JMSPushRequest refreshPushRequests(JMSSession jMSSession, JMSPushRequest jMSPushRequest, long l) {
        while (jMSPushRequest != null && jMSPushRequest.getFirstPushEntry() == null) {
            jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext();
        }
        JMSPushRequest jMSPushRequest2 = null;
        Request request = null;
        while (jMSPushRequest != null) {
            MessageImpl messageImpl = jMSPushRequest.getMessage();
            JMSPushRequest jMSPushRequest3 = new JMSPushRequest(0, null, messageImpl);
            if (jMSPushRequest2 == null) {
                jMSPushRequest2 = jMSPushRequest3;
            } else {
                request.setNext(jMSPushRequest3);
            }
            messageImpl.setSequenceNumber(messageImpl.getSequenceNumber() - l);
            request = jMSPushRequest3;
            for (JMSPushEntry jMSPushEntry = jMSPushRequest.getFirstPushEntry(); jMSPushEntry != null; jMSPushEntry = jMSPushEntry.getNext()) {
                JMSConsumer jMSConsumer = (JMSConsumer)jMSSession.replacementConsumerMap.get(jMSPushEntry.getConsumerId());
                if (jMSConsumer == null || !jMSPushEntry.getClientResponsibleForAcknowledge()) continue;
                long l2 = jMSPushEntry.getFrontEndSequenceNumber() - l;
                JMSPushEntry jMSPushEntry2 = new JMSPushEntry(null, jMSConsumer.getJMSID(), 0L, l2, messageImpl.getDeliveryCount(), 0x200000);
                jMSPushEntry2.setClientResponsibleForAcknowledge(true);
                jMSPushRequest3.addPushEntry(jMSPushEntry2);
            }
            jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext();
        }
        return jMSPushRequest2;
    }

    private long getMaxSequenceNumber(JMSPushRequest jMSPushRequest, long l) {
        long l2 = l;
        for (JMSPushRequest jMSPushRequest2 = jMSPushRequest; jMSPushRequest2 != null; jMSPushRequest2 = (JMSPushRequest)jMSPushRequest2.getNext()) {
            for (JMSPushEntry jMSPushEntry = jMSPushRequest2.getFirstPushEntry(); jMSPushEntry != null; jMSPushEntry = jMSPushEntry.getNext()) {
                if (l2 >= jMSPushEntry.getFrontEndSequenceNumber()) continue;
                l2 = jMSPushEntry.getFrontEndSequenceNumber();
            }
        }
        return l2;
    }

    public void acknowledgeAsync(WLAcknowledgeInfo wLAcknowledgeInfo, CompletionListener completionListener) {
        try {
            this.acknowledge(wLAcknowledgeInfo);
            completionListener.onCompletion(null);
        }
        catch (Throwable throwable) {
            completionListener.onException(throwable);
        }
    }

    public void sendAsync(MessageProducer messageProducer, Message message, CompletionListener completionListener) {
        try {
            messageProducer.send(message);
        }
        catch (Throwable throwable) {
            completionListener.onException(throwable);
        }
    }

    public void sendAsync(WLMessageProducer wLMessageProducer, Message message, int n, int n2, long l, CompletionListener completionListener) {
        try {
            wLMessageProducer.send(message, n, n2, l);
        }
        catch (Throwable throwable) {
            completionListener.onException(throwable);
        }
    }

    public void sendAsync(WLMessageProducer wLMessageProducer, javax.jms.Destination destination, Message message, CompletionListener completionListener) {
        try {
            wLMessageProducer.send(destination, message);
        }
        catch (Throwable throwable) {
            completionListener.onException(throwable);
        }
    }

    public void sendAsync(WLMessageProducer wLMessageProducer, javax.jms.Destination destination, Message message, int n, int n2, long l, CompletionListener completionListener) {
        try {
            wLMessageProducer.send(destination, message, n, n2, l);
        }
        catch (Throwable throwable) {
            completionListener.onException(throwable);
        }
    }

    public void receiveAsync(MessageConsumer messageConsumer, CompletionListener completionListener) {
        ((WLConsumerImpl)messageConsumer).receiveAsync(completionListener);
    }

    public void receiveAsync(MessageConsumer messageConsumer, long l, CompletionListener completionListener) {
        ((WLConsumerImpl)messageConsumer).receiveAsync(l, completionListener);
    }

    public void receiveNoWaitAsync(MessageConsumer messageConsumer, CompletionListener completionListener) {
        ((WLConsumerImpl)messageConsumer).receiveNoWaitAsync(completionListener);
    }

    static {
        try {
            IGNORE_JmsAsyncQueue = System.getProperty("weblogic.jms.IGNORE_JmsAsyncQueue", "false").equalsIgnoreCase("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ASYNC_RESERVED_MSG = new TextMessageImpl("internal ASYNC_RESERVED_MSG");
    }

    private class JMSConsumerReceiveResponsePrivate
    extends JMSConsumerReceiveResponse {
        static final long serialVersionUID = -7380653133580038280L;
        private int deliveryCount;

        JMSConsumerReceiveResponsePrivate(MessageImpl messageImpl, long l, boolean bl, int n) {
            super(messageImpl, l, bl);
            this.deliveryCount = n;
        }

        int getDeliveryCount() {
            return this.deliveryCount;
        }
    }

    private class UseForRunnable
    implements Runnable {
        private JMSSession session;

        protected UseForRunnable(JMSSession jMSSession2) {
            this.session = jMSSession2;
        }

        public void run() {
            this.session.executeMessage();
        }
    }

    static final class PendingWTMessage {
        final ConsumerInternal consumer;
        final long sequenceNumber;
        PendingWTMessage next;

        PendingWTMessage(ConsumerInternal consumerInternal, long l) {
            this.consumer = consumerInternal;
            this.sequenceNumber = l;
        }
    }

    static final class UnackedMessage {
        final ConsumerInternal consumer;
        final long sequenceNumber;
        UnackedMessage next;

        UnackedMessage(ConsumerInternal consumerInternal, long l) {
            this.consumer = consumerInternal;
            this.sequenceNumber = l;
        }
    }
}

