/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.SessionInternal;
import weblogic.jms.client.XAConnectionInternal;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.PeerVersionable;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.Invocable;

public final class JMSXAConnection
extends JMSConnection
implements XAConnectionInternal,
JMSPeerGoneListener,
Externalizable,
Invocable,
Reconnectable,
Cloneable {
    static final long serialVersionUID = -4665036665162468456L;
    private static final byte EXTVERSION = 1;

    public JMSXAConnection(JMSID jMSID, String string, int n, int n2, int n3, int n4, long l, long l2, long l3, long l4, long l5, boolean bl, boolean bl2, int n5, int n6, int n7, boolean bl3, DispatcherWrapper dispatcherWrapper, boolean bl4, int n8, int n9, int n10, int n11, String string2, PeerVersionable peerVersionable, String string3, String string4, PeerInfo peerInfo, int n12, int n13, int n14, int n15, int n16, long l6, long l7) {
        super(jMSID, string, n, n2, n3, n4, l, l2, l3, l4, l5, true, bl2, n5, n6, n7, bl3, dispatcherWrapper, bl4, n8, n9, n10, n11, false, string2, peerVersionable, string3, string4, peerInfo, n12, n13, n14, n15, n16, l6, l7);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        SessionInternal sessionInternal = this.createSessionInternal(false, 2, true, 2);
        return (XAQueueSession)sessionInternal;
    }

    public XATopicSession createXATopicSession() throws JMSException {
        SessionInternal sessionInternal = this.createSessionInternal(false, 2, true, 1);
        return (XATopicSession)sessionInternal;
    }

    public XASession createXASession() throws JMSException {
        return (XASession)this.createSessionInternal(false, 2, true, 0);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public JMSXAConnection() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeByte(1);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
    }
}

