/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.IOException;
import java.net.SocketException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import javax.jms.JMSException;
import javax.naming.NameNotFoundException;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConsumer;
import weblogic.jms.client.JMSProducer;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.common.DestroyConnectionException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.LostServerException;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.utils.NestedThrowable;

abstract class ReconnectController {
    private static final int STATE_NO_RETRY = -2304;
    private static final int STATE_USER_CLOSED = -1280;
    private static final int STATE_CONNECTED = 0;
    private static final int STATE_HAVE_RECON_INFO_PHYSICAL_CLOSE_DONE = 512;
    private static final int STATE_HAVE_RECON_INFO_PEERGONEE_IN_PROGRESS = 1028;
    private static final int STATE_HAVE_RECON_INFO_CLOSE_IN_PROGRESS = 1040;
    private static final int STATE_RECON_SCHEDULED = 1280;
    private static final int STATE_RECON_IN_PROGRESS = 1536;
    private int state;
    private Throwable lastProblem;
    ReconnectController firstChild;
    ReconnectController lastChild;
    ReconnectController prevChild;
    ReconnectController nextChild;
    ReconnectController parent;
    private volatile Reconnectable physical;
    private static int RETRIES = 12;
    private static long LARGE_TIME_FOR_EXCEPTION_MSG = 14400000L;
    static boolean TODOREMOVEDebug = false;

    protected ReconnectController(ReconnectController reconnectController, Reconnectable reconnectable) {
        int n;
        this.physical = reconnectable;
        assert (this.getState() == 0);
        if (reconnectController != null && (n = reconnectController.getState()) != -1280) {
            this.parent = reconnectController;
            this.setState(n);
            reconnectController.addChild(this);
        }
    }

    abstract Object getConnectionStateLock();

    protected abstract ReconnectController getParent();

    protected abstract JMSConnection getPhysicalJMSConnection();

    protected abstract WLConnectionImpl getWLConnectionImpl();

    int getState() {
        return this.state;
    }

    private void setState(int n) {
        this.state = n;
    }

    Throwable getLastProblem() {
        return this.lastProblem;
    }

    protected void setLastProblem(Throwable throwable) {
        this.lastProblem = throwable;
        if (TODOREMOVEDebug) {
            if (throwable == null) {
                System.err.println("Debug ReconnectController lastProblem cleared");
            } else {
                JMSConnection.displayExceptionCauses("Debug ReconnectController lastProblem set", throwable);
            }
        }
    }

    protected Reconnectable getPhysical() {
        return this.physical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            return this.getState() == -1280;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChild(ReconnectController reconnectController) {
        assert (reconnectController != this);
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            if (this.getState() == -1280) {
                return;
            }
            if (this.lastChild == null) {
                this.firstChild = this.lastChild = reconnectController;
            } else {
                reconnectController.prevChild = this.lastChild;
                this.lastChild.nextChild = reconnectController;
                this.lastChild = reconnectController;
            }
        }
    }

    protected void removeChild(ReconnectController reconnectController) {
        if (reconnectController == this) {
            return;
        }
        if (reconnectController.prevChild == null) {
            this.firstChild = reconnectController.nextChild;
        } else {
            reconnectController.prevChild.nextChild = reconnectController.nextChild;
        }
        if (reconnectController.nextChild == null) {
            this.lastChild = reconnectController.prevChild;
        } else {
            reconnectController.nextChild.prevChild = reconnectController.prevChild;
        }
        reconnectController.prevChild = null;
        reconnectController.nextChild = null;
    }

    protected void setRecursiveStateUserClosed() {
        this.setState(-1280);
        ReconnectController reconnectController;
        while ((reconnectController = this.firstChild) != null) {
            this.removeChild(reconnectController);
            reconnectController.setRecursiveStateUserClosed();
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRecursiveState(int n) {
        assert (n != -1280);
        if (TODOREMOVEDebug) {
            if (n == -2304) {
                new Exception("DEBUG ReconnectController STATE_NO_RETRY from " + this.getStringState(this.getState())).printStackTrace();
            } else {
                System.err.println("DEBUG ReconnectController stateBecomes " + this.getStringState(n) + " " + this.getPhysical());
            }
        }
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            this.setStateChildrenInternal(n);
        }
    }

    private void setStateChildrenInternal(int n) {
        if (this.getState() == -1280 || this.getState() == -2304) {
            return;
        }
        this.setState(n);
        ReconnectController reconnectController = this.firstChild;
        while (reconnectController != null) {
            reconnectController.setStateChildrenInternal(n);
            reconnectController = reconnectController.nextChild;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRecursiveStateNotify(int n) {
        Object object;
        Object object2 = object = this.getConnectionStateLock();
        synchronized (object2) {
            this.setRecursiveState(n);
            object.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Reconnectable getPhysicalWaitForState(long l) {
        Object object;
        Object object2 = object = this.getConnectionStateLock();
        synchronized (object2) {
            return this.waitForStateInternal(l);
        }
    }

    protected Reconnectable getPhysicalWaitForState() {
        return this.getPhysicalWaitForState(System.currentTimeMillis());
    }

    boolean stateNeedsWait() {
        return 1024 <= this.getState();
    }

    protected Reconnectable waitForStateInternal(long l) {
        long l2;
        long l3;
        while (this.stateNeedsWait() && (l3 = this.getWLConnectionImpl().getReconnectBlockingInternal()) != 0L && (l3 != -1L || this.getWLConnectionImpl().getLastReconnectTimer() != 0L) && (l2 = this.remainingMillis(l)) >= 1L) {
            if (TODOREMOVEDebug) {
                System.err.println("ReconnectController Debug waiting to change " + this.getStringState(this.getState()) + " " + l2 + " " + this.getPhysical());
            } else if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("ReconnectController waiting to change " + this.getStringState(this.getState()) + " " + l2);
            }
            try {
                this.getConnectionStateLock().wait(l2);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        return this.getPhysical();
    }

    private long remainingMillis(long l) {
        long l2 = this.getWLConnectionImpl().getReconnectBlockingInternal();
        if (l2 == -1L) {
            return LARGE_TIME_FOR_EXCEPTION_MSG;
        }
        long l3 = System.currentTimeMillis() - l;
        return l2 - l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Reconnectable waitForStateOrTime(long l) {
        Object object;
        Object object2 = object = this.getConnectionStateLock();
        synchronized (object2) {
            long l2 = l - System.currentTimeMillis();
            while (l2 > 0L && this.stateNeedsWait()) {
                try {
                    object.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            return this.getPhysical();
        }
    }

    protected AssertionError wrongState(int n) {
        AssertionError assertionError = new AssertionError((Object)this.wrongStateString(n));
        if (TODOREMOVEDebug) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        return assertionError;
    }

    String wrongStateString(int n) {
        return "ReconnectController unexpected state " + n + " is " + this.getStringState(n);
    }

    protected String getStringState(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "STATE_CONNECTED";
                break;
            }
            case 512: {
                string = "STATE_HAVE_RECON_INFO_PHYSICAL_CLOSE_DONE";
                break;
            }
            case 1040: {
                string = "STATE_HAVE_RECON_INFO_CLOSE_IN_PROGRESS";
                break;
            }
            case 1028: {
                string = "STATE_HAVE_RECON_INFO_PEERGONEE_IN_PROGRESS";
                break;
            }
            case -2304: {
                string = "STATE_NO_RETRY";
                break;
            }
            case 1536: {
                string = "STATE_RECON_IN_PROGRESS";
                break;
            }
            case 1280: {
                string = "STATE_RECON_SCHEDULED";
                break;
            }
            case -1280: {
                string = "STATE_USER_CLOSED";
                break;
            }
            default: {
                string = "Illegal State " + n;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPhysicalReconnectable(Reconnectable reconnectable) {
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            int n = this.getState();
            switch (n) {
                case 0: 
                case 512: 
                case 1536: {
                    this.physical = reconnectable;
                    break;
                }
                case -2304: 
                case -1280: 
                case 1028: 
                case 1040: 
                case 1280: {
                    break;
                }
                default: {
                    throw this.wrongState(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws JMSException {
        Object object;
        Object object2;
        try {
            if (this.getState() == 0 && this.getPhysicalJMSConnection().isConnected()) {
                this.getPhysical().close();
            }
            Object var2_1 = null;
            object = object2 = this.getConnectionStateLock();
        }
        catch (Throwable throwable) {
            Object object3;
            Object var2_2 = null;
            Object object4 = object3 = this.getConnectionStateLock();
            synchronized (object4) {
                try {
                    this.getPhysical().forgetReconnectState();
                    Object var6_9 = null;
                    if (this.getState() != -1280) {
                        this.setRecursiveStateUserClosed();
                        if (this.parent != null) {
                            this.parent.removeChild(this);
                        }
                        object3.notifyAll();
                    }
                }
                catch (Throwable throwable2) {
                    Object var6_10 = null;
                    if (this.getState() != -1280) {
                        this.setRecursiveStateUserClosed();
                        if (this.parent != null) {
                            this.parent.removeChild(this);
                        }
                        object3.notifyAll();
                    }
                    throw throwable2;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            try {
                this.getPhysical().forgetReconnectState();
                Object var6_7 = null;
                if (this.getState() != -1280) {
                    this.setRecursiveStateUserClosed();
                    if (this.parent != null) {
                        this.parent.removeChild(this);
                    }
                    object2.notifyAll();
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (this.getState() != -1280) {
                    this.setRecursiveStateUserClosed();
                    if (this.parent != null) {
                        this.parent.removeChild(this);
                    }
                    object2.notifyAll();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reconnectable analyzeExceptionAndReconnect(long l, Reconnectable reconnectable, boolean bl, weblogic.jms.common.JMSException jMSException) throws JMSException {
        int n = -256;
        int n2 = RETRIES;
        while (true) {
            block17: {
                JMSConnection jMSConnection;
                try {
                    Object object = this.getConnectionStateLock();
                    synchronized (object) {
                        n = this.getState();
                        if (n2 == 0) {
                            return this.changedPhysicalOrThrow(reconnectable, jMSException);
                        }
                        if (n2 == RETRIES) {
                            this.throwNonRecoverableException(jMSException, bl);
                            this.getWLConnectionImpl().updateLastReconnectTimer();
                        }
                        switch (n) {
                            case -2304: 
                            case -1280: 
                            case 0: {
                                return this.changedPhysicalOrThrow(reconnectable, jMSException);
                            }
                            case 512: {
                                if (this.getWLConnectionImpl().getReconnectPolicyInternal() == 0) {
                                    this.getWLConnectionImpl().setRecursiveStateNotify(-2304);
                                    return this.changedPhysicalOrThrow(reconnectable, jMSException);
                                }
                                jMSConnection = this.getPhysicalJMSConnection();
                                n = this.setupReconnectSchedule(jMSConnection, 1280);
                                break;
                            }
                            case 1028: 
                            case 1040: 
                            case 1280: 
                            case 1536: {
                                this.waitForStateInternal(l);
                                if (!this.stateNeedsWait()) {
                                    break block17;
                                }
                                return this.changedPhysicalOrThrow(reconnectable, jMSException);
                            }
                            default: {
                                throw this.wrongState(n);
                            }
                        }
                    }
                }
                catch (LostServerException lostServerException) {
                    if (jMSException == null || lostServerException.getCause() != null) {
                        throw lostServerException;
                    }
                    throw this.attachReasonToException(lostServerException, l, n);
                }
                assert (n == 1280);
                jMSConnection.getReconnectWorkManager().schedule((Runnable)jMSConnection);
            }
            --n2;
        }
    }

    protected int setupReconnectSchedule(JMSConnection jMSConnection, int n) {
        jMSConnection.setReplacementConnection(null);
        this.getWLConnectionImpl().setRecursiveStateNotify(n);
        return n;
    }

    private Reconnectable changedPhysicalOrThrow(Reconnectable reconnectable, weblogic.jms.common.JMSException jMSException) throws weblogic.jms.common.JMSException {
        Reconnectable reconnectable2 = this.getPhysical();
        if (reconnectable != null && reconnectable.getFEPeerInfo() == reconnectable2.getFEPeerInfo()) {
            throw jMSException;
        }
        return reconnectable2;
    }

    private LostServerException attachReasonToException(LostServerException lostServerException, long l, int n) {
        LostServerException lostServerException2;
        long l2;
        String string = n == 0 ? null : (this.getWLConnectionImpl().getReconnectBlockingInternal() > -1L && (l2 = this.remainingMillis(l)) <= 0L ? "timed out in state " + this.getStringState(n) + " after " + (this.getWLConnectionImpl().getReconnectBlockingInternal() - l2) + " milliseconds" : "server connection in state " + this.getStringState(n));
        Throwable throwable = this.getWLConnectionImpl().getLastProblem();
        if (throwable == null) {
            if (string == null) {
                if (TODOREMOVEDebug) {
                    System.err.println("DEBUG ReconnectController in " + this.getStringState(this.getState()));
                }
                return lostServerException;
            }
            lostServerException2 = new LostServerException(string);
        } else {
            lostServerException2 = new LostServerException(string, throwable);
        }
        lostServerException2.setReplayLastException(true);
        lostServerException.initCause((Throwable)((Object)lostServerException2));
        return lostServerException;
    }

    protected JMSConnection computeJMSConnection(long l, Reconnectable reconnectable, weblogic.jms.common.JMSException jMSException) throws JMSException {
        return (JMSConnection)this.analyzeExceptionAndReconnect(l, reconnectable, true, jMSException);
    }

    protected JMSSession computeJMSSession(long l, Reconnectable reconnectable, weblogic.jms.common.JMSException jMSException) throws JMSException {
        return (JMSSession)this.analyzeExceptionAndReconnect(l, reconnectable, true, jMSException);
    }

    protected JMSProducer nonIdempotentJMSProducer(long l, Reconnectable reconnectable, weblogic.jms.common.JMSException jMSException) throws JMSException {
        return (JMSProducer)this.analyzeExceptionAndReconnect(l, reconnectable, false, jMSException);
    }

    protected JMSProducer idempotentJMSProducer(long l, Reconnectable reconnectable, weblogic.jms.common.JMSException jMSException) throws JMSException {
        return (JMSProducer)this.analyzeExceptionAndReconnect(l, reconnectable, true, jMSException);
    }

    protected JMSConsumer computeJMSConsumer(long l, Reconnectable reconnectable, weblogic.jms.common.JMSException jMSException) throws JMSException {
        return (JMSConsumer)this.analyzeExceptionAndReconnect(l, reconnectable, true, jMSException);
    }

    protected Reconnectable checkClosedReconnect(long l, Reconnectable reconnectable) throws JMSException {
        try {
            reconnectable.publicCheckClosed();
            return reconnectable;
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            Reconnectable reconnectable2 = this.analyzeExceptionAndReconnect(l, reconnectable, true, jMSException);
            if (reconnectable2 != reconnectable) {
                return reconnectable2;
            }
            throw jMSException;
        }
    }

    private void throwNonRecoverableException(weblogic.jms.common.JMSException jMSException, boolean bl) throws JMSException {
        int n;
        if (jMSException == null) {
            return;
        }
        boolean bl2 = false;
        Object object = jMSException;
        for (n = 40; object instanceof weblogic.jms.common.JMSException && n != 0; --n) {
            if (object instanceof DestroyConnectionException) {
                throw jMSException;
            }
            if (!bl2 && object instanceof LostServerException) {
                bl2 = ((LostServerException)((Object)object)).isReplayLastException();
            }
            object = ((Throwable)object).getCause();
        }
        n = 40;
        for (Object object2 = object; object2 != null && n != 0; object2 = ((Throwable)object2).getCause(), --n) {
            if (object2 instanceof ConnectException || object2 instanceof UnknownHostException || object2 instanceof ConnectIOException || object2 instanceof NoSuchObjectException) {
                return;
            }
            if (!(object2 instanceof DispatcherException) || !(((Throwable)object2).getCause() instanceof NameNotFoundException)) continue;
            if (TODOREMOVEDebug) {
                System.err.println("DEBUG ReconnectController new recover NameNotFound " + this.getStringState(this.getState()));
                JMSConnection.displayExceptionCauses("DEBUG ReconnectController nameNotFound", (Throwable)((Object)jMSException));
            }
            return;
        }
        if (jMSException instanceof LostServerException && (object == null || bl2)) {
            return;
        }
        if (bl && jMSException instanceof LostServerException && object instanceof Exception && ReconnectController.getCauseOrNested((Throwable)object) instanceof UnmarshalException && (ReconnectController.getCauseOrNested(((Throwable)object).getCause()) instanceof IOException || ReconnectController.getCauseOrNested(((Throwable)object).getCause()) instanceof SocketException)) {
            return;
        }
        if (TODOREMOVEDebug) {
            System.err.println("DEBUG ReconnectController did not recover " + this.getStringState(this.getState()) + " preInvokeFailure " + (40 - n));
            JMSConnection.displayExceptionCauses("DEBUG ReconnectController nonRecover", (Throwable)((Object)jMSException));
        }
        throw jMSException;
    }

    private static Throwable getCauseOrNested(Throwable throwable) {
        Throwable throwable2;
        if (throwable.getCause() != null) {
            return throwable.getCause();
        }
        if (throwable instanceof NestedThrowable && (throwable2 = ((NestedThrowable)throwable).getNested()) != throwable) {
            return throwable2;
        }
        return null;
    }
}

