/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.ConsumerInternal;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConsumer;
import weblogic.jms.client.JMSMessageContext;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.WLSessionImpl;
import weblogic.jms.common.JMSID;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.utils.expressions.ExpressionEvaluator;

public class WLConsumerImpl
extends ReconnectController
implements ConsumerInternal {
    private WLSessionImpl parent;
    private Object PROXY_ID_LOCK = new Object();
    private long proxyID;

    public WLConsumerImpl(JMSConsumer jMSConsumer, WLSessionImpl wLSessionImpl) {
        super(wLSessionImpl, jMSConsumer);
        this.parent = wLSessionImpl;
    }

    protected ReconnectController getParent() {
        return this.parent;
    }

    Object getConnectionStateLock() {
        return this.parent.getConnectionStateLock();
    }

    protected WLConnectionImpl getWLConnectionImpl() {
        return this.parent.getWLConnectionImpl();
    }

    protected void forget() {
    }

    protected JMSConnection getPhysicalJMSConnection() {
        return this.parent.getPhysicalJMSConnection();
    }

    private JMSConsumer physicalConsumer() {
        return (JMSConsumer)this.getPhysical();
    }

    public String getWLSServerName() {
        return ((ClientRuntimeInfo)((Object)this.getPhysicalWaitForState())).getWLSServerName();
    }

    public String getRuntimeMBeanName() {
        return ((ClientRuntimeInfo)((Object)this.getPhysicalWaitForState())).getRuntimeMBeanName();
    }

    public ClientRuntimeInfo getParentInfo() {
        return ((ClientRuntimeInfo)((Object)this.getPhysicalWaitForState())).getParentInfo();
    }

    public Queue getQueue() throws JMSException {
        return this.physicalConsumer().getQueue();
    }

    public Topic getTopic() throws JMSException {
        return ((JMSConsumer)this.getPhysicalWaitForState()).getTopic();
    }

    public boolean getNoLocal() throws JMSException {
        return ((JMSConsumer)this.getPhysicalWaitForState()).getNoLocal();
    }

    public void decrementWindowCurrent(boolean bl) throws JMSException {
        ((JMSConsumer)this.getPhysicalWaitForState()).decrementWindowCurrent(bl);
    }

    public Destination getDestination() {
        return this.physicalConsumer().getDestination();
    }

    public long getExpectedSequenceNumber() {
        return this.physicalConsumer().getExpectedSequenceNumber();
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.physicalConsumer().getExpressionEvaluator();
    }

    public ID getId() {
        return this.physicalConsumer().getId();
    }

    public JMSID getJMSID() {
        return this.physicalConsumer().getJMSID();
    }

    public JMSMessageContext getMessageListenerContext() {
        return this.physicalConsumer().getMessageListenerContext();
    }

    public JMSSession getSession() {
        return this.physicalConsumer().getSession();
    }

    public int getWindowCurrent() {
        return this.physicalConsumer().getWindowCurrent();
    }

    public int getWindowMaximum() {
        return this.physicalConsumer().getWindowMaximum();
    }

    public boolean isDurable() {
        return this.physicalConsumer().isDurable();
    }

    public boolean privateGetNoLocal() {
        return this.physicalConsumer().privateGetNoLocal();
    }

    public void removeDurableConsumer() {
        this.physicalConsumer().removeDurableConsumer();
    }

    public void setExpectedSequenceNumber(long l) {
        this.physicalConsumer().setExpectedSequenceNumber(l);
    }

    public void setExpectedSequenceNumber(long l, boolean bl) {
        this.physicalConsumer().setExpectedSequenceNumber(l, bl);
    }

    public final void setClosed(boolean bl) {
        this.physicalConsumer().setClosed(bl);
    }

    public void setId(JMSID jMSID) {
        this.physicalConsumer().setId(jMSID);
    }

    public void setRuntimeMBeanName(String string) {
        this.physicalConsumer().setRuntimeMBeanName(string);
    }

    public void setWindowCurrent(int n) {
        this.physicalConsumer().setWindowCurrent(n);
    }

    public boolean isClosed() {
        return super.isClosed();
    }

    public String getMessageSelector() throws JMSException {
        return this.physicalConsumer().getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        return ((JMSConsumer)this.getPhysicalWaitForState()).getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        ((JMSConsumer)this.getPhysicalWaitForState()).setMessageListener(messageListener);
    }

    public void setMessageListener(MessageListener messageListener, long l) throws JMSException {
        ((JMSConsumer)this.getPhysicalWaitForState()).setMessageListener(messageListener, l);
    }

    public void close(long l) throws JMSException {
        ((JMSConsumer)this.getPhysicalWaitForState()).close(l);
    }

    public Message receive() throws JMSException {
        long l = System.currentTimeMillis();
        JMSConsumer jMSConsumer = null;
        try {
            jMSConsumer = this.computeJMSConsumer(l, null, null);
            return jMSConsumer.receive();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            jMSConsumer = this.computeJMSConsumer(l, jMSConsumer, jMSException);
            return jMSConsumer.receive();
        }
    }

    public Message receive(long l) throws JMSException {
        long l2 = System.currentTimeMillis();
        JMSConsumer jMSConsumer = null;
        try {
            jMSConsumer = this.computeJMSConsumer(l2, null, null);
            return jMSConsumer.receive(l);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            jMSConsumer = this.computeJMSConsumer(l2, jMSConsumer, jMSException);
            return jMSConsumer.receive(l);
        }
    }

    public Message receiveNoWait() throws JMSException {
        long l = System.currentTimeMillis();
        JMSConsumer jMSConsumer = null;
        try {
            jMSConsumer = this.computeJMSConsumer(l, null, null);
            return jMSConsumer.receiveNoWait();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            jMSConsumer = this.computeJMSConsumer(l, jMSConsumer, jMSException);
            return jMSConsumer.receiveNoWait();
        }
    }

    public void receiveAsync(CompletionListener completionListener) {
        try {
            long l = System.currentTimeMillis();
            JMSConsumer jMSConsumer = null;
            try {
                jMSConsumer = this.computeJMSConsumer(l, null, null);
                jMSConsumer.receiveInternal(Long.MAX_VALUE, completionListener);
            }
            catch (weblogic.jms.common.JMSException jMSException) {
                jMSConsumer = this.computeJMSConsumer(l, jMSConsumer, jMSException);
                jMSConsumer.receiveInternal(Long.MAX_VALUE, completionListener);
            }
        }
        catch (Throwable throwable) {
            completionListener.onException(throwable);
        }
    }

    public void receiveAsync(long l, CompletionListener completionListener) {
        try {
            long l2 = System.currentTimeMillis();
            JMSConsumer jMSConsumer = null;
            try {
                jMSConsumer = this.computeJMSConsumer(l2, null, null);
                jMSConsumer.receiveInternal(l, completionListener);
            }
            catch (weblogic.jms.common.JMSException jMSException) {
                jMSConsumer = this.computeJMSConsumer(l2, jMSConsumer, jMSException);
                jMSConsumer.receiveInternal(l, completionListener);
            }
        }
        catch (Throwable throwable) {
            completionListener.onException(throwable);
        }
    }

    public void receiveNoWaitAsync(CompletionListener completionListener) {
        try {
            long l = System.currentTimeMillis();
            JMSConsumer jMSConsumer = null;
            try {
                jMSConsumer = this.computeJMSConsumer(l, null, null);
                jMSConsumer.receiveInternal(0x7FFFFFFFFFFFFFFEL, completionListener);
            }
            catch (weblogic.jms.common.JMSException jMSException) {
                jMSConsumer = this.computeJMSConsumer(l, jMSConsumer, jMSException);
                jMSConsumer.receiveInternal(0x7FFFFFFFFFFFFFFEL, completionListener);
            }
        }
        catch (Throwable throwable) {
            completionListener.onException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProxyID(long l) {
        Object object = this.PROXY_ID_LOCK;
        synchronized (object) {
            this.proxyID = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getProxyID() {
        Object object = this.PROXY_ID_LOCK;
        synchronized (object) {
            return this.proxyID;
        }
    }
}

