/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferDataInputStream;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.common.PayloadText;
import weblogic.utils.StringUtils;
import weblogic.utils.io.DataIO;

public final class BufferDataOutputStream
extends BufferOutputStream
implements PayloadStream,
PayloadText,
ObjectOutput {
    private byte[] buf;
    private final byte[] fixedSizeBuf;
    private int count;
    private final ObjectIOBypass objectIOBypass;
    private boolean isBypassOutputStream;
    private boolean isJMSStoreOutputStream;
    private boolean isJMSMulticastOutputStream;
    private static final int VERSION = 1234;

    public BufferDataOutputStream(ObjectIOBypass objectIOBypass, int n) {
        this.objectIOBypass = objectIOBypass;
        this.buf = new byte[n];
        this.fixedSizeBuf = null;
    }

    public BufferDataOutputStream(ObjectIOBypass objectIOBypass, byte[] byArray) {
        this.objectIOBypass = objectIOBypass;
        this.fixedSizeBuf = byArray;
        this.buf = byArray;
    }

    BufferDataOutputStream(ObjectIOBypass objectIOBypass, DataInput dataInput) throws IOException {
        this(objectIOBypass, dataInput, dataInput.readInt());
    }

    BufferDataOutputStream(ObjectIOBypass objectIOBypass, DataInput dataInput, int n) throws IOException {
        this(objectIOBypass, n);
        dataInput.readFully(this.buf);
    }

    private void resizeBuf(int n, int n2) throws IOException {
        if (n >= n2) {
            return;
        }
        if (this.fixedSizeBuf != null) {
            throw new IOException("exceeded fixed size allocation");
        }
        byte[] byArray = n2 >= 0x200000 ? (n2 >= 0x2000000 ? (n2 >= 0x7F7FFFFE ? new byte[Integer.MAX_VALUE] : new byte[n2 + 0x7FFFFF & 0xFF800000]) : new byte[n2 + 1048575 & 0xFFF00000]) : new byte[n2 << 1];
        System.arraycopy(this.buf, 0, byArray, 0, n);
        this.buf = byArray;
    }

    public final boolean isJMSStoreOutputStream() {
        return this.isJMSStoreOutputStream;
    }

    public final boolean isBypassOutputStream() {
        return this.isBypassOutputStream;
    }

    public final boolean isJMSMulticastOutputStream() {
        return this.isJMSMulticastOutputStream;
    }

    public final void setIsJMSStoreOutputStream() {
        this.isJMSStoreOutputStream = true;
    }

    public final void setIsBypassOutputStream() {
        this.isBypassOutputStream = true;
    }

    public final void setIsJMSMulticastOutputStream() {
        this.isJMSMulticastOutputStream = true;
    }

    public final void write(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.resizeBuf(this.count, this.count + 1);
        }
        this.buf[this.count++] = (byte)n;
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            this.resizeBuf(this.count, n3);
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public final void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public final void reset() {
        this.count = 0;
    }

    public final byte[] getBuffer() {
        return this.buf;
    }

    public final ObjectOutput getObjectOutput() {
        return this;
    }

    final void copyBuffer() throws JMSException {
        byte[] byArray = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
        this.buf = byArray;
    }

    public final int size() {
        return this.count;
    }

    public final void writeObject(Object object) throws IOException {
        this.writeInt(1234);
        if (this.objectIOBypass == null) {
            throw new IOException(JMSClientExceptionLogger.logRawObjectError2Loggable().getMessage());
        }
        this.objectIOBypass.writeObject(this, object);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        if (this.count >= this.buf.length) {
            this.resizeBuf(this.count, this.count + 1);
        }
        this.buf[this.count++] = (byte)(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.resizeBuf(this.count, this.count + 1);
        }
        this.buf[this.count++] = (byte)n;
    }

    public final void writeShort(int n) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 2);
        }
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public final void writeChar(int n) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 2);
        }
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public final void writeInt(int n) throws IOException {
        if (this.count + 4 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 4);
        }
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public final void writeLong(long l) throws IOException {
        if (this.count + 8 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 8);
        }
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)(l >>> 0);
    }

    public final void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        if (this.count + 4 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 4);
        }
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public final void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        if (this.count + 8 > this.buf.length) {
            this.resizeBuf(this.count, this.count + 8);
        }
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)(l >>> 0);
    }

    public final void writeBytes(String string) throws IOException {
        BufferDataOutputStream bufferDataOutputStream = this;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            ((OutputStream)bufferDataOutputStream).write((byte)string.charAt(i));
        }
    }

    public final void writeChars(String string) throws IOException {
        BufferDataOutputStream bufferDataOutputStream = this;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            ((OutputStream)bufferDataOutputStream).write(c >>> 8 & 0xFF);
            ((OutputStream)bufferDataOutputStream).write(c >>> 0 & 0xFF);
        }
    }

    public final void writeUTF32(String string) throws IOException {
        BufferDataOutputStream.writeUTF32(this, string);
    }

    public static void writeUTF32(ObjectOutput objectOutput, String string) throws IOException {
        int n = StringUtils.getUTFLength((String)string);
        objectOutput.writeInt(n);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            DataIO.writeUTFChar((DataOutput)objectOutput, (int)string.charAt(i));
        }
    }

    public final void writeUTF(String string) throws IOException {
        DataIO.writeUTF((OutputStream)this, (String)string);
    }

    public void writeLengthAndData(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.count);
        dataOutput.write(this.buf, 0, this.count);
    }

    public PayloadText copyPayloadWithoutSharedText() throws JMSException {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        BufferDataOutputStream bufferDataOutputStream = new BufferDataOutputStream(this.objectIOBypass, byArray);
        bufferDataOutputStream.count = this.count;
        return bufferDataOutputStream;
    }

    public PayloadStream copyPayloadWithoutSharedStream() throws JMSException {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        BufferDataOutputStream bufferDataOutputStream = new BufferDataOutputStream(this.objectIOBypass, byArray);
        bufferDataOutputStream.count = this.count;
        return bufferDataOutputStream;
    }

    public PayloadStream moveToPayload() {
        return this;
    }

    public BufferInputStream getInputStream() throws IOException {
        return new BufferDataInputStream(this.objectIOBypass, this.buf, 0, this.count);
    }

    public int getLength() {
        return this.count;
    }

    public String readUTF8() throws IOException {
        return new BufferDataInputStream(this.objectIOBypass, this.buf, 0, this.count).readUTF8();
    }
}

