/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkInput;
import weblogic.utils.io.ChunkedDataInputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringInput;

public class BufferInputStreamChunked
extends BufferInputStream
implements StringInput,
ChunkInput,
ObjectInput {
    private final ObjectIOBypass objectIOBypass;
    private final ChunkedDataInputStream cdis;
    private int mark = 0;
    private static final int VERSION = 1234;

    public BufferInputStreamChunked(ObjectIOBypass objectIOBypass, ChunkedDataInputStream chunkedDataInputStream) {
        this.objectIOBypass = objectIOBypass;
        this.cdis = chunkedDataInputStream;
        this.internalMarkForCDIS();
    }

    private void internalMarkForCDIS() {
        this.cdis.mark(16384);
    }

    private void internalReset() {
        this.cdis.reset();
        this.internalMarkForCDIS();
    }

    ChunkedDataInputStream getInternalCDIS() {
        return this.cdis;
    }

    public void unput() throws IOException {
        int n = this.cdis.pos() - 1;
        this.internalReset();
        this.cdis.skip((long)n);
    }

    public void reset() throws IOException {
        this.internalReset();
        this.skip(this.mark);
        this.mark = 0;
    }

    public void mark(int n) {
        this.mark = this.pos();
    }

    public int pos() {
        return this.cdis.pos();
    }

    public void gotoPos(int n) throws IOException {
        this.mark = 0;
        this.internalReset();
        this.skip(n);
    }

    public boolean markSupported() {
        return false;
    }

    public int size() {
        return Chunk.size((Chunk)this.cdis.getChunks());
    }

    public int read() throws IOException {
        return this.cdis.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.cdis.read(byArray, n, n2);
    }

    public int available() {
        return this.cdis.available();
    }

    public synchronized void close() throws IOException {
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.cdis.readFully(byArray, n, n2);
    }

    public final int skipBytes(int n) throws IOException {
        return this.cdis.skipBytes(n);
    }

    public Chunk readChunks() throws IOException {
        return this.cdis.readChunks();
    }

    public int peekInt(int n) throws IOException {
        return this.cdis.peekInt(n);
    }

    public final Object readObject() throws IOException, ClassNotFoundException {
        int n = this.readInt();
        if (n != 1234) {
            throw new StreamCorruptedException(JMSClientExceptionLogger.logUnknownStreamVersionLoggable((int)n).getMessage());
        }
        if (this.objectIOBypass == null) {
            throw new StreamCorruptedException(JMSClientExceptionLogger.logRawObjectErrorLoggable().getMessage());
        }
        return this.objectIOBypass.readObject(this);
    }

    public final boolean readBoolean() throws IOException {
        return this.cdis.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this.cdis.readByte();
    }

    public final int readUnsignedByte() throws IOException {
        return this.cdis.readUnsignedByte();
    }

    public final short readShort() throws IOException {
        return this.cdis.readShort();
    }

    public final int readUnsignedShort() throws IOException {
        return this.cdis.readUnsignedShort();
    }

    public final char readChar() throws IOException {
        return this.cdis.readChar();
    }

    public final int readInt() throws IOException {
        return this.cdis.readInt();
    }

    public final long readLong() throws IOException {
        return this.cdis.readLong();
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.cdis.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.cdis.readLong());
    }

    public final String readLine() throws IOException {
        throw new IOException(JMSClientExceptionLogger.logNotImplementedLoggable().getMessage());
    }

    public final String readUTF() throws IOException {
        return DataIO.readUTF((InputStream)this);
    }

    public final String readASCII() throws IOException {
        return this.cdis.readASCII();
    }

    public final String readUTF8() throws IOException {
        return this.cdis.readUTF8();
    }

    public final String readUTF32() throws IOException {
        return BufferInputStreamChunked.readUTF32(this);
    }

    static String readUTF32(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        block5: while (n2 < n) {
            int n3 = dataInput.readByte() & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    stringBuffer.append((char)n3);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = dataInput.readByte();
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0x1F) << 6 | by & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = dataInput.readByte();
                    byte by2 = dataInput.readByte();
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(stringBuffer);
    }
}

