/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferInputStreamChunked;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadChunkBase;
import weblogic.jms.common.PayloadStream;
import weblogic.utils.StringUtils;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkOutput;
import weblogic.utils.io.ChunkedDataInputStream;
import weblogic.utils.io.ChunkedDataOutputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringOutput;

final class BufferOutputStreamChunked
extends BufferOutputStream
implements StringOutput,
ChunkOutput,
ObjectOutput {
    private final ObjectIOBypass objectIOBypass;
    private boolean isBypassOutputStream;
    private boolean isJMSStoreOutputStream;
    private boolean isJMSMulticastOutputStream;
    private ChunkedDataOutputStream cdos;
    private Chunk chunk;
    private static final int VERSION = 1234;

    BufferOutputStreamChunked(ObjectIOBypass objectIOBypass) {
        this.objectIOBypass = objectIOBypass;
        this.cdos = new ChunkedDataOutputStream();
        this.chunk = this.cdos.getCurrentChunk();
    }

    BufferOutputStreamChunked() {
        this(null);
    }

    public final boolean isJMSStoreOutputStream() {
        return this.isJMSStoreOutputStream;
    }

    public final boolean isBypassOutputStream() {
        return this.isBypassOutputStream;
    }

    public final boolean isJMSMulticastOutputStream() {
        return this.isJMSMulticastOutputStream;
    }

    public final void setIsJMSStoreOutputStream() {
        this.isJMSStoreOutputStream = true;
    }

    public final void setIsBypassOutputStream() {
        this.isBypassOutputStream = true;
    }

    public final void setIsJMSMulticastOutputStream() {
        this.isJMSMulticastOutputStream = true;
    }

    public final void write(int n) {
        this.cdos.write(n);
    }

    public final void write(byte[] byArray, int n, int n2) {
        this.cdos.write(byArray, n, n2);
    }

    public final void reset() {
        this.cdos.reset();
    }

    public final int size() {
        return this.cdos.getPosition();
    }

    public final void writeObject(Object object) throws IOException {
        this.writeInt(1234);
        if (this.objectIOBypass == null) {
            throw new IOException(JMSClientExceptionLogger.logRawObjectError2Loggable().getMessage());
        }
        this.objectIOBypass.writeObject(this, object);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.cdos.writeBoolean(bl);
    }

    public final void writeByte(int n) throws IOException {
        this.cdos.writeByte(n);
    }

    public final void writeShort(int n) throws IOException {
        this.cdos.writeShort(n);
    }

    public final void writeChar(int n) throws IOException {
        this.cdos.writeChar(n);
    }

    public final void writeInt(int n) throws IOException {
        this.cdos.writeInt(n);
    }

    public final void writeLong(long l) throws IOException {
        this.cdos.writeLong(l);
    }

    public final void writeFloat(float f) throws IOException {
        this.cdos.writeFloat(f);
    }

    public final void writeDouble(double d) throws IOException {
        this.cdos.writeDouble(d);
    }

    public final void writeBytes(String string) throws IOException {
        this.cdos.writeBytes(string);
    }

    public final void writeChars(String string) throws IOException {
        this.cdos.writeChars(string);
    }

    public final void writeUTF32(String string) throws IOException {
        BufferOutputStreamChunked.writeUTF32(this, string);
    }

    public static void writeUTF32(DataOutput dataOutput, String string) throws IOException {
        int n = StringUtils.getUTFLength((String)string);
        dataOutput.writeInt(n);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            DataIO.writeUTFChar((DataOutput)dataOutput, (int)string.charAt(i));
        }
    }

    public final void writeUTF(String string) throws IOException {
        this.cdos.writeUTF(string);
    }

    public int getLength() {
        Chunk chunk = this.cdos.getCurrentChunk();
        chunk.end = Math.max(chunk.end, this.cdos.getChunkPos());
        return Chunk.size((Chunk)this.chunk);
    }

    public void writeLengthAndData(DataOutput dataOutput) throws IOException {
        Chunk chunk = this.cdos.getCurrentChunk();
        chunk.end = Math.max(chunk.end, this.cdos.getChunkPos());
        PayloadChunkBase.internalWriteLengthAndData(dataOutput, this.chunk);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        Chunk chunk = this.cdos.getCurrentChunk();
        chunk.end = Math.max(chunk.end, this.cdos.getChunkPos());
        Chunk chunk2 = this.chunk;
        while (chunk2 != null) {
            if (chunk2.end > 0) {
                outputStream.write(chunk2.buf, 0, chunk2.end);
            }
            chunk2 = chunk2.next;
        }
    }

    public BufferInputStream getInputStream() throws IOException {
        return new BufferInputStreamChunked(this.objectIOBypass, new ChunkedDataInputStream(this.cdos.getSharedBeforeCopyTail(), 0));
    }

    public Payload moveToPayload() {
        Chunk chunk = this.cdos.getCurrentChunk();
        chunk.end = Math.max(chunk.end, this.cdos.getChunkPos());
        Chunk chunk2 = this.chunk;
        this.chunk = null;
        this.cdos = null;
        return new PayloadChunkBase(chunk2);
    }

    PayloadStream copyPayloadWithoutSharedStream() throws JMSException {
        Chunk chunk = this.cdos.getCurrentChunk();
        chunk.end = Math.max(chunk.end, this.cdos.getChunkPos());
        return new PayloadChunkBase(PayloadChunkBase.copyWithoutSharedData(this.chunk));
    }

    public void writeChunks(Chunk chunk) throws IOException {
        Chunk chunk2 = Chunk.tail((Chunk)chunk);
        if (chunk2.isReadOnlySharedBuf()) {
            chunk2.next = Chunk.getChunk();
        }
        this.cdos.writeChunks(chunk);
    }

    public void copyBuffer() throws JMSException {
        Chunk chunk = this.cdos.getCurrentChunk();
        chunk.end = Math.max(chunk.end, this.cdos.getChunkPos());
        ChunkedDataOutputStream chunkedDataOutputStream = new ChunkedDataOutputStream();
        Chunk chunk2 = chunkedDataOutputStream.getCurrentChunk();
        try {
            this.writeTo((OutputStream)chunkedDataOutputStream);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException);
        }
        this.cdos = chunkedDataOutputStream;
        this.chunk = chunk2;
    }

    public ObjectOutput getObjectOutput() {
        return this;
    }

    public void writeASCII(String string) throws IOException {
        this.cdos.writeASCII(string);
    }

    public void writeUTF8(String string) throws IOException {
        this.cdos.writeUTF8(string);
    }
}

