/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageEOFException;
import weblogic.jms.common.MessageFormatException;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;

public final class BytesMessageImpl
extends MessageImpl
implements BytesMessage,
Externalizable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte VERSIONMASK = 127;
    static final long serialVersionUID = -8264735281046103996L;
    transient PayloadStream payload;
    private transient BufferOutputStream bos;
    private transient BufferInputStream bis;

    public BytesMessageImpl() {
    }

    public BytesMessageImpl(BytesMessage bytesMessage) throws IOException, javax.jms.JMSException {
        this(bytesMessage, null, null);
    }

    public BytesMessageImpl(BytesMessage bytesMessage, Destination destination, Destination destination2) throws IOException, javax.jms.JMSException {
        super((Message)bytesMessage, destination, destination2);
        int n = 4096;
        byte[] byArray = new byte[n];
        bytesMessage.reset();
        int n2 = bytesMessage.readBytes(byArray, n);
        while (n2 > 0) {
            this.writeBytes(byArray, 0, n2);
            n2 = bytesMessage.readBytes(byArray, n);
        }
        this.reset();
        this.setPropertiesWritable(false);
    }

    public byte getType() {
        return 1;
    }

    public void nullBody() {
        this.payload = null;
        this.bis = null;
        this.bos = null;
        this.payloadCopyOnWrite = false;
    }

    private String getReadPastEnd(int n) {
        return JMSClientExceptionLogger.logReadPastEnd2Loggable((int)n).getMessage();
    }

    static String getReadError(int n) {
        return JMSClientExceptionLogger.logReadErrorLoggable((int)n).getMessage();
    }

    public boolean readBoolean() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readBoolean();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.getReadPastEnd(10), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(10), (Throwable)iOException);
        }
    }

    public byte readByte() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.getReadPastEnd(20), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(20), (Throwable)iOException);
        }
    }

    public int readUnsignedByte() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readUnsignedByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.getReadPastEnd(30), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(30), (Throwable)iOException);
        }
    }

    public short readShort() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readShort();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.getReadPastEnd(40), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(40), (Throwable)iOException);
        }
    }

    public int readUnsignedShort() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.getReadPastEnd(50), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(50), (Throwable)iOException);
        }
    }

    public char readChar() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readChar();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.getReadPastEnd(60), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(60), (Throwable)iOException);
        }
    }

    public int readInt() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readInt();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.getReadPastEnd(70), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(70), (Throwable)iOException);
        }
    }

    public long readLong() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readLong();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.getReadPastEnd(80), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(80), (Throwable)iOException);
        }
    }

    public float readFloat() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readFloat();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.getReadPastEnd(90), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(90), (Throwable)iOException);
        }
    }

    public double readDouble() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readDouble();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.getReadPastEnd(100), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(100), (Throwable)iOException);
        }
    }

    public String readUTF() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bis.readUTF();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.getReadPastEnd(110), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(110), (Throwable)iOException);
        }
    }

    public int readBytes(byte[] byArray) throws javax.jms.JMSException {
        return this.readBytes(byArray, byArray.length);
    }

    public int readBytes(byte[] byArray, int n) throws javax.jms.JMSException {
        if (n < 0) {
            throw new IndexOutOfBoundsException(JMSClientExceptionLogger.logNegativeLengthLoggable((int)n).getMessage());
        }
        if (n > byArray.length) {
            throw new IndexOutOfBoundsException(JMSClientExceptionLogger.logTooMuchLengthLoggable((int)n, (int)byArray.length).getMessage());
        }
        try {
            this.checkReadable();
        }
        catch (javax.jms.MessageEOFException messageEOFException) {
            return -1;
        }
        try {
            return this.bis.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(5), (Throwable)iOException);
        }
    }

    private String getWriteError(int n) {
        return JMSClientExceptionLogger.logWriteErrorLoggable((int)n).getMessage();
    }

    public void writeBoolean(boolean bl) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw new JMSException(this.getWriteError(10), (Throwable)iOException);
        }
    }

    public void writeByte(byte by) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeByte(by);
        }
        catch (IOException iOException) {
            throw new JMSException(this.getWriteError(20), (Throwable)iOException);
        }
    }

    public void writeShort(short s) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeShort(s);
        }
        catch (IOException iOException) {
            throw new JMSException(this.getWriteError(30), (Throwable)iOException);
        }
    }

    public void writeChar(char c) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeChar(c);
        }
        catch (IOException iOException) {
            throw new JMSException(this.getWriteError(40), (Throwable)iOException);
        }
    }

    public void writeInt(int n) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeInt(n);
        }
        catch (IOException iOException) {
            throw new JMSException(this.getWriteError(50), (Throwable)iOException);
        }
    }

    public void writeLong(long l) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeLong(l);
        }
        catch (IOException iOException) {
            throw new JMSException(this.getWriteError(60), (Throwable)iOException);
        }
    }

    public void writeFloat(float f) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeFloat(f);
        }
        catch (IOException iOException) {
            throw new JMSException(this.getWriteError(70), (Throwable)iOException);
        }
    }

    public void writeDouble(double d) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeDouble(d);
        }
        catch (IOException iOException) {
            throw new JMSException(this.getWriteError(80), (Throwable)iOException);
        }
    }

    public void writeUTF(String string) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new JMSException(this.getWriteError(90), (Throwable)iOException);
        }
    }

    public void writeBytes(byte[] byArray) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bos.write(byArray);
        }
        catch (IOException iOException) {
            throw new JMSException(this.getWriteError(100), (Throwable)iOException);
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws javax.jms.JMSException {
        this.checkWritable();
        try {
            this.bos.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException);
        }
    }

    public void writeObject(Object object) throws javax.jms.JMSException {
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Number) {
            if (object instanceof Byte) {
                this.writeByte(((Number)object).byteValue());
            } else if (object instanceof Short) {
                this.writeShort(((Number)object).shortValue());
            } else if (object instanceof Integer) {
                this.writeInt(((Number)object).intValue());
            } else if (object instanceof Long) {
                this.writeLong(((Number)object).longValue());
            } else if (object instanceof Float) {
                this.writeFloat(((Number)object).floatValue());
            } else if (object instanceof Double) {
                this.writeDouble(((Number)object).doubleValue());
            }
        } else if (object instanceof String) {
            this.writeUTF((String)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else {
            throw new MessageFormatException(JMSClientExceptionLogger.logInvalidObjectLoggable((String)object.getClass().getName()).getMessage());
        }
    }

    public void reset() throws javax.jms.JMSException {
        try {
            this.setBodyWritable(false);
            if (this.bis != null) {
                this.bis.reset();
            } else if (this.bos != null) {
                this.payload = (PayloadStream)this.bos.moveToPayload();
                this.bos = null;
            }
            this.payloadCopyOnWrite = false;
        }
        catch (IOException iOException) {
            throw new JMSException(BytesMessageImpl.getReadError(578), (Throwable)iOException);
        }
    }

    public MessageImpl copy() throws javax.jms.JMSException {
        BytesMessageImpl bytesMessageImpl = new BytesMessageImpl();
        super.copy(bytesMessageImpl);
        if (this.bos != null) {
            bytesMessageImpl.payload = this.bos.copyPayloadWithoutSharedStream();
        } else if (this.payload != null) {
            bytesMessageImpl.payload = this.payload.copyPayloadWithoutSharedStream();
        }
        this.payloadCopyOnWrite = true;
        bytesMessageImpl.payloadCopyOnWrite = true;
        bytesMessageImpl.setBodyWritable(false);
        bytesMessageImpl.setPropertiesWritable(false);
        return bytesMessageImpl;
    }

    private void checkWritable() throws javax.jms.JMSException {
        super.writeMode();
        if (this.bos == null) {
            this.bos = PayloadFactoryImpl.createOutputStream();
        } else if (this.payloadCopyOnWrite) {
            this.bos.copyBuffer();
            this.payloadCopyOnWrite = false;
        }
    }

    private void checkReadable() throws javax.jms.JMSException {
        super.readMode();
        this.decompressMessageBody();
        if (this.bis == null) {
            if (this.payload == null) {
                throw new MessageEOFException(this.getReadPastEnd(120));
            }
            try {
                this.bis = this.payload.getInputStream();
            }
            catch (IOException iOException) {
                throw new JMSException(BytesMessageImpl.getReadError(510), (Throwable)iOException);
            }
        }
    }

    public String toString() {
        return "BytesMessage[" + this.getJMSMessageID() + "]";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Payload payload;
        ObjectOutput objectOutput2;
        super.writeExternal(objectOutput);
        int n = Integer.MAX_VALUE;
        if (objectOutput instanceof MessageImpl.JMSObjectOutputWrapper) {
            objectOutput2 = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getInnerObjectOutput();
            n = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getCompressionThreshold();
        } else {
            objectOutput2 = objectOutput;
        }
        int n2 = this.getVersion(objectOutput2) >= 30 ? (int)((byte)(3 | (this.shouldCompress(objectOutput2, n) ? -128 : 0))) : 2;
        objectOutput2.writeByte(n2);
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("BytesMessageImpl.write versionInt x" + Integer.toHexString(n2).toUpperCase() + ((n2 & 0xFFFFFF80) != 0 ? " compression is on" : ""));
        }
        if (this.isCompressed()) {
            if (n2 == 2) {
                this.decompress().writeLengthAndData(objectOutput2);
            } else {
                this.flushCompressedMessageBody(objectOutput2);
            }
            return;
        }
        if (this.bos != null) {
            payload = this.bos;
        } else if (this.payload != null) {
            payload = this.payload;
        } else {
            objectOutput2.writeInt(0);
            return;
        }
        if ((n2 & 0xFFFFFF80) != 0) {
            this.writeExternalCompressPayload(objectOutput2, payload);
        } else {
            payload.writeLengthAndData(objectOutput2);
        }
    }

    public final void decompressMessageBody() throws javax.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            try {
                this.payload = (PayloadStream)this.decompress();
            }
            catch (IOException iOException) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)iOException);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.cleanupCompressedMessageBody();
            throw throwable;
        }
        this.cleanupCompressedMessageBody();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        byte by2 = (byte)(by & 0x7F);
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("BytesMessageImpl.read  versionInt x" + Integer.toHexString(by2).toUpperCase());
        }
        if (by2 < 1 || by2 > 3) {
            throw JMSUtilities.versionIOException(by2, 1, 3);
        }
        switch (by2) {
            case 3: {
                if ((by & 0xFFFFFF80) != 0) {
                    this.readExternalCompressedMessageBody(objectInput);
                    break;
                }
            }
            case 2: {
                this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)objectInput));
                break;
            }
            case 1: {
                if (!objectInput.readBoolean()) break;
                this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)objectInput));
            }
        }
        this.setBodyWritable(false);
        this.setPropertiesWritable(false);
    }

    public long getPayloadSize() {
        if (this.isCompressed()) {
            return this.getCompressedMessageBodySize();
        }
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.payload != null) {
            this.bodySize = this.payload.getLength();
            return this.bodySize;
        }
        if (this.bos != null) {
            return this.bos.size();
        }
        this.bodySize = 0L;
        return 0L;
    }

    private long getLen() {
        if (this.bos != null) {
            return this.bos.size();
        }
        if (this.payload != null) {
            return this.payload.getLength();
        }
        return 0L;
    }

    public long getBodyLength() throws javax.jms.JMSException {
        super.readMode();
        return this.getLen();
    }

    public byte[] getBodyBytes() throws javax.jms.JMSException {
        Payload payload;
        if (this.payload != null) {
            payload = this.payload;
        } else if (this.bos != null) {
            payload = this.bos;
        } else {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            payload.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new JMSException(iOException);
        }
    }

    public PayloadStream getPayload() throws javax.jms.JMSException {
        if (this.isCompressed()) {
            try {
                this.payload = (PayloadStream)this.decompress();
            }
            catch (IOException iOException) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)iOException);
            }
        }
        return this.payload;
    }

    public void setPayload(PayloadStream payloadStream) {
        if (this.payload != null || this.bis != null || this.bos != null || this.payloadCopyOnWrite) {
            throw new AssertionError();
        }
        try {
            this.writeMode();
        }
        catch (javax.jms.JMSException jMSException) {
            throw new AssertionError((Object)jMSException);
        }
        this.payload = payloadStream;
    }
}

