/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.deployment.jms.ForeignOpaqueTag;
import weblogic.jms.common.CDSListListener;
import weblogic.jms.common.CDSListProvider;
import weblogic.jms.common.CDSLocalProxy;
import weblogic.jms.common.CDSSecurityHandle;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DDMemberInformation;
import weblogic.jms.common.DDMembershipChangeEventImpl;
import weblogic.jms.common.DDMembershipChangeListener;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class CDS {
    private static CDS singleton = new CDS();
    private final List dd2Listeners = Collections.synchronizedList(new LinkedList());
    private final HashMap unsuccessfulDDLookup = new HashMap();
    private final HashMap pendingRegistration = new HashMap();
    private static CDSListProvider localCDSServer;
    private static CDSListProvider localCDSProxy;
    private TimerManager timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("weblogic.jms.common.DistributedDestinationManager", (WorkManager)null);
    private Timer ddPoller;
    private boolean ddLookupIsRunning;
    private TimerManager timerManagerForRegistration = null;
    private Timer listenerRegistrar;
    private static final String DDM_NAME = "weblogic.jms.common.DistributedDestinationManager";
    private static final String DDM_REGISTRATION_MANAGER_NAME = "weblogic.jms.common.DistributedDestinationRegistrationManager";
    private static final String CDS_ASYNC_REGISTRATION_WM_NAME = "CdsAsyncRegistration";
    private WorkManager cdsAsyncRegistrationWorkManager;
    private boolean postDeploymentsStart = false;
    private static final long JMS_DD_JNDI_LOOKUP_INTERVAL = 10000L;
    private static final long JMS_DD_JNDI_LOOKUP_INITIAL_DELAY = 10000L;
    private static final long JMS_DD_LISTENER_REGISTRATION_INTERVAL = 500L;
    private static final long JMS_DD_LISTENER_REGISTRATION_DELAY = 500L;
    private static final int INITIAL_CONTEXT_SUCCEEDED = 0;
    private static final int INITIAL_JNDI_LOOKUP_SUCCEEDED = 1;
    private static final int POLLER_JNDI_LOOKUP_SUCCEEDED = 2;
    private static final int NUMBER_OF_RETRIES_BEFORE_ON_FAILURE_CALLBACK = 10;
    private static final int DEFAULT_CDS_ASYNC_REGISTRATION_THREAD_COUNT;

    public static synchronized CDS getCDS() {
        return singleton;
    }

    private void initializeWorkManager() {
        this.cdsAsyncRegistrationWorkManager = WorkManagerFactory.getInstance().findOrCreate(CDS_ASYNC_REGISTRATION_WM_NAME, 100, 1, DEFAULT_CDS_ASYNC_REGISTRATION_THREAD_COUNT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPolling(DD2Listener dD2Listener) {
        Object object = this.dd2Listeners;
        synchronized (object) {
            ListIterator listIterator = this.dd2Listeners.listIterator();
            while (listIterator.hasNext()) {
                if (dD2Listener != listIterator.next()) continue;
                listIterator.remove();
                break;
            }
        }
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("The DD " + dD2Listener.getDestinationName() + " is not up, starting the poller...");
        }
        object = this;
        synchronized (object) {
            this.unsuccessfulDDLookup.put(dD2Listener.getListener(), dD2Listener);
            if (this.ddPoller == null) {
                this.ddPoller = this.timerManager.schedule((TimerListener)new DDLookupTimerListener(), 10000L, 10000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDSSecurityHandle registerForDDMembershipInformation(DDMembershipChangeListener dDMembershipChangeListener) {
        if (dDMembershipChangeListener == null) {
            throw new AssertionError((Object)"Listener cannot be null");
        }
        if (this.cdsAsyncRegistrationWorkManager == null) {
            this.initializeWorkManager();
        }
        this.timerManagerForRegistration = TimerManagerFactory.getTimerManagerFactory().getTimerManager(DDM_REGISTRATION_MANAGER_NAME, this.cdsAsyncRegistrationWorkManager);
        DD2Listener dD2Listener = new DD2Listener(dDMembershipChangeListener);
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("Scheduling initial registration for DD JNDI Name " + dDMembershipChangeListener.getDestinationName() + " providerIRL = " + dD2Listener.getProviderURL() + " isLocal =  " + dD2Listener.isLocal());
        }
        CDS cDS = this;
        synchronized (cDS) {
            this.pendingRegistration.put(dD2Listener.getListener(), dD2Listener);
            if (this.listenerRegistrar == null) {
                this.listenerRegistrar = this.timerManagerForRegistration.schedule((TimerListener)new DDListenerRegistrationTimerListener(), 500L, 500L);
            }
        }
        return dD2Listener;
    }

    public DDMemberInformation[] getDDMembershipInformation(DDMembershipChangeListener dDMembershipChangeListener) {
        DDMemberInformation[] dDMemberInformationArray;
        Context context;
        if (dDMembershipChangeListener == null) {
            throw new AssertionError((Object)"Listener cannot be null");
        }
        DD2Listener dD2Listener = new DD2Listener(dDMembershipChangeListener);
        String string = dDMembershipChangeListener.getDestinationName();
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("getSubject: before looking up " + string + " providerIRL = " + dD2Listener.getProviderURL() + " isLocal =  " + dD2Listener.isLocal());
        }
        if ((context = CDS.createInitialContext(dD2Listener, false)) == null) {
            this.startPolling(dD2Listener);
            return null;
        }
        Object object = this.lookupDestination(context, dD2Listener, false);
        if (object == null) {
            this.startPolling(dD2Listener);
            return null;
        }
        try {
            dDMemberInformationArray = this.processDD(context, dD2Listener, object);
        }
        catch (javax.jms.JMSException jMSException) {
            this.startPolling(dD2Listener);
            return null;
        }
        dD2Listener.setCurrentMemberList(dDMemberInformationArray);
        return dDMemberInformationArray;
    }

    private void moveListenerToPoller(HashMap hashMap, Object object) {
        DD2Listener dD2Listener = (DD2Listener)hashMap.remove(object);
        if (hashMap.size() == 0 && this.listenerRegistrar != null) {
            this.listenerRegistrar = null;
        }
        this.startPolling(dD2Listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupDDAndCalloutListener(HashMap hashMap, boolean bl) {
        CDS cDS = this;
        synchronized (cDS) {
            for (Object k : ((HashMap)hashMap.clone()).keySet()) {
                DDMemberInformation[] dDMemberInformationArray;
                DD2Listener dD2Listener = (DD2Listener)hashMap.get(k);
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("lookupDDAndCalloutListener ddl= " + dD2Listener + " isPoller=" + bl);
                }
                if (dD2Listener == null) continue;
                Context context = CDS.createInitialContext(dD2Listener, bl);
                if (context == null) {
                    if (bl) continue;
                    this.moveListenerToPoller(hashMap, k);
                    continue;
                }
                Object object = this.lookupDestination(context, dD2Listener, bl);
                if (object == null) {
                    if (bl) continue;
                    this.moveListenerToPoller(hashMap, k);
                    continue;
                }
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("lookupDDAndCalloutListener has successfully looked up the destination  with JNDI name " + dD2Listener.getDestinationName() + ", going to process the membership information");
                }
                try {
                    dDMemberInformationArray = this.processDD(context, dD2Listener, object);
                }
                catch (javax.jms.JMSException jMSException) {
                    dD2Listener.reportException((Exception)((Object)jMSException));
                    if (bl) continue;
                    this.moveListenerToPoller(hashMap, k);
                    continue;
                }
                if (!dD2Listener.isDD()) {
                    List list = this.dd2Listeners;
                    synchronized (list) {
                        this.dd2Listeners.remove(dD2Listener);
                    }
                }
                hashMap.remove(k);
                if (hashMap.size() == 0) {
                    if (bl) {
                        if (this.ddPoller != null) {
                            this.ddPoller.cancel();
                            this.ddPoller = null;
                        }
                    } else if (this.listenerRegistrar != null) {
                        this.listenerRegistrar = null;
                    }
                }
                dD2Listener.listChange(dDMemberInformationArray);
            }
        }
    }

    private static Context createInitialContext(DD2Listener dD2Listener, boolean bl) {
        Exception exception = null;
        final DD2Listener dD2Listener2 = dD2Listener;
        Context context = null;
        try {
            Context context2 = (Context)CrossDomainSecurityManager.runAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getSubjectFromListener(dD2Listener2), new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return dD2Listener2.getInitialContext();
                }
            });
            dD2Listener2.setState(0);
            context = context2;
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Successfully created the initial context for the JNDIName " + dD2Listener2.getDestinationName());
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            exception = privilegedActionException.getException();
        }
        catch (NamingException namingException) {
            exception = namingException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        if (exception != null) {
            if (bl) {
                dD2Listener2.incrementPollerRetryCount();
                if (dD2Listener.getPollerRetryCount() == 10) {
                    if (JMSDebug.JMSCDS.isDebugEnabled()) {
                        JMSDebug.JMSCDS.debug("From ddPoller: The initial context creation for the JNDI name " + dD2Listener.getDestinationName() + " has failed, and the poller has reached the retry limit for reporting error, calling out listener's onFailure ...");
                    }
                    if ((dD2Listener.getState() & 0) != 1) {
                        dD2Listener2.reportException(exception);
                    }
                }
            } else {
                if ((dD2Listener2.getState() & 0) != 1) {
                    dD2Listener2.reportException(exception);
                }
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("The initial context creation for JNDIName " + dD2Listener2.getDestinationName() + "has failed, going to start polling", (Throwable)exception);
                }
            }
        }
        return context;
    }

    private Object lookupDestination(Context context, DD2Listener dD2Listener, boolean bl) {
        Object object = null;
        Exception exception = null;
        try {
            final Context context2 = context;
            final DD2Listener dD2Listener2 = dD2Listener;
            object = CrossDomainSecurityManager.runAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getSubjectFromListener(dD2Listener), new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return context2.lookup(dD2Listener2.getDestinationName());
                }
            });
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("The destination JNDI lookup succeeded for " + dD2Listener.getDestinationName() + " destination = " + object + ", going to process the membership information");
            }
            if (!bl) {
                dD2Listener.setState(1);
            } else {
                dD2Listener.setState(2);
                dD2Listener.resetPollerRetryCount();
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            exception = privilegedActionException.getException();
        }
        catch (NamingException namingException) {
            exception = namingException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        if (exception != null) {
            if (bl) {
                dD2Listener.incrementPollerRetryCount();
                if (dD2Listener.getPollerRetryCount() == 10) {
                    if (JMSDebug.JMSCDS.isDebugEnabled()) {
                        JMSDebug.JMSCDS.debug("From ddPoller: The destination with JNDI name " + dD2Listener.getDestinationName() + " is not up and poller has reached the retry limit for reporting error, calling out listener's onFailure ...");
                    }
                    if ((dD2Listener.getState() & 2) != 1) {
                        dD2Listener.reportException(exception);
                    }
                }
            } else {
                if ((dD2Listener.getState() & 1) != 1) {
                    dD2Listener.reportException(exception);
                }
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("Initial destination lookup for the JNDI name " + dD2Listener.getDestinationName() + "has failed, going to start polling", (Throwable)exception);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDDMembershipChangeListener(DDMembershipChangeListener dDMembershipChangeListener) {
        if (dDMembershipChangeListener == null) {
            throw new AssertionError((Object)"Listener cannot be null");
        }
        String string = dDMembershipChangeListener.getDestinationName();
        DD2Listener dD2Listener = null;
        CDS cDS = this;
        synchronized (cDS) {
            dD2Listener = (DD2Listener)this.pendingRegistration.remove(dDMembershipChangeListener);
            if (dD2Listener != null) {
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("unregisterDDMembershipChangeListener: " + dDMembershipChangeListener + ". Removing the corresponding DD (JNDI name: " + string + ") which is currently " + " kept in pendingRegistration map");
                }
                if (this.pendingRegistration.size() == 0) {
                    this.listenerRegistrar = null;
                }
                return;
            }
        }
        cDS = this;
        synchronized (cDS) {
            dD2Listener = (DD2Listener)this.unsuccessfulDDLookup.remove(dDMembershipChangeListener);
            if (dD2Listener != null) {
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("unregisterDDMembershipChangeListener: " + dDMembershipChangeListener + ". Removing the corresponding DD (JNDI name: " + string + ") which is currently " + " kept in unsuccessfulDDLookup map");
                }
                if (this.unsuccessfulDDLookup.size() == 0) {
                    this.ddPoller = null;
                }
                return;
            }
        }
        cDS = this;
        synchronized (cDS) {
            List list = this.dd2Listeners;
            synchronized (list) {
                ListIterator listIterator = this.dd2Listeners.listIterator();
                while (listIterator.hasNext()) {
                    dD2Listener = (DD2Listener)listIterator.next();
                    if (dD2Listener.getListener() != dDMembershipChangeListener) continue;
                    if (JMSDebug.JMSCDS.isDebugEnabled()) {
                        JMSDebug.JMSCDS.debug("unregisterDDMembershipChangeListener: " + dDMembershipChangeListener + ". Removing the correponding DD (JNDI name: " + string + ") which is currently " + " kept in ddl map");
                    }
                    listIterator.remove();
                    if (dD2Listener.isLocal()) {
                        if (localCDSServer == null) {
                            throw new AssertionError((Object)"MDB says that it is local, but the CDS is not able to find server symbols");
                        }
                        localCDSServer.unregisterListener(dD2Listener);
                        continue;
                    }
                    localCDSProxy.unregisterListener(dD2Listener);
                }
            }
        }
    }

    private static DDMemberInformation[] processForeign(DD2Listener dD2Listener, Object object) {
        boolean bl = false;
        if (object instanceof Queue) {
            bl = true;
            if (object instanceof Topic) {
                try {
                    bl = ((Queue)object).getQueueName() != null;
                }
                catch (Throwable throwable) {
                    bl = false;
                }
            }
        }
        String string = bl ? new String("javax.jms.Queue") : (object instanceof Topic ? new String("javax.jms.Topic") : null);
        DDMemberInformation dDMemberInformation = new DDMemberInformation(null, string, dD2Listener.getDestinationName(), null, null, dD2Listener.getDestinationName(), null, null, null);
        DDMemberInformation[] dDMemberInformationArray = new DDMemberInformation[]{dDMemberInformation};
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("processDD(): The destination with JNDI name " + dD2Listener.getDestinationName() + " is processed as foreign destination");
        }
        return dDMemberInformationArray;
    }

    private static DDMemberInformation[] processNonDD(DD2Listener dD2Listener, Object object) {
        if (!(object instanceof DestinationImpl)) {
            return CDS.processForeign(dD2Listener, object);
        }
        DestinationImpl destinationImpl = (DestinationImpl)object;
        dD2Listener.setDestinationImpl(destinationImpl);
        DDMemberInformation[] dDMemberInformationArray = null;
        String string = null;
        String string2 = destinationImpl.getName();
        Object var6_6 = null;
        Object var7_7 = null;
        string = destinationImpl.isQueue() ? new String("javax.jms.Queue") : new String("javax.jms.Topic");
        DDMemberInformation dDMemberInformation = new DDMemberInformation(destinationImpl.getName(), string, dD2Listener.getDestinationName(), destinationImpl, null, dD2Listener.getDestinationName(), null, null, null);
        dDMemberInformationArray = new DDMemberInformation[]{dDMemberInformation};
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("processDD(): The destination with config name " + string2 + " is processed as physical destination");
        }
        return dDMemberInformationArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DDMemberInformation[] processDD(final Context context, final DD2Listener dD2Listener, Object object) throws javax.jms.JMSException {
        boolean bl = false;
        if (!(object instanceof DistributedDestinationImpl) || object instanceof DistributedDestinationImpl && ((DestinationImpl)object).isPre90()) {
            bl = true;
        }
        Exception exception = null;
        try {
            CrossDomainSecurityManager.runAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getSubjectFromListener(dD2Listener), new PrivilegedExceptionAction(){

                public Object run() throws NamingException, IOException {
                    CDS.this.checkForeign(context, dD2Listener);
                    return null;
                }
            });
            dD2Listener.setIsSecurityHandleReady(true);
        }
        catch (PrivilegedActionException privilegedActionException) {
            exception = privilegedActionException.getException();
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (NamingException namingException) {
            exception = namingException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        if (exception != null) {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("The destination JNDI lookup Link failed for " + dD2Listener.getJNDIName(), (Throwable)exception);
            }
            throw new JMSException(exception.getMessage(), (Throwable)exception);
        }
        if (bl) {
            dD2Listener.setIsDD(false);
            return CDS.processNonDD(dD2Listener, object);
        }
        dD2Listener.setDestinationImpl((DestinationImpl)object);
        dD2Listener.setIsDD(true);
        DDMemberInformation[] dDMemberInformationArray = null;
        String string = dD2Listener.getConfigName();
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("processDD(): The destination with config name " + string + " is being processed as distributed destination");
        }
        if (dD2Listener.isLocal()) {
            if (localCDSServer == null) {
                throw new AssertionError((Object)"MDB says that it is local, but the CDS is not able to find server symbols");
            }
            dDMemberInformationArray = localCDSServer.registerListener(dD2Listener);
        } else {
            dDMemberInformationArray = localCDSProxy.registerListener(dD2Listener);
        }
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("processDD(): The destination with config name " + string + " is a " + (dD2Listener.isLocal() ? "local" : "remote") + "distributed destination, " + " getLocalDDMemberInformation(" + string + ") returned " + dDMemberInformationArray.toString());
        }
        List list = this.dd2Listeners;
        synchronized (list) {
            this.dd2Listeners.add(dD2Listener);
        }
        return dDMemberInformationArray;
    }

    private void checkForeign(Context context, CDSListListener cDSListListener) throws NamingException, IOException {
        boolean bl = false;
        Object object = null;
        object = context.lookupLink(cDSListListener.getJNDIName());
        if (object instanceof ForeignOpaqueTag) {
            String string;
            Hashtable hashtable = ((ForeignOpaqueTag)object).getJNDIEnvironment();
            String string2 = string = hashtable == null ? "unknown" : (String)hashtable.get("java.naming.provider.url");
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Destination " + cDSListListener.getJNDIName() + " is instanceof ForeignOpaqueTag, with foreignJNDIEnv " + hashtable);
                JMSDebug.JMSCDS.debug("Changing context to foreign provider before registering listener " + (string == null ? "unknown" : string));
            }
            if (hashtable != null) {
                cDSListListener.setForeign(hashtable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeploymentsStart() {
        CDS cDS = this;
        synchronized (cDS) {
            if (this.ddPoller != null) {
                this.ddPoller.cancel();
                this.ddPoller = null;
                this.ddPoller = this.timerManager.schedule((TimerListener)new DDLookupTimerListener(), 0L, 10000L);
            }
            this.postDeploymentsStart = true;
        }
    }

    private static String getDestinationName(Destination destination) {
        if (destination instanceof DistributedDestinationImpl) {
            return ((DistributedDestinationImpl)destination).getInstanceName();
        }
        return ((DestinationImpl)destination).getName();
    }

    public static void dumpDDMITable(DDMemberInformation[] dDMemberInformationArray) {
        if (dDMemberInformationArray == null || dDMemberInformationArray.length == 0) {
            JMSDebug.JMSCDS.debug("Table is empty");
            return;
        }
        for (int i = 0; i < dDMemberInformationArray.length; ++i) {
            if (dDMemberInformationArray[i].getDestination() == null) continue;
            JMSDebug.JMSCDS.debug("Entry[" + i + "] = " + CDS.getDestinationName(dDMemberInformationArray[i].getDestination()) + ": " + " with destination id " + ((DestinationImpl)dDMemberInformationArray[i].getDestination()).getDestinationId() + ": " + dDMemberInformationArray[i]);
        }
    }

    public static void dumpChangeEvent(DDMembershipChangeEventImpl dDMembershipChangeEventImpl) {
        JMSDebug.JMSCDS.debug("Here is the added table:");
        CDS.dumpDDMITable(dDMembershipChangeEventImpl.getAddedDDMemberInformation());
        JMSDebug.JMSCDS.debug("Here is the removed table:");
        CDS.dumpDDMITable(dDMembershipChangeEventImpl.getRemovedDDMemberInformation());
    }

    private static boolean unchanged(DDMemberInformation dDMemberInformation, DDMemberInformation dDMemberInformation2) {
        if (dDMemberInformation.isProductionPaused() != dDMemberInformation2.isProductionPaused()) {
            return false;
        }
        if (dDMemberInformation.isInsertionPaused() != dDMemberInformation2.isInsertionPaused()) {
            return false;
        }
        if (dDMemberInformation.isConsumptionPaused() != dDMemberInformation2.isConsumptionPaused()) {
            return false;
        }
        DestinationImpl destinationImpl = (DestinationImpl)dDMemberInformation.getDestination();
        DestinationImpl destinationImpl2 = (DestinationImpl)dDMemberInformation2.getDestination();
        if (!destinationImpl.getDestinationId().equals(destinationImpl2.getDestinationId())) {
            return false;
        }
        if (!destinationImpl.getDispatcherId().equals(destinationImpl2.getDispatcherId())) {
            return false;
        }
        return destinationImpl.getServerName().equals(destinationImpl2.getServerName());
    }

    private static DDMembershipChangeEventImpl makeChangeEvent(boolean bl, String string, String string2, DDMemberInformation[] dDMemberInformationArray, DDMemberInformation[] dDMemberInformationArray2) {
        Object object;
        Object object22;
        if (dDMemberInformationArray2 == null) {
            if (dDMemberInformationArray == null) {
                return null;
            }
            return new DDMembershipChangeEventImpl(bl, string, string2, dDMemberInformationArray, dDMemberInformationArray2);
        }
        if (dDMemberInformationArray == null) {
            return new DDMembershipChangeEventImpl(bl, string, string2, dDMemberInformationArray, dDMemberInformationArray2);
        }
        HashMap<String, DDMemberInformation> hashMap = new HashMap<String, DDMemberInformation>();
        for (int i = 0; dDMemberInformationArray != null && i < dDMemberInformationArray.length; ++i) {
            hashMap.put(dDMemberInformationArray[i].getMemberName(), dDMemberInformationArray[i]);
        }
        HashMap<String, DDMemberInformation> hashMap2 = new HashMap<String, DDMemberInformation>();
        for (int i = 0; dDMemberInformationArray2 != null && i < dDMemberInformationArray2.length; ++i) {
            hashMap2.put(dDMemberInformationArray2[i].getMemberName(), dDMemberInformationArray2[i]);
        }
        LinkedList<DDMemberInformation[]> linkedList = new LinkedList<DDMemberInformation[]>();
        LinkedList<DDMemberInformation[]> linkedList2 = new LinkedList<DDMemberInformation[]>();
        for (Object object22 : hashMap.values()) {
            object = (DDMemberInformation[])hashMap2.get(object22.getMemberName());
            if (object == null) {
                linkedList.add((DDMemberInformation[])object22);
                continue;
            }
            if (CDS.unchanged((DDMemberInformation)object22, (DDMemberInformation)object)) continue;
            linkedList.add((DDMemberInformation[])object22);
            linkedList2.add((DDMemberInformation[])object);
        }
        for (Object object22 : hashMap2.values()) {
            object = (DDMemberInformation)hashMap.get(object22.getMemberName());
            if (object != null) continue;
            linkedList2.add((DDMemberInformation[])object22);
        }
        if (linkedList.size() == 0 && linkedList2.size() == 0) {
            return null;
        }
        object22 = null;
        if (linkedList.size() != 0) {
            object22 = linkedList.toArray(new DDMemberInformation[0]);
        }
        object = null;
        if (linkedList2.size() != 0) {
            object = linkedList2.toArray(new DDMemberInformation[0]);
        }
        return new DDMembershipChangeEventImpl(bl, string, string2, (DDMemberInformation[])object22, (DDMemberInformation[])object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ddLookup() {
        CDS cDS;
        CDS cDS2 = this;
        synchronized (cDS2) {
            if (this.ddLookupIsRunning) {
                return;
            }
            this.ddLookupIsRunning = true;
        }
        try {
            this.lookupDDAndCalloutListener(this.unsuccessfulDDLookup, true);
            Object var4_3 = null;
            cDS = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            CDS cDS3 = this;
            synchronized (cDS3) {
                this.ddLookupIsRunning = false;
            }
            throw throwable;
        }
        synchronized (cDS) {
            this.ddLookupIsRunning = false;
        }
    }

    static {
        localCDSProxy = CDSLocalProxy.getSingleton();
        try {
            localCDSServer = (CDSListProvider)Class.forName("weblogic.jms.common.CDSServer").getDeclaredMethod("getSingleton", null).invoke((Object)null, (Object[])null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 8;
        String string = System.getProperty("weblogic.jms.CDS.AsyncRegisterationThreadCount", "8");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        DEFAULT_CDS_ASYNC_REGISTRATION_THREAD_COUNT = n;
    }

    private final class DDLookupTimerListener
    implements NakedTimerListener {
        DDLookupTimerListener() {
        }

        public void timerExpired(Timer timer) {
            CDS.this.ddLookup();
        }
    }

    private final class DD2Listener
    implements CDSListListener,
    Runnable,
    CDSSecurityHandle {
        private DDMembershipChangeListener listener;
        private DDMemberInformation[] currentMemberList = null;
        private DDMemberInformation[] pendingMemberList = null;
        private DestinationImpl dImpl;
        private boolean isDD;
        private boolean running;
        private boolean moreToProcess;
        private AbstractSubject foreignSubject;
        private String providerURL;
        private Context foreignContext;
        private AbstractSubject listenerThreadSubject;
        private int pollerRetryCount = 0;
        private int state;
        private final Object stateLock = new Object();
        private Exception lastExceptionReported = null;
        private int privilegedActionExceptionReported = 0;
        private int namingExceptionReported = 0;
        private int ioExceptionReported = 0;
        private int unknownExceptionReported = 0;
        private boolean isSecurityHandleReady;
        private boolean isForeignJMSServer;
        private boolean isRemoteDomain;
        private Object foreignContextLock = new Object();

        public DD2Listener(DDMembershipChangeListener dDMembershipChangeListener) {
            this.listener = dDMembershipChangeListener;
            this.providerURL = dDMembershipChangeListener.getProviderURL();
            this.listenerThreadSubject = CrossDomainSecurityManager.getCurrentSubject();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(int n) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state |= n;
            }
        }

        public int getState() {
            return this.state;
        }

        public void incrementPollerRetryCount() {
            ++this.pollerRetryCount;
        }

        public void resetPollerRetryCount() {
            this.pollerRetryCount = 0;
        }

        public int getPollerRetryCount() {
            return this.pollerRetryCount;
        }

        public synchronized void setIsSecurityHandleReady(boolean bl) {
            this.isSecurityHandleReady = bl;
        }

        public void reportException(Exception exception) {
            if (exception instanceof PrivilegedActionException) {
                ++this.privilegedActionExceptionReported;
                if (this.privilegedActionExceptionReported > 1) {
                    return;
                }
            }
            if (exception instanceof NamingException) {
                ++this.namingExceptionReported;
                if (this.namingExceptionReported > 1) {
                    return;
                }
            }
            if (exception instanceof IOException) {
                ++this.ioExceptionReported;
                if (this.ioExceptionReported > 1) {
                    return;
                }
            }
            this.listener.onFailure(this.getJNDIName(), exception);
            this.lastExceptionReported = exception;
        }

        public Exception getLastExceptionReported() {
            return this.lastExceptionReported;
        }

        public int getIOExceptionReported() {
            return this.ioExceptionReported;
        }

        public int getNamingExceptionReported() {
            return this.namingExceptionReported;
        }

        public int getPrivilegedActionExceptionReported() {
            return this.privilegedActionExceptionReported;
        }

        public int getUnknownExceptionReported() {
            return this.unknownExceptionReported;
        }

        public void setIsDD(boolean bl) {
            this.isDD = bl;
        }

        public boolean isDD() {
            return this.isDD;
        }

        public String getDestinationName() {
            return this.listener.getDestinationName();
        }

        public String getProviderURL() {
            return this.providerURL;
        }

        public String getJNDIName() {
            return this.listener.getDestinationName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setForeign(Hashtable hashtable) throws NamingException, IOException {
            assert (hashtable != null);
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>(hashtable);
            if (hashtable.get("java.naming.factory.initial") == null) {
                hashtable2.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            }
            hashtable2.put("weblogic.jndi.disableLoggingOfWarningMsg", "true");
            Object object = this.foreignContextLock;
            synchronized (object) {
                this.foreignContext = new InitialContext(hashtable2);
            }
            AbstractSubject abstractSubject = CrossDomainSecurityManager.getCurrentSubject();
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug(" setForeign env = " + hashtable2);
            }
            this.providerURL = (String)hashtable2.get("java.naming.provider.url");
            boolean bl = false;
            if (this.providerURL != null && hashtable2.get("java.naming.factory.initial") != null && ((String)hashtable2.get("java.naming.factory.initial")).indexOf("weblogic") != -1) {
                bl = CrossDomainSecurityManager.getCrossDomainSecurityUtil().isRemoteDomain(this.providerURL);
            }
            DD2Listener dD2Listener = this;
            synchronized (dD2Listener) {
                this.foreignSubject = abstractSubject;
                this.isForeignJMSServer = true;
                this.isRemoteDomain = bl;
                if (hashtable2.get("java.naming.security.principal") == null && this.isRemoteDomain) {
                    if (JMSDebug.JMSCDS.isDebugEnabled()) {
                        JMSDebug.JMSCDS.debug(" setForeign is remote domain use anonynous");
                    }
                    this.foreignSubject = SubjectManager.getSubjectManager().getAnonymousSubject();
                }
            }
        }

        public DDMembershipChangeListener getListener() {
            return this.listener;
        }

        public Context getInitialContext() throws NamingException {
            return this.getInitialContextFromListener();
        }

        public AbstractSubject getSubject() {
            return this.listener.getSubject();
        }

        public boolean isLocal() {
            return this.providerURL == null || this.providerURL.length() == 0;
        }

        public String getConfigName() {
            if (this.dImpl == null) {
                return null;
            }
            return this.dImpl.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Context getContext() throws NamingException {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug(" getContext() foreign = " + this.foreignContext);
            }
            Object object = this.foreignContextLock;
            synchronized (object) {
                if (this.foreignContext != null) {
                    return this.foreignContext;
                }
            }
            return this.getInitialContextFromListener();
        }

        private Context getInitialContextFromListener() throws NamingException {
            try {
                return (Context)CrossDomainSecurityManager.runAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(this.providerURL, this.listenerThreadSubject), new PrivilegedExceptionAction(){

                    public Object run() throws NamingException {
                        return DD2Listener.this.listener.getInitialContext();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof NamingException) {
                    throw (NamingException)exception;
                }
                throw new NamingException(exception.getMessage());
            }
        }

        public synchronized DDMemberInformation[] getCurrentMemberList() {
            return this.currentMemberList;
        }

        public synchronized void setCurrentMemberList(DDMemberInformation[] dDMemberInformationArray) {
            this.currentMemberList = dDMemberInformationArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void listChange(DDMemberInformation[] dDMemberInformationArray) {
            DD2Listener dD2Listener = this;
            synchronized (dD2Listener) {
                if (this.pendingMemberList == dDMemberInformationArray || this.currentMemberList == dDMemberInformationArray) {
                    return;
                }
                this.pendingMemberList = dDMemberInformationArray;
                this.moreToProcess = true;
                if (this.running) {
                    return;
                }
                this.running = true;
            }
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void distributedDestinationGone(DispatcherId dispatcherId) {
            ArrayList<DDMemberInformation> arrayList = new ArrayList<DDMemberInformation>();
            if (this.currentMemberList != null) {
                DDMemberInformation dDMemberInformation = null;
                DD2Listener dD2Listener = this;
                synchronized (dD2Listener) {
                    for (int i = 0; i < this.currentMemberList.length; ++i) {
                        DDMemberInformation dDMemberInformation2 = this.currentMemberList[i];
                        DispatcherId dispatcherId2 = ((DestinationImpl)dDMemberInformation2.getDestination()).getDispatcherId();
                        if (dispatcherId2.equals(dispatcherId)) {
                            dDMemberInformation = dDMemberInformation2;
                            continue;
                        }
                        arrayList.add(dDMemberInformation2);
                    }
                }
                if (dDMemberInformation != null) {
                    this.listChange(arrayList.toArray(new DDMemberInformation[arrayList.size()]));
                }
            }
            CDS.this.startPolling(this);
        }

        public DestinationImpl getDestinationImpl() {
            return this.dImpl;
        }

        public DistributedDestinationImpl getDistributedDestinationImpl() {
            return (DistributedDestinationImpl)this.dImpl;
        }

        public void setDestinationImpl(DestinationImpl destinationImpl) {
            this.dImpl = destinationImpl;
        }

        public synchronized boolean isRemoteDomain() {
            return this.isRemoteDomain;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.foreignContextLock;
            synchronized (object) {
                try {
                    if (this.foreignContext != null) {
                        this.foreignContext.close();
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }

        public synchronized boolean isReady() {
            return this.isSecurityHandleReady;
        }

        public synchronized boolean isForeignJMSServer() {
            if (!this.isSecurityHandleReady) {
                throw new IllegalStateException("The handle is not ready");
            }
            return this.isForeignJMSServer;
        }

        public synchronized AbstractSubject getForeignSubject() {
            if (!this.isSecurityHandleReady) {
                throw new IllegalStateException("The handle is not ready");
            }
            return this.foreignSubject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DDMembershipChangeEventImpl dDMembershipChangeEventImpl = null;
            while (true) {
                DD2Listener dD2Listener;
                block13: {
                    dD2Listener = this;
                    synchronized (dD2Listener) {
                        dDMembershipChangeEventImpl = CDS.makeChangeEvent(this.isDD(), this.getConfigName(), this.getJNDIName(), this.pendingMemberList, this.currentMemberList);
                        if (dDMembershipChangeEventImpl == null) {
                            this.running = false;
                            return;
                        }
                        this.currentMemberList = this.pendingMemberList;
                        this.moreToProcess = false;
                    }
                    if (JMSDebug.JMSCDS.isDebugEnabled()) {
                        CDS.dumpChangeEvent(dDMembershipChangeEventImpl);
                    }
                    if (JMSDebug.JMSCDS.isDebugEnabled()) {
                        JMSDebug.JMSCDS.debug("informDDMembershipChangeLocally(): Invoking the onMembershipChange() of the local  DDMembershipChangeListener " + this.listener + " for DD JNDIName " + this.getJNDIName());
                    }
                    try {
                        this.listener.onDDMembershipChange(dDMembershipChangeEventImpl);
                    }
                    catch (Throwable throwable) {
                        if (!JMSDebug.JMSCDS.isDebugEnabled()) break block13;
                        JMSDebug.JMSCDS.debug("Exception when calling user code: ", throwable);
                    }
                }
                dD2Listener = this;
                synchronized (dD2Listener) {
                    if (!this.moreToProcess) {
                        this.running = false;
                        break;
                    }
                }
            }
        }
    }

    private final class DDListenerRegistrationTimerListener
    implements NakedTimerListener {
        DDListenerRegistrationTimerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            Timer timer2 = null;
            Boolean bl = false;
            CDS cDS = CDS.this;
            synchronized (cDS) {
                if (CDS.this.postDeploymentsStart) {
                    bl = CDS.this.postDeploymentsStart;
                    if (CDS.this.listenerRegistrar != null) {
                        timer2 = CDS.this.listenerRegistrar;
                        CDS.this.listenerRegistrar = null;
                    }
                }
            }
            if (timer2 != null) {
                timer2.cancel();
            }
            if (bl.booleanValue() || !KernelStatus.isServer()) {
                CDS.this.lookupDDAndCalloutListener(CDS.this.pendingRegistration, false);
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("ddListenerRegistrar has finished registering all of the listeners pendingRegistration map.");
                }
            }
        }
    }
}

