/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.common.CDSListListener;
import weblogic.jms.common.CDSServer;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DDMemberInformation;
import weblogic.jms.common.DDMembershipCancelRequest;
import weblogic.jms.common.DDMembershipPushRequest;
import weblogic.jms.common.DDMembershipRequest;
import weblogic.jms.common.DDMembershipResponse;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.dispatcher.DispatcherAdapter;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.CrossDomainManager;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherCommon;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherWrapperState;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.security.subject.AbstractSubject;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManagerFactory;

public final class CDSRemoteProxy
implements Invocable,
JMSPeerGoneListener {
    private final List listenerDispatcherList = Collections.synchronizedList(new LinkedList());
    private static CDSRemoteProxy singleton = new CDSRemoteProxy();
    private transient int refCount;

    public static synchronized CDSRemoteProxy getSingleton() {
        return singleton;
    }

    private int processDDMembershipRequest(DDMembershipRequest dDMembershipRequest) throws javax.jms.JMSException {
        String string = dDMembershipRequest.getDDConfigName();
        String string2 = dDMembershipRequest.getDDJndiName();
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("processDDMembershipRequest(): configName: " + string + " and jndiName: " + string2);
        }
        DispatcherWrapper dispatcherWrapper = dDMembershipRequest.getDispatcherWrapper();
        JMSDispatcher jMSDispatcher = null;
        try {
            jMSDispatcher = JMSDispatcherManager.addDispatcherReference(dispatcherWrapper);
            jMSDispatcher.addDispatcherPeerGoneListener(this);
        }
        catch (DispatcherException dispatcherException) {
            throw new JMSException(dispatcherException.getMessage(), (Throwable)dispatcherException);
        }
        ListenerDispatcher listenerDispatcher = new ListenerDispatcher(string, string2, jMSDispatcher);
        this.listenerDispatcherList.add(listenerDispatcher);
        DDMemberInformation[] dDMemberInformationArray = listenerDispatcher.getDDMemberInformation();
        DDMembershipResponse dDMembershipResponse = new DDMembershipResponse(dDMemberInformationArray);
        dDMembershipRequest.setResult(dDMembershipResponse);
        dDMembershipRequest.setState(Integer.MAX_VALUE);
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (dDMemberInformationArray != null) {
                for (int i = 0; i < dDMemberInformationArray.length; ++i) {
                    stringBuffer.append("\nMember[" + i + "]=" + dDMemberInformationArray[i].toString());
                }
            } else {
                stringBuffer.append("null");
            }
            JMSDebug.JMSCDS.debug("processDDMembershipRequest(): Returning the DDMembershipResponse back to the caller with local distributed destination member information: " + stringBuffer.toString());
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processDDMembershipCancelRequest(DDMembershipCancelRequest dDMembershipCancelRequest) {
        String string = dDMembershipCancelRequest.getDDJndiName();
        List list = this.listenerDispatcherList;
        synchronized (list) {
            ListIterator listIterator = this.listenerDispatcherList.listIterator();
            while (listIterator.hasNext()) {
                ListenerDispatcher listenerDispatcher = (ListenerDispatcher)listIterator.next();
                if (!listenerDispatcher.getJNDIName().equals(string)) continue;
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("processDDMembershipCancelRequest(): Removing the remote dispatcher " + listenerDispatcher + ", from the remoteDispatchers map for DD JNDI name " + string);
                }
                listIterator.remove();
                listenerDispatcher.peerGone();
            }
        }
        return Integer.MAX_VALUE;
    }

    public int invoke(Request request) throws Throwable {
        switch (request.getMethodId()) {
            case 18455: {
                return this.processDDMembershipRequest((DDMembershipRequest)request);
            }
            case 18967: {
                return this.processDDMembershipCancelRequest((DDMembershipCancelRequest)request);
            }
        }
        throw new JMSException("No such method " + request.getMethodId());
    }

    public JMSID getJMSID() {
        return null;
    }

    public ID getId() {
        return null;
    }

    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    public int incrementRefCount() {
        return ++this.refCount;
    }

    public int decrementRefCount() {
        return --this.refCount;
    }

    public void dispatcherPeerGone(Exception exception, Dispatcher dispatcher) {
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("CDSServer.jmsPeerGone() " + dispatcher.getId());
        }
        this.peerGone(dispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void peerGone(Dispatcher dispatcher) {
        if (dispatcher.getId() == null) {
            return;
        }
        List list = this.listenerDispatcherList;
        synchronized (list) {
            ListIterator listIterator = this.listenerDispatcherList.listIterator();
            while (listIterator.hasNext()) {
                ListenerDispatcher listenerDispatcher = (ListenerDispatcher)listIterator.next();
                DispatcherCommon dispatcherCommon = listenerDispatcher != null && listenerDispatcher.getDispatcher() != null ? ((DispatcherAdapter)listenerDispatcher.getDispatcher()).getDelegate() : null;
                if (dispatcherCommon == null || dispatcherCommon.getId() == null || !dispatcherCommon.getId().equals(dispatcher.getId()) || !CrossDomainManager.getCrossDomainUtil().isSameDomain((Dispatcher)dispatcherCommon, dispatcher)) continue;
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("peerGone(): Dispatcher " + listenerDispatcher.getDispatcher() + " for DD (JNDI Name: " + listenerDispatcher.getJNDIName() + ") is affected by this peerGone, will be removed " + "from remoteDispatchers map " + "- CALLEE TO THE PEER case");
                }
                listIterator.remove();
                listenerDispatcher.distributedDestinationGone(dispatcher.getId());
            }
        }
    }

    private static boolean supportDispatchWithId(JMSDispatcher jMSDispatcher) {
        PeerInfo peerInfo = null;
        Dispatcher dispatcher = null;
        if (jMSDispatcher instanceof DispatcherAdapter) {
            dispatcher = ((DispatcherAdapter)jMSDispatcher).getDelegate();
            if (dispatcher instanceof DispatcherWrapperState) {
                peerInfo = ((DispatcherWrapperState)dispatcher).getPeerInfo();
            }
        } else if (jMSDispatcher instanceof DispatcherWrapperState) {
            peerInfo = ((DispatcherWrapperState)((Object)jMSDispatcher)).getPeerInfo();
        }
        return peerInfo != null && peerInfo.compareTo((Object)PeerInfo.VERSION_910) >= 0;
    }

    private static final class ListenerDispatcher
    implements CDSListListener,
    TimerListener {
        private JMSDispatcher dispatcher;
        private String jndiName;
        private String configName;
        private DDMemberInformation[] ddMemberInformation;
        private Timer timer;
        private long lastTime = 0L;
        private Object timerLock = new Object();
        private boolean timerSet = false;
        private AbstractSubject subject = null;

        public ListenerDispatcher(String string, String string2, JMSDispatcher jMSDispatcher) throws javax.jms.JMSException {
            this.dispatcher = jMSDispatcher;
            this.jndiName = string2;
            this.configName = string;
            this.ddMemberInformation = CDSServer.getSingleton().registerListener(this);
            this.subject = CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(jMSDispatcher);
        }

        public JMSDispatcher getDispatcher() {
            return this.dispatcher;
        }

        public DDMemberInformation[] getDDMemberInformation() {
            return this.ddMemberInformation;
        }

        public AbstractSubject getSubject() {
            return this.subject;
        }

        public AbstractSubject getForeignSubject() throws NamingException {
            return null;
        }

        public void setForeign(Hashtable hashtable) {
        }

        public boolean isLocal() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void listChange(DDMemberInformation[] dDMemberInformationArray) {
            long l = 0L;
            this.ddMemberInformation = dDMemberInformationArray;
            Object object = this.timerLock;
            synchronized (object) {
                if (!this.timerSet) {
                    long l2;
                    this.timerSet = true;
                    l = this.lastTime == 0L ? 0L : ((l2 = System.currentTimeMillis()) - this.lastTime > 3000L ? 0L : 3000L - (l2 - this.lastTime));
                    if (l == 0L) {
                        this.timerExpired(null);
                    } else {
                        this.timer = this.getTimerManager().schedule((TimerListener)this, l);
                    }
                }
            }
        }

        public void distributedDestinationGone(DispatcherId dispatcherId) {
            block4: {
                if (this.dispatcher == null) {
                    return;
                }
                DispatcherWrapper dispatcherWrapper = JMSDispatcherManager.getLocalDispatcherWrapper();
                final DDMembershipCancelRequest dDMembershipCancelRequest = new DDMembershipCancelRequest(this.jndiName, dispatcherWrapper);
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("Dispatching DDMembershipCancelRequest for " + this.jndiName);
                }
                final JMSDispatcher jMSDispatcher = this.dispatcher;
                try {
                    CrossDomainSecurityManager.doAs(this.subject, new PrivilegedExceptionAction(){

                        public Object run() throws javax.jms.JMSException {
                            if (CDSRemoteProxy.supportDispatchWithId(jMSDispatcher)) {
                                jMSDispatcher.dispatchNoReplyWithId(dDMembershipCancelRequest, ListenerDispatcher.this.jndiName.hashCode());
                            } else {
                                jMSDispatcher.dispatchNoReply(dDMembershipCancelRequest);
                            }
                            return null;
                        }
                    });
                }
                catch (javax.jms.JMSException jMSException) {
                    if (!JMSDebug.JMSCDS.isDebugEnabled()) break block4;
                    JMSDebug.JMSCDS.debug("Exception in dispatching DDMembershipCancelRequest for " + this.jndiName, (Throwable)jMSException);
                }
            }
        }

        public DistributedDestinationImpl getDistributedDestinationImpl() {
            return null;
        }

        public Context getContext() {
            return null;
        }

        public String getProviderURL() {
            return null;
        }

        public String getJNDIName() {
            return this.jndiName;
        }

        public String getConfigName() {
            return this.configName;
        }

        public void peerGone() {
            CDSServer.getSingleton().unregisterListener(this);
            this.dispatcher = null;
            if (this.timer != null) {
                this.timer.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            block7: {
                final JMSDispatcher jMSDispatcher = this.dispatcher;
                if (jMSDispatcher == null) {
                    return;
                }
                Object object = this.timerLock;
                synchronized (object) {
                    this.lastTime = System.currentTimeMillis();
                    this.timerSet = false;
                }
                object = JMSDispatcherManager.getLocalDispatcherWrapper();
                final DDMembershipPushRequest dDMembershipPushRequest = new DDMembershipPushRequest(this.configName, this.jndiName, this.ddMemberInformation, (DispatcherWrapper)object);
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("Dispatching DDMembershipPushRequest for " + this.jndiName);
                }
                try {
                    CrossDomainSecurityManager.doAs(this.subject, new PrivilegedExceptionAction(){

                        public Object run() throws javax.jms.JMSException {
                            if (CDSRemoteProxy.supportDispatchWithId(jMSDispatcher)) {
                                jMSDispatcher.dispatchNoReplyWithId(dDMembershipPushRequest, ListenerDispatcher.this.jndiName.hashCode());
                            } else {
                                jMSDispatcher.dispatchNoReply(dDMembershipPushRequest);
                            }
                            return null;
                        }
                    });
                }
                catch (javax.jms.JMSException jMSException) {
                    if (!JMSDebug.JMSCDS.isDebugEnabled()) break block7;
                    JMSDebug.JMSCDS.debug("Exception in dispatching DDMembershipPushRequest for " + this.jndiName, (Throwable)jMSException);
                }
            }
        }

        private TimerManager getTimerManager() {
            return TimerManagerFactory.getTimerManagerFactory().getTimerManager("weblogic.jms.common.CDSRemoteProxy" + this.configName, WorkManagerFactory.getInstance().getSystem());
        }
    }
}

