/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.dispatcher.Invocable;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;

public final class CDSRouter
implements Invocable {
    private static Invocable remoteProxy;
    private static Invocable localProxy;
    private static CDSRouter singleton;

    public static CDSRouter getSingleton() {
        return singleton;
    }

    public int invoke(Request request) throws Throwable {
        switch (request.getMethodId()) {
            case 18455: {
                if (remoteProxy != null) {
                    return remoteProxy.invoke(request);
                }
                throw new JMSException("No such method " + request.getMethodId());
            }
            case 18711: {
                return localProxy.invoke(request);
            }
            case 18967: {
                if (remoteProxy != null) {
                    remoteProxy.invoke(request);
                }
                return localProxy.invoke(request);
            }
        }
        throw new JMSException("No such method " + request.getMethodId());
    }

    public JMSID getJMSID() {
        return null;
    }

    public ID getId() {
        return null;
    }

    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    static {
        singleton = new CDSRouter();
        try {
            remoteProxy = (Invocable)Class.forName("weblogic.jms.common.CDSRemoteProxy").getDeclaredMethod("getSingleton", null).invoke(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            localProxy = (Invocable)Class.forName("weblogic.jms.common.CDSLocalProxy").getDeclaredMethod("getSingleton", null).invoke(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

