/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.security.AccessController;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.jms.JMSException;
import weblogic.jms.common.CDS;
import weblogic.jms.common.CDSListListener;
import weblogic.jms.common.CDSListProvider;
import weblogic.jms.common.DDMemberInformation;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dd.DDMember;
import weblogic.jms.dd.DDStatusListener;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class CDSServer
implements CDSListProvider {
    private final List listeners = Collections.synchronizedList(new LinkedList());
    private static CDSServer singleton = new CDSServer();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static ServerRuntimeMBean serverRuntimeMBean;

    public static synchronized CDSServer getSingleton() {
        block3: {
            if (serverRuntimeMBean == null) {
                try {
                    serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
                }
                catch (Exception exception) {
                    if (!JMSDebug.JMSCDS.isDebugEnabled()) break block3;
                    JMSDebug.JMSCDS.debug("Failed to get server runtime mbean:" + exception);
                }
            }
        }
        return singleton;
    }

    public static TargetMBean getDestinationTarget(DomainMBean domainMBean, Object object) {
        if (!(object instanceof DestinationImpl)) {
            return null;
        }
        String string = ((DestinationImpl)object).getServerName();
        JMSServerMBean jMSServerMBean = domainMBean.lookupJMSServer(string);
        if (jMSServerMBean == null) {
            return null;
        }
        TargetMBean[] targetMBeanArray = jMSServerMBean.getTargets();
        if (targetMBeanArray == null) {
            return null;
        }
        return targetMBeanArray[0];
    }

    private String getLocalClusterName() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        if (serverMBean.getCluster() != null) {
            return serverMBean.getCluster().getName();
        }
        return null;
    }

    public synchronized DDMemberInformation[] registerListener(CDSListListener cDSListListener) throws JMSException {
        DDHandlerChangeListener dDHandlerChangeListener = new DDHandlerChangeListener(cDSListListener);
        this.listeners.add(dDHandlerChangeListener);
        return dDHandlerChangeListener.getDDMemberInformation();
    }

    public synchronized void unregisterListener(CDSListListener cDSListListener) {
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext()) {
            DDHandlerChangeListener dDHandlerChangeListener = (DDHandlerChangeListener)listIterator.next();
            if (dDHandlerChangeListener.getListener() != cDSListListener) continue;
            dDHandlerChangeListener.quit();
            listIterator.remove();
            break;
        }
    }

    private final class DDHandlerChangeListener
    implements DDStatusListener {
        private final DDHandler ddHandler;
        private final CDSListListener listener;

        public DDHandlerChangeListener(CDSListListener cDSListListener) throws JMSException {
            this.ddHandler = DDManager.findDDHandlerByDDName(cDSListListener.getConfigName());
            if (this.ddHandler == null) {
                throw new JMSException("There is no DD named " + cDSListListener.getConfigName());
            }
            this.listener = cDSListListener;
            this.ddHandler.addStatusListener(this, 19);
        }

        public CDSListListener getListener() {
            return this.listener;
        }

        public void quit() {
            this.ddHandler.removeStatusListener(this);
        }

        private void waitForServerUp() {
            int n = 0;
            if (serverRuntimeMBean == null) {
                return;
            }
            while (serverRuntimeMBean.getStateVal() != 2 && serverRuntimeMBean.getStateVal() != 7 && serverRuntimeMBean.getStateVal() != 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++n < 10) continue;
                break;
            }
        }

        public synchronized DDMemberInformation[] getDDMemberInformation() {
            LinkedList<DDMemberInformation> linkedList = new LinkedList<DDMemberInformation>();
            Iterator iterator = this.ddHandler.memberCloneIterator();
            while (iterator.hasNext()) {
                DDMember dDMember = (DDMember)iterator.next();
                if (!dDMember.isUp()) continue;
                DestinationImpl destinationImpl = new DestinationImpl(this.ddHandler.isQueue() ? 1 : 2, dDMember.getJMSServerName(), dDMember.getPersistentStoreName(), dDMember.getName(), this.ddHandler.getApplicationName(), this.ddHandler.getEARModuleName(), dDMember.getBackEndId(), dDMember.getDestinationId(), dDMember.getDispatcherId());
                linkedList.add(new DDMemberInformation(this.ddHandler.getName(), this.ddHandler.isQueue() ? new String("javax.jms.Queue") : new String("javax.jms.Topic"), this.ddHandler.getJNDIName(), this.ddHandler.getForwardingPolicy(), destinationImpl, dDMember.getWLSServerName(), dDMember.getGlobalJNDIName(), dDMember.getLocalJNDIName(), CDSServer.this.getLocalClusterName(), dDMember.getMigratableTargetName(), dDMember.getDomainName(), dDMember.isConsumptionPaused(), dDMember.isInsertionPaused(), dDMember.isProductionPaused(), true));
            }
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                if (linkedList.size() == 0) {
                    JMSDebug.JMSCDS.debug("list is null");
                } else {
                    JMSDebug.JMSCDS.debug("list has in it:");
                    CDS.dumpDDMITable(linkedList.toArray(new DDMemberInformation[0]));
                }
            }
            return linkedList.toArray(new DDMemberInformation[0]);
        }

        public void statusChangeNotification(DDHandler dDHandler, int n) {
            if ((n & 0x10) != 0) {
                this.quit();
                this.listener.distributedDestinationGone(null);
            } else {
                this.waitForServerUp();
                this.listener.listChange(this.getDDMemberInformation());
            }
        }
    }
}

