/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jms.JMSException;
import weblogic.jms.common.ClientCrossDomainSecurityUtil;
import weblogic.jms.common.CrossDomainSecurityUtil;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public final class CrossDomainSecurityManager {
    private static final String THICK_SUBJECT_MANAGER = "weblogic.security.service.SubjectManagerImpl";
    private static final String IIOPCLIENT_SUBJECT_MANAGER = "weblogic.corba.client.security.SubjectManagerImpl";
    private static final String T3CLIENT_SUBJECT_MANAGER = "weblogic.security.subject.SubjectManager";
    private static boolean initialized;
    private static final AbstractSubject kernelID;
    public static CrossDomainSecurityUtil util;

    private static final AbstractSubject getKernelIdentity() {
        try {
            CrossDomainSecurityManager.ensureSubjectManagerInitialized();
            return (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    public static CrossDomainSecurityUtil getCrossDomainSecurityUtil() {
        return util;
    }

    public static void setCrossDomainSecurityUtil(CrossDomainSecurityUtil crossDomainSecurityUtil) {
        util = crossDomainSecurityUtil;
    }

    public static void ensureSubjectManagerInitialized() {
        Method method;
        Class<?> clazz;
        block13: {
            if (initialized) {
                return;
            }
            try {
                clazz = Class.forName(THICK_SUBJECT_MANAGER, true, ClassLoader.getSystemClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = Class.forName(IIOPCLIENT_SUBJECT_MANAGER, true, ClassLoader.getSystemClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    try {
                        clazz = Class.forName(T3CLIENT_SUBJECT_MANAGER, true, ClassLoader.getSystemClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        if (SubjectManager.getSubjectManager() != null) {
                            clazz = SubjectManager.getSubjectManager().getClass();
                            break block13;
                        }
                        throw new AssertionError((Object)classNotFoundException3);
                    }
                }
            }
        }
        try {
            method = clazz.getMethod("ensureInitialized", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        try {
            method.invoke(null, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
        initialized = true;
    }

    public static final AbstractSubject getCurrentSubject() {
        return SubjectManager.getSubjectManager().getCurrentSubject(kernelID);
    }

    public static final void doAs(AbstractSubject abstractSubject, PrivilegedExceptionAction privilegedExceptionAction) throws JMSException {
        block2: {
            try {
                abstractSubject.doAs(kernelID, privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (!(exception instanceof JMSException)) break block2;
                throw (JMSException)((Object)exception);
            }
        }
    }

    public static final void doAsWithWrappedException(AbstractSubject abstractSubject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        abstractSubject.doAs(kernelID, privilegedExceptionAction);
    }

    public static final Object runAs(AbstractSubject abstractSubject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return abstractSubject.doAs(kernelID, privilegedExceptionAction);
    }

    public static final Object runAs(AbstractSubject abstractSubject, PrivilegedAction privilegedAction) {
        return abstractSubject.doAs(kernelID, privilegedAction);
    }

    static {
        kernelID = CrossDomainSecurityManager.getKernelIdentity();
        util = new ClientCrossDomainSecurityUtil();
    }
}

