/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.cache.CacheEntry;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.messaging.dispatcher.DispatcherId;

public class DDMemberInformation
implements CacheEntry,
Externalizable {
    static final long serialVersionUID = 7307718114460216150L;
    private static final int EXTVERSIONDIABLO = 1;
    private static final int EXTVERSIONDANTE = 2;
    private static final int EXTVERSIONCORDELL = 3;
    private static final int VERSION_MASK = 255;
    private static final int _HAS_DD_TYPE = 256;
    private static final int _HAS_DD_JNDI_NAME = 512;
    private static final int _HAS_DD_MEMBER_JNDI_NAME = 1024;
    private static final int _HAS_DD_MEMBER_LOCAL_JNDI_NAME = 2048;
    private static final int _HAS_DD_MEMBER_CLUSTER_NAME = 4096;
    private static final int _HAS_MIGRATABLE_TARGET_NAME = 8192;
    private static final int _HAS_APPLICATION_NAME = 16384;
    private static final int _HAS_MODULE_NAME = 32768;
    private static final int _HAS_DESTINATION_ID = 65536;
    private static final int _IS_INSERTION_PAUSED = 131072;
    private static final int _IS_PRODUCTION_PAUSED = 262144;
    private static final int _IS_CONSUMPTION_PAUSED = 524288;
    private static final int _HAS_DOMAIN_NAME = 0x100000;
    private static final int _HAS_FORWARDING_POLICY = 0x200000;
    private static final int _HAS_WLS_SERVER_NAME = 0x400000;
    private static final int _HAS_PERSISTENT_STORE_NAME = 0x800000;
    private static final int _IS_10_3_4_OR_LATER = 0x1000000;
    private String ddConfigName = null;
    private String ddType = null;
    private String ddJNDIName = null;
    private String ddMemberJndiName = null;
    private String ddMemberServerName;
    private String ddMemberLocalJndiName = null;
    private String ddMemberClusterName = null;
    private String ddMemberMigratableTargetName = null;
    private DestinationImpl dImpl;
    boolean isConsumptionPaused = false;
    boolean isInsertionPaused = false;
    boolean isProductionPaused = false;
    private String ddMemberDomainName = null;
    private boolean fromWire = false;
    private transient boolean isLocalDD = false;
    private int forwardingPolicy = 1;
    private boolean isPre10_3_4 = true;

    public DDMemberInformation(String string, String string2, String string3, DestinationImpl destinationImpl, String string4, String string5, String string6, String string7, String string8) {
        this(string, string2, string3, destinationImpl, string4, string5, string6, string7, string8, false);
    }

    public DDMemberInformation(String string, String string2, String string3, DestinationImpl destinationImpl, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        this(string, string2, string3, 1, destinationImpl, string4, string5, string6, string7, string8, false, false, false, bl);
    }

    public DDMemberInformation(String string, String string2, String string3, int n, DestinationImpl destinationImpl, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, string2, string3, n, destinationImpl, string4, string5, string6, string7, string8, null, bl, bl2, bl3, bl4);
    }

    public DDMemberInformation(String string, String string2, String string3, int n, DestinationImpl destinationImpl, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.ddConfigName = string;
        this.ddType = string2;
        this.ddJNDIName = string3;
        this.forwardingPolicy = n;
        this.dImpl = destinationImpl;
        this.ddMemberServerName = string4;
        this.ddMemberJndiName = string5;
        this.ddMemberLocalJndiName = string6;
        this.ddMemberClusterName = string7;
        this.ddMemberMigratableTargetName = string8;
        this.ddMemberDomainName = string9;
        this.isConsumptionPaused = bl;
        this.isInsertionPaused = bl2;
        this.isProductionPaused = bl3;
        this.isLocalDD = bl4;
        if (destinationImpl != null) {
            this.isPre10_3_4 = destinationImpl.isPre10_3_4();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DDMemberInformation)) {
            return false;
        }
        DDMemberInformation dDMemberInformation = (DDMemberInformation)object;
        if (this.dImpl != null ? !this.dImpl.equals(dDMemberInformation.dImpl) : dDMemberInformation.dImpl != null) {
            return false;
        }
        if (this.ddConfigName != null ? !this.ddConfigName.equals(dDMemberInformation.ddConfigName) : dDMemberInformation.ddConfigName != null) {
            return false;
        }
        return !(this.ddType != null ? !this.ddType.equals(dDMemberInformation.ddType) : dDMemberInformation.ddType != null);
    }

    public int hashCode() {
        int n = this.ddConfigName != null ? this.ddConfigName.hashCode() : 0;
        n = 29 * n + (this.ddType != null ? this.ddType.hashCode() : 0);
        n = 29 * n + (this.dImpl != null ? this.dImpl.hashCode() : 0);
        return n;
    }

    public boolean isConsumptionPaused() {
        return this.isConsumptionPaused;
    }

    public boolean isInsertionPaused() {
        return this.isInsertionPaused;
    }

    public boolean isProductionPaused() {
        return this.isProductionPaused;
    }

    public boolean isDD() {
        if (this.fromWire) {
            return true;
        }
        return this.isLocalDD;
    }

    public String getName() {
        return this.getDDJNDIName();
    }

    public String getMemberName() {
        if (this.dImpl == null) {
            return null;
        }
        return this.dImpl.getName();
    }

    public String getDDType() {
        return this.ddType;
    }

    public String getDDConfigName() {
        return this.ddConfigName;
    }

    public String getDDJNDIName() {
        return this.ddJNDIName;
    }

    public String getDDMemberJndiName() {
        return this.ddMemberJndiName;
    }

    public Destination getDestination() {
        return this.dImpl;
    }

    public String getDDMemberLocalJndiName() {
        return this.ddMemberLocalJndiName;
    }

    public String getDDMemberServerName() {
        return this.ddMemberServerName;
    }

    public String getDDMemberClusterName() {
        return this.ddMemberClusterName;
    }

    public String getDDMemberMigratableTargetName() {
        return this.ddMemberMigratableTargetName;
    }

    public String getDDMemberDomainName() {
        return this.ddMemberDomainName;
    }

    public int getForwardingPolicy() {
        return this.forwardingPolicy;
    }

    public boolean isAdvancedTopicSupported() {
        return !this.isPre10_3_4;
    }

    public DDMemberInformation() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        int n2 = n = this.getVersion(objectOutput);
        if (this.ddType != null) {
            n2 |= 0x100;
        }
        if (this.ddJNDIName != null) {
            n2 |= 0x200;
        }
        if (this.ddMemberJndiName != null) {
            n2 |= 0x400;
        }
        if (this.ddMemberLocalJndiName != null) {
            n2 |= 0x800;
        }
        if (this.ddMemberClusterName != null) {
            n2 |= 0x1000;
        }
        if (this.ddMemberMigratableTargetName != null) {
            n2 |= 0x2000;
        }
        if (this.dImpl.getId() != null) {
            n2 |= 0x10000;
        }
        if (this.isConsumptionPaused) {
            n2 |= 0x80000;
        }
        if (this.isInsertionPaused) {
            n2 |= 0x20000;
        }
        if (this.isProductionPaused) {
            n2 |= 0x40000;
        }
        if (n > 1 && this.ddMemberDomainName != null) {
            n2 |= 0x100000;
        }
        if (n >= 3) {
            n2 |= 0x200000;
            if (this.ddMemberServerName != null) {
                n2 |= 0x400000;
            }
            if (this.dImpl.getApplicationName() != null) {
                n2 |= 0x4000;
            }
            if (this.dImpl.getModuleName() != null) {
                n2 |= 0x8000;
            }
            if (this.dImpl.getApplicationName() != null) {
                n2 |= 0x4000;
            }
            if (this.dImpl.getPersistentStoreName() != null) {
                n2 |= 0x800000;
            }
        }
        if (!this.isPre10_3_4) {
            n2 |= 0x1000000;
        }
        objectOutput.writeInt(n2);
        objectOutput.writeUTF(this.ddConfigName);
        if ((n2 & 0x100) != 0) {
            objectOutput.writeUTF(this.ddType);
        }
        if ((n2 & 0x200) != 0) {
            objectOutput.writeUTF(this.ddJNDIName);
        }
        if ((n2 & 0x400) != 0) {
            objectOutput.writeUTF(this.ddMemberJndiName);
        }
        if ((n2 & 0x800) != 0) {
            objectOutput.writeUTF(this.ddMemberLocalJndiName);
        }
        if ((n2 & 0x1000) != 0) {
            objectOutput.writeUTF(this.ddMemberClusterName);
        }
        if ((n2 & 0x2000) != 0) {
            objectOutput.writeUTF(this.ddMemberMigratableTargetName);
        }
        if ((n2 & 0x100000) != 0) {
            objectOutput.writeUTF(this.ddMemberDomainName);
        }
        if ((n2 & 0x200000) != 0) {
            objectOutput.writeInt(this.forwardingPolicy);
        }
        objectOutput.writeInt(this.dImpl.getType());
        objectOutput.writeUTF(this.dImpl.getServerName());
        objectOutput.writeUTF(this.getMemberName());
        if ((n2 & 0x4000) != 0) {
            objectOutput.writeUTF(this.dImpl.getApplicationName());
        }
        if ((n2 & 0x8000) != 0) {
            objectOutput.writeUTF(this.dImpl.getModuleName());
        }
        this.dImpl.getBackEndId().writeExternal(objectOutput);
        if ((n2 & 0x10000) != 0) {
            this.dImpl.getId().writeExternal(objectOutput);
        }
        this.dImpl.getDispatcherId().writeExternal(objectOutput);
        if ((n2 & 0x400000) != 0) {
            objectOutput.writeUTF(this.ddMemberServerName);
        }
        if ((n2 & 0x800000) != 0) {
            objectOutput.writeUTF(this.dImpl.getPersistentStoreName());
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            throw JMSUtilities.versionIOException(n2, 1, 3);
        }
        if ((n & 0x80000) != 0) {
            this.isConsumptionPaused = true;
        }
        if ((n & 0x20000) != 0) {
            this.isInsertionPaused = true;
        }
        if ((n & 0x40000) != 0) {
            this.isProductionPaused = true;
        }
        this.ddConfigName = objectInput.readUTF();
        if ((n & 0x100) != 0) {
            this.ddType = objectInput.readUTF();
        }
        if ((n & 0x200) != 0) {
            this.ddJNDIName = objectInput.readUTF();
        }
        if ((n & 0x400) != 0) {
            this.ddMemberJndiName = objectInput.readUTF();
        }
        if ((n & 0x800) != 0) {
            this.ddMemberLocalJndiName = objectInput.readUTF();
        }
        if ((n & 0x1000) != 0) {
            this.ddMemberClusterName = objectInput.readUTF();
        }
        if ((n & 0x2000) != 0) {
            this.ddMemberMigratableTargetName = objectInput.readUTF();
        }
        if ((n & 0x100000) != 0) {
            this.ddMemberDomainName = objectInput.readUTF();
        }
        if ((n & 0x200000) != 0) {
            this.forwardingPolicy = objectInput.readInt();
        }
        int n3 = objectInput.readInt();
        String string = objectInput.readUTF();
        String string2 = objectInput.readUTF();
        String string3 = null;
        if ((n & 0x4000) != 0) {
            string3 = objectInput.readUTF();
        }
        String string4 = null;
        if ((n & 0x8000) != 0) {
            string4 = objectInput.readUTF();
        }
        JMSServerId jMSServerId = new JMSServerId();
        jMSServerId.readExternal(objectInput);
        JMSID jMSID = null;
        if ((n & 0x10000) != 0) {
            jMSID = new JMSID();
            jMSID.readExternal(objectInput);
        }
        DispatcherId dispatcherId = new DispatcherId();
        dispatcherId.readExternal(objectInput);
        if ((n & 0x400000) != 0) {
            this.ddMemberServerName = objectInput.readUTF();
        }
        String string5 = null;
        if ((n & 0x800000) != 0) {
            string5 = objectInput.readUTF();
        }
        if ((n & 0x1000000) != 0) {
            this.isPre10_3_4 = false;
        }
        this.dImpl = new DestinationImpl(n3, string, string5, string2, string3, string4, jMSServerId, jMSID, dispatcherId);
        this.fromWire = true;
    }

    public String toString() {
        return new String("\nDDMemberInformation : \n  DD Type                          = " + this.ddType + "\n" + (this.ddType.equals("javax.jms.Topic") ? "  DD ForwardingPolicy              = " + this.getForwardingPolicy() : "") + "\n" + "  DD Config Name                   = " + this.getDDConfigName() + "\n" + "  DD JNDI Name                     = " + this.ddJNDIName + "\n" + "  DD Member JNDI Name              = " + this.ddMemberJndiName + "\n" + "  DD Member Name                   = " + this.getMemberName() + "\n" + "  DD Member Consumption Paused     = " + this.isConsumptionPaused + "\n" + "  DD Member Insertion Paused       = " + this.isInsertionPaused + "\n" + "  DD Member Production Paused      = " + this.isProductionPaused + "\n" + "  DD Member Local JNDI Name        = " + this.ddMemberLocalJndiName + "\n" + "  DD Member Server Name            = " + this.ddMemberServerName + "\n" + "  DD Member Cluster Name           = " + this.ddMemberClusterName + "\n" + "  DD Member Migratable Target Name = " + this.ddMemberMigratableTargetName + "\n" + "  DD Member Domain Name            = " + this.ddMemberDomainName + "\n" + "  DD Member AdvancedTopicSupported = " + this.isAdvancedTopicSupported() + "\n");
    }

    private int getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_DIABLO) < 0) {
                throw JMSUtilities.versionIOException(0, 1, 3);
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_1000) < 0) {
                return 1;
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_1033) < 0) {
                return 2;
            }
        }
        return 3;
    }
}

