/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.common.Destination;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.extensions.WLDestination;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.store.common.PersistentStoreOutputStream;

public class DestinationImpl
extends Destination
implements Queue,
Topic,
TemporaryQueue,
TemporaryTopic,
Externalizable,
WLDestination,
Cloneable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte EXTVERSION4 = 4;
    private static final byte EXTVERSION5 = 5;
    private static final byte EXTVERSION6 = 6;
    private static final long serialVersionUID = 6099783323740404732L;
    public static final byte TYPE_ANONYMOUS = 0;
    public static final byte TYPE_QUEUE = 1;
    public static final byte TYPE_TOPIC = 2;
    public static final byte TYPE_TEMP_QUEUE = 4;
    public static final byte TYPE_TEMP_TOPIC = 8;
    private transient JMSConnection connection;
    private String name;
    private String serverName;
    private String applicationName;
    private String moduleName;
    JMSServerId backEndId;
    private String multicastAddress;
    private int port;
    private boolean pre90 = false;
    private boolean pre10_3_4 = false;
    JMSID destinationId;
    byte type = 1;
    DispatcherId dispatcherId;
    private long generation = 1L;
    private static final int FIRSTGENERATION = 1;
    private String[] safExportAllowed;
    private String referenceName;
    private String persistentStoreName = null;
    private static final int _VERSIONMASK = 3840;
    private static final int _VERSIONSHIFT = 8;
    private static final int _TYPEMASK = 15;
    private static final int _TYPESHIFT = 0;
    private static final int _HASREFERENCENAME = 16;
    private static final int _HASGENERATION = 32;
    private static final int _ISPARTOFAPP = 64;
    private static final int _ISPARTOFEAR = 128;
    protected static final int _HASIDS = 4096;
    private static final int _ISNOTREPLYTO = 8192;
    private static final int _HASMULTICASTADDR = 16384;
    private static final int _HASDISPID = 32768;
    private static final int _HASSTORENAME = 1;
    private static final int _HASMOREFLAGS = 32768;

    public DestinationImpl() {
    }

    public DestinationImpl(byte by, String string, String string2, String string3, String string4) {
        this.applicationName = string3;
        this.moduleName = string4;
        this.destinationImplInternal(by, string, string2);
    }

    public void destinationImplInternal(byte by, String string, String string2) {
        this.name = string2;
        this.serverName = string;
        this.type = by;
    }

    public DestinationImpl(byte by) {
        this.type = by;
    }

    public DestinationImpl(int n, String string, String string2, String string3, String string4, String string5, JMSServerId jMSServerId, JMSID jMSID, long l, String string6) {
        this.applicationName = string4;
        this.moduleName = string5;
        this.destinationImplInternalWithCreationTime(n, string, string3, jMSServerId, jMSID, l);
        this.persistentStoreName = string2;
        this.setSafExportAllowedArray(string6);
    }

    private void destinationImplInternalWithCreationTime(int n, String string, String string2, JMSServerId jMSServerId, JMSID jMSID, long l) {
        this.type = (byte)n;
        this.serverName = string;
        this.name = string2;
        this.backEndId = jMSServerId;
        this.destinationId = jMSID;
        this.generation = l;
        this.dispatcherId = JMSDispatcherManager.getLocalDispatcher().getId();
    }

    public DestinationImpl(int n, String string, String string2, String string3, String string4, String string5, JMSServerId jMSServerId, JMSID jMSID, DispatcherId dispatcherId) {
        this.applicationName = string4;
        this.moduleName = string5;
        this.destinationImplInternalWithoutCreationTime(n, string, string3, jMSServerId, jMSID);
        this.dispatcherId = dispatcherId;
        this.persistentStoreName = string2;
    }

    public DestinationImpl(int n, String string, String string2, String string3, String string4, JMSServerId jMSServerId, JMSID jMSID) {
        this.applicationName = string3;
        this.moduleName = string4;
        this.destinationImplInternalWithoutCreationTime(n, string, string2, jMSServerId, jMSID);
        this.dispatcherId = JMSDispatcherManager.getLocalDispatcher().getId();
    }

    public DestinationImpl(int n, String string, String string2, String string3, String string4, JMSServerId jMSServerId, JMSID jMSID, String string5, String string6) {
        this(n, string, string2, string3, string4, jMSServerId, jMSID);
        this.setSafExportAllowedArray(string5);
        this.persistentStoreName = string6;
    }

    private void destinationImplInternalWithoutCreationTime(int n, String string, String string2, JMSServerId jMSServerId, JMSID jMSID) {
        this.type = (byte)n;
        this.serverName = string;
        this.name = string2;
        this.backEndId = jMSServerId;
        this.destinationId = jMSID;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public DestinationImpl getClone() {
        try {
            return (DestinationImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public void setReferenceName(String string) {
        this.referenceName = string;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    void setSafExportAllowedArray(String string) {
        if (string == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = new String(string);
        int n = 0;
        while ((n = string2.indexOf(",")) != -1) {
            arrayList.add(string2.substring(0, n - 1));
            string2 = string2.substring(n + 1);
        }
        if (string2 != null) {
            arrayList.add(string2);
        }
        if (arrayList.size() > 0) {
            this.safExportAllowed = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.safExportAllowed[i] = (String)arrayList.get(i);
            }
        }
    }

    public String[] getSafAllowedArray() {
        return this.safExportAllowed;
    }

    public final boolean isQueue() {
        return this.type == 1 || this.type == 4;
    }

    public final boolean isTopic() {
        return this.type == 2 || this.type == 8;
    }

    public final boolean isAnonymous() {
        return this.type == 0;
    }

    String getDestinationName() {
        return this.name;
    }

    public String toString() {
        return this.getDestinationName();
    }

    public final String getQueueName() {
        return this.getDestinationName();
    }

    public final String getTopicName() {
        return this.getDestinationName();
    }

    public byte getDestinationInstanceType() {
        return 1;
    }

    public final int getType() {
        return this.type;
    }

    public final void setBackEndID(JMSServerId jMSServerId) {
        this.backEndId = jMSServerId;
    }

    public final synchronized JMSServerId getBackEndId() {
        return this.backEndId;
    }

    public final JMSID getId() {
        return this.destinationId;
    }

    public final synchronized JMSID getDestinationId() {
        return this.destinationId;
    }

    public final void setDestinationId(JMSID jMSID) {
        this.destinationId = jMSID;
    }

    public String getMemberName() {
        return this.name;
    }

    public String getCreateDestinationArgument() {
        String string = this.getServerName() + "/" + this.getMemberName();
        return string.intern();
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.getDestinationName();
    }

    protected void setServerName(String string) {
        this.serverName = string;
    }

    public final String getServerName() {
        return this.serverName;
    }

    protected void setApplicationName(String string) {
        this.applicationName = string;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    protected void setModuleName(String string) {
        this.moduleName = string;
    }

    public final String getModuleName() {
        return this.moduleName;
    }

    public final DispatcherId getDispatcherId() {
        return this.dispatcherId;
    }

    public final void setDispatcherId(DispatcherId dispatcherId) {
        this.dispatcherId = dispatcherId;
    }

    public synchronized boolean isStale() {
        return this.dispatcherId == null;
    }

    public synchronized void markStale() {
        this.dispatcherId = null;
    }

    public String getPersistentStoreName() {
        return this.persistentStoreName;
    }

    protected int getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            int n = peerInfo.getMajor();
            if (n < 6) {
                throw new IOException(JMSClientExceptionLogger.logIncompatibleVersion9Loggable((byte)1, (byte)2, (byte)3, (byte)4, (String)peerInfo.toString()).getMessage());
            }
            switch (n) {
                case 10: {
                    if (peerInfo.compareTo((Object)PeerInfo.VERSION_1034) >= 0) {
                        return 6;
                    }
                    if (peerInfo.compareTo((Object)PeerInfo.VERSION_1033) >= 0) {
                        return 5;
                    }
                    return 4;
                }
                case 9: {
                    return 4;
                }
                case 7: 
                case 8: {
                    return 3;
                }
                case 6: {
                    return 2;
                }
            }
        }
        return 6;
    }

    public final boolean isPre90() {
        return this.pre90;
    }

    public final boolean isPre10_3_4() {
        return this.pre10_3_4;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeDestinationImpl(objectOutput, this.name);
    }

    final void writeDestinationImpl(ObjectOutput objectOutput) throws IOException {
        this.writeDestinationImpl(objectOutput, this.name);
    }

    final void writeDestinationImpl(ObjectOutput objectOutput, String string) throws IOException {
        int n;
        boolean bl = objectOutput instanceof PersistentStoreOutputStream;
        boolean bl2 = objectOutput instanceof WLObjectOutput;
        int n2 = 0;
        int n3 = this.getVersion(objectOutput);
        n2 = (short)(n2 | n3 << 8);
        if (!bl && n3 <= 3) {
            n2 = (short)(n2 & 0xFFFFF0FF);
            n2 = (short)(n2 | 0x200);
        }
        n2 = (short)(n2 | this.type);
        if (bl) {
            n2 = (short)(n2 | 0x20);
            if (this.applicationName != null) {
                n2 = (short)(n2 | 0x40);
            }
            if (this.moduleName != null) {
                n2 = (short)(n2 | 0x80);
            }
            objectOutput.writeShort(n2);
            objectOutput.writeUTF(string);
            objectOutput.writeUTF(this.serverName);
            objectOutput.writeLong(this.getGeneration());
            if (this.applicationName != null) {
                objectOutput.writeUTF(this.applicationName);
            }
            if (this.moduleName != null) {
                objectOutput.writeUTF(this.moduleName);
            }
            return;
        }
        n2 = (short)(n2 | 0x1000);
        if (this.multicastAddress != null) {
            n2 = (short)(n2 | 0x4000);
        }
        if (this.destinationId != null) {
            n2 = (short)(n2 | 0x2000);
        }
        JMSID jMSID = this.destinationId;
        if (this.dispatcherId != null) {
            n2 = (short)(n2 | 0x8000);
        }
        if (this.applicationName != null) {
            n2 = (short)(n2 | 0x40);
        }
        if (this.moduleName != null) {
            n2 = (short)(n2 | 0x80);
        }
        if (n3 >= 4 && this.referenceName != null) {
            n2 = (short)(n2 | 0x10);
        }
        objectOutput.writeShort(n2);
        if (bl2) {
            ((WLObjectOutput)objectOutput).writeAbbrevString(this.name);
            ((WLObjectOutput)objectOutput).writeAbbrevString(this.serverName);
        } else {
            objectOutput.writeUTF(this.name);
            objectOutput.writeUTF(this.serverName);
        }
        if (n3 >= 4) {
            if (this.applicationName != null) {
                objectOutput.writeUTF(this.applicationName);
            }
            if (this.moduleName != null) {
                objectOutput.writeUTF(this.moduleName);
            }
            if (this.safExportAllowed == null) {
                objectOutput.writeByte(0);
            } else {
                objectOutput.writeByte(this.safExportAllowed.length);
                for (n = 0; n < this.safExportAllowed.length; ++n) {
                    objectOutput.writeUTF(this.safExportAllowed[n]);
                }
            }
        }
        if (jMSID != null) {
            this.backEndId.writeExternal(objectOutput);
            jMSID.writeExternal(objectOutput);
        }
        if (this.multicastAddress != null) {
            objectOutput.writeUTF(this.multicastAddress);
            objectOutput.writeInt(this.port);
        }
        if (this.dispatcherId != null) {
            this.dispatcherId.writeExternal(objectOutput);
        }
        if ((n2 & 0x10) != 0) {
            objectOutput.writeUTF(this.referenceName);
        }
        n = 0;
        if (n3 >= 5) {
            if (this.persistentStoreName != null && this.persistentStoreName.length() != 0) {
                n = (short)(n | 1);
            }
            objectOutput.writeShort(n);
        }
        if (n & true) {
            objectOutput.writeUTF(this.persistentStoreName);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        short s = objectInput.readShort();
        this.readDestinationImpl(objectInput, s);
    }

    final void readDestinationImpl(ObjectInput objectInput, int n) throws IOException, ClassNotFoundException {
        int n2;
        byte by = (byte)((n & 0xF00) >>> 8 & 0xFF);
        if (by == 1) {
            this.readExternalVersion1(objectInput, (byte)(n & 0xFF));
            return;
        }
        if (by != 2 && by != 3 && by != 4 && by != 5 && by != 6) {
            throw JMSUtilities.versionIOException(by, 1, 6);
        }
        if (by < 4) {
            this.pre90 = true;
        }
        if (by < 6) {
            this.pre10_3_4 = true;
        }
        this.type = (byte)((n & 0xF) >>> 0 & 0xFF);
        if ((n & 0x1000) == 0) {
            this.name = objectInput.readUTF();
            this.serverName = objectInput.readUTF();
            if ((n & 0x20) != 0) {
                this.generation = by == 2 ? (long)objectInput.readInt() : objectInput.readLong();
            }
            if ((n & 0x40) != 0) {
                this.applicationName = objectInput.readUTF();
            }
            if ((n & 0x80) != 0) {
                this.moduleName = objectInput.readUTF();
            }
            return;
        }
        if (objectInput instanceof WLObjectInput) {
            this.name = ((WLObjectInput)objectInput).readAbbrevString();
            this.serverName = ((WLObjectInput)objectInput).readAbbrevString();
        } else {
            this.name = objectInput.readUTF();
            this.serverName = objectInput.readUTF();
        }
        if (by >= 4) {
            if ((n & 0x40) != 0) {
                this.applicationName = objectInput.readUTF();
            }
            if ((n & 0x80) != 0) {
                this.moduleName = objectInput.readUTF();
            }
            if ((n2 = objectInput.readByte()) > 0) {
                this.safExportAllowed = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    this.safExportAllowed[i] = objectInput.readUTF();
                }
            }
        }
        if ((n & 0x2000) != 0) {
            this.backEndId = new JMSServerId();
            this.backEndId.readExternal(objectInput);
            this.destinationId = new JMSID();
            this.destinationId.readExternal(objectInput);
        }
        if ((n & 0x4000) != 0) {
            this.multicastAddress = objectInput.readUTF();
            this.port = objectInput.readInt();
        }
        if ((n & 0x8000) != 0) {
            this.dispatcherId = new DispatcherId();
            this.dispatcherId.readExternal(objectInput);
        }
        if ((n & 0x10) != 0) {
            this.referenceName = objectInput.readUTF();
        }
        n2 = 0;
        if (by >= 5) {
            n2 = objectInput.readShort();
        }
        if ((n2 & 1) != 0) {
            this.persistentStoreName = objectInput.readUTF();
        }
    }

    private void readExternalVersion1(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        this.type = by;
        this.generation = 1L;
        this.name = objectInput.readUTF();
        this.serverName = objectInput.readUTF();
        if (objectInput.readBoolean()) {
            this.backEndId = new JMSServerId();
            this.backEndId.readExternal(objectInput);
        }
        if (objectInput.readBoolean()) {
            this.destinationId = new JMSID();
            this.destinationId.readExternal(objectInput);
        }
        if (objectInput.readBoolean()) {
            this.multicastAddress = objectInput.readUTF();
            this.port = objectInput.readInt();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DestinationImpl)) {
            return false;
        }
        DestinationImpl destinationImpl = (DestinationImpl)object;
        if (destinationImpl == this) {
            return true;
        }
        if (this.type != destinationImpl.type) {
            return false;
        }
        if (this.destinationId == null) {
            return false;
        }
        if (!this.name.equals(destinationImpl.name)) {
            return false;
        }
        return this.destinationId.equals(destinationImpl.destinationId);
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return super.hashCode();
    }

    public final void delete() throws javax.jms.JMSException {
        if (this.connection == null) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidTemporaryDestinationLoggable().getMessage());
        }
        this.connection.destroyTemporaryDestination(this.backEndId, this.destinationId);
    }

    public final void setConnection(JMSConnection jMSConnection) {
        this.connection = jMSConnection;
    }

    public final JMSConnection getConnection() {
        return this.connection;
    }

    public final void setMulticastAddress(String string) {
        this.multicastAddress = string;
    }

    public final String getMulticastAddress() {
        return this.multicastAddress;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    public final synchronized long getGeneration() {
        return this.generation;
    }
}

