/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.frontend.FEConnection;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.Dispatcher;

public final class DestinationPeerGoneAdapter
implements JMSPeerGoneListener {
    private final DestinationImpl destination;
    private final FEConnection feConnection;
    private transient int refCount;

    public DestinationPeerGoneAdapter(DestinationImpl destinationImpl, FEConnection fEConnection) {
        this.destination = destinationImpl;
        this.feConnection = fEConnection;
    }

    public DestinationImpl getDestinationImpl() {
        return this.destination;
    }

    public int incrementRefCount() {
        return ++this.refCount;
    }

    public int decrementRefCount() {
        return --this.refCount;
    }

    public ID getId() {
        return this.destination.getId();
    }

    public void dispatcherPeerGone(Exception exception, Dispatcher dispatcher) {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("DestinationImpl.jmsPeerGone()");
        }
        this.destination.dispatcherId = null;
        if (this.feConnection != null) {
            this.feConnection.removeTemporaryDestination(this.destination.destinationId);
            this.feConnection.getFrontEnd().removeBackEndDestination(this.destination);
        }
    }

    public int hashCode() {
        return this.destination.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DestinationPeerGoneAdapter)) {
            return false;
        }
        DestinationPeerGoneAdapter destinationPeerGoneAdapter = (DestinationPeerGoneAdapter)object;
        return this.destination.equals(destinationPeerGoneAdapter.destination);
    }
}

