/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.naming.NamingException;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.common.DSManager;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.SingularAggregatable;
import weblogic.jms.common.Subscription;
import weblogic.jndi.Aggregatable;
import weblogic.jndi.internal.NamingNode;
import weblogic.management.ManagementException;
import weblogic.store.common.PersistentStoreOutputStream;

public final class DurableSubscription
extends SingularAggregatable
implements Subscription {
    private static final byte EXTVERSION = 1;
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    static final long serialVersionUID = 4168599304001594429L;
    private DestinationImpl destinationImpl;
    private String selector;
    private boolean noLocal;
    private Vector dsVector = new Vector();
    private JMSID dsId;
    private transient BEConsumerImpl myConsumer;
    private transient Map<JMSID, BEConsumerImpl> subscribers = new HashMap<JMSID, BEConsumerImpl>();
    private transient String jndiName;
    private transient String consumerName;
    private transient int clientIdPolicy;
    private transient int subscriptionSharingPolicy;
    private transient boolean pending = true;
    private transient boolean stale;
    private transient int waits;
    private transient int subscribersTotalCount;
    private transient int subscribersHighCount;
    private static final int _HASDESTIMPL = 1;
    private static final int _HASSELECTOR = 2;
    private static final int _NOLOCAL = 4;
    private static final int _HASID = 8;
    private static final int _HASNAME = 16;

    public synchronized int getSubscribersTotalCount() {
        return this.subscribersTotalCount;
    }

    public synchronized int getSubscribersHighCount() {
        return this.subscribersHighCount;
    }

    public synchronized void resetSubscribersCount() {
        this.subscribersHighCount = 0;
        this.subscribersTotalCount = 0;
    }

    public DurableSubscription(String string, DestinationImpl destinationImpl, String string2, boolean bl, int n, int n2) {
        this.destinationImpl = destinationImpl;
        if (string2 != null && string2.trim().length() > 0) {
            this.selector = string2;
        }
        this.noLocal = bl;
        this.clientIdPolicy = n;
        this.subscriptionSharingPolicy = n2;
        this.consumerName = string;
        try {
            this.dsId = JMSService.getService().getNextId();
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
    }

    public DurableSubscription() {
    }

    public synchronized BEConsumerImpl getConsumer() {
        if (this.myConsumer != null) {
            return this.myConsumer;
        }
        Iterator<BEConsumerImpl> iterator = this.subscribers.values().iterator();
        if (iterator.hasNext()) {
            this.myConsumer = iterator.next();
            return this.myConsumer;
        }
        return null;
    }

    public synchronized void addSubscriber(BEConsumerImpl bEConsumerImpl) {
        if (this.myConsumer == null || this.subscribers.size() == 0 || this.myConsumer.getJMSID() == null) {
            this.myConsumer = bEConsumerImpl;
        }
        this.subscriptionSharingPolicy = bEConsumerImpl.getSubscriptionSharingPolicy();
        if (bEConsumerImpl.getJMSID() != null) {
            this.subscribers.put(bEConsumerImpl.getJMSID(), bEConsumerImpl);
        }
        ++this.subscribersTotalCount;
        if (this.getSubscribersCount() > this.subscribersHighCount) {
            this.subscribersHighCount = this.getSubscribersCount();
        }
    }

    public synchronized void removeSubscriber(JMSID jMSID) {
        BEConsumerImpl bEConsumerImpl = this.subscribers.remove(jMSID);
        if (this.myConsumer == bEConsumerImpl) {
            this.myConsumer = null;
            Iterator<BEConsumerImpl> iterator = this.subscribers.values().iterator();
            if (iterator.hasNext()) {
                this.myConsumer = iterator.next();
            }
        }
        if (this.myConsumer == null && bEConsumerImpl != null) {
            this.myConsumer = bEConsumerImpl;
        }
    }

    public synchronized int getSubscribersCount() {
        return this.subscribers.size();
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public String getSelector() {
        return this.selector;
    }

    public DestinationImpl getDestinationImpl() {
        return this.destinationImpl;
    }

    public JMSServerId getBackEndId() {
        return this.destinationImpl.getBackEndId();
    }

    public synchronized int getSubscriptionSharingPolicy() {
        return this.subscriptionSharingPolicy;
    }

    public static boolean noLocalAndSelectorMatch(Subscription subscription, boolean bl, String string) {
        String string2;
        if (bl != subscription.isNoLocal()) {
            return false;
        }
        if (subscription.getSelector() == null || (string2 = subscription.getSelector().trim()).length() == 0 || string2.equals("TRUE")) {
            string2 = null;
        }
        if (string == null || (string = string.trim()).length() == 0 || string.equals("TRUE")) {
            string = null;
        }
        if (string2 == null && string != null || string2 != null && string == null) {
            return false;
        }
        return string2 == null || string2.equals(string);
    }

    public boolean equalsForSerialized(Object object) {
        if (!(object instanceof DurableSubscription)) {
            return false;
        }
        DurableSubscription durableSubscription = (DurableSubscription)object;
        if (!DurableSubscription.noLocalAndSelectorMatch(this, durableSubscription.noLocal, durableSubscription.selector) || this.destinationImpl == null && durableSubscription.destinationImpl != null || this.destinationImpl != null && durableSubscription.destinationImpl == null) {
            return false;
        }
        return Destination.equalsForDS(this.destinationImpl, durableSubscription.destinationImpl);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DurableSubscription)) {
            return false;
        }
        DurableSubscription durableSubscription = (DurableSubscription)object;
        if (!DurableSubscription.noLocalAndSelectorMatch(this, durableSubscription.noLocal, durableSubscription.selector) || this.destinationImpl == null && durableSubscription.destinationImpl != null || this.destinationImpl != null && durableSubscription.destinationImpl == null || this.consumerName != null && !this.consumerName.equals(durableSubscription.consumerName) || this.clientIdPolicy != durableSubscription.clientIdPolicy) {
            return false;
        }
        return Destination.equalsForDS(this.destinationImpl, durableSubscription.destinationImpl);
    }

    public int hashCode() {
        return this.jndiName.hashCode();
    }

    public void hadConflict(boolean bl) {
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("durableSubscription.hadConflict jndiName=" + this.jndiName + " didWin=" + bl);
        }
        if (bl) {
            return;
        }
        if (this.getSubscribersCount() == 0) {
            return;
        }
        try {
            this.getConsumer().delete(false, false);
        }
        catch (JMSException jMSException) {
        }
        catch (javax.jms.JMSException jMSException) {
            // empty catch block
        }
    }

    public synchronized boolean hasWaits() {
        return this.waits > 0;
    }

    public synchronized void incrementWaits() {
        ++this.waits;
    }

    public synchronized void decrementWaits() {
        --this.waits;
    }

    public synchronized void setPending(boolean bl) {
        this.pending = bl;
    }

    public synchronized boolean isPending() {
        return this.pending;
    }

    public synchronized void setStale(boolean bl) {
        this.stale = bl;
    }

    public synchronized boolean isStale() {
        return this.stale;
    }

    public String toString() {
        return "DurableSubscription((" + super.toString() + ") " + this.destinationImpl + ":" + this.selector + ":" + this.noLocal + ")";
    }

    private synchronized void add(DurableSubscription durableSubscription) {
        if (durableSubscription != this) {
            durableSubscription.dsVector = this.dsVector;
        }
        this.dsVector.add(durableSubscription);
    }

    private synchronized void remove(DurableSubscription durableSubscription) {
        for (int i = 0; i < this.dsVector.size(); ++i) {
            DurableSubscription durableSubscription2 = (DurableSubscription)this.dsVector.elementAt(i);
            if (!durableSubscription2.dsId.equals(durableSubscription.dsId)) continue;
            this.dsVector.remove(i);
        }
    }

    public synchronized Vector getDSVector() {
        return (Vector)this.dsVector.clone();
    }

    public String getName() {
        return this.jndiName;
    }

    public void onBind(NamingNode namingNode, String string, Aggregatable aggregatable) {
        super.onBind(namingNode, string, aggregatable);
        if (this.hasAggregatable()) {
            Aggregatable aggregatable2 = aggregatable == null ? this : aggregatable;
            this.add((DurableSubscription)aggregatable2);
            if (aggregatable == null) {
                DSManager.manager().add((DurableSubscription)aggregatable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onUnbind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        Aggregatable aggregatable2;
        boolean bl = super.onUnbind(namingNode, string, aggregatable);
        if (bl) {
            aggregatable2 = null;
            DurableSubscription durableSubscription = this;
            synchronized (durableSubscription) {
                aggregatable2 = (DurableSubscription)this.dsVector.firstElement();
            }
            if (aggregatable2 != null) {
                DSManager.manager().remove((DurableSubscription)aggregatable2);
            }
        }
        aggregatable2 = aggregatable == null ? this : aggregatable;
        this.remove((DurableSubscription)aggregatable2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws javax.jms.JMSException {
        BEConsumerImpl bEConsumerImpl;
        Iterator iterator;
        Throwable throwable = null;
        DurableSubscription durableSubscription = this;
        synchronized (durableSubscription) {
            iterator = ((HashMap)((HashMap)this.subscribers).clone()).values().iterator();
            bEConsumerImpl = this.myConsumer;
        }
        if (!iterator.hasNext() && bEConsumerImpl != null) {
            bEConsumerImpl.delete(false, true);
        }
        while (iterator.hasNext()) {
            bEConsumerImpl = (BEConsumerImpl)iterator.next();
            try {
                if (bEConsumerImpl == null) continue;
                bEConsumerImpl.delete(false, true);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
        }
        if (throwable instanceof JMSException) {
            throw (JMSException)((Object)throwable);
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws javax.jms.JMSException {
        BEConsumerImpl bEConsumerImpl;
        Iterator iterator;
        Throwable throwable = null;
        DurableSubscription durableSubscription = this;
        synchronized (durableSubscription) {
            iterator = ((HashMap)((HashMap)this.subscribers).clone()).values().iterator();
            bEConsumerImpl = this.myConsumer;
        }
        if (!iterator.hasNext() && bEConsumerImpl != null) {
            try {
                bEConsumerImpl.close(0L);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
        }
        while (iterator.hasNext()) {
            bEConsumerImpl = (BEConsumerImpl)iterator.next();
            try {
                bEConsumerImpl.close(0L);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
            }
        }
        if (bEConsumerImpl != null) {
            bEConsumerImpl.cleanupDurableSubscription(true, false, false, false, true);
        }
        if (throwable instanceof JMSException) {
            throw (JMSException)((Object)throwable);
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    private int getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            int n = peerInfo.getMajor();
            int n2 = peerInfo.getMinor();
            if (n < 6) {
                throw new IOException("Peer neither compatible with 1 or 2 .  PeerInfo is " + peerInfo);
            }
            if (n == 6 && n2 < 2) {
                return 1;
            }
        }
        return 2;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        boolean bl = false;
        int n = this.getVersion(objectOutput);
        if (n == 1) {
            this.writeExternal1(objectOutput);
            return;
        }
        if (n >= 2) {
            if (objectOutput instanceof PersistentStoreOutputStream) {
                bl = true;
            }
            int n2 = 0;
            objectOutput.writeByte(2);
            if (this.destinationImpl != null) {
                n2 |= 1;
            }
            if (this.selector != null) {
                n2 |= 2;
            }
            if (this.noLocal) {
                n2 |= 4;
            }
            if (!bl) {
                if (this.dsId != null) {
                    n2 |= 8;
                }
                if (this.consumerName != null) {
                    n2 |= 0x10;
                }
            }
            objectOutput.writeByte((byte)n2);
        }
        super.writeExternal(objectOutput);
        if (this.destinationImpl != null) {
            this.destinationImpl.writeExternal(objectOutput);
        }
        if (this.selector != null) {
            objectOutput.writeUTF(this.selector);
        }
        if (!bl && n >= 2) {
            if (this.dsId != null) {
                this.dsId.writeExternal(objectOutput);
            }
            if (this.getConsumer() != null) {
                this.consumerName = this.getConsumer().getName();
            }
            if (this.consumerName != null) {
                if (objectOutput instanceof WLObjectOutput) {
                    ((WLObjectOutput)objectOutput).writeAbbrevString(this.consumerName);
                } else {
                    objectOutput.writeUTF(this.consumerName);
                }
            }
        }
    }

    private void writeExternal1(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        if (this.destinationImpl == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            this.destinationImpl.writeExternal(objectOutput);
        }
        if (this.selector == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.selector);
        }
        objectOutput.writeBoolean(this.noLocal);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by == 1) {
            this.readExternal1(objectInput);
            return;
        }
        if (by != 2) {
            throw JMSUtilities.versionIOException(by, 1, 2);
        }
        byte by2 = objectInput.readByte();
        super.readExternal(objectInput);
        if ((by2 & 1) != 0) {
            this.destinationImpl = new DestinationImpl();
            this.destinationImpl.readExternal(objectInput);
        }
        if ((by2 & 2) != 0) {
            this.selector = objectInput.readUTF();
        }
        this.noLocal = (by2 & 4) != 0;
        int n = this.getVersion(objectInput);
        if (n >= 2) {
            if ((by2 & 8) != 0) {
                this.dsId = new JMSID();
                this.dsId.readExternal(objectInput);
            }
            if ((by2 & 0x10) != 0) {
                this.consumerName = objectInput instanceof WLObjectInput ? ((WLObjectInput)objectInput).readAbbrevString() : objectInput.readUTF();
                this.jndiName = BEConsumerImpl.JNDINameForSubscription(this.consumerName);
            }
        }
    }

    private void readExternal1(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        super.readExternal(objectInput);
        if (objectInput.readBoolean()) {
            this.destinationImpl = new DestinationImpl();
            this.destinationImpl.readExternal(objectInput);
        }
        if (objectInput.readBoolean()) {
            this.selector = objectInput.readUTF();
        }
        this.noLocal = objectInput.readBoolean();
    }
}

