/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;

public final class HdrMessageImpl
extends MessageImpl
implements Externalizable {
    private static final byte EXTVERSION = 1;
    static final long serialVersionUID = -5400333814519213733L;
    private int controlOpcode;

    public HdrMessageImpl() {
    }

    public HdrMessageImpl(Message message) throws JMSException {
        this(message, null, null);
    }

    public void nullBody() {
    }

    public HdrMessageImpl(Message message, Destination destination, Destination destination2) throws JMSException {
        super(message, destination, destination2);
    }

    public byte getType() {
        return 2;
    }

    public final int getControlOpcode() {
        return this.controlOpcode;
    }

    public final void setControlOpcode(int n) {
        assert ((n & 0xFF00FFFF) == 0);
        this.controlOpcode = n;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ObjectOutput objectOutput2 = objectOutput instanceof MessageImpl.JMSObjectOutputWrapper ? ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getInnerObjectOutput() : objectOutput;
        objectOutput2.writeByte(1);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
    }

    public MessageImpl copy() throws JMSException {
        HdrMessageImpl hdrMessageImpl = new HdrMessageImpl();
        this.copy(hdrMessageImpl);
        return hdrMessageImpl;
    }

    public long getPayloadSize() {
        return 0L;
    }

    public void decompressMessageBody() {
    }
}

