/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.util.Date;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jms.common.JMSException;
import weblogic.messaging.dispatcher.DispatcherException;

public final class JMSDebug {
    public static final DebugLogger JMSBackEnd = DebugLogger.getDebugLogger((String)"DebugJMSBackEnd");
    public static final DebugLogger JMSFrontEnd = DebugLogger.getDebugLogger((String)"DebugJMSFrontEnd");
    public static final DebugLogger JMSCommon = DebugLogger.getDebugLogger((String)"DebugJMSCommon");
    public static final DebugLogger JMSConfig = DebugLogger.getDebugLogger((String)"DebugJMSConfig");
    public static final DebugLogger JMSLocking = DebugLogger.getDebugLogger((String)"DebugJMSLocking");
    public static final DebugLogger JMSXA = DebugLogger.getDebugLogger((String)"DebugJMSXA");
    public static final DebugLogger JMSStore = DebugLogger.getDebugLogger((String)"DebugJMSStore");
    public static final DebugLogger JMSBoot = DebugLogger.getDebugLogger((String)"DebugJMSBoot");
    public static final DebugLogger JMSDurSub = DebugLogger.getDebugLogger((String)"DebugJMSDurSub");
    public static final DebugLogger JMSDispatcher = DebugLogger.getDebugLogger((String)"DebugJMSDispatcher");
    public static final DebugLogger JMSDistTopic = DebugLogger.getDebugLogger((String)"DebugJMSDistTopic");
    public static final DebugLogger JMSAME = DebugLogger.getDebugLogger((String)"DebugJMSAME");
    public static final DebugLogger JMSPauseResume = DebugLogger.getDebugLogger((String)"DebugJMSPauseResume");
    public static final DebugLogger JMSModule = DebugLogger.getDebugLogger((String)"DebugJMSModule");
    public static final DebugLogger JMSMessagePath = DebugLogger.getDebugLogger((String)"DebugJMSMessagePath");
    public static final DebugLogger JMSSAF = DebugLogger.getDebugLogger((String)"DebugJMSSAF");
    public static final DebugLogger JMSCDS = DebugLogger.getDebugLogger((String)"DebugJMSCDS");
    public static final DebugLogger JMSCrossDomainSecurity = DebugLogger.getDebugLogger((String)"DebugJMSCrossDomainSecurity");
    public static final DebugLogger JMSDotNetProxy = DebugLogger.getDebugLogger((String)"DebugJMSDotNetProxy");
    public static final DebugLogger JMSDotNetTransport = DebugLogger.getDebugLogger((String)"DebugJMSDotNetTransport");
    public static final DebugLogger JMSDotNetT3Server = DebugLogger.getDebugLogger((String)"DebugJMSDotNetT3Server");
    private static final boolean DEBUG = true;
    private long lastTimeThrew;
    private int millisecBetweenThrows = 50000;
    private int countMatchMask = 15;
    private int throwCount;

    public JMSDebug() {
    }

    public JMSDebug(int n, int n2) {
        this.millisecBetweenThrows = n;
        this.countMatchMask = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String shouldThrow(String string) {
        long l;
        block5: {
            block4: {
                try {
                    if ((this.throwCount & this.countMatchMask) == 0) break block4;
                    JMSDebug.debug("mask not satisfied " + string + (this.throwCount & this.countMatchMask));
                    String string2 = null;
                    Object var6_5 = null;
                    ++this.throwCount;
                    return string2;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    ++this.throwCount;
                    throw throwable;
                }
            }
            l = System.currentTimeMillis();
            if (l - (long)this.millisecBetweenThrows >= this.lastTimeThrew) break block5;
            JMSDebug.debug("too soon to throw: " + string + new Date());
            String string3 = null;
            Object var6_6 = null;
            ++this.throwCount;
            return string3;
        }
        Object var6_7 = null;
        ++this.throwCount;
        this.lastTimeThrew = l;
        String string4 = "Testing resilience to: " + string + ", " + this.throwCount + " " + new Date();
        JMSDebug.debug(string4);
        return string4;
    }

    public void periodicallyThrowJMSException(String string) throws javax.jms.JMSException {
        String string2 = this.shouldThrow(string);
        if (string2 != null) {
            throw new JMSException(string2);
        }
    }

    public void periodicallyThrowDispatcherException(String string) throws DispatcherException {
        String string2 = this.shouldThrow(string);
        if (string2 != null) {
            throw new DispatcherException(string2);
        }
    }

    public static final void unlocked(String string, Object object) {
        if (JMSLocking.isDebugEnabled()) {
            JMSLocking.debug("LCK!" + Thread.currentThread().getName() + ": " + string + " : unlocked " + object);
        }
    }

    private static final void debug(String string) {
        JMSDistTopic.debug(string);
    }
}

