/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Response;

public final class JMSDestinationCreateResponse
extends Response
implements Externalizable {
    static final long serialVersionUID = -5700193800061807432L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int DESTINATION_MASK = 1792;
    private static final int DESTINATION_SHIFT = 8;
    private DestinationImpl destination;

    public JMSDestinationCreateResponse(DestinationImpl destinationImpl) {
        this.destination = destinationImpl;
    }

    public final DestinationImpl getDestination() {
        return this.destination;
    }

    public JMSDestinationCreateResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        int n = 1;
        objectOutput.writeInt(n |= Destination.getDestinationType(this.destination, 8));
        super.writeExternal(objectOutput);
        this.destination.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        if ((n & 0x700) != 0) {
            this.destination = Destination.createDestination((byte)((n & 0x700) >>> 8), objectInput);
        } else if (((PeerInfoable)objectInput).getPeerInfo().compareTo((Object)PeerInfo.VERSION_70) < 0) {
            this.destination = new DestinationImpl();
            this.destination.readExternal(objectInput);
        }
    }
}

