/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.health.HealthState;
import weblogic.jms.JMSService;
import weblogic.jms.common.DestinationImpl;
import weblogic.messaging.kernel.runtime.MessagingKernelDiagnosticImageSource;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.xml.stax.util.XMLPrettyPrinter;

public class JMSDiagnosticImageSource
extends MessagingKernelDiagnosticImageSource {
    public JMSDiagnosticImageSource() {
        ImageManager imageManager = ImageManager.getInstance();
        imageManager.registerImageSource("JMS", (ImageSource)this);
    }

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        super.createDiagnosticImage(outputStream);
        try {
            XMLPrettyPrinter xMLPrettyPrinter = new XMLPrettyPrinter((Writer)new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8")), 2);
            xMLPrettyPrinter.writeStartDocument();
            try {
                JMSService.getJMSService().dump(this, (XMLStreamWriter)xMLPrettyPrinter);
            }
            catch (DiagnosticImageTimeoutException diagnosticImageTimeoutException) {
                this.dumpTimeoutComment((XMLStreamWriter)xMLPrettyPrinter);
                xMLPrettyPrinter.flush();
                return;
            }
            xMLPrettyPrinter.writeEndDocument();
            xMLPrettyPrinter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ImageSourceCreationException("JMS image creation failed.", (Throwable)xMLStreamException);
        }
        catch (IOException iOException) {
            throw new ImageSourceCreationException("JMS image creation failed.", (Throwable)iOException);
        }
    }

    public static void dumpHealthStateElement(XMLStreamWriter xMLStreamWriter, HealthState healthState) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("Health");
        xMLStreamWriter.writeAttribute("state", HealthState.mapToString(healthState.getState()));
        String[] stringArray = healthState.getReasonCode();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                xMLStreamWriter.writeStartElement("Reason");
                xMLStreamWriter.writeCharacters(stringArray[i]);
                xMLStreamWriter.writeEndElement();
            }
        }
        xMLStreamWriter.writeEndElement();
    }

    public static void dumpDestinationImpl(XMLStreamWriter xMLStreamWriter, DestinationImpl destinationImpl) throws XMLStreamException {
        xMLStreamWriter.writeAttribute("name", destinationImpl.getName() != null ? destinationImpl.getName() : "");
        xMLStreamWriter.writeAttribute("serverName", destinationImpl.getServerName());
        xMLStreamWriter.writeAttribute("applicationName", destinationImpl.getApplicationName() != null ? destinationImpl.getApplicationName() : "");
        xMLStreamWriter.writeAttribute("moduleName", destinationImpl.getModuleName() != null ? destinationImpl.getModuleName() : "");
        xMLStreamWriter.writeAttribute("id", destinationImpl.getDestinationId() != null ? destinationImpl.getDestinationId().toString() : "");
    }
}

