/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import weblogic.jms.common.JMSException;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.mbeanservers.edit.EditServiceMBean;
import weblogic.management.mbeanservers.runtime.RuntimeServiceMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.auth.login.PasswordCredential;

public class JMSEditHelper {
    private static final String PROTOCOL_PACKAGE = "weblogic.management.remote";
    private static final String EDIT_SERVER = "weblogic.management.mbeanservers.edit";
    private static final String RUN_SERVER = "weblogic.management.mbeanservers.runtime";
    private static final String DOMAIN_RUNTIME_SERVER = "weblogic.management.mbeanservers.domainruntime";

    private static MBeanServerConnection lookupMBeanServerConnection(String string, Context context) throws javax.jms.JMSException {
        MBeanServerConnection mBeanServerConnection;
        JMXConnector jMXConnector;
        JMXServiceURL jMXServiceURL;
        try {
            jMXServiceURL = new JMXServiceURL("wlx", "localhost", 7001, "/jndi/" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new JMSException("ERROR: While trying to get JMXServiceURL: " + malformedURLException, (Throwable)malformedURLException);
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("jmx.remote.protocol.provider.pkgs", PROTOCOL_PACKAGE);
        hashtable.put("weblogic.context", context);
        try {
            jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
        }
        catch (IOException iOException) {
            throw new JMSException("ERROR: Could not connect the JMXConnector", (Throwable)iOException);
        }
        try {
            mBeanServerConnection = jMXConnector.getMBeanServerConnection();
        }
        catch (IOException iOException) {
            throw new JMSException("ERROR: Could not get the MBeanServerConnnection", (Throwable)iOException);
        }
        return mBeanServerConnection;
    }

    public static ConfigurationManagerMBean getConfigurationManager(Context context) throws javax.jms.JMSException {
        EditServiceMBean editServiceMBean;
        ObjectName objectName;
        MBeanServerConnection mBeanServerConnection = JMSEditHelper.lookupMBeanServerConnection(EDIT_SERVER, context);
        try {
            objectName = new ObjectName(EditServiceMBean.OBJECT_NAME);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new JMSException("ERROR: While trying to get an object name got a malformed object name: " + EditServiceMBean.OBJECT_NAME + " due to: " + malformedObjectNameException, (Throwable)malformedObjectNameException);
        }
        try {
            editServiceMBean = (EditServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)objectName);
        }
        catch (Throwable throwable) {
            throw new JMSException("ERROR: While trying to get the edit service got a throwable: " + throwable, throwable);
        }
        return editServiceMBean.getConfigurationManager();
    }

    public static RuntimeServiceMBean getRuntimeService(Context context) throws javax.jms.JMSException {
        RuntimeServiceMBean runtimeServiceMBean;
        ObjectName objectName;
        MBeanServerConnection mBeanServerConnection = JMSEditHelper.lookupMBeanServerConnection(RUN_SERVER, context);
        try {
            objectName = new ObjectName(RuntimeServiceMBean.OBJECT_NAME);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new JMSException("ERROR: While trying to get an object name got a malformed object name: " + RuntimeServiceMBean.OBJECT_NAME + " due to: " + malformedObjectNameException, (Throwable)malformedObjectNameException);
        }
        try {
            runtimeServiceMBean = (RuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)objectName);
        }
        catch (Throwable throwable) {
            throw new JMSException("ERROR: While trying to get the edit service got a throwable: " + throwable, throwable);
        }
        return runtimeServiceMBean;
    }

    public static DomainRuntimeServiceMBean getDomainRuntimeService(Context context) throws Exception {
        try {
            RuntimeServiceMBean runtimeServiceMBean = JMSEditHelper.getRuntimeService(context);
            ServerRuntimeMBean serverRuntimeMBean = runtimeServiceMBean.getServerRuntime();
            String string = serverRuntimeMBean.getAdminServerHost();
            int n = serverRuntimeMBean.getAdminServerListenPort();
            String string2 = (String)context.getEnvironment().get("java.naming.security.principal");
            String string3 = null;
            Object obj = context.getEnvironment().get("java.naming.security.credentials");
            string3 = obj != null && obj instanceof PasswordCredential ? ((PasswordCredential)obj).getPassword() : (String)obj;
            JMXServiceURL jMXServiceURL = new JMXServiceURL("t3", string, n, "/jndi/weblogic.management.mbeanservers.domainruntime");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (string2 != null) {
                hashtable.put("java.naming.security.principal", string2);
            }
            if (string3 != null) {
                hashtable.put("java.naming.security.credentials", string3);
            }
            hashtable.put("jmx.remote.protocol.provider.pkgs", PROTOCOL_PACKAGE);
            JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
            MBeanServerConnection mBeanServerConnection = jMXConnector.getMBeanServerConnection();
            DomainRuntimeServiceMBean domainRuntimeServiceMBean = (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME));
            return domainRuntimeServiceMBean;
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
    }
}

