/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.Response;

public final class JMSEnumerationNextElementResponse
extends Response
implements Externalizable {
    static final long serialVersionUID = -6840179225324539871L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int MESSAGE_MASK = 65280;
    private static final int MESSAGE_SHIFT = 8;
    private MessageImpl message;
    private int compressionThreshold = Integer.MAX_VALUE;

    public JMSEnumerationNextElementResponse(MessageImpl messageImpl) {
        this.message = messageImpl;
    }

    public final void setCompressionThreshold(int n) {
        this.compressionThreshold = n;
    }

    public final int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public final MessageImpl getMessage() {
        return this.message;
    }

    public JMSEnumerationNextElementResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        int n = 1;
        if (this.message != null) {
            n |= this.message.getType() << 8;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        if (this.message != null) {
            if (this.compressionThreshold == Integer.MAX_VALUE) {
                this.message.writeExternal(objectOutput);
            } else {
                this.message.writeExternal(MessageImpl.createJMSObjectOutputWrapper(objectOutput, this.compressionThreshold, true));
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        byte by = (byte)((n & 0xFF00) >> 8);
        if (by != 0) {
            this.message = MessageImpl.createMessageImpl(by);
            this.message.readExternal(objectInput);
        }
    }
}

