/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.rmi.RemoteException;
import javax.jms.JMSException;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.utils.NestedThrowable;

public final class JMSFailover {
    private final DistributedDestinationImpl[] dests;
    private final Object firstFailure;
    private final int size;
    private int current;

    public JMSFailover(DistributedDestinationImpl[] distributedDestinationImplArray, Object object) {
        this.dests = distributedDestinationImplArray;
        this.size = distributedDestinationImplArray.length;
        this.current = 0;
        this.firstFailure = object;
    }

    public static boolean isRecoverableFailure(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (true) {
            if (throwable == null) {
                return false;
            }
            if (throwable instanceof RuntimeException || throwable instanceof Error) {
                return false;
            }
            if (throwable instanceof RemoteException) {
                return RemoteHelper.isRecoverablePreInvokeFailure((RemoteException)((RemoteException)throwable));
            }
            if (throwable.getCause() != null) {
                throwable = throwable.getCause();
                continue;
            }
            if (!(throwable instanceof NestedThrowable)) break;
            throwable = ((NestedThrowable)throwable).getNested();
        }
        if (!(throwable instanceof JMSException)) {
            return false;
        }
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug("failover permitted for ", throwable2);
        } else if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
            JMSDebug.JMSFrontEnd.debug("failover permitted for ", throwable2);
        }
        return true;
    }

    public DistributedDestinationImpl failover(DistributedDestinationImpl distributedDestinationImpl, Throwable throwable) {
        if (!JMSFailover.isRecoverableFailure(throwable)) {
            return null;
        }
        if (this.current < this.size) {
            if (this.dests[this.current] == this.firstFailure && ++this.current >= this.size) {
                return null;
            }
            return this.dests[this.current++];
        }
        return null;
    }
}

